/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.Vector;

public class PlanetModel {
    public static final PlanetModel SPHERE = new PlanetModel(1.0, 1.0);
    public static final double WGS84_MEAN = 6371009.0;
    public static final double WGS84_POLAR = 6356752.314245;
    public static final double WGS84_EQUATORIAL = 6378137.0;
    public static final PlanetModel WGS84 = new PlanetModel(1.0011188180710464, 0.9977622562211103);
    public final double ab;
    public final double c;
    public final double inverseAb;
    public final double inverseC;
    public final double inverseAbSquared;
    public final double inverseCSquared;
    public final double flattening;
    public final double squareRatio;
    public final GeoPoint NORTH_POLE;
    public final GeoPoint SOUTH_POLE;
    public final GeoPoint MIN_X_POLE;
    public final GeoPoint MAX_X_POLE;
    public final GeoPoint MIN_Y_POLE;
    public final GeoPoint MAX_Y_POLE;

    public PlanetModel(double ab, double c) {
        this.ab = ab;
        this.c = c;
        this.inverseAb = 1.0 / ab;
        this.inverseC = 1.0 / c;
        this.flattening = (ab - c) * this.inverseAb;
        this.squareRatio = (ab * ab - c * c) / (c * c);
        this.inverseAbSquared = this.inverseAb * this.inverseAb;
        this.inverseCSquared = this.inverseC * this.inverseC;
        this.NORTH_POLE = new GeoPoint(c, 0.0, 0.0, 1.0, 1.5707963267948966, 0.0);
        this.SOUTH_POLE = new GeoPoint(c, 0.0, 0.0, -1.0, -1.5707963267948966, 0.0);
        this.MIN_X_POLE = new GeoPoint(ab, -1.0, 0.0, 0.0, 0.0, -Math.PI);
        this.MAX_X_POLE = new GeoPoint(ab, 1.0, 0.0, 0.0, 0.0, 0.0);
        this.MIN_Y_POLE = new GeoPoint(ab, 0.0, -1.0, 0.0, 0.0, -1.5707963267948966);
        this.MAX_Y_POLE = new GeoPoint(ab, 0.0, 1.0, 0.0, 0.0, 1.5707963267948966);
    }

    public double getMinimumMagnitude() {
        return Math.min(this.ab, this.c);
    }

    public double getMaximumMagnitude() {
        return Math.max(this.ab, this.c);
    }

    public double getMinimumXValue() {
        return -this.ab;
    }

    public double getMaximumXValue() {
        return this.ab;
    }

    public double getMinimumYValue() {
        return -this.ab;
    }

    public double getMaximumYValue() {
        return this.ab;
    }

    public double getMinimumZValue() {
        return -this.c;
    }

    public double getMaximumZValue() {
        return this.c;
    }

    public boolean pointOnSurface(Vector v) {
        return this.pointOnSurface(v.x, v.y, v.z);
    }

    public boolean pointOnSurface(double x, double y, double z) {
        return Math.abs(x * x * this.inverseAb * this.inverseAb + y * y * this.inverseAb * this.inverseAb + z * z * this.inverseC * this.inverseC - 1.0) < 1.0E-12;
    }

    public boolean pointOutside(Vector v) {
        return this.pointOutside(v.x, v.y, v.z);
    }

    public boolean pointOutside(double x, double y, double z) {
        return (x * x + y * y) * this.inverseAb * this.inverseAb + z * z * this.inverseC * this.inverseC - 1.0 > 1.0E-12;
    }

    public double surfaceDistance(GeoPoint pt1, GeoPoint pt2) {
        double cosSigma;
        double cos2SigmaM;
        double sinSigma;
        double sigma;
        double sinAlpha;
        double cosSqAlpha;
        double C;
        double L = pt2.getLongitude() - pt1.getLongitude();
        double U1 = Math.atan((1.0 - this.flattening) * Math.tan(pt1.getLatitude()));
        double U2 = Math.atan((1.0 - this.flattening) * Math.tan(pt2.getLatitude()));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double dCosU1CosU2 = cosU1 * cosU2;
        double dCosU1SinU2 = cosU1 * sinU2;
        double dSinU1SinU2 = sinU1 * sinU2;
        double dSinU1CosU2 = sinU1 * cosU2;
        double lambda = L;
        double lambdaP = Math.PI * 2;
        int iterLimit = 0;
        do {
            double cosLambda;
            double sinLambda;
            if ((sinSigma = Math.sqrt(cosU2 * (sinLambda = Math.sin(lambda)) * (cosU2 * sinLambda) + (dCosU1SinU2 - dSinU1CosU2 * (cosLambda = Math.cos(lambda))) * (dCosU1SinU2 - dSinU1CosU2 * cosLambda))) == 0.0) {
                return 0.0;
            }
            cosSigma = dSinU1SinU2 + dCosU1CosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            sinAlpha = dCosU1CosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SigmaM = cosSigma - 2.0 * dSinU1SinU2 / cosSqAlpha;
            if (!Double.isNaN(cos2SigmaM)) continue;
            cos2SigmaM = 0.0;
        } while (Math.abs((lambda = L + (1.0 - (C = this.flattening / 16.0 * cosSqAlpha * (4.0 + this.flattening * (4.0 - 3.0 * cosSqAlpha)))) * this.flattening * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) > 1.0E-12 && ++iterLimit < 40);
        double uSq = cosSqAlpha * this.squareRatio;
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        return this.c * A * (sigma - deltaSigma);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PlanetModel)) {
            return false;
        }
        PlanetModel other = (PlanetModel)o;
        return this.ab == other.ab && this.c == other.c;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.ab);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.c);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        if (this.equals(SPHERE)) {
            return "PlanetModel.SPHERE";
        }
        if (this.equals(WGS84)) {
            return "PlanetModel.WGS84";
        }
        return "PlanetModel(ab=" + this.ab + " c=" + this.c + ")";
    }
}

