/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.analytics.rest;

import com.fasterxml.jackson.core.JsonParseException;
import com.maltego.analytics.AmplitudeProperties;
import com.maltego.analytics.rest.AmplitudeRequestException;
import com.maltego.analytics.rest.Request;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.openide.util.Exceptions;

public class AmplitudeRestClient {
    private static final Logger LOG = Logger.getLogger(AmplitudeRestClient.class.getName());
    private static final int TIMEOUT_MILLIS = 15000;

    public static void sendEvent(Collection<String> events) throws AmplitudeRequestException {
        try {
            LOG.log(Level.INFO, "Sending analytics request for {0} events ", events.size());
            Request request = Request.build(events);
            String requestJson = request.toJson();
            LOG.log(Level.FINE, "Analytics request: {0}", requestJson);
            URL url = new URL(AmplitudeProperties.getInstance().getUrl());
            HttpAgent agent = new HttpAgent(url);
            agent.setConnectTimeout(15000);
            agent.setReadTimeout(15000);
            agent.doPost("application/json", requestJson);
            AmplitudeRestClient.parseResponseBody(agent);
        }
        catch (IOException ex) {
            Throwable cause;
            if (ex instanceof JsonParseException && ex.getMessage() != null && ex.getMessage().contains("Unexpected character ('<'")) {
                NormalException.logStackTrace((Throwable)ex);
            }
            String msg = (cause = ex.getCause()) == null ? null : cause.getMessage();
            boolean validCommsIssue = !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("Unable to tunnel through proxy. Proxy returns");
            validCommsIssue = validCommsIssue || cause instanceof SSLHandshakeException && !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("PKIX path building failed");
            validCommsIssue = validCommsIssue || cause instanceof SSLHandshakeException && !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("Remote host terminated the handshake");
            validCommsIssue = validCommsIssue || cause instanceof SSLException && !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("Connection reset");
            boolean bl = validCommsIssue = validCommsIssue || cause instanceof IOException && !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("stream is closed");
            if (validCommsIssue || cause instanceof UnknownHostException || cause instanceof SocketTimeoutException || cause instanceof SocketException) {
                NormalException.logStackTrace((Throwable)ex);
            } else {
                Exceptions.printStackTrace((Throwable)ex);
            }
            throw new AmplitudeRequestException("Analytics request failed.", true);
        }
    }

    private static void parseResponseBody(HttpAgent httpAgent) throws AmplitudeRequestException {
        int responseCode = httpAgent.getResponseCode();
        if (responseCode >= 200 && responseCode < 300) {
            LOG.log(Level.INFO, "Analytics event sent successfully");
            try {
                LOG.log(Level.FINE, "Analytics result: {0}", httpAgent.getContentAsString());
            }
            catch (IOException ex) {
                NormalException.logStackTrace((Throwable)ex);
            }
        } else {
            String errorAsString = null;
            try {
                errorAsString = httpAgent.getErrorAsString();
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "exception getting error on analytics request", ex);
            }
            LOG.log(Level.WARNING, "Analytics request failed. Error code: {0}\nError body: {1}", new Object[]{responseCode, errorAsString});
            boolean canRetry = responseCode != 400 && responseCode != 403;
            throw new AmplitudeRequestException(errorAsString, canRetry);
        }
    }
}

