/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.types;

import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;

public class Blob {
    private final byte[] _value;

    public Blob(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Blob bytes may not be null.");
        }
        this._value = bytes;
    }

    public Blob(String base64String) {
        if (base64String == null) {
            throw new IllegalArgumentException("Blob base64 string may not be null.");
        }
        this._value = Base64.decodeBase64((String)base64String);
    }

    public byte[] get() {
        return this._value;
    }

    public String toBase64String() {
        return Base64.encodeBase64String((byte[])this._value);
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Arrays.hashCode(this._value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Blob other = (Blob)obj;
        return Arrays.equals(this._value, other._value);
    }

    public String toString() {
        return "Blob{" + this.toBase64String() + '}';
    }
}

