/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.crypto.KeyWrapper;

public class PublicKeysWrapper {
    private final List<KeyWrapper> keys;
    public static final PublicKeysWrapper EMPTY = new PublicKeysWrapper(Collections.emptyList());

    public PublicKeysWrapper(List<KeyWrapper> keys) {
        this.keys = keys;
    }

    public List<KeyWrapper> getKeys() {
        return this.keys;
    }

    public List<String> getKids() {
        return this.keys.stream().map(KeyWrapper::getKid).collect(Collectors.toList());
    }

    public KeyWrapper getKeyByKidAndAlg(String kid, String alg) {
        return this.keys.stream().filter(keyWrapper -> kid == null || kid.equals(keyWrapper.getKid())).filter(keyWrapper -> alg == null || alg.equals(keyWrapper.getAlgorithmOrDefault()) || keyWrapper.getAlgorithm() == null && kid != null).findFirst().orElse(null);
    }
}

