/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.lucene.serialize.NumericTypeConverter;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;

class IntConverter
extends NumericTypeConverter<Integer> {
    private static final Integer MIN_SORT_VALUE = Integer.MIN_VALUE;
    private static final Integer MAX_SORT_VALUE = Integer.MAX_VALUE;

    public IntConverter() {
        super("int", Integer.class, Integer.TYPE, SortField.Type.INT);
    }

    @Override
    IndexableField createNumberField(Integer value, String fieldName) {
        return new IntField(fieldName, value.intValue(), Field.Store.YES);
    }

    @Override
    long toSortableLong(Integer value) {
        return value.intValue();
    }

    @Override
    protected Integer getMinSortField() {
        return MIN_SORT_VALUE;
    }

    @Override
    protected Integer getMaxSortField() {
        return MAX_SORT_VALUE;
    }

    @Override
    Integer toType(Number number) {
        return number.intValue();
    }

    @Override
    protected BytesRef createFilterTerm(Integer value) {
        BytesRefBuilder builder = new BytesRefBuilder();
        NumericUtils.intToPrefixCoded((int)value, (int)0, (BytesRefBuilder)builder);
        return builder.get();
    }
}

