/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery.yadis;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.UrlIdentifier;
import org.openid4java.discovery.xrds.XrdsServiceEndpoint;
import org.openid4java.discovery.yadis.YadisException;
import org.openid4java.discovery.yadis.YadisUrl;

public class YadisResult {
    private static Log _log = LogFactory.getLog(YadisResult.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private List _endpoints;
    private String _contentType;
    private YadisUrl _yadisUrl;
    private String _normalizedUrl;
    private URL _xrdsLocation;
    private Throwable _failureCause;

    public void setYadisUrl(YadisUrl url) {
        this._yadisUrl = url;
    }

    public YadisUrl getYadisUrl() {
        return this._yadisUrl;
    }

    public void setXrdsLocation(String xrdsLocation, int onFailError) throws YadisException {
        URL xrdsUrl = null;
        boolean validXrdsUrl = true;
        try {
            xrdsUrl = new URL(xrdsLocation);
        }
        catch (MalformedURLException e) {
            validXrdsUrl = false;
        }
        if (xrdsUrl == null || !validXrdsUrl || !xrdsUrl.getProtocol().equals("http") && !xrdsUrl.getProtocol().equals("https")) {
            throw new YadisException("A Yadis Resource Descriptor URL MUST be an absolute URL and it must be HTTP or HTTPS; found: " + xrdsLocation, onFailError);
        }
        if (DEBUG) {
            _log.debug((Object)("Setting X-XRDS-Location for yadis result: " + xrdsLocation));
        }
        this._xrdsLocation = xrdsUrl;
    }

    public URL getXrdsLocation() {
        return this._xrdsLocation;
    }

    public void setEndpoints(List endpoints) {
        this._endpoints = endpoints;
    }

    public List getEndpoints() {
        return this._endpoints;
    }

    public int getEndpointCount() {
        return this._endpoints == null ? 0 : this._endpoints.size();
    }

    public List getDiscoveredInformation(Set targetTypes) throws DiscoveryException {
        ArrayList<DiscoveryInformation> result = new ArrayList<DiscoveryInformation>();
        if (this.hasEndpoints()) {
            for (XrdsServiceEndpoint endpoint : this._endpoints) {
                for (String type : endpoint.getTypes()) {
                    if (!targetTypes.contains(type)) continue;
                    try {
                        result.add(new DiscoveryInformation(new URL(endpoint.getUri()), DiscoveryInformation.OPENID_SIGNON_TYPES.contains(type) ? new UrlIdentifier(this._normalizedUrl) : null, "http://specs.openid.net/auth/2.0/signon".equals(type) ? endpoint.getLocalId() : (DiscoveryInformation.OPENID1_SIGNON_TYPES.contains(type) ? endpoint.getDelegate() : null), type, endpoint.getTypes()));
                    }
                    catch (MalformedURLException e) {
                        throw new YadisException("Invalid endpoint URL discovered: " + endpoint.getUri(), 1794);
                    }
                }
            }
        }
        return result;
    }

    public boolean hasEndpoints() {
        return this._endpoints != null && !this._endpoints.isEmpty();
    }

    public String getNormalizedUrl() {
        return this._normalizedUrl;
    }

    public void setNormalizedUrl(String _normalizedUrl) {
        this._normalizedUrl = _normalizedUrl;
    }

    public void setContentType(String type) {
        this._contentType = type;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void setFailureCause(Throwable e) {
        this._failureCause = e;
    }

    public Throwable getFailureCause() {
        return this._failureCause;
    }

    public String dump() {
        StringBuffer dump = new StringBuffer();
        dump.append("YadisURL:").append(this._yadisUrl);
        dump.append("\nNormalizedURL:").append(this._normalizedUrl);
        dump.append("\nX-XRDS-Location:").append(this._xrdsLocation);
        dump.append("\nContent-type:").append(this._contentType);
        if (this._endpoints != null) {
            dump.append("\nXRDS:");
            for (XrdsServiceEndpoint endpoint : this._endpoints) {
                dump.append("\n\tType: ").append(endpoint.getTypes().toArray());
                dump.append("\n\tServicePriority: ").append(endpoint.getServicePriority());
                dump.append("\n\tUriPriority: ").append(endpoint.getUriPriority());
                dump.append("\n\tURI: ").append(endpoint.getUri());
            }
        }
        return dump.toString();
    }
}

