// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SSUBW2_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SSUBW2_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_ssubw2_8H[] = {
  0x00fb, 0x00d5, 0x3367, 0x555d, 0x8000, 0x8000, 0x8000, 0x0000,
  0x00d4, 0x00b3, 0x333b, 0x5558, 0x7fff, 0x7fff, 0x7fff, 0xffff,
  0x00b2, 0x0087, 0x3336, 0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0xfffe,
  0x0086, 0x0082, 0x3335, 0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0xfff8,
  0x0081, 0x0081, 0x3334, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0xffcd,
  0x0080, 0x0080, 0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0xffab,
  0x007f, 0x007f, 0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0xff83,
  0x007e, 0x007e, 0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82, 0xff82,
  0x007d, 0x007d, 0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81, 0xff81,
  0x007c, 0x0077, 0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80, 0x0080,
  0x0076, 0x004c, 0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x807f, 0x007f,
  0x004b, 0x002a, 0x32b6, 0x54d7, 0x7f7e, 0x807e, 0x807e, 0x007e,
  0x0029, 0x0002, 0x32b5, 0x54d6, 0x807d, 0x807d, 0x807d, 0x007d,
  0x0001, 0x0001, 0x32b4, 0x55d5, 0x807c, 0x807c, 0x807c, 0x0056,
  0x0000, 0x0000, 0x33b3, 0x55d4, 0x807b, 0x807b, 0x8055, 0x0034,
  0xffff, 0x00ff, 0x33b2, 0x55d3, 0x807a, 0x8054, 0x8033, 0x0008,
  0x00fe, 0x00fe, 0x33b1, 0x55d2, 0x8053, 0x8032, 0x8007, 0x0003,
  0x00fd, 0x00fd, 0x33b0, 0x55ab, 0x8031, 0x8006, 0x8002, 0x0002,
  0x00fc, 0x00fc, 0x3389, 0x5589, 0x8005, 0x8001, 0x8001, 0x0001,
  0x00fc, 0x3389, 0x5589, 0x8005, 0x8001, 0x8001, 0x0001, 0x0001,
  0x00d5, 0x3367, 0x555d, 0x8000, 0x8000, 0x8000, 0x0000, 0x0000,
  0x00b3, 0x333b, 0x5558, 0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff,
  0x0087, 0x3336, 0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0xfffe, 0xfff9,
  0x0082, 0x3335, 0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0xfff8, 0xffce,
  0x0081, 0x3334, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0xffcd, 0xffac,
  0x0080, 0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0xffab, 0xff84,
  0x007f, 0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0xff83, 0xff83,
  0x007e, 0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82, 0xff82, 0xff82,
  0x007d, 0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81, 0xff81, 0x0081,
  0x0077, 0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80, 0x0080, 0x0080,
  0x004c, 0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x807f, 0x007f, 0x007f,
  0x002a, 0x32b6, 0x54d7, 0x7f7e, 0x807e, 0x807e, 0x007e, 0x007e,
  0x0002, 0x32b5, 0x54d6, 0x807d, 0x807d, 0x807d, 0x007d, 0x0057,
  0x0001, 0x32b4, 0x55d5, 0x807c, 0x807c, 0x807c, 0x0056, 0x0035,
  0x0000, 0x33b3, 0x55d4, 0x807b, 0x807b, 0x8055, 0x0034, 0x0009,
  0x00ff, 0x33b2, 0x55d3, 0x807a, 0x8054, 0x8033, 0x0008, 0x0004,
  0x00fe, 0x33b1, 0x55d2, 0x8053, 0x8032, 0x8007, 0x0003, 0x0003,
  0x00fd, 0x33b0, 0x55ab, 0x8031, 0x8006, 0x8002, 0x0002, 0x0002,
  0x33b0, 0x55ab, 0x8031, 0x8006, 0x8002, 0x0002, 0x0002, 0x0002,
  0x3389, 0x5589, 0x8005, 0x8001, 0x8001, 0x0001, 0x0001, 0x0001,
  0x3367, 0x555d, 0x8000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000,
  0x333b, 0x5558, 0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff, 0xfffa,
  0x3336, 0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0xfffe, 0xfff9, 0xffcf,
  0x3335, 0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0xfff8, 0xffce, 0xffad,
  0x3334, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0xffcd, 0xffac, 0xff85,
  0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0xffab, 0xff84, 0xff84,
  0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0xff83, 0xff83, 0xff83,
  0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82, 0xff82, 0xff82, 0x0082,
  0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81, 0xff81, 0x0081, 0x0081,
  0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80, 0x0080, 0x0080, 0x0080,
  0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x807f, 0x007f, 0x007f, 0x007f,
  0x32b6, 0x54d7, 0x7f7e, 0x807e, 0x807e, 0x007e, 0x007e, 0x0058,
  0x32b5, 0x54d6, 0x807d, 0x807d, 0x807d, 0x007d, 0x0057, 0x0036,
  0x32b4, 0x55d5, 0x807c, 0x807c, 0x807c, 0x0056, 0x0035, 0x000a,
  0x33b3, 0x55d4, 0x807b, 0x807b, 0x8055, 0x0034, 0x0009, 0x0005,
  0x33b2, 0x55d3, 0x807a, 0x8054, 0x8033, 0x0008, 0x0004, 0x0004,
  0x33b1, 0x55d2, 0x8053, 0x8032, 0x8007, 0x0003, 0x0003, 0x0003,
  0x55d2, 0x8053, 0x8032, 0x8007, 0x0003, 0x0003, 0x0003, 0x0010,
  0x55ab, 0x8031, 0x8006, 0x8002, 0x0002, 0x0002, 0x0002, 0x000f,
  0x5589, 0x8005, 0x8001, 0x8001, 0x0001, 0x0001, 0x0001, 0x000e,
  0x555d, 0x8000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0008,
  0x5558, 0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff, 0xfffa, 0xffdd,
  0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0xfffe, 0xfff9, 0xffcf, 0xffbb,
  0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0xfff8, 0xffce, 0xffad, 0xff93,
  0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0xffcd, 0xffac, 0xff85, 0xff92,
  0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0xffab, 0xff84, 0xff84, 0xff91,
  0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0xff83, 0xff83, 0xff83, 0x0090,
  0x554d, 0x7fca, 0x7fa9, 0x7f82, 0xff82, 0xff82, 0x0082, 0x008f,
  0x5522, 0x7fa8, 0x7f81, 0x7f81, 0xff81, 0x0081, 0x0081, 0x008e,
  0x5500, 0x7f80, 0x7f80, 0x7f80, 0x0080, 0x0080, 0x0080, 0x008d,
  0x54d8, 0x7f7f, 0x7f7f, 0x807f, 0x007f, 0x007f, 0x007f, 0x0066,
  0x54d7, 0x7f7e, 0x807e, 0x807e, 0x007e, 0x007e, 0x0058, 0x0044,
  0x54d6, 0x807d, 0x807d, 0x807d, 0x007d, 0x0057, 0x0036, 0x0018,
  0x55d5, 0x807c, 0x807c, 0x807c, 0x0056, 0x0035, 0x000a, 0x0013,
  0x55d4, 0x807b, 0x807b, 0x8055, 0x0034, 0x0009, 0x0005, 0x0012,
  0x55d3, 0x807a, 0x8054, 0x8033, 0x0008, 0x0004, 0x0004, 0x0011,
  0x807a, 0x8054, 0x8033, 0x0008, 0x0004, 0x0004, 0x0011, 0x007d,
  0x8053, 0x8032, 0x8007, 0x0003, 0x0003, 0x0003, 0x0010, 0x007c,
  0x8031, 0x8006, 0x8002, 0x0002, 0x0002, 0x0002, 0x000f, 0x007b,
  0x8005, 0x8001, 0x8001, 0x0001, 0x0001, 0x0001, 0x000e, 0x0075,
  0x8000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0008, 0x004a,
  0x7fff, 0x7fff, 0x7fff, 0xffff, 0xffff, 0xfffa, 0xffdd, 0x0028,
  0x7ffe, 0x7ffe, 0x7ffe, 0xfffe, 0xfff9, 0xffcf, 0xffbb, 0x0000,
  0x7ffd, 0x7ffd, 0x7ffd, 0xfff8, 0xffce, 0xffad, 0xff93, 0xffff,
  0x7ffc, 0x7ffc, 0x7ff7, 0xffcd, 0xffac, 0xff85, 0xff92, 0xfffe,
  0x7ffb, 0x7ff6, 0x7fcc, 0xffab, 0xff84, 0xff84, 0xff91, 0x00fd,
  0x7ff5, 0x7fcb, 0x7faa, 0xff83, 0xff83, 0xff83, 0x0090, 0x00fc,
  0x7fca, 0x7fa9, 0x7f82, 0xff82, 0xff82, 0x0082, 0x008f, 0x00fb,
  0x7fa8, 0x7f81, 0x7f81, 0xff81, 0x0081, 0x0081, 0x008e, 0x00fa,
  0x7f80, 0x7f80, 0x7f80, 0x0080, 0x0080, 0x0080, 0x008d, 0x00d3,
  0x7f7f, 0x7f7f, 0x807f, 0x007f, 0x007f, 0x007f, 0x0066, 0x00b1,
  0x7f7e, 0x807e, 0x807e, 0x007e, 0x007e, 0x0058, 0x0044, 0x0085,
  0x807d, 0x807d, 0x807d, 0x007d, 0x0057, 0x0036, 0x0018, 0x0080,
  0x807c, 0x807c, 0x807c, 0x0056, 0x0035, 0x000a, 0x0013, 0x007f,
  0x807b, 0x807b, 0x8055, 0x0034, 0x0009, 0x0005, 0x0012, 0x007e,
  0x807b, 0x8055, 0x0034, 0x0009, 0x0005, 0x0012, 0x007e, 0x007e,
  0x8054, 0x8033, 0x0008, 0x0004, 0x0004, 0x0011, 0x007d, 0x007d,
  0x8032, 0x8007, 0x0003, 0x0003, 0x0003, 0x0010, 0x007c, 0x007c,
  0x8006, 0x8002, 0x0002, 0x0002, 0x0002, 0x000f, 0x007b, 0x0076,
  0x8001, 0x8001, 0x0001, 0x0001, 0x0001, 0x000e, 0x0075, 0x004b,
  0x8000, 0x8000, 0x0000, 0x0000, 0x0000, 0x0008, 0x004a, 0x0029,
  0x7fff, 0x7fff, 0xffff, 0xffff, 0xfffa, 0xffdd, 0x0028, 0x0001,
  0x7ffe, 0x7ffe, 0xfffe, 0xfff9, 0xffcf, 0xffbb, 0x0000, 0x0000,
  0x7ffd, 0x7ffd, 0xfff8, 0xffce, 0xffad, 0xff93, 0xffff, 0xffff,
  0x7ffc, 0x7ff7, 0xffcd, 0xffac, 0xff85, 0xff92, 0xfffe, 0x00fe,
  0x7ff6, 0x7fcc, 0xffab, 0xff84, 0xff84, 0xff91, 0x00fd, 0x00fd,
  0x7fcb, 0x7faa, 0xff83, 0xff83, 0xff83, 0x0090, 0x00fc, 0x00fc,
  0x7fa9, 0x7f82, 0xff82, 0xff82, 0x0082, 0x008f, 0x00fb, 0x00fb,
  0x7f81, 0x7f81, 0xff81, 0x0081, 0x0081, 0x008e, 0x00fa, 0x00d4,
  0x7f80, 0x7f80, 0x0080, 0x0080, 0x0080, 0x008d, 0x00d3, 0x00b2,
  0x7f7f, 0x807f, 0x007f, 0x007f, 0x007f, 0x0066, 0x00b1, 0x0086,
  0x807e, 0x807e, 0x007e, 0x007e, 0x0058, 0x0044, 0x0085, 0x0081,
  0x807d, 0x807d, 0x007d, 0x0057, 0x0036, 0x0018, 0x0080, 0x0080,
  0x807c, 0x807c, 0x0056, 0x0035, 0x000a, 0x0013, 0x007f, 0x007f,
  0x807c, 0x0056, 0x0035, 0x000a, 0x0013, 0x007f, 0x007f, 0x007f,
  0x8055, 0x0034, 0x0009, 0x0005, 0x0012, 0x007e, 0x007e, 0x007e,
  0x8033, 0x0008, 0x0004, 0x0004, 0x0011, 0x007d, 0x007d, 0x007d,
  0x8007, 0x0003, 0x0003, 0x0003, 0x0010, 0x007c, 0x007c, 0x0077,
  0x8002, 0x0002, 0x0002, 0x0002, 0x000f, 0x007b, 0x0076, 0x004c,
  0x8001, 0x0001, 0x0001, 0x0001, 0x000e, 0x0075, 0x004b, 0x002a,
  0x8000, 0x0000, 0x0000, 0x0000, 0x0008, 0x004a, 0x0029, 0x0002,
  0x7fff, 0xffff, 0xffff, 0xfffa, 0xffdd, 0x0028, 0x0001, 0x0001,
  0x7ffe, 0xfffe, 0xfff9, 0xffcf, 0xffbb, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0xfff8, 0xffce, 0xffad, 0xff93, 0xffff, 0xffff, 0x00ff,
  0x7ff7, 0xffcd, 0xffac, 0xff85, 0xff92, 0xfffe, 0x00fe, 0x00fe,
  0x7fcc, 0xffab, 0xff84, 0xff84, 0xff91, 0x00fd, 0x00fd, 0x00fd,
  0x7faa, 0xff83, 0xff83, 0xff83, 0x0090, 0x00fc, 0x00fc, 0x00fc,
  0x7f82, 0xff82, 0xff82, 0x0082, 0x008f, 0x00fb, 0x00fb, 0x00d5,
  0x7f81, 0xff81, 0x0081, 0x0081, 0x008e, 0x00fa, 0x00d4, 0x00b3,
  0x7f80, 0x0080, 0x0080, 0x0080, 0x008d, 0x00d3, 0x00b2, 0x0087,
  0x807f, 0x007f, 0x007f, 0x007f, 0x0066, 0x00b1, 0x0086, 0x0082,
  0x807e, 0x007e, 0x007e, 0x0058, 0x0044, 0x0085, 0x0081, 0x0081,
  0x807d, 0x007d, 0x0057, 0x0036, 0x0018, 0x0080, 0x0080, 0x0080,
  0x007d, 0x0057, 0x0036, 0x0018, 0x0080, 0x0080, 0x0080, 0x3333,
  0x0056, 0x0035, 0x000a, 0x0013, 0x007f, 0x007f, 0x007f, 0x3332,
  0x0034, 0x0009, 0x0005, 0x0012, 0x007e, 0x007e, 0x007e, 0x3331,
  0x0008, 0x0004, 0x0004, 0x0011, 0x007d, 0x007d, 0x007d, 0x332b,
  0x0003, 0x0003, 0x0003, 0x0010, 0x007c, 0x007c, 0x0077, 0x3300,
  0x0002, 0x0002, 0x0002, 0x000f, 0x007b, 0x0076, 0x004c, 0x32de,
  0x0001, 0x0001, 0x0001, 0x000e, 0x0075, 0x004b, 0x002a, 0x32b6,
  0x0000, 0x0000, 0x0000, 0x0008, 0x004a, 0x0029, 0x0002, 0x32b5,
  0xffff, 0xffff, 0xfffa, 0xffdd, 0x0028, 0x0001, 0x0001, 0x32b4,
  0xfffe, 0xfff9, 0xffcf, 0xffbb, 0x0000, 0x0000, 0x0000, 0x33b3,
  0xfff8, 0xffce, 0xffad, 0xff93, 0xffff, 0xffff, 0x00ff, 0x33b2,
  0xffcd, 0xffac, 0xff85, 0xff92, 0xfffe, 0x00fe, 0x00fe, 0x33b1,
  0xffab, 0xff84, 0xff84, 0xff91, 0x00fd, 0x00fd, 0x00fd, 0x33b0,
  0xff83, 0xff83, 0xff83, 0x0090, 0x00fc, 0x00fc, 0x00fc, 0x3389,
  0xff82, 0xff82, 0x0082, 0x008f, 0x00fb, 0x00fb, 0x00d5, 0x3367,
  0xff81, 0x0081, 0x0081, 0x008e, 0x00fa, 0x00d4, 0x00b3, 0x333b,
  0x0080, 0x0080, 0x0080, 0x008d, 0x00d3, 0x00b2, 0x0087, 0x3336,
  0x007f, 0x007f, 0x007f, 0x0066, 0x00b1, 0x0086, 0x0082, 0x3335,
  0x007e, 0x007e, 0x0058, 0x0044, 0x0085, 0x0081, 0x0081, 0x3334,
  0x007e, 0x0058, 0x0044, 0x0085, 0x0081, 0x0081, 0x3334, 0x5555,
  0x0057, 0x0036, 0x0018, 0x0080, 0x0080, 0x0080, 0x3333, 0x5554,
  0x0035, 0x000a, 0x0013, 0x007f, 0x007f, 0x007f, 0x3332, 0x5553,
  0x0009, 0x0005, 0x0012, 0x007e, 0x007e, 0x007e, 0x3331, 0x554d,
  0x0004, 0x0004, 0x0011, 0x007d, 0x007d, 0x007d, 0x332b, 0x5522,
  0x0003, 0x0003, 0x0010, 0x007c, 0x007c, 0x0077, 0x3300, 0x5500,
  0x0002, 0x0002, 0x000f, 0x007b, 0x0076, 0x004c, 0x32de, 0x54d8,
  0x0001, 0x0001, 0x000e, 0x0075, 0x004b, 0x002a, 0x32b6, 0x54d7,
  0x0000, 0x0000, 0x0008, 0x004a, 0x0029, 0x0002, 0x32b5, 0x54d6,
  0xffff, 0xfffa, 0xffdd, 0x0028, 0x0001, 0x0001, 0x32b4, 0x55d5,
  0xfff9, 0xffcf, 0xffbb, 0x0000, 0x0000, 0x0000, 0x33b3, 0x55d4,
  0xffce, 0xffad, 0xff93, 0xffff, 0xffff, 0x00ff, 0x33b2, 0x55d3,
  0xffac, 0xff85, 0xff92, 0xfffe, 0x00fe, 0x00fe, 0x33b1, 0x55d2,
  0xff84, 0xff84, 0xff91, 0x00fd, 0x00fd, 0x00fd, 0x33b0, 0x55ab,
  0xff83, 0xff83, 0x0090, 0x00fc, 0x00fc, 0x00fc, 0x3389, 0x5589,
  0xff82, 0x0082, 0x008f, 0x00fb, 0x00fb, 0x00d5, 0x3367, 0x555d,
  0x0081, 0x0081, 0x008e, 0x00fa, 0x00d4, 0x00b3, 0x333b, 0x5558,
  0x0080, 0x0080, 0x008d, 0x00d3, 0x00b2, 0x0087, 0x3336, 0x5557,
  0x007f, 0x007f, 0x0066, 0x00b1, 0x0086, 0x0082, 0x3335, 0x5556,
  0x007f, 0x0066, 0x00b1, 0x0086, 0x0082, 0x3335, 0x5556, 0x7ffd,
  0x0058, 0x0044, 0x0085, 0x0081, 0x0081, 0x3334, 0x5555, 0x7ffc,
  0x0036, 0x0018, 0x0080, 0x0080, 0x0080, 0x3333, 0x5554, 0x7ffb,
  0x000a, 0x0013, 0x007f, 0x007f, 0x007f, 0x3332, 0x5553, 0x7ff5,
  0x0005, 0x0012, 0x007e, 0x007e, 0x007e, 0x3331, 0x554d, 0x7fca,
  0x0004, 0x0011, 0x007d, 0x007d, 0x007d, 0x332b, 0x5522, 0x7fa8,
  0x0003, 0x0010, 0x007c, 0x007c, 0x0077, 0x3300, 0x5500, 0x7f80,
  0x0002, 0x000f, 0x007b, 0x0076, 0x004c, 0x32de, 0x54d8, 0x7f7f,
  0x0001, 0x000e, 0x0075, 0x004b, 0x002a, 0x32b6, 0x54d7, 0x7f7e,
  0x0000, 0x0008, 0x004a, 0x0029, 0x0002, 0x32b5, 0x54d6, 0x807d,
  0xfffa, 0xffdd, 0x0028, 0x0001, 0x0001, 0x32b4, 0x55d5, 0x807c,
  0xffcf, 0xffbb, 0x0000, 0x0000, 0x0000, 0x33b3, 0x55d4, 0x807b,
  0xffad, 0xff93, 0xffff, 0xffff, 0x00ff, 0x33b2, 0x55d3, 0x807a,
  0xff85, 0xff92, 0xfffe, 0x00fe, 0x00fe, 0x33b1, 0x55d2, 0x8053,
  0xff84, 0xff91, 0x00fd, 0x00fd, 0x00fd, 0x33b0, 0x55ab, 0x8031,
  0xff83, 0x0090, 0x00fc, 0x00fc, 0x00fc, 0x3389, 0x5589, 0x8005,
  0x0082, 0x008f, 0x00fb, 0x00fb, 0x00d5, 0x3367, 0x555d, 0x8000,
  0x0081, 0x008e, 0x00fa, 0x00d4, 0x00b3, 0x333b, 0x5558, 0x7fff,
  0x0080, 0x008d, 0x00d3, 0x00b2, 0x0087, 0x3336, 0x5557, 0x7ffe,
  0x008d, 0x00d3, 0x00b2, 0x0087, 0x3336, 0x5557, 0x7ffe, 0x7ffe,
  0x0066, 0x00b1, 0x0086, 0x0082, 0x3335, 0x5556, 0x7ffd, 0x7ffd,
  0x0044, 0x0085, 0x0081, 0x0081, 0x3334, 0x5555, 0x7ffc, 0x7ffc,
  0x0018, 0x0080, 0x0080, 0x0080, 0x3333, 0x5554, 0x7ffb, 0x7ff6,
  0x0013, 0x007f, 0x007f, 0x007f, 0x3332, 0x5553, 0x7ff5, 0x7fcb,
  0x0012, 0x007e, 0x007e, 0x007e, 0x3331, 0x554d, 0x7fca, 0x7fa9,
  0x0011, 0x007d, 0x007d, 0x007d, 0x332b, 0x5522, 0x7fa8, 0x7f81,
  0x0010, 0x007c, 0x007c, 0x0077, 0x3300, 0x5500, 0x7f80, 0x7f80,
  0x000f, 0x007b, 0x0076, 0x004c, 0x32de, 0x54d8, 0x7f7f, 0x7f7f,
  0x000e, 0x0075, 0x004b, 0x002a, 0x32b6, 0x54d7, 0x7f7e, 0x807e,
  0x0008, 0x004a, 0x0029, 0x0002, 0x32b5, 0x54d6, 0x807d, 0x807d,
  0xffdd, 0x0028, 0x0001, 0x0001, 0x32b4, 0x55d5, 0x807c, 0x807c,
  0xffbb, 0x0000, 0x0000, 0x0000, 0x33b3, 0x55d4, 0x807b, 0x807b,
  0xff93, 0xffff, 0xffff, 0x00ff, 0x33b2, 0x55d3, 0x807a, 0x8054,
  0xff92, 0xfffe, 0x00fe, 0x00fe, 0x33b1, 0x55d2, 0x8053, 0x8032,
  0xff91, 0x00fd, 0x00fd, 0x00fd, 0x33b0, 0x55ab, 0x8031, 0x8006,
  0x0090, 0x00fc, 0x00fc, 0x00fc, 0x3389, 0x5589, 0x8005, 0x8001,
  0x008f, 0x00fb, 0x00fb, 0x00d5, 0x3367, 0x555d, 0x8000, 0x8000,
  0x008e, 0x00fa, 0x00d4, 0x00b3, 0x333b, 0x5558, 0x7fff, 0x7fff,
  0x00fa, 0x00d4, 0x00b3, 0x333b, 0x5558, 0x7fff, 0x7fff, 0x7fff,
  0x00d3, 0x00b2, 0x0087, 0x3336, 0x5557, 0x7ffe, 0x7ffe, 0x7ffe,
  0x00b1, 0x0086, 0x0082, 0x3335, 0x5556, 0x7ffd, 0x7ffd, 0x7ffd,
  0x0085, 0x0081, 0x0081, 0x3334, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7,
  0x0080, 0x0080, 0x0080, 0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc,
  0x007f, 0x007f, 0x007f, 0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa,
  0x007e, 0x007e, 0x007e, 0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82,
  0x007d, 0x007d, 0x007d, 0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81,
  0x007c, 0x007c, 0x0077, 0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80,
  0x007b, 0x0076, 0x004c, 0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x807f,
  0x0075, 0x004b, 0x002a, 0x32b6, 0x54d7, 0x7f7e, 0x807e, 0x807e,
  0x004a, 0x0029, 0x0002, 0x32b5, 0x54d6, 0x807d, 0x807d, 0x807d,
  0x0028, 0x0001, 0x0001, 0x32b4, 0x55d5, 0x807c, 0x807c, 0x807c,
  0x0000, 0x0000, 0x0000, 0x33b3, 0x55d4, 0x807b, 0x807b, 0x8055,
  0xffff, 0xffff, 0x00ff, 0x33b2, 0x55d3, 0x807a, 0x8054, 0x8033,
  0xfffe, 0x00fe, 0x00fe, 0x33b1, 0x55d2, 0x8053, 0x8032, 0x8007,
  0x00fd, 0x00fd, 0x00fd, 0x33b0, 0x55ab, 0x8031, 0x8006, 0x8002,
  0x00fc, 0x00fc, 0x00fc, 0x3389, 0x5589, 0x8005, 0x8001, 0x8001,
  0x00fb, 0x00fb, 0x00d5, 0x3367, 0x555d, 0x8000, 0x8000, 0x8000,
  0x00fb, 0x00d5, 0x3367, 0x555d, 0x8000, 0x8000, 0x8000, 0x8000,
  0x00d4, 0x00b3, 0x333b, 0x5558, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x00b2, 0x0087, 0x3336, 0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe,
  0x0086, 0x0082, 0x3335, 0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ff8,
  0x0081, 0x0081, 0x3334, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0x7fcd,
  0x0080, 0x0080, 0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0x7fab,
  0x007f, 0x007f, 0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0x7f83,
  0x007e, 0x007e, 0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82, 0x7f82,
  0x007d, 0x007d, 0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81, 0x7f81,
  0x007c, 0x0077, 0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80, 0x8080,
  0x0076, 0x004c, 0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x807f, 0x807f,
  0x004b, 0x002a, 0x32b6, 0x54d7, 0x7f7e, 0x807e, 0x807e, 0x807e,
  0x0029, 0x0002, 0x32b5, 0x54d6, 0x807d, 0x807d, 0x807d, 0x807d,
  0x0001, 0x0001, 0x32b4, 0x55d5, 0x807c, 0x807c, 0x807c, 0x8056,
  0x0000, 0x0000, 0x33b3, 0x55d4, 0x807b, 0x807b, 0x8055, 0x8034,
  0xffff, 0x00ff, 0x33b2, 0x55d3, 0x807a, 0x8054, 0x8033, 0x8008,
  0x00fe, 0x00fe, 0x33b1, 0x55d2, 0x8053, 0x8032, 0x8007, 0x8003,
  0x00fd, 0x00fd, 0x33b0, 0x55ab, 0x8031, 0x8006, 0x8002, 0x8002,
  0x00fc, 0x00fc, 0x3389, 0x5589, 0x8005, 0x8001, 0x8001, 0x8001,
  0x00fc, 0x3389, 0x5589, 0x8005, 0x8001, 0x8001, 0x8001, 0x8001,
  0x00d5, 0x3367, 0x555d, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x00b3, 0x333b, 0x5558, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0087, 0x3336, 0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ff9,
  0x0082, 0x3335, 0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ff8, 0x7fce,
  0x0081, 0x3334, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0x7fcd, 0x7fac,
  0x0080, 0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0x7fab, 0x7f84,
  0x007f, 0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0x7f83, 0x7f83,
  0x007e, 0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82, 0x7f82, 0x7f82,
  0x007d, 0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81, 0x7f81, 0x8081,
  0x0077, 0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80, 0x8080, 0x8080,
  0x004c, 0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x807f, 0x807f, 0x807f,
  0x002a, 0x32b6, 0x54d7, 0x7f7e, 0x807e, 0x807e, 0x807e, 0x807e,
  0x0002, 0x32b5, 0x54d6, 0x807d, 0x807d, 0x807d, 0x807d, 0x8057,
  0x0001, 0x32b4, 0x55d5, 0x807c, 0x807c, 0x807c, 0x8056, 0x8035,
  0x0000, 0x33b3, 0x55d4, 0x807b, 0x807b, 0x8055, 0x8034, 0x8009,
  0x00ff, 0x33b2, 0x55d3, 0x807a, 0x8054, 0x8033, 0x8008, 0x8004,
  0x00fe, 0x33b1, 0x55d2, 0x8053, 0x8032, 0x8007, 0x8003, 0x8003,
  0x00fd, 0x33b0, 0x55ab, 0x8031, 0x8006, 0x8002, 0x8002, 0x8002,
  0x33b0, 0x55ab, 0x8031, 0x8006, 0x8002, 0x8002, 0x8002, 0xaaaa,
  0x3389, 0x5589, 0x8005, 0x8001, 0x8001, 0x8001, 0x8001, 0xaaa9,
  0x3367, 0x555d, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xaaa8,
  0x333b, 0x5558, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xaaa2,
  0x3336, 0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ff9, 0xaa77,
  0x3335, 0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ff8, 0x7fce, 0xaa55,
  0x3334, 0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0x7fcd, 0x7fac, 0xaa2d,
  0x3333, 0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0x7fab, 0x7f84, 0xaa2c,
  0x3332, 0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0x7f83, 0x7f83, 0xaa2b,
  0x3331, 0x554d, 0x7fca, 0x7fa9, 0x7f82, 0x7f82, 0x7f82, 0xab2a,
  0x332b, 0x5522, 0x7fa8, 0x7f81, 0x7f81, 0x7f81, 0x8081, 0xab29,
  0x3300, 0x5500, 0x7f80, 0x7f80, 0x7f80, 0x8080, 0x8080, 0xab28,
  0x32de, 0x54d8, 0x7f7f, 0x7f7f, 0x807f, 0x807f, 0x807f, 0xab27,
  0x32b6, 0x54d7, 0x7f7e, 0x807e, 0x807e, 0x807e, 0x807e, 0xab00,
  0x32b5, 0x54d6, 0x807d, 0x807d, 0x807d, 0x807d, 0x8057, 0xaade,
  0x32b4, 0x55d5, 0x807c, 0x807c, 0x807c, 0x8056, 0x8035, 0xaab2,
  0x33b3, 0x55d4, 0x807b, 0x807b, 0x8055, 0x8034, 0x8009, 0xaaad,
  0x33b2, 0x55d3, 0x807a, 0x8054, 0x8033, 0x8008, 0x8004, 0xaaac,
  0x33b1, 0x55d2, 0x8053, 0x8032, 0x8007, 0x8003, 0x8003, 0xaaab,
  0x55d2, 0x8053, 0x8032, 0x8007, 0x8003, 0x8003, 0xaaab, 0xcccc,
  0x55ab, 0x8031, 0x8006, 0x8002, 0x8002, 0x8002, 0xaaaa, 0xcccb,
  0x5589, 0x8005, 0x8001, 0x8001, 0x8001, 0x8001, 0xaaa9, 0xccca,
  0x555d, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xaaa8, 0xccc4,
  0x5558, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xaaa2, 0xcc99,
  0x5557, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ff9, 0xaa77, 0xcc77,
  0x5556, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ff8, 0x7fce, 0xaa55, 0xcc4f,
  0x5555, 0x7ffc, 0x7ffc, 0x7ff7, 0x7fcd, 0x7fac, 0xaa2d, 0xcc4e,
  0x5554, 0x7ffb, 0x7ff6, 0x7fcc, 0x7fab, 0x7f84, 0xaa2c, 0xcc4d,
  0x5553, 0x7ff5, 0x7fcb, 0x7faa, 0x7f83, 0x7f83, 0xaa2b, 0xcd4c,
  0x554d, 0x7fca, 0x7fa9, 0x7f82, 0x7f82, 0x7f82, 0xab2a, 0xcd4b,
  0x5522, 0x7fa8, 0x7f81, 0x7f81, 0x7f81, 0x8081, 0xab29, 0xcd4a,
  0x5500, 0x7f80, 0x7f80, 0x7f80, 0x8080, 0x8080, 0xab28, 0xcd49,
  0x54d8, 0x7f7f, 0x7f7f, 0x807f, 0x807f, 0x807f, 0xab27, 0xcd22,
  0x54d7, 0x7f7e, 0x807e, 0x807e, 0x807e, 0x807e, 0xab00, 0xcd00,
  0x54d6, 0x807d, 0x807d, 0x807d, 0x807d, 0x8057, 0xaade, 0xccd4,
  0x55d5, 0x807c, 0x807c, 0x807c, 0x8056, 0x8035, 0xaab2, 0xcccf,
  0x55d4, 0x807b, 0x807b, 0x8055, 0x8034, 0x8009, 0xaaad, 0xccce,
  0x55d3, 0x807a, 0x8054, 0x8033, 0x8008, 0x8004, 0xaaac, 0xcccd,
  0x807a, 0x8054, 0x8033, 0x8008, 0x8004, 0xaaac, 0xcccd, 0xff80,
  0x8053, 0x8032, 0x8007, 0x8003, 0x8003, 0xaaab, 0xcccc, 0xff7f,
  0x8031, 0x8006, 0x8002, 0x8002, 0x8002, 0xaaaa, 0xcccb, 0xff7e,
  0x8005, 0x8001, 0x8001, 0x8001, 0x8001, 0xaaa9, 0xccca, 0xff78,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xaaa8, 0xccc4, 0xff4d,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xaaa2, 0xcc99, 0xff2b,
  0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ff9, 0xaa77, 0xcc77, 0xff03,
  0x7ffd, 0x7ffd, 0x7ffd, 0x7ff8, 0x7fce, 0xaa55, 0xcc4f, 0xff02,
  0x7ffc, 0x7ffc, 0x7ff7, 0x7fcd, 0x7fac, 0xaa2d, 0xcc4e, 0xff01,
  0x7ffb, 0x7ff6, 0x7fcc, 0x7fab, 0x7f84, 0xaa2c, 0xcc4d, 0x0000,
  0x7ff5, 0x7fcb, 0x7faa, 0x7f83, 0x7f83, 0xaa2b, 0xcd4c, 0xffff,
  0x7fca, 0x7fa9, 0x7f82, 0x7f82, 0x7f82, 0xab2a, 0xcd4b, 0xfffe,
  0x7fa8, 0x7f81, 0x7f81, 0x7f81, 0x8081, 0xab29, 0xcd4a, 0xfffd,
  0x7f80, 0x7f80, 0x7f80, 0x8080, 0x8080, 0xab28, 0xcd49, 0xffd6,
  0x7f7f, 0x7f7f, 0x807f, 0x807f, 0x807f, 0xab27, 0xcd22, 0xffb4,
  0x7f7e, 0x807e, 0x807e, 0x807e, 0x807e, 0xab00, 0xcd00, 0xff88,
  0x807d, 0x807d, 0x807d, 0x807d, 0x8057, 0xaade, 0xccd4, 0xff83,
  0x807c, 0x807c, 0x807c, 0x8056, 0x8035, 0xaab2, 0xcccf, 0xff82,
  0x807b, 0x807b, 0x8055, 0x8034, 0x8009, 0xaaad, 0xccce, 0xff81,
  0x807b, 0x8055, 0x8034, 0x8009, 0xaaad, 0xccce, 0xff81, 0xff81,
  0x8054, 0x8033, 0x8008, 0x8004, 0xaaac, 0xcccd, 0xff80, 0xff80,
  0x8032, 0x8007, 0x8003, 0x8003, 0xaaab, 0xcccc, 0xff7f, 0xff7f,
  0x8006, 0x8002, 0x8002, 0x8002, 0xaaaa, 0xcccb, 0xff7e, 0xff79,
  0x8001, 0x8001, 0x8001, 0x8001, 0xaaa9, 0xccca, 0xff78, 0xff4e,
  0x8000, 0x8000, 0x8000, 0x8000, 0xaaa8, 0xccc4, 0xff4d, 0xff2c,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xaaa2, 0xcc99, 0xff2b, 0xff04,
  0x7ffe, 0x7ffe, 0x7ffe, 0x7ff9, 0xaa77, 0xcc77, 0xff03, 0xff03,
  0x7ffd, 0x7ffd, 0x7ff8, 0x7fce, 0xaa55, 0xcc4f, 0xff02, 0xff02,
  0x7ffc, 0x7ff7, 0x7fcd, 0x7fac, 0xaa2d, 0xcc4e, 0xff01, 0x0001,
  0x7ff6, 0x7fcc, 0x7fab, 0x7f84, 0xaa2c, 0xcc4d, 0x0000, 0x0000,
  0x7fcb, 0x7faa, 0x7f83, 0x7f83, 0xaa2b, 0xcd4c, 0xffff, 0xffff,
  0x7fa9, 0x7f82, 0x7f82, 0x7f82, 0xab2a, 0xcd4b, 0xfffe, 0xfffe,
  0x7f81, 0x7f81, 0x7f81, 0x8081, 0xab29, 0xcd4a, 0xfffd, 0xffd7,
  0x7f80, 0x7f80, 0x8080, 0x8080, 0xab28, 0xcd49, 0xffd6, 0xffb5,
  0x7f7f, 0x807f, 0x807f, 0x807f, 0xab27, 0xcd22, 0xffb4, 0xff89,
  0x807e, 0x807e, 0x807e, 0x807e, 0xab00, 0xcd00, 0xff88, 0xff84,
  0x807d, 0x807d, 0x807d, 0x8057, 0xaade, 0xccd4, 0xff83, 0xff83,
  0x807c, 0x807c, 0x8056, 0x8035, 0xaab2, 0xcccf, 0xff82, 0xff82,
  0x807c, 0x8056, 0x8035, 0xaab2, 0xcccf, 0xff82, 0xff82, 0xff82,
  0x8055, 0x8034, 0x8009, 0xaaad, 0xccce, 0xff81, 0xff81, 0xff81,
  0x8033, 0x8008, 0x8004, 0xaaac, 0xcccd, 0xff80, 0xff80, 0xff80,
  0x8007, 0x8003, 0x8003, 0xaaab, 0xcccc, 0xff7f, 0xff7f, 0xff7a,
  0x8002, 0x8002, 0x8002, 0xaaaa, 0xcccb, 0xff7e, 0xff79, 0xff4f,
  0x8001, 0x8001, 0x8001, 0xaaa9, 0xccca, 0xff78, 0xff4e, 0xff2d,
  0x8000, 0x8000, 0x8000, 0xaaa8, 0xccc4, 0xff4d, 0xff2c, 0xff05,
  0x7fff, 0x7fff, 0x7fff, 0xaaa2, 0xcc99, 0xff2b, 0xff04, 0xff04,
  0x7ffe, 0x7ffe, 0x7ff9, 0xaa77, 0xcc77, 0xff03, 0xff03, 0xff03,
  0x7ffd, 0x7ff8, 0x7fce, 0xaa55, 0xcc4f, 0xff02, 0xff02, 0x0002,
  0x7ff7, 0x7fcd, 0x7fac, 0xaa2d, 0xcc4e, 0xff01, 0x0001, 0x0001,
  0x7fcc, 0x7fab, 0x7f84, 0xaa2c, 0xcc4d, 0x0000, 0x0000, 0x0000,
  0x7faa, 0x7f83, 0x7f83, 0xaa2b, 0xcd4c, 0xffff, 0xffff, 0xffff,
  0x7f82, 0x7f82, 0x7f82, 0xab2a, 0xcd4b, 0xfffe, 0xfffe, 0xffd8,
  0x7f81, 0x7f81, 0x8081, 0xab29, 0xcd4a, 0xfffd, 0xffd7, 0xffb6,
  0x7f80, 0x8080, 0x8080, 0xab28, 0xcd49, 0xffd6, 0xffb5, 0xff8a,
  0x807f, 0x807f, 0x807f, 0xab27, 0xcd22, 0xffb4, 0xff89, 0xff85,
  0x807e, 0x807e, 0x807e, 0xab00, 0xcd00, 0xff88, 0xff84, 0xff84,
  0x807d, 0x807d, 0x8057, 0xaade, 0xccd4, 0xff83, 0xff83, 0xff83,
  0x807d, 0x8057, 0xaade, 0xccd4, 0xff83, 0xff83, 0xff83, 0xff83,
  0x8056, 0x8035, 0xaab2, 0xcccf, 0xff82, 0xff82, 0xff82, 0xff82,
  0x8034, 0x8009, 0xaaad, 0xccce, 0xff81, 0xff81, 0xff81, 0xff81,
  0x8008, 0x8004, 0xaaac, 0xcccd, 0xff80, 0xff80, 0xff80, 0xff7b,
  0x8003, 0x8003, 0xaaab, 0xcccc, 0xff7f, 0xff7f, 0xff7a, 0xff50,
  0x8002, 0x8002, 0xaaaa, 0xcccb, 0xff7e, 0xff79, 0xff4f, 0xff2e,
  0x8001, 0x8001, 0xaaa9, 0xccca, 0xff78, 0xff4e, 0xff2d, 0xff06,
  0x8000, 0x8000, 0xaaa8, 0xccc4, 0xff4d, 0xff2c, 0xff05, 0xff05,
  0x7fff, 0x7fff, 0xaaa2, 0xcc99, 0xff2b, 0xff04, 0xff04, 0xff04,
  0x7ffe, 0x7ff9, 0xaa77, 0xcc77, 0xff03, 0xff03, 0xff03, 0x0003,
  0x7ff8, 0x7fce, 0xaa55, 0xcc4f, 0xff02, 0xff02, 0x0002, 0x0002,
  0x7fcd, 0x7fac, 0xaa2d, 0xcc4e, 0xff01, 0x0001, 0x0001, 0x0001,
  0x7fab, 0x7f84, 0xaa2c, 0xcc4d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7f83, 0x7f83, 0xaa2b, 0xcd4c, 0xffff, 0xffff, 0xffff, 0xffd9,
  0x7f82, 0x7f82, 0xab2a, 0xcd4b, 0xfffe, 0xfffe, 0xffd8, 0xffb7,
  0x7f81, 0x8081, 0xab29, 0xcd4a, 0xfffd, 0xffd7, 0xffb6, 0xff8b,
  0x8080, 0x8080, 0xab28, 0xcd49, 0xffd6, 0xffb5, 0xff8a, 0xff86,
  0x807f, 0x807f, 0xab27, 0xcd22, 0xffb4, 0xff89, 0xff85, 0xff85,
  0x807e, 0x807e, 0xab00, 0xcd00, 0xff88, 0xff84, 0xff84, 0xff84,
  0x807e, 0xab00, 0xcd00, 0xff88, 0xff84, 0xff84, 0xff84, 0xfff0,
  0x8057, 0xaade, 0xccd4, 0xff83, 0xff83, 0xff83, 0xff83, 0xffef,
  0x8035, 0xaab2, 0xcccf, 0xff82, 0xff82, 0xff82, 0xff82, 0xffee,
  0x8009, 0xaaad, 0xccce, 0xff81, 0xff81, 0xff81, 0xff81, 0xffe8,
  0x8004, 0xaaac, 0xcccd, 0xff80, 0xff80, 0xff80, 0xff7b, 0xffbd,
  0x8003, 0xaaab, 0xcccc, 0xff7f, 0xff7f, 0xff7a, 0xff50, 0xff9b,
  0x8002, 0xaaaa, 0xcccb, 0xff7e, 0xff79, 0xff4f, 0xff2e, 0xff73,
  0x8001, 0xaaa9, 0xccca, 0xff78, 0xff4e, 0xff2d, 0xff06, 0xff72,
  0x8000, 0xaaa8, 0xccc4, 0xff4d, 0xff2c, 0xff05, 0xff05, 0xff71,
  0x7fff, 0xaaa2, 0xcc99, 0xff2b, 0xff04, 0xff04, 0xff04, 0x0070,
  0x7ff9, 0xaa77, 0xcc77, 0xff03, 0xff03, 0xff03, 0x0003, 0x006f,
  0x7fce, 0xaa55, 0xcc4f, 0xff02, 0xff02, 0x0002, 0x0002, 0x006e,
  0x7fac, 0xaa2d, 0xcc4e, 0xff01, 0x0001, 0x0001, 0x0001, 0x006d,
  0x7f84, 0xaa2c, 0xcc4d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0046,
  0x7f83, 0xaa2b, 0xcd4c, 0xffff, 0xffff, 0xffff, 0xffd9, 0x0024,
  0x7f82, 0xab2a, 0xcd4b, 0xfffe, 0xfffe, 0xffd8, 0xffb7, 0xfff8,
  0x8081, 0xab29, 0xcd4a, 0xfffd, 0xffd7, 0xffb6, 0xff8b, 0xfff3,
  0x8080, 0xab28, 0xcd49, 0xffd6, 0xffb5, 0xff8a, 0xff86, 0xfff2,
  0x807f, 0xab27, 0xcd22, 0xffb4, 0xff89, 0xff85, 0xff85, 0xfff1,
  0xab27, 0xcd22, 0xffb4, 0xff89, 0xff85, 0xff85, 0xfff1, 0xfffd,
  0xab00, 0xcd00, 0xff88, 0xff84, 0xff84, 0xff84, 0xfff0, 0xfffc,
  0xaade, 0xccd4, 0xff83, 0xff83, 0xff83, 0xff83, 0xffef, 0xfffb,
  0xaab2, 0xcccf, 0xff82, 0xff82, 0xff82, 0xff82, 0xffee, 0xfff5,
  0xaaad, 0xccce, 0xff81, 0xff81, 0xff81, 0xff81, 0xffe8, 0xffca,
  0xaaac, 0xcccd, 0xff80, 0xff80, 0xff80, 0xff7b, 0xffbd, 0xffa8,
  0xaaab, 0xcccc, 0xff7f, 0xff7f, 0xff7a, 0xff50, 0xff9b, 0xff80,
  0xaaaa, 0xcccb, 0xff7e, 0xff79, 0xff4f, 0xff2e, 0xff73, 0xff7f,
  0xaaa9, 0xccca, 0xff78, 0xff4e, 0xff2d, 0xff06, 0xff72, 0xff7e,
  0xaaa8, 0xccc4, 0xff4d, 0xff2c, 0xff05, 0xff05, 0xff71, 0x007d,
  0xaaa2, 0xcc99, 0xff2b, 0xff04, 0xff04, 0xff04, 0x0070, 0x007c,
  0xaa77, 0xcc77, 0xff03, 0xff03, 0xff03, 0x0003, 0x006f, 0x007b,
  0xaa55, 0xcc4f, 0xff02, 0xff02, 0x0002, 0x0002, 0x006e, 0x007a,
  0xaa2d, 0xcc4e, 0xff01, 0x0001, 0x0001, 0x0001, 0x006d, 0x0053,
  0xaa2c, 0xcc4d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0046, 0x0031,
  0xaa2b, 0xcd4c, 0xffff, 0xffff, 0xffff, 0xffd9, 0x0024, 0x0005,
  0xab2a, 0xcd4b, 0xfffe, 0xfffe, 0xffd8, 0xffb7, 0xfff8, 0x0000,
  0xab29, 0xcd4a, 0xfffd, 0xffd7, 0xffb6, 0xff8b, 0xfff3, 0xffff,
  0xab28, 0xcd49, 0xffd6, 0xffb5, 0xff8a, 0xff86, 0xfff2, 0xfffe,
  0xcd49, 0xffd6, 0xffb5, 0xff8a, 0xff86, 0xfff2, 0xfffe, 0xfffe,
  0xcd22, 0xffb4, 0xff89, 0xff85, 0xff85, 0xfff1, 0xfffd, 0xfffd,
  0xcd00, 0xff88, 0xff84, 0xff84, 0xff84, 0xfff0, 0xfffc, 0xfffc,
  0xccd4, 0xff83, 0xff83, 0xff83, 0xff83, 0xffef, 0xfffb, 0xfff6,
  0xcccf, 0xff82, 0xff82, 0xff82, 0xff82, 0xffee, 0xfff5, 0xffcb,
  0xccce, 0xff81, 0xff81, 0xff81, 0xff81, 0xffe8, 0xffca, 0xffa9,
  0xcccd, 0xff80, 0xff80, 0xff80, 0xff7b, 0xffbd, 0xffa8, 0xff81,
  0xcccc, 0xff7f, 0xff7f, 0xff7a, 0xff50, 0xff9b, 0xff80, 0xff80,
  0xcccb, 0xff7e, 0xff79, 0xff4f, 0xff2e, 0xff73, 0xff7f, 0xff7f,
  0xccca, 0xff78, 0xff4e, 0xff2d, 0xff06, 0xff72, 0xff7e, 0x007e,
  0xccc4, 0xff4d, 0xff2c, 0xff05, 0xff05, 0xff71, 0x007d, 0x007d,
  0xcc99, 0xff2b, 0xff04, 0xff04, 0xff04, 0x0070, 0x007c, 0x007c,
  0xcc77, 0xff03, 0xff03, 0xff03, 0x0003, 0x006f, 0x007b, 0x007b,
  0xcc4f, 0xff02, 0xff02, 0x0002, 0x0002, 0x006e, 0x007a, 0x0054,
  0xcc4e, 0xff01, 0x0001, 0x0001, 0x0001, 0x006d, 0x0053, 0x0032,
  0xcc4d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0046, 0x0031, 0x0006,
  0xcd4c, 0xffff, 0xffff, 0xffff, 0xffd9, 0x0024, 0x0005, 0x0001,
  0xcd4b, 0xfffe, 0xfffe, 0xffd8, 0xffb7, 0xfff8, 0x0000, 0x0000,
  0xcd4a, 0xfffd, 0xffd7, 0xffb6, 0xff8b, 0xfff3, 0xffff, 0xffff,
  0xfffd, 0xffd7, 0xffb6, 0xff8b, 0xfff3, 0xffff, 0xffff, 0xffff,
  0xffd6, 0xffb5, 0xff8a, 0xff86, 0xfff2, 0xfffe, 0xfffe, 0xfffe,
  0xffb4, 0xff89, 0xff85, 0xff85, 0xfff1, 0xfffd, 0xfffd, 0xfffd,
  0xff88, 0xff84, 0xff84, 0xff84, 0xfff0, 0xfffc, 0xfffc, 0xfff7,
  0xff83, 0xff83, 0xff83, 0xff83, 0xffef, 0xfffb, 0xfff6, 0xffcc,
  0xff82, 0xff82, 0xff82, 0xff82, 0xffee, 0xfff5, 0xffcb, 0xffaa,
  0xff81, 0xff81, 0xff81, 0xff81, 0xffe8, 0xffca, 0xffa9, 0xff82,
  0xff80, 0xff80, 0xff80, 0xff7b, 0xffbd, 0xffa8, 0xff81, 0xff81,
  0xff7f, 0xff7f, 0xff7a, 0xff50, 0xff9b, 0xff80, 0xff80, 0xff80,
  0xff7e, 0xff79, 0xff4f, 0xff2e, 0xff73, 0xff7f, 0xff7f, 0x007f,
  0xff78, 0xff4e, 0xff2d, 0xff06, 0xff72, 0xff7e, 0x007e, 0x007e,
  0xff4d, 0xff2c, 0xff05, 0xff05, 0xff71, 0x007d, 0x007d, 0x007d,
  0xff2b, 0xff04, 0xff04, 0xff04, 0x0070, 0x007c, 0x007c, 0x007c,
  0xff03, 0xff03, 0xff03, 0x0003, 0x006f, 0x007b, 0x007b, 0x0055,
  0xff02, 0xff02, 0x0002, 0x0002, 0x006e, 0x007a, 0x0054, 0x0033,
  0xff01, 0x0001, 0x0001, 0x0001, 0x006d, 0x0053, 0x0032, 0x0007,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0046, 0x0031, 0x0006, 0x0002,
  0xffff, 0xffff, 0xffff, 0xffd9, 0x0024, 0x0005, 0x0001, 0x0001,
  0xfffe, 0xfffe, 0xffd8, 0xffb7, 0xfff8, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_ssubw2_8H = 456;

#endif  // VIXL_SIM_SSUBW2_8H_TRACE_AARCH64_H_
