RabbitMQ `3.12.1` is a maintenance release in the `3.12.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from the [3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0)
if upgrading from a version prior to 3.12.0.

This release requires Erlang 25 and supports Erlang versions up to `26.0.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.12.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.11.x (or older releases) on Erlang 25 to 3.12.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.12.x/release-notes).

### Core Server

#### Bug Fixes

 * Declaration of a classic queue could run into an exception.

   GitHub issue: [#8629](https://github.com/rabbitmq/rabbitmq-server/pull/8629)

 * Classic queues v1 (CQv1) that had a backlog of messages stored by 3.9 and earlier versions
   could run into an exception during queue index recovery after an upgrade to 3.10.x or any later series.

   CQv2 and queues without a backlog were not affected.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#8453](https://github.com/rabbitmq/rabbitmq-server/pull/8453)

 * Nodes that had a large number of quorum queues could observe accumulation of Erlang processes
   under significant load. A follow-up change to [#7389](https://github.com/rabbitmq/rabbitmq-server/issues/7389).

   GitHub issue: [#8591](https://github.com/rabbitmq/rabbitmq-server/pull/8591)

 * Feature flag discovery on a newly added node could discover an incomplete inventory of feature flags.

   GitHub issue: [#8477](https://github.com/rabbitmq/rabbitmq-server/pull/8477)

 * Feature flag discovery operations will now be retried multiple times in case of network failures.

   GitHub issue: [#8491](https://github.com/rabbitmq/rabbitmq-server/pull/8491)

 * Nodes in clusters that had quorum queues and non-mirrored classic queues on stopped (or failed) nodes
   could run into an exception.

   The same exception could affect `rabbitmqctl list_queues`.

   GitHub issue: [#8596](https://github.com/rabbitmq/rabbitmq-server/pull/8596)

 * Proxy Protocol v2 LOCAL packets were not supported.

   GitHub issue: [#8654](https://github.com/rabbitmq/rabbitmq-server/issues/8654)

#### Enhancements

 * When a quorum queue does not find its local replica data files on boot, it will now log
   a warning.

   GitHub issue: [#8630](https://github.com/rabbitmq/rabbitmq-server/pull/8630)


### Management Plugin

#### Bug Fixes

 * An attempt to clear limits of a non-existent virtual host failed with a 500 status code.

   GitHub issue: [#8523](https://github.com/rabbitmq/rabbitmq-server/pull/8523)

#### Enhacements

 * Management UI will now display node maintenance status.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#8558](https://github.com/rabbitmq/rabbitmq-server/issues/8558)

 * The "Queues" tab in the UI was renamed to "Queue and Streams" to better reflect
   its contents.

   GitHub issue: [#8520](https://github.com/rabbitmq/rabbitmq-server/pull/8520)

 * New HTTP API endpoints for quorum queue replica management, equivalent to
   the `rabbitmq-queues` commands that manage replicas.

   ```
   POST /api/queues/quorum/{vhost}/{name}/replicas/add
   DELETE /api/queues/quorum/{vhost}/{name}/replicas/remove
   POST /api/queues/quorum/replicas/on/{node}/grow
   DELETE /api/queues/quorum/replicas/on/{node}/shrink
   ```

   GitHub issue: [#8561](https://github.com/rabbitmq/rabbitmq-server/pull/8561)

### Stream Plugin

#### Bug Fixes

 * Stream client connections that authenticated using x.509 certificates
   failed.

   GitHub issue: [#8488](https://github.com/rabbitmq/rabbitmq-server/pull/8488)

### OAuth 2 Plugin

#### Bug Fixes

 * Only set OAuth 2 client's CA certificate file setting when it is defined.

   GitHub issue: [#8548](https://github.com/rabbitmq/rabbitmq-server/pull/8548)

#### Enhancements

 * The plugin will now accept JWT tokens without a `scope`. Such tokens would only be useful when the plugin
   is used exclusively for authentication and not authorization.

   GitHub issue: [#8391](https://github.com/rabbitmq/rabbitmq-server/issues/8391)

 * `oauth2` is now an accepted alias for the OAuth 2 authentication and authorization backend:

   ```
   auth_backends.1 = oauth2
   ```

   Previously the only option for OAuth 2 was using a full module name,
   `rabbit_auth_backend_oauth2`.

   GitHub issue: [#8513](https://github.com/rabbitmq/rabbitmq-server/pull/8513)


### STOMP Plugin

#### Bug Fixes

 * STOMP plugin log entries had an extra line feed character.

   GitHub issue: [#2568](https://github.com/rabbitmq/rabbitmq-server/issues/2568)


## Dependency Upgrades

 * `ra` was upgraded to [`2.6.2`](https://github.com/rabbitmq/ra/releases)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.12.1.tar.xz`
instead of the source tarball produced by GitHub.
