% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hooks-html.R, R/hooks-asciidoc.R,
%   R/hooks-latex.R, R/hooks-md.R, R/hooks-rst.R, R/hooks-textile.R
\name{render_html}
\alias{render_html}
\alias{hooks_html}
\alias{render_asciidoc}
\alias{hooks_asciidoc}
\alias{render_latex}
\alias{hooks_latex}
\alias{render_sweave}
\alias{hooks_sweave}
\alias{render_listings}
\alias{hooks_listings}
\alias{render_markdown}
\alias{hooks_markdown}
\alias{render_jekyll}
\alias{hooks_jekyll}
\alias{render_rst}
\alias{hooks_rst}
\alias{render_textile}
\alias{hooks_textile}
\title{Set or get output hooks for different output formats}
\usage{
render_html()

hooks_html()

render_asciidoc()

hooks_asciidoc()

render_latex()

hooks_latex()

render_sweave()

hooks_sweave(envirs = c("Sinput", "Soutput", "Schunk"))

render_listings()

hooks_listings(envirs = c("Sinput", "Soutput", "Schunk"))

render_markdown(strict = FALSE, fence_char = "`")

hooks_markdown(strict = FALSE, fence_char = "`")

render_jekyll(highlight = c("pygments", "prettify", "none"), extra = "")

hooks_jekyll(highlight = c("pygments", "prettify", "none"), extra = "")

render_rst(strict = FALSE)

hooks_rst(strict = FALSE)

render_textile()

hooks_textile()
}
\arguments{
\item{envirs}{Names of LaTeX environments for code input, output, and chunk.}

\item{strict}{Boolean; whether to use strict markdown or reST syntax. For markdown, if
\code{TRUE}, code blocks will be indented by 4 spaces, otherwise they are
put in fences made by three backticks. For reST, if \code{TRUE}, code is
put under two colons and indented by 4 spaces, otherwise it is put under the
\samp{sourcecode} directive (this is useful for e.g. Sphinx).}

\item{fence_char}{A single character to be used in the code blocks fence.
This can be e.g. a backtick or a tilde, depending on your Markdown rendering
engine.}

\item{highlight}{Which code highlighting engine to use: if \code{pygments},
the Liquid syntax is used (default approach Jekyll); if \code{prettify},
the output is prepared for the JavaScript library \file{prettify.js}; if
\code{none}, no highlighting engine will be used, and code blocks are simply
indented by 4 spaces).}

\item{extra}{Extra tags for the highlighting engine. For \code{pygments}, this
can be \code{'linenos'}; for \code{prettify}, it can be \code{'linenums'}.}
}
\value{
\code{NULL} for \code{render_*} functions; corresponding hooks are
  set as a side effect. A list of output hooks for \code{hooks_*()}
  functions.
}
\description{
The \code{render_*()} functions set built-in output hooks for LaTeX, HTML,
Markdown, reStructuredText, AsciiDoc, and Textile. The \code{hooks_*()}
functions return a list of the output hooks for the corresponding format.
}
\details{
There are three variants of Markdown documents: ordinary Markdown
(\code{render_markdown(strict = TRUE)}, which calls
\code{hooks_markdown(strict = TRUE)}), extended Markdown (e.g., GitHub
Flavored Markdown and Pandoc; \code{render_markdown(strict = FALSE)}, which
calls \code{hooks_markdown(strict = FALSE)}), and Jekyll (a blogging system
on GitHub; \code{render_jekyll()}, which calls \code{hooks_jekyll()}).

For LaTeX output, there are three variants: \pkg{knitr}'s default style
(\code{render_latex()}, which calls \code{hooks_latex()} and uses the LaTeX
\pkg{framed} package), Sweave style (\code{render_sweave()}, which calls
\code{hooks_sweave()} and uses \file{Sweave.sty}), and listings style
(\code{render_listings()}, which calls \code{hooks_listings()} and uses LaTeX
\pkg{listings} package).

Default HTML output hooks are set by \code{render_html()} (which calls
\code{hooks_html()}); \code{render_rst()} (which calls \code{hooks_rst()}) is
for reStructuredText; \code{render_textile()} (which calls
\code{hooks_textile()}) is for Textile, and \code{render_asciidoc()} (which
calls \code{hooks_asciidoc()}) is AsciiDoc.

The \code{render_*()} functions can be used before \code{knit()} or in the
first chunk of the input document (ideally this chunk has options
\code{include = FALSE} and \code{cache = FALSE}) so that all the following
chunks will be formatted as expected.

You can also use \code{\link{knit_hooks}} to set the format's hooks with the
\code{hooks_*()} functions; see references for more info on further
customizing output hooks.
}
\examples{
# below is pretty much what knitr::render_markdown() does:
knitr::knit_hooks$set(knitr::hooks_markdown())

# you can retrieve a subset of the hooks and set them, e.g.,
knitr::knit_hooks$set(knitr::hooks_markdown()["source"])

knitr::knit_hooks$restore()
}
\references{
See output hooks in \url{https://yihui.org/knitr/hooks/}, and
  some examples in
  \url{https://bookdown.org/yihui/rmarkdown-cookbook/output-hooks.html}

  Jekyll and Liquid:
  \url{https://github.com/jekyll/jekyll/wiki/Liquid-Extensions}; prettify.js:
  \url{https://code.google.com/archive/p/google-code-prettify}
}
