% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.family.R
\name{enrich.family}
\alias{enrich.family}
\title{Enrich objects of class \code{\link{family}}}
\usage{
\method{enrich}{family}(object, with = "all", ...)
}
\arguments{
\item{object}{an object of class \code{\link{family}}}

\item{with}{a character vector with enrichment options for \code{object}}

\item{...}{extra arguments to be passed to the \code{compute_*}
functions}
}
\value{
The object \code{object} of class \code{\link{family}} with
    extra components. \code{get_enrichment_options.family()}
    returns the components and their descriptions.
}
\description{
Enrich objects of class \code{\link{family}} with family-specific
mathematical functions
}
\details{
\code{\link[stats]{family}} objects specify characteristics of the
models used by functions such as \code{\link[stats]{glm}}. The
families implemented in the \code{stats} package include
\code{\link[stats]{binomial}}, \code{\link[stats]{gaussian}},
\code{\link[stats]{Gamma}}, \code{\link[stats]{inverse.gaussian}},
and \code{\link[stats]{poisson}}, which are all special cases of
the exponential family of distributions that have probability mass
or density function of the form \deqn{f(y; \theta, \phi) =
\exp\left\{\frac{y\theta - b(\theta) - c_1(y)}{\phi/m} -
\frac{1}{2}a\left(-\frac{m}{\phi}\right) + c_2(y)\right\} \quad y
\in Y \subset \Re\,, \theta \in \Theta \subset \Re\, , \phi >
0}{f(y, theta, phi) = exp((y * theta - b(theta) - c_1(y))/(phi/m) -
a(-m/phi)/2 + c_2(y))} where \eqn{m > 0}{m > 0} is an observation
weight, and \eqn{a(.)}{a(.)}, \eqn{b(.)}{b(.)},
\eqn{c_1(.)}{c_1(.)} and \eqn{c_2(.)}{c_2(.)} are sufficiently
smooth, real-valued functions.

The current implementation of \code{\link[stats]{family}} objects
includes the variance function (\code{variance}), the deviance
residuals (\code{dev.resids}), and the Akaike information criterion
(\code{aic}). See, also \code{\link{family}}.

The \code{enrich} method can further enrich exponential
\code{\link{family}} distributions with \eqn{\theta}{theta} in
terms of \eqn{\mu}{mu} (\code{theta}), the functions
\eqn{b(\theta)}{b(theta)} (\code{bfun}), \eqn{c_1(y)}{c_1(y)}
(\code{c1fun}), \eqn{c_2(y)}{c_2(y)} (\code{c2fun}),
\eqn{a(\zeta)}{a(zeta)} (\code{fun}), the first two derivatives of
\eqn{V(\mu)}{V(mu)} (\code{d1variance} and \code{d2variance},
respectively), and the first four derivatives of
\eqn{a(\zeta)}{a(zeta)} (\code{d1afun}, \code{d2afun},
\code{d3afun}, \code{d4afun}, respectively).

Corresponding enrichment options are also avaialble for
\code{\link[stats]{quasibinomial}},
\code{\link[stats]{quasipoisson}} and \code{\link[gnm]{wedderburn}}
families.

The \code{\link[stats]{quasi}} families are enriched with
\code{d1variance} and \code{d2variance}.

See \code{\link{enrich.link-glm}} for the enrichment of
\code{\link[=make.link]{link-glm}} objects.
}
\examples{

## An example from ?glm to illustrate that things still work with
## enriched families
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
print(d.AD <- data.frame(treatment, outcome, counts))
glm.D93 <- glm(counts ~ outcome + treatment, family = enrich(poisson()))
anova(glm.D93)
summary(glm.D93)
}
\seealso{
\code{\link{enrich.link-glm}}, \code{\link{make.link}}
}
