% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_me_CV_errors_parallel.R
\name{calibrate_me_CV_errors}
\alias{calibrate_me_CV_errors}
\title{calibrate_me_CV_errors}
\usage{
calibrate_me_CV_errors(actual, predicted, model_idx, folds = 10, n_seeds,
  nCores)
}
\arguments{
\item{actual}{vector of observed class labels (0/1)}

\item{predicted}{vector of uncalibrated predictions}

\item{model_idx}{which calibration models should be implemented, 1=hist_scaled, 2=hist_transformed, 3=BBQ_scaled, 4=BBQ_transformed, 5=GUESS}

\item{folds}{number of folds in the cross-validation, Default: 10}

\item{n_seeds}{\code{n_seeds} determines how often random data set partition is repeated with varying seed}

\item{nCores}{\code{nCores} how many cores should be used during parallelisation. Default: 4}
}
\value{
returns all trained calibration models that were built during the \code{n_seeds}-times repeated \code{folds}-CV.
\cr Error values for each of the \code{n_seeds} CV runs are given.
}
\description{
trains and evaluates calibration models using \code{n_seeds}-times repeated \code{folds}-Cross-Validation (CV).\code{model_idx} specifies which models should be trained.
\cr Model training and evaluation is repeated \code{n_seeds}-times with a different training/test set partition scheme for the CV each time.
}
\details{
parallised execution over \code{n_seeds}
}
