% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistic-ulm.R
\name{run_ulm}
\alias{run_ulm}
\title{Univariate Linear Model (ULM)}
\usage{
run_ulm(
  mat,
  network,
  .source = source,
  .target = target,
  .mor = mor,
  .likelihood = likelihood,
  sparse = FALSE,
  center = FALSE,
  na.rm = FALSE,
  minsize = 5L
)
}
\arguments{
\item{mat}{Matrix to evaluate (e.g. expression matrix).
Target nodes in rows and conditions in columns.
\code{rownames(mat)} must have at least one intersection with the elements
in \code{network} \code{.target} column.}

\item{network}{Tibble or dataframe with edges and it's associated metadata.}

\item{.source}{Column with source nodes.}

\item{.target}{Column with target nodes.}

\item{.mor}{Column with edge mode of regulation (i.e. mor).}

\item{.likelihood}{Deprecated argument. Now it will always be set to 1.}

\item{sparse}{Deprecated parameter.}

\item{center}{Logical value indicating if \code{mat} must be centered by
\code{\link[base:colSums]{base::rowMeans()}}.}

\item{na.rm}{Should missing values (including NaN) be omitted from the
calculations of \code{\link[base:colSums]{base::rowMeans()}}?}

\item{minsize}{Integer indicating the minimum number of targets per source.}
}
\value{
A long format tibble of the enrichment scores for each source
across the samples. Resulting tibble contains the following columns:
\enumerate{
\item \code{statistic}: Indicates which method is associated with which score.
\item \code{source}: Source nodes of \code{network}.
\item \code{condition}: Condition representing each column of \code{mat}.
\item \code{score}: Regulatory activity (enrichment score).
}
}
\description{
Calculates regulatory activities using ULM.
}
\details{
ULM fits a linear model for each sample and regulator, where the observed
molecular readouts in mat are the response variable and the regulator weights
in net are the explanatory one. Target features with no associated weight
are set to zero. The obtained t-value from the fitted model is the activity
\code{ulm} of a given regulator.
}
\examples{
inputs_dir <- system.file("testdata", "inputs", package = "decoupleR")

mat <- readRDS(file.path(inputs_dir, "mat.rds"))
net <- readRDS(file.path(inputs_dir, "net.rds"))

run_ulm(mat, net, minsize=0)
}
\seealso{
Other decoupleR statistics: 
\code{\link{decouple}()},
\code{\link{run_aucell}()},
\code{\link{run_fgsea}()},
\code{\link{run_gsva}()},
\code{\link{run_mdt}()},
\code{\link{run_mlm}()},
\code{\link{run_ora}()},
\code{\link{run_udt}()},
\code{\link{run_viper}()},
\code{\link{run_wmean}()},
\code{\link{run_wsum}()}
}
\concept{decoupleR statistics}
