'\"
'\" Copyright (c) 2003-2008 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Program manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No warranty. None. Use at your own risk.
'\"
.TH OWFS 5 2006 "OWFS Configuration File Manpage" "One-Wire File System"
.SH NAME
.B owfs.conf
\- owfs programs configuration file
.SH SYNOPSIS
An OWFS configuration file is specified on the command line:
.TP 
.B owfs -c config_file [other options]
The file name is arbitrary, there is no default configuration file used.
.SH USAGE
A configuration file can be invoked for any of the OWFS programs (
.B owfs (1) owhttpd (1) owserver (1) owftpd (1)
) or any of the language bindings (
.B owperl (1) owcapi (1) owtcl (1) owphp owpython
) to set command line parameters.
.SH SYNTAX
.P
Similar to Unix shell script or perl syntax
.TP
Comments
# Any 
.I #
marks the start of a comment
.br
# blank lines are ignored

.TP
Options
.B option 
# some options (like 'foreground') take no values
.br
.B option = value 
# other options need a value
.br
.B option value   
# '=' can be omitted if whitespace separates
.br
.B Option
# Case is ignored (for options, not values)
.br
.B opt            
# non-ambiguous abbreviation allowed
.br
.B -opt --opt     
# hyphens ignored
.TP
.I owserver
.B server: 
opt = value # only
.I owserver
effected by this line
.br
.B ! server: 
opt = value # 
.I owserver
NOT effected by this line
.TP
.I owhttpd
.B http: 
opt = value # only
.I owhttpd
effected by this line
.br
.B ! http: 
opt = value # 
.I owhttpd
NOT effected by this line
.TP
.I owftpd
.B ftp: 
opt = value # only
.I owftpd
effected by this line
.br
.B ! ftp: 
opt = value # 
.I owftpd
NOT effected by this line
.TP
.I owfs
.B owfs: 
opt = value # only
.I owfs
effected by this line
.br
.B ! owfs: 
opt = value # 
.I owfs
NOT effected by this line
.TP
Limits
# maximum line length of 250 characters
.br
# no limit on number of lines
.SH "DESCRIPTION"
.so man5/description.5so
.SS Configuration
.B owfs.conf (5)
allows a uniform set of command line parameters to be set.
.P
Not all OWFS programs use the same command line options, but the non-relevant ones will be ignored.
.P
Command line and configuration options can mixed. They will be invoked in the order presented. Left to right for the command line. Top to bottom for the configuration file.
.P
Configuration files can call other configuration files. There is an arbitrary depth of 5 levels to prevent infinite loops. More than one configuration file can be specified.
.SH SAMPLE
.TP
Here is a sample configuration file with all the possible parameters included.
#
.B Sources
.br
.I device
= /dev/ttyS0 # serial port: DS9097U DS9097 ECLO or LINK
.br
.I device
= /dev/i2c-0 # i2c port: DS2482-100 or DS2482-800
.br
.I usb
#       USB device: DS9490 PuceBaboon
.br
.I usb
= 2 #   Second DS9490
.br
.I usb
= all # All DS9490s
.br
.I altUSB
# Willy Robison's tweaks
.br
.I LINK
= /dev/ttyS0 #     serial LINK in ascii mode
.br
.I LINK
= [address:]port # LINK-HUB-E (tcp access)
.br
.I HA7
# HA7Net autodiscovery mode
.br
.I HA7
= address[:port] # HA7Net at tcp address (port 80)
.br
.I etherweather
= address[:port] # Etherweather device
.br
.I server
= [address:]port #
.B owserver
tcp address
.br
.I FAKE
= 10,1B # Random simulated device with family codes (hex)
.br
.I TESTER
= 28,3E # Predictable simulated device with family codes
.br
#
.br
#
.B Sinks
.br
# #
.B owfs
specific
.br
.I mountpoint
= filelocation #
.I FUSE
mount point
.br
.I allow_other #
Short hand for
.I FUSE
mount option "\"\-o allow_other\""
.br
# #
.B owhttpd owserver owftpd
specific
.br
.I port
= [address:]port # tcp out port
.br
#
.br
#
.B Temperature scales
.br
.I Celsius
# default
.br
.I Fahrenheit
.br
.I Kelvin
.br
.I Rankine
.br
#
.br
#
.B Timeouts (all in seconds)
.br
#                    cache for values that change on their own
.br
.I timeout_volatile
= value # seconds "volatile" values remain in cache
.br
#                    cache for values that change on command
.br
.I timeout_stable
= value # seconds "stable" values remain in cache
.br
#                    cache for directory lists (non-alarm)
.br
.I timeout_directory
= value # seconds "directory" values remain in cache
.br
#                    cache for 1-wire device location
.br
.I timeout_presence
= value # seconds "device presence" (which bus)
.br
.I timeout_serial
= value # seconds to wait for serial response
.br
.I timeout_usb
= value # seconds to wait for USB response
.br
.I timeout_network
= value # seconds to wait for tcp/ip response
.br
.I timeout_ftp
= value # seconds inactivity before closing ftp session
.br
#
.br
#
.B Process control
.br
.I configuration
= filename # file (like this) of program options
.br
.I pid_file
= filename # file to store PID number
.br
.I foreground
.br
.I background
# default
.br
.I readonly
# prevent changing 1-wire device contents
.br
.I write
# default
.br
.I error_print
= 0-3 # 0-mixed 1-syslog 2-stderr 3-suppressed
.br
.I error_level
= 0-9 # increasing noise
.br
#
.br
#
.B zeroconf / Bonjour
.br
.I zero
#   turn on zeroconf announcement (default)
.br
.I nozero
#   turn off zeroconf announcement
.br
. I announce
= name  # name of announced service (optional)
.br
.I autoserver
#   Add owservers descovered by zeroconf/Bonjour
.br
.I noautoserver
#   Don't use zeroconf/Bonjour owservers (default)
.br
#
.br
#
.B tcp persistence
.br
.I timeout_persistent_low
= 600 # minimum time a persistent socket will stay open
.br
.I timeout_persistent_high
= 3600 # max time an idle client socket will stay around
.br
.I
.br
#
.br
#
.B Display
.br
.I format
= f[.]i[[.]c] # 1-wire address
.I f
amily
.I i
d code
.I c
rc
.br
#
.br
#
.B Cache
.br
.I cache_size
= 1000000 # maximum cache size (in bytes) or 0 for no limit (default 0)
#
.br
#
.B Information
.br
# (silly in a configuration file)
.br
.I version
.br
.I help
.br
.I morehelp
.SH SEE ALSO
.so man5/seealso.5so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
