/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacy;

import java.nio.ByteBuffer;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaRuleKind;
import org.neo4j.string.UTF8;

class SchemaRuleDeserializer2_0to3_1 {
    private SchemaRuleDeserializer2_0to3_1() {
    }

    static boolean isLegacySchemaRule(byte schemaRuleType) {
        return schemaRuleType >= 1 && schemaRuleType <= SchemaRuleKind.values().length;
    }

    static SchemaRule deserialize(long id, int labelId, byte kindByte, ByteBuffer buffer) throws MalformedSchemaRuleException {
        SchemaRuleKind kind = SchemaRuleKind.forId(kindByte);
        try {
            SchemaRule rule = SchemaRuleDeserializer2_0to3_1.newRule(kind, id, labelId, buffer);
            if (null == rule) {
                throw new MalformedSchemaRuleException(null, "Deserialized null schema rule for id %d with kind %s", new Object[]{id, kind.name()});
            }
            return rule;
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException((Throwable)e, "Could not deserialize schema rule for id %d with kind %s", new Object[]{id, kind.name()});
        }
    }

    private static SchemaRule newRule(SchemaRuleKind kind, long id, int labelId, ByteBuffer buffer) {
        switch (kind) {
            case INDEX_RULE: {
                return SchemaRuleDeserializer2_0to3_1.readIndexRule(id, false, labelId, buffer);
            }
            case CONSTRAINT_INDEX_RULE: {
                return SchemaRuleDeserializer2_0to3_1.readIndexRule(id, true, labelId, buffer);
            }
            case UNIQUENESS_CONSTRAINT: {
                return SchemaRuleDeserializer2_0to3_1.readUniquenessConstraintRule(id, labelId, buffer);
            }
            case NODE_PROPERTY_EXISTENCE_CONSTRAINT: {
                return SchemaRuleDeserializer2_0to3_1.readNodePropertyExistenceConstraintRule(id, labelId, buffer);
            }
            case RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT: {
                return SchemaRuleDeserializer2_0to3_1.readRelPropertyExistenceConstraintRule(id, labelId, buffer);
            }
        }
        throw new IllegalArgumentException(kind.name());
    }

    private static IndexDescriptor readIndexRule(long id, boolean constraintIndex, int label, ByteBuffer serialized) {
        String providerKey = UTF8.getDecodedStringFrom((ByteBuffer)serialized);
        String providerVersion = UTF8.getDecodedStringFrom((ByteBuffer)serialized);
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor(providerKey, providerVersion);
        int[] propertyKeyIds = SchemaRuleDeserializer2_0to3_1.readIndexPropertyKeys(serialized);
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)label, (int[])propertyKeyIds);
        String name = SchemaRuleDeserializer2_0to3_1.defaultIndexName(id);
        if (constraintIndex) {
            return IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor).withName(name).materialise(id).withOwningConstraintId(SchemaRuleDeserializer2_0to3_1.readOwningConstraint(serialized));
        }
        return IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)providerDescriptor).withName(name).materialise(id);
    }

    static String defaultIndexName(long id) {
        return "index_" + id;
    }

    private static int[] readIndexPropertyKeys(ByteBuffer serialized) {
        int count = serialized.getShort();
        assert (count >= 1);
        int[] props = new int[count];
        for (int i = 0; i < count; ++i) {
            props[i] = Numbers.safeCastLongToInt((long)serialized.getLong());
        }
        return props;
    }

    private static long readOwningConstraint(ByteBuffer serialized) {
        return serialized.getLong();
    }

    public static ConstraintDescriptor readUniquenessConstraintRule(long id, int labelId, ByteBuffer buffer) {
        int[] propertyIds = SchemaRuleDeserializer2_0to3_1.readConstraintPropertyKeys(buffer);
        Long ownedIndex = SchemaRuleDeserializer2_0to3_1.readOwnedIndexRule(buffer);
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])propertyIds);
        return constraint.withId(id).withOwnedIndexId(ownedIndex.longValue());
    }

    public static ConstraintDescriptor readNodePropertyExistenceConstraintRule(long id, int labelId, ByteBuffer buffer) {
        int propertyKey = SchemaRuleDeserializer2_0to3_1.readPropertyKey(buffer);
        return ConstraintDescriptorFactory.existsForLabel((int)labelId, (int[])new int[]{propertyKey}).withId(id);
    }

    public static ConstraintDescriptor readRelPropertyExistenceConstraintRule(long id, int relTypeId, ByteBuffer buffer) {
        int propertyKey = SchemaRuleDeserializer2_0to3_1.readPropertyKey(buffer);
        return ConstraintDescriptorFactory.existsForRelType((int)relTypeId, (int[])new int[]{propertyKey}).withId(id);
    }

    private static int readPropertyKey(ByteBuffer buffer) {
        return buffer.getInt();
    }

    private static int[] readConstraintPropertyKeys(ByteBuffer buffer) {
        int[] keys = new int[buffer.get()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = Numbers.safeCastLongToInt((long)buffer.getLong());
        }
        return keys;
    }

    private static Long readOwnedIndexRule(ByteBuffer buffer) {
        return buffer.getLong();
    }
}

