/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.Serializable;
import java.util.OptionalLong;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.internal.recordstorage.SchemaRecordChangeTranslator;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.recordstorage.TransactionRecordState;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

class TransactionToRecordStateVisitor
extends TxStateVisitor.Adapter {
    private boolean clearSchemaState;
    private final TransactionRecordState recordState;
    private final SchemaState schemaState;
    private final SchemaRuleAccess schemaStorage;
    private final SchemaRecordChangeTranslator schemaStateChanger;
    private final ConstraintRuleAccessor constraintSemantics;
    private final CursorContext cursorContext;
    private final StoreCursors storeCursors;

    TransactionToRecordStateVisitor(TransactionRecordState recordState, SchemaState schemaState, SchemaRuleAccess schemaRuleAccess, ConstraintRuleAccessor constraintSemantics, CursorContext cursorContext, StoreCursors storeCursors) {
        this.recordState = recordState;
        this.schemaState = schemaState;
        this.schemaStorage = schemaRuleAccess;
        this.schemaStateChanger = schemaRuleAccess.getSchemaRecordChangeTranslator();
        this.constraintSemantics = constraintSemantics;
        this.cursorContext = cursorContext;
        this.storeCursors = storeCursors;
    }

    public void close() {
        try {
            if (this.clearSchemaState) {
                this.schemaState.clear();
            }
        }
        finally {
            this.clearSchemaState = false;
        }
    }

    public void visitCreatedNode(long id) {
        this.recordState.nodeCreate(id);
    }

    public void visitDeletedNode(long id) {
        this.recordState.nodeDelete(id);
    }

    public void visitRelationshipModifications(RelationshipModifications modifications) {
        this.recordState.relModify(modifications);
        modifications.creations().forEach((id, t, s, e, properties) -> this.visitAddedRelProperties(id, properties));
    }

    public void visitNodePropertyChanges(long id, Iterable<StorageProperty> added, Iterable<StorageProperty> changed, IntIterable removed) {
        removed.each((IntProcedure & Serializable)propId -> this.recordState.nodeRemoveProperty(id, propId));
        for (StorageProperty property : changed) {
            this.recordState.nodeChangeProperty(id, property.propertyKeyId(), property.value());
        }
        for (StorageProperty property : added) {
            this.recordState.nodeAddProperty(id, property.propertyKeyId(), property.value());
        }
    }

    public void visitRelPropertyChanges(long id, int type, long startNode, long endNode, Iterable<StorageProperty> added, Iterable<StorageProperty> changed, IntIterable removed) {
        removed.each((IntProcedure & Serializable)relId -> this.recordState.relRemoveProperty(id, relId));
        for (StorageProperty property : changed) {
            this.recordState.relChangeProperty(id, property.propertyKeyId(), property.value());
        }
        this.visitAddedRelProperties(id, added);
    }

    private void visitAddedRelProperties(long id, Iterable<StorageProperty> added) {
        for (StorageProperty property : added) {
            this.recordState.relAddProperty(id, property.propertyKeyId(), property.value());
        }
    }

    public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) {
        removed.each((LongProcedure & Serializable)label -> this.recordState.removeLabelFromNode(label, id));
        added.each((LongProcedure & Serializable)label -> this.recordState.addLabelToNode(label, id));
    }

    public void visitAddedIndex(IndexDescriptor index) throws KernelException {
        this.schemaStateChanger.createSchemaRule(this.recordState, (SchemaRule)index);
    }

    public void visitRemovedIndex(IndexDescriptor index) {
        this.schemaStateChanger.dropSchemaRule(this.recordState, (SchemaRule)index);
    }

    public void visitAddedConstraint(ConstraintDescriptor constraint) throws KernelException {
        this.clearSchemaState = true;
        long constraintId = this.schemaStorage.newRuleId(this.cursorContext);
        switch (constraint.type()) {
            case UNIQUE: {
                this.visitAddedUniquenessConstraint(constraint.asUniquenessConstraint(), constraintId);
                break;
            }
            case UNIQUE_EXISTS: {
                this.visitAddedNodeKeyConstraint(constraint.asNodeKeyConstraint(), constraintId);
                break;
            }
            case EXISTS: {
                ConstraintDescriptor rule = this.constraintSemantics.createExistenceConstraint(constraintId, constraint);
                this.schemaStateChanger.createSchemaRule(this.recordState, (SchemaRule)rule);
                break;
            }
            default: {
                throw new IllegalStateException(constraint.type().toString());
            }
        }
    }

    private void visitAddedUniquenessConstraint(UniquenessConstraintDescriptor uniqueConstraint, long constraintId) throws KernelException {
        IndexDescriptor indexRule = (IndexDescriptor)this.schemaStorage.loadSingleSchemaRule(uniqueConstraint.ownedIndexId(), this.storeCursors);
        ConstraintDescriptor constraint = this.constraintSemantics.createUniquenessConstraintRule(constraintId, uniqueConstraint, indexRule.getId());
        this.schemaStateChanger.createSchemaRule(this.recordState, (SchemaRule)constraint);
        this.schemaStateChanger.setConstraintIndexOwner(this.recordState, indexRule, constraintId);
    }

    private void visitAddedNodeKeyConstraint(NodeKeyConstraintDescriptor uniqueConstraint, long constraintId) throws KernelException {
        IndexDescriptor indexRule = (IndexDescriptor)this.schemaStorage.loadSingleSchemaRule(uniqueConstraint.ownedIndexId(), this.storeCursors);
        ConstraintDescriptor constraint = this.constraintSemantics.createNodeKeyConstraintRule(constraintId, uniqueConstraint, indexRule.getId());
        this.schemaStateChanger.createSchemaRule(this.recordState, (SchemaRule)constraint);
        this.schemaStateChanger.setConstraintIndexOwner(this.recordState, indexRule, constraintId);
    }

    public void visitRemovedConstraint(ConstraintDescriptor constraint) {
        this.clearSchemaState = true;
        try {
            ConstraintDescriptor rule = this.schemaStorage.constraintsGetSingle(constraint, this.storeCursors);
            this.schemaStateChanger.dropSchemaRule(this.recordState, (SchemaRule)rule);
            if (constraint.enforcesUniqueness()) {
                IndexDescriptor[] indexes;
                for (IndexDescriptor index : indexes = this.schemaStorage.indexGetForSchema((SchemaDescriptorSupplier)constraint, this.storeCursors)) {
                    OptionalLong owningConstraintId = index.getOwningConstraintId();
                    if (!owningConstraintId.isPresent() || owningConstraintId.getAsLong() != rule.getId()) continue;
                    this.visitRemovedIndex(index);
                }
            }
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IllegalStateException("Constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.", e);
        }
        catch (DuplicateSchemaRuleException e) {
            throw new IllegalStateException("Multiple constraints found for specified label and property.", e);
        }
    }

    public void visitCreatedLabelToken(long id, String name, boolean internal) {
        this.recordState.createLabelToken(name, id, internal);
    }

    public void visitCreatedPropertyKeyToken(long id, String name, boolean internal) {
        this.recordState.createPropertyKeyToken(name, id, internal);
    }

    public void visitCreatedRelationshipTypeToken(long id, String name, boolean internal) {
        this.recordState.createRelationshipTypeToken(name, id, internal);
    }
}

