/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.NamedDiagnosticsProvider;
import org.neo4j.kernel.impl.store.NeoStores;

public abstract class NeoStoresDiagnostics
extends NamedDiagnosticsProvider {
    private final NeoStores neoStores;

    NeoStoresDiagnostics(NeoStores neoStores, String message) {
        super(message);
        this.neoStores = neoStores;
    }

    public void dump(DiagnosticsLogger logger) {
        try {
            this.dump(this.neoStores, logger);
        }
        catch (RuntimeException e) {
            logger.log("Diagnostics not available: " + e.getMessage());
        }
    }

    protected abstract void dump(NeoStores var1, DiagnosticsLogger var2);

    public static class NeoStoreRecords
    extends NeoStoresDiagnostics {
        NeoStoreRecords(NeoStores neoStores) {
            super(neoStores, "Neostore records");
        }

        @Override
        protected void dump(NeoStores neoStores, DiagnosticsLogger logger) {
            neoStores.getMetaDataStore().logRecords(logger);
        }
    }

    public static class NeoStoreIdUsage
    extends NeoStoresDiagnostics {
        NeoStoreIdUsage(NeoStores neoStores) {
            super(neoStores, "Id usage");
        }

        @Override
        protected void dump(NeoStores neoStores, DiagnosticsLogger logger) {
            neoStores.logIdUsage(logger);
        }
    }

    public static class NeoStoreVersions
    extends NeoStoresDiagnostics {
        NeoStoreVersions(NeoStores nodeStores) {
            super(nodeStores, "Store versions");
        }

        @Override
        protected void dump(NeoStores neoStores, DiagnosticsLogger logger) {
            neoStores.logVersions(logger);
        }
    }
}

