/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Clock;
import java.util.List;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.DefaultPlanStalenessCaller;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.ExecutionEngineQueryCacheMonitor;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.InputQuery;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.StatsDivergenceCalculator$;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.expressions.IterablePredicateExpression$;
import org.neo4j.cypher.internal.expressions.functions.Function$;
import org.neo4j.cypher.internal.options.CypherExecutionMode;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.planning.CypherCacheFlushingMonitor;
import org.neo4j.cypher.internal.planning.CypherCacheHitMonitor;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\r\u0005e\u0001\u0002\u001c8\u0001\u0001C\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0013\"A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003S\u0011!I\u0006A!b\u0001\n\u0003Q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\t\u0004!Q1A\u0005\u0002\rD\u0011\"!\u0001\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0015\u0005\r\u0001A!b\u0001\n\u0003\t)\u0001\u0003\u0006\u0002\u0012\u0001\u0011\t\u0011)A\u0005\u0003\u000fA!\"a\u0005\u0001\u0005\u000b\u0007I\u0011AA\u000b\u0011)\ti\u0002\u0001B\u0001B\u0003%\u0011q\u0003\u0005\u000b\u0003?\u0001!Q1A\u0005\u0002\u0005\u0005\u0002BCA\u0018\u0001\t\u0005\t\u0015!\u0003\u0002$!Q\u0011\u0011\u0007\u0001\u0003\u0006\u0004%\t!a\r\t\u0015\u0005\u0005\u0003A!A!\u0002\u0013\t)\u0004\u0003\u0006\u0002D\u0001\u0011)\u0019!C\u0001\u0003\u000bB!\"a\u0016\u0001\u0005\u0003\u0005\u000b\u0011BA$\u0011\u001d\tI\u0006\u0001C\u0001\u00037B\u0011\"!\u001d\u0001\u0005\u0004%I!a\u001d\t\u0011\u0005\u0015\u0005\u0001)A\u0005\u0003kB\u0011\"a\"\u0001\u0005\u0004%I!!#\t\u0011\u0005E\u0005\u0001)A\u0005\u0003\u0017C\u0011\"a%\u0001\u0005\u0004%I!!&\t\u0011\u0005u\u0005\u0001)A\u0005\u0003/Cq!a(\u0001\t\u0013\t\t\u000bC\u0005\u0002>\u0002\u0011\r\u0011\"\u0003\u0002@\"A\u0011q\u0019\u0001!\u0002\u0013\t\t\rC\u0005\u0002J\u0002\u0011\r\u0011\"\u0003\u0002L\"A\u00111\u001b\u0001!\u0002\u0013\ti\rC\u0005\u0002V\u0002\u0011\r\u0011\"\u0003\u0002X\"A\u0011q\u001c\u0001!\u0002\u0013\tI\u000eC\u0005\u0002b\u0002\u0011\r\u0011\"\u0003\u0002d\"A\u00111\u001e\u0001!\u0002\u0013\t)\u000fC\u0005\u0002n\u0002\u0011\r\u0011\"\u0003\u0002p\"A\u0011q\u001f\u0001!\u0002\u0013\t\t\u0010C\u0004\u0002z\u0002!\t!a?\t\u000f\u0005e\b\u0001\"\u0001\u0003F!9!1\u000e\u0001\u0005\u0002\t5\u0004b\u0002B@\u0001\u0011%!\u0011\u0011\u0005\b\u0005\u007f\u0003A\u0011\u0002Ba\u0011\u001d\u0011Y\u000e\u0001C\u0005\u0005;DqAa<\u0001\t\u0013\u0011\t\u0010C\u0004\u0003~\u0002!\tAa@\t\u000f\r\u001d\u0001\u0001\"\u0001\u0004\n!91Q\u0002\u0001\u0005\u0002\r=\u0001bBB\u0012\u0001\u0011%1QE\u0004\b\u0007+:\u0004\u0012AB,\r\u00191t\u0007#\u0001\u0004Z!9\u0011\u0011L\u0019\u0005\u0002\rm\u0003\"CB/c\t\u0007I\u0011AB0\u0011!\u00199'\rQ\u0001\n\r\u0005\u0004\"CB5cE\u0005I\u0011AB6\u0005=)\u00050Z2vi&|g.\u00128hS:,'B\u0001\u001d:\u0003!Ig\u000e^3s]\u0006d'B\u0001\u001e<\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011A(P\u0001\u0006]\u0016|GG\u001b\u0006\u0002}\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\u0019E,XM]=TKJ4\u0018nY3\u0016\u0003%\u0003\"AS'\u000e\u0003-S!\u0001T\u001e\u0002\r-,'O\\3m\u0013\tq5JA\rHe\u0006\u0004\b\u000eR1uC\n\f7/Z)vKJL8+\u001a:wS\u000e,\u0017!D9vKJL8+\u001a:wS\u000e,\u0007%\u0001\blKJtW\r\\'p]&$xN]:\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!V\u001e\u0002\u00155|g.\u001b;pe&tw-\u0003\u0002X)\nAQj\u001c8ji>\u00148/A\blKJtW\r\\'p]&$xN]:!\u0003\u0019!(/Y2feV\t1\f\u0005\u0002]?6\tQL\u0003\u0002_o\u00059AO]1dS:<\u0017B\u00011^\u0005E\u0019u.\u001c9jY\u0006$\u0018n\u001c8Ue\u0006\u001cWM]\u0001\biJ\f7-\u001a:!\u0003-\u0019\u0017m\u00195f)J\f7-\u001a:\u0016\u0003\u0011\u00042!\u001a4i\u001b\u00059\u0014BA48\u0005-\u0019\u0015m\u00195f)J\f7-\u001a:\u0011\u0007%<(P\u0004\u0002kk:\u00111\u000e\u001e\b\u0003YNt!!\u001c:\u000f\u00059\fX\"A8\u000b\u0005A|\u0014A\u0002\u001fs_>$h(C\u0001?\u0013\taT(\u0003\u0002;w%\u0011\u0001(O\u0005\u0003m^\n!\"U;fef\u001c\u0015m\u00195f\u0013\tA\u0018P\u0001\u0005DC\u000eDWmS3z\u0015\t1x\u0007\u0005\u0002|}:\u0011Q\r`\u0005\u0003{^\n!\"\u00138qkR\fV/\u001a:z\u0013\tAxP\u0003\u0002~o\u0005a1-Y2iKR\u0013\u0018mY3sA\u000511m\u001c8gS\u001e,\"!a\u0002\u0011\t\u0005%\u0011QB\u0007\u0003\u0003\u0017Q1!a\u00018\u0013\u0011\ty!a\u0003\u0003'\rK\b\u000f[3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u000f\r|gNZ5hA\u0005y1m\\7qS2,'\u000fT5ce\u0006\u0014\u00180\u0006\u0002\u0002\u0018A\u0019Q-!\u0007\n\u0007\u0005mqGA\bD_6\u0004\u0018\u000e\\3s\u0019&\u0014'/\u0019:z\u0003A\u0019w.\u001c9jY\u0016\u0014H*\u001b2sCJL\b%\u0001\u0007dC\u000eDWMR1di>\u0014\u00180\u0006\u0002\u0002$A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*]\nQaY1dQ\u0016LA!!\f\u0002(\t!2)\u00194gK&tWmQ1dQ\u00164\u0015m\u0019;pef\fQbY1dQ\u00164\u0015m\u0019;pef\u0004\u0013a\u00037pOB\u0013xN^5eKJ,\"!!\u000e\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f<\u0003\u001dawnZ4j]\u001eLA!a\u0010\u0002:\tYAj\\4Qe>4\u0018\u000eZ3s\u00031awn\u001a)s_ZLG-\u001a:!\u0003\u0015\u0019Gn\\2l+\t\t9\u0005\u0005\u0003\u0002J\u0005MSBAA&\u0015\u0011\ti%a\u0014\u0002\tQLW.\u001a\u0006\u0003\u0003#\nAA[1wC&!\u0011QKA&\u0005\u0015\u0019En\\2l\u0003\u0019\u0019Gn\\2lA\u00051A(\u001b8jiz\"B#!\u0018\u0002`\u0005\u0005\u00141MA3\u0003O\nI'a\u001b\u0002n\u0005=\u0004CA3\u0001\u0011\u001595\u00031\u0001J\u0011\u0015\u00016\u00031\u0001S\u0011\u0015I6\u00031\u0001\\\u0011\u0015\u00117\u00031\u0001e\u0011\u001d\t\u0019a\u0005a\u0001\u0003\u000fAq!a\u0005\u0014\u0001\u0004\t9\u0002C\u0004\u0002 M\u0001\r!a\t\t\u000f\u0005E2\u00031\u0001\u00026!I\u00111I\n\u0011\u0002\u0003\u0007\u0011qI\u0001\u001dI\u00164\u0017-\u001e7u#V,'/_#yK\u000e,H/[8o\u001b>t\u0017\u000e^8s+\t\t)\b\u0005\u0003\u0002x\u0005\u0005UBAA=\u0015\u0011\tY(! \u0002\u000bE,XM]=\u000b\u0007\u0005}4*\u0001\u0003j[Bd\u0017\u0002BAB\u0003s\u0012Q#U;fef,\u00050Z2vi&|g.T8oSR|'/A\u000feK\u001a\fW\u000f\u001c;Rk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8N_:LGo\u001c:!\u0003%\u0001(/\u001a)beN,'/\u0006\u0002\u0002\fB\u0019Q-!$\n\u0007\u0005=uGA\u0005Qe\u0016\u0004\u0016M]:fe\u0006Q\u0001O]3QCJ\u001cXM\u001d\u0011\u000231\f7\u000f^\"p[6LG\u000f^3e)bLE\r\u0015:pm&$WM]\u000b\u0003\u0003/\u00032!ZAM\u0013\r\tYj\u000e\u0002\u001a\u0019\u0006\u001cHoQ8n[&$H/\u001a3Uq&#\u0007K]8wS\u0012,'/\u0001\u000emCN$8i\\7nSR$X\r\u001a+y\u0013\u0012\u0004&o\u001c<jI\u0016\u0014\b%\u0001\tqY\u0006t'+Z;tC\nLG.\u001b;jsR1\u00111UAU\u0003g\u00032!ZAS\u0013\r\t9k\u000e\u0002\u0011%\u0016,8/\u00192jY&$\u0018p\u0015;bi\u0016Dq!a+\u001b\u0001\u0004\ti+A\bfq\u0016\u001cW\u000f^1cY\u0016\fV/\u001a:z!\r)\u0017qV\u0005\u0004\u0003c;$aD#yK\u000e,H/\u00192mKF+XM]=\t\u000f\u0005U&\u00041\u0001\u00028\u0006!BO]1og\u0006\u001cG/[8oC2\u001cuN\u001c;fqR\u0004B!a\u001e\u0002:&!\u00111XA=\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yi\u0006\u0019An\\4\u0016\u0005\u0005\u0005\u0007\u0003BA\u001c\u0003\u0007LA!!2\u0002:\t\u0019Aj\\4\u0002\t1|w\rI\u0001\u0014a2\fgn\u0015;bY\u0016tWm]:DC2dWM]\u000b\u0003\u0003\u001b\u0004R!ZAh\u0003[K1!!58\u0005i!UMZ1vYR\u0004F.\u00198Ti\u0006dWM\\3tg\u000e\u000bG\u000e\\3s\u0003Q\u0001H.\u00198Ti\u0006dWM\\3tg\u000e\u000bG\u000e\\3sA\u0005Q\u0011/^3ss\u000e\u000b7\r[3\u0016\u0005\u0005e\u0007CB3\u0002\\\"\fi+C\u0002\u0002^^\u0012!\"U;fef\u001c\u0015m\u00195f\u0003-\tX/\u001a:z\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u001d5\f7\u000f^3s\u0007>l\u0007/\u001b7feV\u0011\u0011Q\u001d\t\u0004K\u0006\u001d\u0018bAAuo\tqQ*Y:uKJ\u001cu.\u001c9jY\u0016\u0014\u0018aD7bgR,'oQ8na&dWM\u001d\u0011\u0002\u0019M\u001c\u0007.Z7b\u0011\u0016d\u0007/\u001a:\u0016\u0005\u0005E\bcA3\u0002t&\u0019\u0011Q_\u001c\u0003\u0019M\u001b\u0007.Z7b\u0011\u0016d\u0007/\u001a:\u0002\u001bM\u001c\u0007.Z7b\u0011\u0016d\u0007/\u001a:!\u0003\u001d)\u00070Z2vi\u0016$b\"!@\u0003\u0004\tU!\u0011\u0006B\u0017\u0005o\u0011Y\u0004\u0005\u0003\u0002x\u0005}\u0018\u0002\u0002B\u0001\u0003s\u0012a\"U;fef,\u00050Z2vi&|g\u000eC\u0004\u0002|\u0015\u0002\rA!\u0002\u0011\t\t\u001d!q\u0002\b\u0005\u0005\u0013\u0011Y\u0001\u0005\u0002o\u0007&\u0019!QB\"\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\tBa\u0005\u0003\rM#(/\u001b8h\u0015\r\u0011ia\u0011\u0005\b\u0005/)\u0003\u0019\u0001B\r\u0003\u0019\u0001\u0018M]1ngB!!1\u0004B\u0013\u001b\t\u0011iB\u0003\u0003\u0003 \t\u0005\u0012a\u0002<jeR,\u0018\r\u001c\u0006\u0004\u0005GY\u0014A\u0002<bYV,7/\u0003\u0003\u0003(\tu!\u0001C'baZ\u000bG.^3\t\u000f\t-R\u00051\u0001\u00028\u000691m\u001c8uKb$\bb\u0002B\u0018K\u0001\u0007!\u0011G\u0001\baJ|g-\u001b7f!\r\u0011%1G\u0005\u0004\u0005k\u0019%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005s)\u0003\u0019\u0001B\u0019\u0003-\u0001(/\u001a)paVd\u0017\r^3\t\u000f\tuR\u00051\u0001\u0003@\u0005Q1/\u001e2tGJL'-\u001a:\u0011\t\u0005]$\u0011I\u0005\u0005\u0005\u0007\nIHA\bRk\u0016\u0014\u0018pU;cg\u000e\u0014\u0018NY3s)A\tiPa\u0012\u0003P\tE#1\u000bB+\u0005K\u0012I\u0007C\u0004\u0002|\u0019\u0002\rA!\u0013\u0011\u0007\u0015\u0014Y%C\u0002\u0003N]\u0012\u0001CR;mYf\u0004\u0016M]:fIF+XM]=\t\u000f\t]a\u00051\u0001\u0003\u001a!9!1\u0006\u0014A\u0002\u0005]\u0006b\u0002B\u001dM\u0001\u0007!\u0011\u0007\u0005\b\u0005/2\u0003\u0019\u0001B-\u0003\u0015Ig\u000e];u!\u0011\u0011YF!\u0019\u000e\u0005\tu#b\u0001B0o\u00059!/\u001e8uS6,\u0017\u0002\u0002B2\u0005;\u0012q\"\u00138qkR$\u0015\r^1TiJ,\u0017-\u001c\u0005\b\u0005O2\u0003\u0019AA;\u00031\tX/\u001a:z\u001b>t\u0017\u000e^8s\u0011\u001d\u0011iD\na\u0001\u0005\u007f\tq\"\u001a=fGV$XmU;ccV,'/\u001f\u000b\u0011\u0003{\u0014yG!\u001d\u0003t\tU$\u0011\u0010B>\u0005{Bq!a\u001f(\u0001\u0004\u0011)\u0001C\u0004\u0003\u0018\u001d\u0002\rA!\u0007\t\u000f\t-r\u00051\u0001\u00028\"9!qO\u0014A\u0002\tE\u0012\u0001E5t\u001fV$XM]7pgR\fV/\u001a:z\u0011\u001d\u0011yc\na\u0001\u0005cAqA!\u000f(\u0001\u0004\u0011\t\u0004C\u0004\u0003>\u001d\u0002\rAa\u0010\u0002\u000f\rdwn]5oOV!!1\u0011BF)\u0019\u0011)Ia*\u0003*R!!q\u0011BO!\u0011\u0011IIa#\r\u0001\u00119!Q\u0012\u0015C\u0002\t=%!\u0001+\u0012\t\tE%q\u0013\t\u0004\u0005\nM\u0015b\u0001BK\u0007\n9aj\u001c;iS:<\u0007c\u0001\"\u0003\u001a&\u0019!1T\"\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003 \"\"\t\u0019\u0001BQ\u0003\u0011\u0019w\u000eZ3\u0011\u000b\t\u0013\u0019Ka\"\n\u0007\t\u00156I\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\u0011Y\u0003\u000ba\u0001\u0003oCqAa+)\u0001\u0004\u0011i+\u0001\u0006ue\u0006\u001cW-\u0012<f]R\u0004BAa,\u0003::!!\u0011\u0017B[\u001d\rQ'1W\u0005\u0003=^J1Aa.^\u0003E\u0019u.\u001c9jY\u0006$\u0018n\u001c8Ue\u0006\u001cWM]\u0005\u0005\u0005w\u0013iLA\u000bRk\u0016\u0014\u0018pQ8na&d\u0017\r^5p]\u00163XM\u001c;\u000b\u0007\t]V,A\u0005e_\u0016CXmY;uKR!\u0012Q Bb\u0005\u0017\u0014iMa4\u0003R\nM'Q\u001bBl\u00053Dq!a\u001f*\u0001\u0004\u0011)\rE\u0002f\u0005\u000fL1A!38\u0005)Ie\u000e];u#V,'/\u001f\u0005\b\u0005/I\u0003\u0019\u0001B\r\u0011\u001d\u0011Y#\u000ba\u0001\u0003oCqAa\u001e*\u0001\u0004\u0011\t\u0004C\u0004\u0003:%\u0002\rA!\r\t\u000f\t]\u0013\u00061\u0001\u0003Z!9!qM\u0015A\u0002\u0005U\u0004BB-*\u0001\u0004\u0011i\u000bC\u0004\u0003>%\u0002\rAa\u0010\u0002G\r|W\u000e]5mKJ<\u0016\u000e\u001e5FqB\u0014Xm]:j_:\u001cu\u000eZ3HK:|\u0005\u000f^5p]RQ!q\u001cBs\u0005S\u0014YO!<\u0011\u000b\u0015\u0014\t/!,\n\u0007\t\rxGA\u0012D_6\u0004\u0018\u000e\\3s/&$\b.\u0012=qe\u0016\u001c8/[8o\u0007>$WmR3o\u001fB$\u0018n\u001c8\t\u000f\t\u001d(\u00061\u0001\u0003F\u0006Q\u0011N\u001c9viF+XM]=\t\reS\u0003\u0019\u0001BW\u0011\u001d\t)L\u000ba\u0001\u0003oCqAa\u0006+\u0001\u0004\u0011I\"\u0001\u0007hKR|%oQ8na&dW\r\u0006\u0006\u0002.\nM(Q\u001fB}\u0005wDqAa\u000b,\u0001\u0004\t9\fC\u0004\u0003x.\u0002\rA!2\u0002#%t\u0017\u000e^5bY&s\u0007/\u001e;Rk\u0016\u0014\u0018\u0010\u0003\u0004ZW\u0001\u0007!Q\u0016\u0005\b\u0005/Y\u0003\u0019\u0001B\r\u0003A\u0019G.Z1s#V,'/_\"bG\",7\u000f\u0006\u0002\u0004\u0002A\u0019!ia\u0001\n\u0007\r\u00151I\u0001\u0003M_:<\u0017\u0001E5t!\u0016\u0014\u0018n\u001c3jG\u000e{W.\\5u)\u0011\u0011\tda\u0003\t\u000f\u0005mT\u00061\u0001\u0003\u0006\u0005\u0011r-\u001a;DsBDWM\u001d$v]\u000e$\u0018n\u001c8t+\t\u0019\t\u0002\u0005\u0004\u0004\u0014\re1QD\u0007\u0003\u0007+QAaa\u0006\u0002P\u0005!Q\u000f^5m\u0013\u0011\u0019Yb!\u0006\u0003\t1K7\u000f\u001e\t\u0005\u0003o\u001ay\"\u0003\u0003\u0004\"\u0005e$a\u0005$v]\u000e$\u0018n\u001c8J]\u001a|'/\\1uS>t\u0017aD2iK\u000e\\\u0007+\u0019:b[\u0016$XM]:\u0015\u0011\r\u001d2QFB\u001c\u0007w\u00012AQB\u0015\u0013\r\u0019Yc\u0011\u0002\u0005+:LG\u000fC\u0004\u00040=\u0002\ra!\r\u0002\u0017E,XM]=QCJ\fWn\u001d\t\u0006\u0005\u000eM\"QA\u0005\u0004\u0007k\u0019%!B!se\u0006L\bbBB\u001d_\u0001\u0007!\u0011D\u0001\fO&4XM\u001c)be\u0006l7\u000fC\u0004\u0004>=\u0002\rA!\u0007\u0002\u001f\u0015DHO]1di\u0016$\u0007+\u0019:b[NDSaLB!\u0007'\u0002RAQB\"\u0007\u000fJ1a!\u0012D\u0005\u0019!\bN]8xgB!1\u0011JB(\u001b\t\u0019YEC\u0002\u0004Nm\n!\"\u001a=dKB$\u0018n\u001c8t\u0013\u0011\u0019\tfa\u0013\u00035A\u000b'/Y7fi\u0016\u0014hj\u001c;G_VtG-\u0012=dKB$\u0018n\u001c8$\u0005\r\u001d\u0013aD#yK\u000e,H/[8o\u000b:<\u0017N\\3\u0011\u0005\u0015\f4CA\u0019B)\t\u00199&A\nQ\u0019\u0006suLQ+J\u0019\u0012KejR0U%&+5+\u0006\u0002\u0004bA\u0019!ia\u0019\n\u0007\r\u00154IA\u0002J]R\fA\u0003\u0015'B\u001d~\u0013U+\u0013'E\u0013:;u\f\u0016*J\u000bN\u0003\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0004n)\"\u0011qIB8W\t\u0019\t\b\u0005\u0003\u0004t\ruTBAB;\u0015\u0011\u00199h!\u001f\u0002\u0013Ut7\r[3dW\u0016$'bAB>\u0007\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r}4Q\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<QueryCache.CacheKey<InputQuery.CacheKey>> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerLibrary compilerLibrary;
    private final CaffeineCacheFactory cacheFactory;
    private final LogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor defaultQueryExecutionMonitor;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller;
    private final QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache;
    private final MasterCompiler masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$9() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$9();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<QueryCache.CacheKey<InputQuery.CacheKey>> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerLibrary compilerLibrary() {
        return this.compilerLibrary;
    }

    public CaffeineCacheFactory cacheFactory() {
        return this.cacheFactory;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private QueryExecutionMonitor defaultQueryExecutionMonitor() {
        return this.defaultQueryExecutionMonitor;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    private ReusabilityState planReusabilitiy(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
        return executableQuery.reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        this.defaultQueryExecutionMonitor().startProcessing(context.executingQuery());
        return this.executeSubquery(query, params, context, true, profile, prePopulate, subscriber);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) {
        queryMonitor.startProcessing(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryMonitor, queryTracer, subscriber));
    }

    public QueryExecution executeSubquery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> {
            boolean couldContainSensitiveFields = isOutermostQuery && this.compilerLibrary().supportsAdministrativeCommands();
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile, couldContainSensitiveFields);
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, this.defaultQueryExecutionMonitor(), queryTracer, subscriber);
        });
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable t) {
                context.rollback();
                throw t;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber) {
        MapValue combinedParams;
        ExecutableQuery executableQuery;
        block4: {
            ExecutableQuery executableQuery2;
            try {
                executableQuery2 = this.getOrCompile(context, query, tracer, params);
            }
            catch (Throwable up) {
                if (isOutermostQuery) {
                    queryMonitor.endFailure(context.executingQuery(), up.getMessage());
                }
                throw up;
            }
            executableQuery = executableQuery2;
            String string = query.options().queryOptions().executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
            }
            combinedParams = params.updatedWith(executableQuery.extractedParams());
            if (!isOutermostQuery) break block4;
            context.executingQuery().onObfuscatorReady(executableQuery.queryObfuscator());
            context.executingQuery().onCompilationCompleted(executableQuery.compilerInfo(), executableQuery.planDescriptionSupplier());
        }
        return executableQuery.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, queryMonitor, subscriber);
    }

    private CompilerWithExpressionCodeGenOption<ExecutableQuery> compilerWithExpressionCodeGenOption(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params) {
        Function0 & Serializable & scala.Serializable compiledExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params);
        Function0 & Serializable & scala.Serializable interpretedExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params);
        return new CompilerWithExpressionCodeGenOption<ExecutableQuery>(this, inputQuery, (Function0)compiledExpressionCompiler, (Function0)interpretedExpressionCompiler){
            private final /* synthetic */ ExecutionEngine $outer;
            private final InputQuery inputQuery$1;
            private final Function0 compiledExpressionCompiler$1;
            private final Function0 interpretedExpressionCompiler$1;

            public ExecutableQuery compile() {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() == 0 ? (ExecutableQuery)this.compiledExpressionCompiler$1.apply() : (ExecutableQuery)this.interpretedExpressionCompiler$1.apply();
            }

            public ExecutableQuery compileWithExpressionCodeGen() {
                return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
            }

            public Option<ExecutableQuery> maybeCompileWithExpressionCodeGen(int hitCount) {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() > 0 && hitCount >= this.$outer.config().recompilationLimit() ? new Some(this.compiledExpressionCompiler$1.apply()) : None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputQuery$1 = inputQuery$1;
                this.compiledExpressionCompiler$1 = compiledExpressionCompiler$1;
                this.interpretedExpressionCompiler$1 = interpretedExpressionCompiler$1;
            }
        };
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery initialInputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params) {
        block7: {
            ExecutableQuery executableQuery;
            block6: {
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));
                boolean forceReplan = false;
                InputQuery inputQuery = initialInputQuery;
                QueryCache.CacheKey<InputQuery.CacheKey> cacheKey = new QueryCache.CacheKey<InputQuery.CacheKey>(initialInputQuery.cacheKey(), QueryCache$.MODULE$.extractParameterTypeMap(params), tc.kernelTransaction().dataRead().transactionStateHasChanges());
                try {
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        if (forceReplan) {
                            forceReplan = false;
                            inputQuery = inputQuery.withReplanOption((CypherReplanOption)CypherReplanOption.force$.MODULE$);
                        }
                        CompilerWithExpressionCodeGenOption<ExecutableQuery> compiler = this.compilerWithExpressionCodeGenOption(inputQuery, tracer, tc, params);
                        ExecutableQuery executableQuery2 = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, compiler, inputQuery.options().queryOptions().replan(), context.executingQuery().id());
                        SchemaHelper.LockedEntities lockedEntities = this.schemaHelper().lockEntities(schemaToken, executableQuery2, tc);
                        if (lockedEntities.successful()) {
                            executableQuery = executableQuery2;
                            break block6;
                        }
                        forceReplan = lockedEntities.needsReplan();
                    }
                    break block7;
                }
                finally {
                    compilerAuthorization.close();
                }
            }
            return executableQuery;
        }
        throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, this.preParser().preParseQuery$default$2(), this.preParser().preParseQuery$default$3());
        CypherExecutionMode cypherExecutionMode = preParsedQuery.options().queryOptions().executionMode();
        CypherExecutionMode.explain$ explain$2 = CypherExecutionMode.explain$.MODULE$;
        return (cypherExecutionMode == null ? explain$2 != null : !cypherExecutionMode.equals(explain$2)) && preParsedQuery.options().isPeriodicCommit();
    }

    public List<FunctionInformation> getCypherFunctions() {
        Seq informations = (Seq)Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, List$.MODULE$.canBuildFrom());
        Seq predicateInformations = (Seq)IterablePredicateExpression$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, Seq$.MODULE$.canBuildFrom());
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)informations.$plus$plus((GenTraversableOnce)predicateInformations, Seq$.MODULE$.canBuildFrom())).asJava();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryParams)).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key))))).distinct();
            throw new ParameterNotFoundException(new StringBuilder(23).append("Expected parameter(s): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])missingKeys)).mkString(", ")).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<QueryCache.CacheKey<InputQuery.CacheKey>> cacheTracer, CypherConfiguration config, CompilerLibrary compilerLibrary, CaffeineCacheFactory cacheFactory, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compilerLibrary = compilerLibrary;
        this.cacheFactory = cacheFactory;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0 & Serializable & scala.Serializable)() -> "Can't work with a null graph database");
        this.defaultQueryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new PreParser(config, cacheFactory);
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new ExecutionEngineQueryCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor.cacheFlushDetected$(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor.cacheHit$(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor.cacheMiss$(this, key);
            }

            public void cacheCompile(Object key) {
                CypherCacheHitMonitor.cacheCompile$(this, key);
            }

            public void cacheCompileWithExpressionCodeGen(Object key) {
                CypherCacheHitMonitor.cacheCompileWithExpressionCodeGen$(this, key);
            }

            public void cacheDiscard(QueryCache.CacheKey<InputQuery.CacheKey> ignored, String queryId, int secondsSinceReplan, Option<String> maybeReason) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringBuilder(69).append("Discarded stale query from the query cache after ").append(secondsSinceReplan).append(" seconds").append(maybeReason.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)r -> new StringBuilder(10).append(". Reason: ").append((String)r).toString())).append(". Query id: ").append(queryId).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor.$init$(this);
                CypherCacheFlushingMonitor.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$cacheDiscard$1(), $anonfun$cacheDiscard$2(java.lang.String )}, serializedLambda);
            }
        }, new String[0]);
        this.planStalenessCaller = new DefaultPlanStalenessCaller(clock, StatsDivergenceCalculator$.MODULE$.divergenceCalculatorFor(config.statsDivergenceCalculator()), (Function0<Object>)this.lastCommittedTxIdProvider(), (Function2 & Serializable & scala.Serializable)(executableQuery, transactionalContext) -> this.planReusabilitiy((ExecutableQuery)executableQuery, (TransactionalContext)transactionalContext), this.org$neo4j$cypher$internal$ExecutionEngine$$log());
        this.queryCache = new QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery>(cacheFactory, config.queryCacheSize(), this.planStalenessCaller(), cacheTracer);
        this.masterCompiler = new MasterCompiler(compilerLibrary);
        this.schemaHelper = new SchemaHelper(this.queryCache(), this.masterCompiler());
    }
}

