/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStore;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountUpdater;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.GBPTreeGenericCountsStore;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;

public class GBPTreeCountsStore
extends GBPTreeGenericCountsStore
implements CountsStore {
    private static final String NAME = "Counts store";
    private static final byte TYPE_NODE = 1;
    private static final byte TYPE_RELATIONSHIP = 2;

    public static CountsKey nodeKey(long labelId) {
        return new CountsKey(1, labelId, 0);
    }

    public static CountsKey relationshipKey(long startLabelId, long typeId, long endLabelId) {
        return new CountsKey(2, startLabelId << 32 | typeId & 0xFFFFFFFFL, (int)endLabelId);
    }

    public GBPTreeCountsStore(PageCache pageCache, Path file, FileSystemAbstraction fileSystem, RecoveryCleanupWorkCollector recoveryCollector, CountsBuilder initialCountsBuilder, DatabaseReadOnlyChecker readOnlyChecker, PageCacheTracer pageCacheTracer, GBPTreeGenericCountsStore.Monitor monitor, String databaseName, int maxCacheSize, LogProvider userLogProvider) throws IOException {
        super(pageCache, file, fileSystem, recoveryCollector, new InitialCountsRebuilder(initialCountsBuilder), readOnlyChecker, NAME, pageCacheTracer, monitor, databaseName, maxCacheSize, userLogProvider);
    }

    public CountsAccessor.Updater apply(long txId, CursorContext cursorContext) {
        CountUpdater updater = this.updater(txId, cursorContext);
        return updater != null ? new Incrementer(updater) : NO_OP_UPDATER;
    }

    public long nodeCount(int labelId, CursorContext cursorContext) {
        return this.read(GBPTreeCountsStore.nodeKey(labelId), cursorContext);
    }

    public long relationshipCount(int startLabelId, int typeId, int endLabelId, CursorContext cursorContext) {
        return this.read(GBPTreeCountsStore.relationshipKey(startLabelId, typeId, endLabelId), cursorContext);
    }

    public void accept(CountsVisitor visitor, CursorContext cursorContext) {
        this.visitAllCounts((key, count) -> {
            if (key.type == 1) {
                visitor.visitNodeCount((int)key.first, count);
            } else if (key.type == 2) {
                visitor.visitRelationshipCount(key.extractHighFirstInt(), key.extractLowFirstInt(), key.second, count);
            } else {
                throw new IllegalArgumentException("Unknown key type " + key.type);
            }
        }, cursorContext);
    }

    public static String keyToString(CountsKey key) {
        if (key.type == 1) {
            return String.format("Node[label:%d]", key.first);
        }
        if (key.type == 2) {
            return String.format("Relationship[startLabel:%d, type:%d, endLabel:%d]", key.extractHighFirstInt(), key.extractLowFirstInt(), key.second);
        }
        throw new IllegalArgumentException("Unknown type " + key.type);
    }

    public static void dump(PageCache pageCache, Path file, PrintStream out, CursorContext cursorContext) throws IOException {
        GBPTreeGenericCountsStore.dump(pageCache, file, out, "neo4j", NAME, cursorContext, GBPTreeCountsStore::keyToString);
    }

    private static class InitialCountsRebuilder
    implements GBPTreeGenericCountsStore.Rebuilder {
        private final CountsBuilder initialCountsBuilder;

        InitialCountsRebuilder(CountsBuilder initialCountsBuilder) {
            this.initialCountsBuilder = initialCountsBuilder;
        }

        @Override
        public long lastCommittedTxId() {
            return this.initialCountsBuilder.lastCommittedTxId();
        }

        @Override
        public void rebuild(CountUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
            this.initialCountsBuilder.initialize(new Incrementer(updater), cursorContext, memoryTracker);
        }
    }

    private static class Incrementer
    implements CountsAccessor.Updater {
        private final CountUpdater actual;

        Incrementer(CountUpdater actual) {
            this.actual = actual;
        }

        public void incrementNodeCount(long labelId, long delta) {
            this.actual.increment(GBPTreeCountsStore.nodeKey(labelId), delta);
        }

        public void incrementRelationshipCount(long startLabelId, int typeId, long endLabelId, long delta) {
            this.actual.increment(GBPTreeCountsStore.relationshipKey(startLabelId, typeId, endLabelId), delta);
        }

        public void close() {
            this.actual.close();
        }
    }
}

