/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.javax.sql.rowset.serial;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Vector;
import javax.sql.rowset.serial.SQLOutputImpl;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialDatalink;
import javax.sql.rowset.serial.SerialRef;
import javax.sql.rowset.serial.SerialStruct;
import junit.framework.TestCase;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockArray;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockBlob;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockClob;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockRef;
import org.apache.harmony.sql.tests.javax.sql.rowset.serial.SQLInputImplTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class SQLOutputImplTest
extends TestCase {
    private static SQLOutputImpl impl;
    private static Vector attr;

    public void test_ConstructorLjava_util_VectorLjava_util_Map() {
        SQLOutputImplTest.assertNotNull((Object)impl);
        try {
            new SQLOutputImpl(null, new HashMap());
            SQLOutputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            new SQLOutputImpl(null, null);
            SQLOutputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            new SQLOutputImpl(new Vector(), null);
            SQLOutputImplTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void test_writeArrayLjava_sql_Array() throws SQLException {
        MockArray mockArray = new MockArray();
        impl.writeArray((Array)mockArray);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        SQLOutputImplTest.assertTrue((boolean)(attr.get(0) instanceof SerialArray));
        impl.writeArray(null);
        SQLOutputImplTest.assertNull(attr.get(1));
    }

    public void test_writeAsciiStreamLjava_io_InputStream() throws SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("abc".getBytes());
        impl.writeAsciiStream(byteArrayInputStream);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        SQLOutputImplTest.assertEquals((Object)"abc", attr.get(0));
        try {
            impl.writeAsciiStream(null);
            SQLOutputImplTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_writeBigDecimalLjava_math_BigDecimal() throws SQLException {
        impl.writeBigDecimal(BigDecimal.ONE);
        impl.writeBigDecimal(BigDecimal.ONE);
        SQLOutputImplTest.assertSame(attr.get(0), attr.get(1));
        impl.writeBigDecimal(null);
        SQLOutputImplTest.assertNull(attr.get(2));
    }

    public void test_writeBinaryStreamLjava_io_InputStream() throws SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("abc".getBytes());
        impl.writeBinaryStream(byteArrayInputStream);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        SQLOutputImplTest.assertEquals((Object)"abc", attr.get(0));
    }

    public void test_writeBlobLjava_sql_Blob() throws SQLException {
        MockBlob mockBlob = new MockBlob();
        impl.writeBlob((Blob)mockBlob);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        SQLOutputImplTest.assertTrue((boolean)(attr.get(0) instanceof SerialBlob));
        impl.writeBlob(null);
        SQLOutputImplTest.assertNull(attr.get(1));
    }

    public void test_writeBooleanZ() throws SQLException {
        impl.writeBoolean(true);
        SQLOutputImplTest.assertTrue((boolean)((Boolean)attr.get(0)));
        impl.writeBoolean(false);
        SQLOutputImplTest.assertFalse((boolean)((Boolean)attr.get(1)));
        impl.writeBoolean(true);
        SQLOutputImplTest.assertTrue((boolean)((Boolean)attr.get(2)));
    }

    public void test_writeByteB() throws SQLException {
        SQLOutputImplTest.assertEquals((int)0, (int)attr.size());
        impl.writeByte((byte)1);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        SQLOutputImplTest.assertEquals((byte)Byte.parseByte("1"), (byte)((Byte)attr.get(0)));
        impl.writeByte((byte)0);
        SQLOutputImplTest.assertEquals((int)2, (int)attr.size());
        SQLOutputImplTest.assertEquals((byte)Byte.parseByte("0"), (byte)((Byte)attr.get(1)));
    }

    public void test_writeBytes$B() throws SQLException {
        byte[] byArray = new byte[3];
        byArray[0] = 4;
        byArray[1] = 5;
        byte[] byArray2 = byArray;
        impl.writeBytes(byArray2);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        byte[] byArray3 = (byte[])attr.get(0);
        SQLOutputImplTest.assertEquals((byte)4, (byte)byArray3[0]);
        SQLOutputImplTest.assertEquals((byte)0, (byte)byArray3[2]);
    }

    public void test_writeCharacterStreamLjava_io_Reader() throws SQLException {
        StringReader stringReader = new StringReader("abc");
        impl.writeCharacterStream(stringReader);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        SQLOutputImplTest.assertEquals((Object)"abc", attr.get(0));
    }

    public void test_writeClobLjava_sql_Clob() throws SQLException {
        MockClob mockClob = new MockClob();
        impl.writeClob((Clob)mockClob);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        SQLOutputImplTest.assertTrue((boolean)(attr.get(0) instanceof SerialClob));
    }

    public void test_writeDateLjava_sql_Date() throws SQLException {
        Date date = new Date(200L);
        impl.writeDate(date);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        SQLOutputImplTest.assertEquals(attr.get(0), (Object)date);
    }

    public void test_writeDoubleD() throws SQLException {
        Object object = new Object();
        attr.add(object);
        impl.writeDouble(3.1415926);
        SQLOutputImplTest.assertEquals((int)2, (int)attr.size());
        SQLOutputImplTest.assertEquals((Object)object, attr.get(0));
        SQLOutputImplTest.assertEquals((double)3.1415926, (double)((Double)attr.get(1)), (double)0.0);
    }

    public void test_writeFloatF() throws SQLException {
        impl.writeFloat(3.14f);
        SQLOutputImplTest.assertEquals((float)3.14f, (float)((Float)attr.get(0)).floatValue(), (float)0.0f);
        impl.writeFloat(Float.MAX_VALUE);
        SQLOutputImplTest.assertEquals((float)3.14f, (float)((Float)attr.get(0)).floatValue(), (float)0.0f);
        SQLOutputImplTest.assertEquals((float)Float.MAX_VALUE, (float)((Float)attr.get(1)).floatValue(), (float)0.0f);
    }

    public void test_writeIntI() throws SQLException {
        impl.writeInt(Integer.MAX_VALUE);
        SQLOutputImplTest.assertEquals((int)Integer.MAX_VALUE, (int)((Integer)attr.get(0)));
    }

    public void test_writeLongJ() throws SQLException {
        impl.writeInt(Integer.MIN_VALUE);
        impl.writeLong(Long.MAX_VALUE);
        SQLOutputImplTest.assertEquals((long)Long.MAX_VALUE, (long)((Long)attr.get(1)));
    }

    public void test_writeObjectLjava_sql_SQLData() throws SQLException {
        SQLInputImplTest.MockSQLData mockSQLData = new SQLInputImplTest.MockSQLData();
        mockSQLData.firstAttribute = "one";
        mockSQLData.secondAttribute = Boolean.FALSE;
        mockSQLData.thirdAttribute = "three";
        mockSQLData.fourthAttribute = 4;
        impl.writeObject((SQLData)mockSQLData);
        SQLOutputImplTest.assertTrue((boolean)(attr.get(0) instanceof SerialStruct));
        SerialStruct serialStruct = (SerialStruct)attr.get(0);
        Object[] objectArray = serialStruct.getAttributes();
        SQLOutputImplTest.assertEquals((Object)mockSQLData.firstAttribute, (Object)objectArray[0]);
        SQLOutputImplTest.assertEquals((Object)mockSQLData.secondAttribute, (Object)objectArray[1]);
        SQLOutputImplTest.assertEquals((Object)mockSQLData.thirdAttribute, (Object)objectArray[2]);
        SQLOutputImplTest.assertEquals((Object)mockSQLData.fourthAttribute, (Object)objectArray[3]);
        SQLOutputImplTest.assertEquals((String)"harmonytests.MockSQLData", (String)serialStruct.getSQLTypeName());
    }

    public void test_writeRefLjava_sql_Ref() throws SQLException {
        MockRef mockRef = new MockRef();
        impl.writeRef((Ref)mockRef);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        SQLOutputImplTest.assertTrue((boolean)(attr.get(0) instanceof SerialRef));
    }

    public void test_writeShortS() throws SQLException {
        impl.writeShort((short)12823);
        SQLOutputImplTest.assertEquals((short)12823, (short)((Short)attr.get(0)));
        impl.writeShort((short)Short.MIN_VALUE);
        SQLOutputImplTest.assertEquals((short)Short.MIN_VALUE, (short)((Short)attr.get(1)));
    }

    public void test_writeStringLjava_lang_String() throws SQLException {
        impl.writeString("abc");
        SQLOutputImplTest.assertEquals((String)"abc", (String)((String)attr.get(0)));
        impl.writeString("def");
        SQLOutputImplTest.assertEquals((String)"def", (String)((String)attr.get(1)));
    }

    public void test_writeStructLjava_sql_Struct() throws SQLException {
        SQLInputImplTest.MockStruct mockStruct = new SQLInputImplTest.MockStruct(new Object[0], "mockStruct1");
        impl.writeStruct((Struct)mockStruct);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        SQLOutputImplTest.assertTrue((boolean)(attr.get(0) instanceof SerialStruct));
        SerialStruct serialStruct = (SerialStruct)attr.get(0);
        SQLOutputImplTest.assertEquals((int)0, (int)serialStruct.getAttributes().length);
        SQLOutputImplTest.assertEquals((String)"mockStruct1", (String)serialStruct.getSQLTypeName());
    }

    public void test_writeTimeLjava_sql_Time() throws SQLException {
        Time time = new Time(200L);
        impl.writeTime(time);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        SQLOutputImplTest.assertEquals(attr.get(0), (Object)time);
    }

    public void test_writeTimestampLjava_sql_Timestamp() throws SQLException {
        Timestamp timestamp = new Timestamp(200L);
        impl.writeTimestamp(timestamp);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        SQLOutputImplTest.assertEquals(attr.get(0), (Object)timestamp);
    }

    public void test_writeURLLjava_net_URL() throws MalformedURLException, SQLException {
        URL uRL = new URL("http://www.apache.org");
        impl.writeURL(uRL);
        SQLOutputImplTest.assertEquals((int)1, (int)attr.size());
        SQLOutputImplTest.assertTrue((boolean)(attr.get(0) instanceof SerialDatalink));
        SQLOutputImplTest.assertEquals((Object)uRL, (Object)((SerialDatalink)attr.get(0)).getDatalink());
        impl.writeURL(null);
        SQLOutputImplTest.assertNull(attr.get(1));
    }

    protected void setUp() throws Exception {
        super.setUp();
        attr = new Vector();
        HashMap hashMap = new HashMap();
        impl = new SQLOutputImpl(attr, hashMap);
    }

    protected void tearDown() throws Exception {
        impl = null;
        attr = null;
        super.tearDown();
    }
}

