/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.console;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.console.JTextPaneAppender;
import com.jsql.view.swing.text.JPopupTextPane;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractColoredConsole
extends JPopupTextPane {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final String tabName;

    protected AbstractColoredConsole(String tabName, String placeholder) {
        super(placeholder);
        this.tabName = tabName;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ((JTextPane)AbstractColoredConsole.this.getProxy()).getCaret().setVisible(true);
                ((JTextPane)AbstractColoredConsole.this.getProxy()).getCaret().setSelectionVisible(true);
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(2));
    }

    protected abstract SimpleAttributeSet getColorAttribute();

    public void append(String message, SimpleAttributeSet attribut) {
        try {
            boolean isCaretAtEnd = ((JTextPane)this.getProxy()).getCaretPosition() == ((JTextPane)this.getProxy()).getDocument().getLength();
            JScrollPane scrollPane = (JScrollPane)((JTextPane)this.getProxy()).getParent().getParent();
            JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
            int extent = scrollBar.getModel().getExtent();
            boolean isScrollBarAtEnd = scrollBar.getValue() >= scrollBar.getMaximum() - extent;
            String logMessage = message.substring(15);
            String logTimestamp = message.substring(0, 15);
            ((JTextPane)this.getProxy()).getDocument().insertString(((JTextPane)this.getProxy()).getDocument().getLength(), (((JTextPane)this.getProxy()).getDocument().getLength() == 0 ? "" : "\n") + logTimestamp, this.getColorAttribute());
            ((JTextPane)this.getProxy()).getDocument().insertString(((JTextPane)this.getProxy()).getDocument().getLength(), logMessage, attribut);
            if (isCaretAtEnd || isScrollBarAtEnd) {
                scrollBar.setValue(scrollBar.getMaximum() + 1);
            }
            Color foregroundColor = UIManager.getColor("TextArea.foreground");
            if (attribut == JTextPaneAppender.ATTRIBUTE_WARN) {
                foregroundColor = LogLevelUtil.COLOR_RED;
            } else if (attribut == JTextPaneAppender.ATTRIBUTE_SUCCESS) {
                foregroundColor = LogLevelUtil.COLOR_GREEN;
            }
            int tabIndex = MediatorHelper.tabConsoles().indexOfTab(this.tabName);
            if (0 <= tabIndex && tabIndex < MediatorHelper.tabConsoles().getTabCount()) {
                Component tabHeader = MediatorHelper.tabConsoles().getTabComponentAt(tabIndex);
                if (MediatorHelper.tabConsoles().getSelectedIndex() != tabIndex) {
                    tabHeader.setFont(tabHeader.getFont().deriveFont(1));
                    if (!UIManager.getColor("TextArea.foreground").equals(foregroundColor)) {
                        tabHeader.setForeground(foregroundColor);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, message, (Throwable)e);
        }
    }
}

