/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBit;
import com.jsql.model.injection.strategy.blind.AbstractInjectionMonobit;
import com.jsql.model.injection.strategy.blind.callable.CallableTime;
import com.jsql.util.LogLevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionTime
extends AbstractInjectionMonobit<CallableTime> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private boolean isTimeInjectable = true;

    public InjectionTime(InjectionModel injectionModel, AbstractInjectionBit.BlindOperator blindOperator) {
        super(injectionModel, blindOperator);
        if (this.falsyBit.isEmpty() || this.injectionModel.isStoppedByUser()) {
            return;
        }
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetTimeTagFalse");
        ArrayList<CallableTime> callablesFalseTest = new ArrayList<CallableTime>();
        for (String falseTest : this.falsyBit) {
            callablesFalseTest.add(new CallableTime(falseTest, injectionModel, this, blindOperator, "time#falsy"));
        }
        try {
            List futuresFalseTest = taskExecutor.invokeAll(callablesFalseTest);
            this.injectionModel.getMediatorUtils().getThreadUtil().shutdown(taskExecutor);
            for (Future futureFalseTest : futuresFalseTest) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (!((CallableTime)futureFalseTest.get()).isTrue()) continue;
                this.isTimeInjectable = false;
                return;
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.checkTrueTests(blindOperator);
    }

    private void checkTrueTests(AbstractInjectionBit.BlindOperator blindOperator) {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetTimeTagTrue");
        ArrayList<CallableTime> callablesTrueTest = new ArrayList<CallableTime>();
        for (String trueTest : this.truthyBit) {
            callablesTrueTest.add(new CallableTime(trueTest, this.injectionModel, this, blindOperator, "time#truthy"));
        }
        try {
            List futuresTrueTest = taskExecutor.invokeAll(callablesTrueTest);
            this.injectionModel.getMediatorUtils().getThreadUtil().shutdown(taskExecutor);
            for (Future futureTrueTest : futuresTrueTest) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (((CallableTime)futureTrueTest.get()).isTrue()) continue;
                this.isTimeInjectable = false;
                return;
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CallableTime getCallableBitTest(String sqlQuery, int indexChar, int bit) {
        return new CallableTime(sqlQuery, indexChar, bit, this.injectionModel, this, this.blindOperator, "bit#" + indexChar + "~" + bit);
    }

    @Override
    public boolean isInjectable() throws StoppedByUserSlidingException {
        if (this.injectionModel.isStoppedByUser()) {
            throw new StoppedByUserSlidingException();
        }
        CallableTime timeTest = new CallableTime(this.injectionModel.getMediatorVendor().getVendor().instance().sqlBlindConfirm(), this.injectionModel, this, this.blindOperator, "time#confirm");
        try {
            timeTest.call();
        }
        catch (Exception e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return this.isTimeInjectable && timeTest.isTrue();
    }

    public int getSleepTime() {
        return this.injectionModel.getMediatorUtils().getPreferencesUtil().isLimitingSleepTimeStrategy() ? this.injectionModel.getMediatorUtils().getPreferencesUtil().countSleepTimeStrategy() : 5;
    }

    @Override
    public String getInfoMessage() {
        return "- Strategy Time: query True when " + this.getSleepTime() + "s delay\n\n";
    }
}

