/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.util;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class UIUtil {
    public static void waitForInput(JDialog view) {
        while (view.isShowing()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void showErrorMessage(JDialog dialog, String msg) {
        JOptionPane.showMessageDialog(dialog, msg, "JavaSnoop", 0);
    }

    public static void showErrorMessage(JFrame frame, String msg) {
        JOptionPane.showMessageDialog(frame, msg, "JavaSnoop", 0);
    }

    public static void pause(int i) {
        try {
            Thread.sleep(i);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static File getFileSelection(Dialog parent, boolean onlyDirectories, String startingDir) {
        int rc;
        JFileChooser fc = new JFileChooser(new File(startingDir));
        fc.setDialogTitle("Select directory to dump source into");
        if (onlyDirectories) {
            fc.setFileSelectionMode(1);
        }
        if ((rc = fc.showOpenDialog(parent)) == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static File getFileSelection(JFrame parent, boolean onlyDirectories, String startingDir) {
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") != -1) {
            FileDialog fileDialog = new FileDialog((Frame)parent, "Select directory to dump source into", 0);
            fileDialog.setDirectory(startingDir);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                return new File(fileDialog.getFile());
            }
        } else {
            int rc;
            JFileChooser fc = new JFileChooser(new File(startingDir));
            fc.setDialogTitle("Select directory to dump source into");
            if (onlyDirectories) {
                fc.setFileSelectionMode(1);
            }
            if ((rc = fc.showOpenDialog(parent)) == 0) {
                return fc.getSelectedFile();
            }
        }
        return null;
    }
}

