/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.tamper.list;

import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.ui.tamper.EditObjectView;
import com.aspect.snoop.ui.tamper.array.EditArrayView;
import com.aspect.snoop.ui.tamper.bytearray.EditByteArrayView;
import com.aspect.snoop.ui.tamper.list.EditListView;
import com.aspect.snoop.ui.tamper.map.EditMapView;
import com.aspect.snoop.util.ReflectionUtil;
import com.aspect.snoop.util.UIUtil;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;

class ListTableModel
extends AbstractTableModel {
    private List items;
    private static Class[] columnTypes = new Class[]{String.class, String.class, String.class, JButton.class};
    private static String[] columnNames = new String[]{"Index", "Type", "toString()", ""};

    public ListTableModel(List items) {
        this.items = items;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return ReflectionUtil.isPrimitiveButNotArray(this.items.get(rowIndex)) && columnIndex == 2 || !ReflectionUtil.isPrimitiveButNotArray(this.items.get(rowIndex)) && columnIndex == 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object o = this.items.get(rowIndex);
        final int row = rowIndex;
        switch (columnIndex) {
            case 0: {
                return rowIndex;
            }
            case 1: {
                return o.getClass().getName();
            }
            case 2: {
                return o.toString();
            }
            case 3: {
                if (ReflectionUtil.isPrimitiveButNotArray(o)) break;
                JButton btn = new JButton("Edit");
                final Object copy = o;
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (copy instanceof Map) {
                            EditMapView view = new EditMapView((Frame)JavaSnoop.getApplication().getMainFrame(), true, (Map)copy);
                            view.setVisible(true);
                            UIUtil.waitForInput(view);
                        } else if (copy instanceof List) {
                            EditListView view = new EditListView((Frame)JavaSnoop.getApplication().getMainFrame(), true, (List)copy);
                            view.setVisible(true);
                            UIUtil.waitForInput(view);
                        } else if (copy instanceof byte[]) {
                            EditByteArrayView view = new EditByteArrayView((Frame)JavaSnoop.getApplication().getMainFrame(), true, (byte[])copy);
                            view.setVisible(true);
                            UIUtil.waitForInput(view);
                            ListTableModel.this.items.set(row, view.getBytes());
                            ListTableModel.this.fireTableStructureChanged();
                        } else if (copy.getClass().isArray()) {
                            EditArrayView view = new EditArrayView((Frame)JavaSnoop.getApplication().getMainFrame(), true, (Object[])copy);
                            view.setVisible(true);
                            UIUtil.waitForInput(view);
                        } else {
                            EditObjectView view = new EditObjectView((Frame)JavaSnoop.getApplication().getMainFrame(), true, copy);
                            view.setVisible(true);
                            UIUtil.waitForInput(view);
                            if (view.shouldReplaceObject()) {
                                ListTableModel.this.items.set(row, view.getObjectReplacement());
                            }
                        }
                    }
                });
                return btn;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object newObject, int rowIndex, int columnIndex) {
        Object o = this.items.get(rowIndex);
        try {
            String s = (String)newObject;
            if (o instanceof Boolean) {
                this.items.set(rowIndex, Boolean.parseBoolean(s));
            } else if (o instanceof Byte) {
                this.items.set(rowIndex, Byte.parseByte(s));
            } else if (o instanceof Character) {
                this.items.set(rowIndex, Character.valueOf(s.charAt(0)));
            } else if (o instanceof String) {
                this.items.set(rowIndex, s);
            } else if (o instanceof Short) {
                this.items.set(rowIndex, Short.parseShort(s));
            } else if (o instanceof Integer) {
                this.items.set(rowIndex, Integer.parseInt(s));
            } else if (o instanceof Long) {
                this.items.set(rowIndex, Long.parseLong(s));
            } else if (o instanceof Double) {
                this.items.set(rowIndex, Double.parseDouble(s));
            } else if (o instanceof Float) {
                this.items.set(rowIndex, Float.valueOf(Float.parseFloat(s)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

