/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.tamper.bytearray;

import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;

public class TableSelectionHandler
implements ListSelectionListener,
TableColumnModelListener {
    private JTable me;
    private JTable otherTable;

    public TableSelectionHandler(JTable t1, JTable t2) {
        this.me = t1;
        this.otherTable = t2;
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        int[] rows = this.me.getSelectedRows();
        int[] cols = this.me.getSelectedColumns();
        int[] theirRows = this.otherTable.getSelectedRows();
        int[] theirCols = this.otherTable.getSelectedColumns();
        if (Arrays.equals(rows, theirRows) && Arrays.equals(cols, theirCols)) {
            return;
        }
        if (rows.length > 0 && cols.length > 0) {
            int minRow = this.min(rows);
            int maxRow = this.max(rows);
            int minCol = this.min(cols);
            int maxCol = this.max(cols);
            this.otherTable.clearSelection();
            this.otherTable.changeSelection(minRow, minCol, false, false);
            this.otherTable.changeSelection(maxRow, maxCol, true, true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    private int max(int[] vals) {
        int max = vals[0];
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] <= max) continue;
            max = vals[i];
        }
        return max;
    }

    private int min(int[] vals) {
        int min = vals[0];
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] >= min) continue;
            min = vals[i];
        }
        return min;
    }
}

