/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui;

import bsh.Interpreter;
import com.aspect.org.jdesktop.application.Action;
import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ApplicationActionMap;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.agent.AgentLogger;
import com.aspect.snoop.util.StringUtil;
import com.aspect.snoop.util.UIUtil;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.python.util.PythonInterpreter;

public class ScriptingView
extends JDialog {
    private static final String nl = System.getProperty("line.separator");
    private static final String prompt = "% ";
    private StyledDocument console = new DefaultStyledDocument();
    private Object jython;
    private Object bsh;
    private JButton btnExecute;
    private JCheckBox chkRememberState;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JComboBox lstLanguage;
    private JTextPane txtConsole;
    private JTextArea txtScript;

    public ScriptingView(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        ((RSyntaxTextArea)this.txtScript).setSyntaxEditingStyle("text/java");
        ((RSyntaxTextArea)this.txtScript).setFont(new Font("Courier", 0, 12));
        this.showPrompt();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.txtScript = new RSyntaxTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.txtConsole = new JTextPane(this.console);
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.chkRememberState = new JCheckBox();
        this.lstLanguage = new JComboBox();
        this.btnExecute = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(JavaSnoop.class).getContext().getResourceMap(ScriptingView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.jScrollPane1.setName("jScrollPane1");
        this.txtScript.setColumns(20);
        this.txtScript.setRows(5);
        this.txtScript.setName("txtScript");
        this.jScrollPane1.setViewportView(this.txtScript);
        this.jScrollPane2.setName("jScrollPane2");
        this.txtConsole.setEditable(false);
        this.txtConsole.setName("txtConsole");
        this.jScrollPane2.setViewportView(this.txtConsole);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.chkRememberState.setText(resourceMap.getString("chkRememberState.text", new Object[0]));
        this.chkRememberState.setName("chkRememberState");
        this.lstLanguage.setModel(new DefaultComboBoxModel<String>(new String[]{"BeanShell", "Jython"}));
        this.lstLanguage.setName("lstLanguage");
        this.lstLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptingView.this.lstLanguageActionPerformed(evt);
            }
        });
        ApplicationActionMap actionMap = Application.getInstance(JavaSnoop.class).getContext().getActionMap(ScriptingView.class, this);
        this.btnExecute.setAction(actionMap.get("executeScript"));
        this.btnExecute.setText(resourceMap.getString("btnExecute.text", new Object[0]));
        this.btnExecute.setName("btnExecute");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 532, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 532, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 323, Short.MAX_VALUE).addComponent(this.lstLanguage, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkRememberState)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 361, Short.MAX_VALUE).addComponent(this.btnExecute))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.chkRememberState).addComponent(this.lstLanguage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnExecute).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 143, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void lstLanguageActionPerformed(ActionEvent evt) {
        String lang = (String)this.lstLanguage.getSelectedItem();
        if ("Jython".equals(lang)) {
            ((RSyntaxTextArea)this.txtScript).setSyntaxEditingStyle("text/python");
        } else if ("BeanShell".equals(lang)) {
            ((RSyntaxTextArea)this.txtScript).setSyntaxEditingStyle("text/java");
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScriptingView dialog = new ScriptingView((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public void showPrompt() {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.FALSE);
        attributes.addAttribute(StyleConstants.CharacterConstants.Italic, Boolean.FALSE);
        attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.black);
        try {
            this.console.insertString(this.console.getLength(), prompt, attributes);
            this.txtConsole.setCaretPosition(this.console.getLength());
        }
        catch (BadLocationException ex) {
            AgentLogger.error(ex);
        }
    }

    public void showErr(String message) {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.FALSE);
        attributes.addAttribute(StyleConstants.CharacterConstants.Italic, Boolean.FALSE);
        attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.red);
        try {
            this.console.insertString(this.console.getLength(), message, attributes);
            this.txtConsole.setCaretPosition(this.console.getLength());
        }
        catch (BadLocationException ex) {
            AgentLogger.error(ex);
        }
    }

    public void showOut(String s) {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        attributes.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.FALSE);
        attributes.addAttribute(StyleConstants.CharacterConstants.Italic, Boolean.FALSE);
        attributes.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.blue);
        try {
            this.console.insertString(this.console.getLength(), s, attributes);
            this.txtConsole.setCaretPosition(this.console.getLength());
        }
        catch (BadLocationException ex) {
            AgentLogger.error(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action
    public void executeScript() {
        try {
            String lang = (String)this.lstLanguage.getSelectedItem();
            String code = this.txtScript.getText();
            if ("Jython".equals(lang)) {
                StringWriter swOut = new StringWriter();
                StringWriter swErr = new StringWriter();
                if (this.jython == null || !this.chkRememberState.isSelected()) {
                    this.jython = new PythonInterpreter();
                }
                ((PythonInterpreter)this.jython).setOut((Writer)swOut);
                ((PythonInterpreter)this.jython).setErr((Writer)swErr);
                try {
                    ((PythonInterpreter)this.jython).exec(code);
                    swOut.flush();
                    swErr.flush();
                    String out = swOut.toString();
                    String err = swErr.toString();
                    this.showOut(out);
                    this.showErr(err);
                }
                catch (Exception ex) {
                    AgentLogger.error("Error evaluating expression: " + ex.getMessage());
                    this.showErr(StringUtil.exception2string(ex));
                }
            } else if ("BeanShell".equals(lang)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream psOut = new PrintStream(baos);
                if (this.bsh == null || !this.chkRememberState.isSelected()) {
                    this.bsh = new Interpreter((Reader)new StringReader(code), psOut, null, false);
                }
                try {
                    ((Interpreter)this.bsh).eval(code);
                }
                catch (Exception ex) {
                    AgentLogger.error("Error evaluating expression: " + ex.getMessage());
                    this.showErr(StringUtil.exception2string(ex));
                    ex.printStackTrace();
                }
                finally {
                    psOut.flush();
                    String out = baos.toString();
                    this.showOut(out);
                }
            }
            this.showOut("");
            this.showErr("");
            this.showPrompt();
        }
        catch (Exception ex) {
            UIUtil.showErrorMessage(this, "Problem with script execution: " + ex.getMessage());
            AgentLogger.error(ex);
        }
    }
}

