package com.epam.indigo.controls;

import com.epam.indigo.Indigo;
import com.epam.indigo.IndigoObject;
import com.epam.indigo.IndigoRenderer;
import java.awt.Frame;
import javax.swing.JFrame;

public class SingleIndigoObjectWindow extends javax.swing.JFrame
{
   private Indigo _indigo;
   private IndigoRenderer _indigo_renderer;
   private IndigoObject _obj;
   private boolean _is_reaction;

   // TODO: show name as $name$, because molecules loaded from SMILES have only names
   
   /** Creates new form CellFrame */
   public SingleIndigoObjectWindow (Frame parent, IndigoObject chem_obj, IndigoRenderer indigo_renderer, boolean is_reaction)
   {
      initComponents();

      obj_panel.setObject(chem_obj, indigo_renderer);

      _is_reaction = is_reaction;
      _indigo_renderer = indigo_renderer;
      if (chem_obj != null)
      {
         _indigo = chem_obj.getIndigo();
         _obj = chem_obj.clone();
      }
      else
      {
         file_menu.setEnabled(false);
         edit_menu.setEnabled(false);
      }
      
      setLocationRelativeTo(parent);
      setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
   }

   public void setInformationMessage (String message)
   {
      obj_panel.setInformationMessage(message);
   }
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   @SuppressWarnings("unchecked")
   // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
   private void initComponents() {

      obj_panel = new com.epam.indigo.controls.IndigoObjectWithPropertiesViewPanel();
      menu_bar = new javax.swing.JMenuBar();
      file_menu = new javax.swing.JMenu();
      save_mi = new javax.swing.JMenuItem();
      exit_mi = new javax.swing.JMenuItem();
      edit_menu = new javax.swing.JMenu();
      layout_mi = new javax.swing.JMenuItem();
      remove_hydrogens_mi = new javax.swing.JMenuItem();
      add_hydrogens = new javax.swing.JMenuItem();

      setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

      obj_panel.setDividerLocation(250);

      file_menu.setText("File");

      save_mi.setText("Save As");
      save_mi.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            save_miActionPerformed(evt);
         }
      });
      file_menu.add(save_mi);

      exit_mi.setText("Close");
      exit_mi.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            exit_miActionPerformed(evt);
         }
      });
      file_menu.add(exit_mi);

      menu_bar.add(file_menu);

      edit_menu.setText("Edit");

      layout_mi.setText("Layout");
      layout_mi.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            layout_miActionPerformed(evt);
         }
      });
      edit_menu.add(layout_mi);

      remove_hydrogens_mi.setText("Remove hydrogens");
      remove_hydrogens_mi.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            remove_hydrogens_miActionPerformed(evt);
         }
      });
      edit_menu.add(remove_hydrogens_mi);

      add_hydrogens.setText("Add hydrogens");
      add_hydrogens.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            add_hydrogensActionPerformed(evt);
         }
      });
      edit_menu.add(add_hydrogens);

      menu_bar.add(edit_menu);

      setJMenuBar(menu_bar);

      javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
      getContentPane().setLayout(layout);
      layout.setHorizontalGroup(
         layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
         .addComponent(obj_panel, javax.swing.GroupLayout.DEFAULT_SIZE, 599, Short.MAX_VALUE)
      );
      layout.setVerticalGroup(
         layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
         .addComponent(obj_panel, javax.swing.GroupLayout.DEFAULT_SIZE, 383, Short.MAX_VALUE)
      );

      pack();
   }// </editor-fold>//GEN-END:initComponents

    private void save_miActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_save_miActionPerformed
       MolSaver mol_saver = new MolSaver(_indigo);
       mol_saver.addExtension("cml");
       if (!_is_reaction)
       {
          mol_saver.addExtension("smi");
          mol_saver.addExtension("mol");
       }
       else
       {
          mol_saver.addExtension("rxn");
       }
       mol_saver.saveMol(new RenderableObject()
       {
          public IndigoObject getRenderableObject ()
          {
             return _obj;
          }

          public Indigo getIndigo ()
          {
             return _indigo;
          }

          public IndigoRenderer getIndigoRenderer ()
          {
             return _indigo_renderer;
          }
       });
    }//GEN-LAST:event_save_miActionPerformed

    private void exit_miActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exit_miActionPerformed
       dispose();
    }//GEN-LAST:event_exit_miActionPerformed

    private void layout_miActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_layout_miActionPerformed
       _obj = _obj.clone();
       _obj.layout();
       obj_panel.setObject(_obj, _indigo_renderer);
    }//GEN-LAST:event_layout_miActionPerformed

    private void remove_hydrogens_miActionPerformed (java.awt.event.ActionEvent evt)//GEN-FIRST:event_remove_hydrogens_miActionPerformed
    {//GEN-HEADEREND:event_remove_hydrogens_miActionPerformed
       _obj = _obj.clone();
       _obj.foldHydrogens();
       obj_panel.setObject(_obj, _indigo_renderer);
    }//GEN-LAST:event_remove_hydrogens_miActionPerformed

    private void add_hydrogensActionPerformed (java.awt.event.ActionEvent evt)//GEN-FIRST:event_add_hydrogensActionPerformed
    {//GEN-HEADEREND:event_add_hydrogensActionPerformed
       _obj = _obj.clone();
       _obj.unfoldHydrogens();
       obj_panel.setObject(_obj, _indigo_renderer);
    }//GEN-LAST:event_add_hydrogensActionPerformed

   // Variables declaration - do not modify//GEN-BEGIN:variables
   private javax.swing.JMenuItem add_hydrogens;
   private javax.swing.JMenu edit_menu;
   private javax.swing.JMenuItem exit_mi;
   private javax.swing.JMenu file_menu;
   private javax.swing.JMenuItem layout_mi;
   private javax.swing.JMenuBar menu_bar;
   private com.epam.indigo.controls.IndigoObjectWithPropertiesViewPanel obj_panel;
   private javax.swing.JMenuItem remove_hydrogens_mi;
   private javax.swing.JMenuItem save_mi;
   // End of variables declaration//GEN-END:variables
}
