# Awesome React Native

<img
src="https://travis-ci.org/jondot/awesome-react-native.svg?branch=master"
alt="Build Status" />

An awesome style list that curates the best React Native libraries,
tools, tutorials, articles and more. PRs are welcome!

## Buzzing

<div style="text-align: center"><table><tr>
    <td style="text-align: center">
        <a href="https://www.youtube.com/watch?v=UPrKMGPDbtY">
        <img src="https://img.youtube.com/vi/UPrKMGPDbtY/0.jpg" width="120" />
        <br />
        Joel on Performance
        </a>
    </td>
    <td style="text-align: center">
        <a href="https://www.youtube.com/watch?v=9baaVjGdBqs">
        <img src="https://img.youtube.com/vi/9baaVjGdBqs/0.jpg" width="120" />
        <br />
        Create React Native App
        </a>
    </td>
    <td style="text-align: center">
        <a href="https://facebook.github.io/react-native/blog/2017/03/13/better-list-views.html">
        <img src="icon.png" width="120" height="90" style="
            background: #d0d0d0;
            padding: 10px;
        " />
        <br />
            Better List Views
        </a>
    </td>
</tr></table></div>

Have something that belongs under "Buzzing"? drop me a line:
dotan\[at\]paracode.com.

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Conferences](#conferences)
  - [Chain React Conf - USA](#chain-react-conf---usa)
  - [React Conf BR - Brazil](#react-conf-br---brazil)
  - [React Native EU - Poland](#react-native-eu---poland)
- [Articles](#articles)
  - [Reference](#reference)
  - [Howtos](#howtos)
  - [Assorted](#assorted)
  - [Continuous Integration](#continuous-integration)
  - [Internals](#internals)
- [Components](#components)
  - [UI](#ui)
  - [Navigation](#navigation)
    - [Navigation/Routing Articles](#navigationrouting-articles)
    - [Navigation Demos](#navigation-demos)
  - [Text & Rich Content](#text--rich-content)
  - [Analytics](#analytics)
  - [Utils & Infra](#utils--infra)
  - [Forms](#forms)
  - [Geolocation](#geolocation)
  - [Internationalization](#internationalization)
  - [Build & Development](#build--development)
  - [Styling](#styling)
  - [System](#system)
  - [Web](#web)
  - [Media](#media)
  - [Storage](#storage)
  - [Backend](#backend)
  - [Integrations](#integrations)
  - [Monetization](#monetization)
  - [Animation](#animation)
  - [Other Platforms](#other-platforms)
- [Utilities](#utilities)
- [Seeds](#seeds)
- [Libraries](#libraries)
- [Open Source Apps](#open-source-apps)
- [Frameworks](#frameworks)
- [Tutorials](#tutorials)
- [Books](#books)
- [Videos](#videos)
  - [Talks](#talks)
  - [Training & tutorials](#training--tutorials)
- [Blogs](#blogs)
- [Releases](#releases)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

Many thanks to everyone on the [contributor
list](https://github.com/jondot/awesome-react-native/graphs/contributors)\:)

## Conferences

Conferences dedicated to React Native specifically. A listing of React
general conferences can be found on the [ReactJS
site](https://facebook.github.io/react/docs/conferences.html).

### Chain React Conf - USA

July 11-13, 2018 in Portland, OR - https://infinite.red/ChainReactConf
Twitter: https://twitter.com/chainreactconf Email: conf@infinite.red

### React Conf BR - Brazil

October 07, 2017 in São Paulo, SP - http://reactconfbr.com.br Facebook:
https://www.facebook.com/reactconf Email: reactconfbr@gmail.com

### React Native EU - Poland

Fall 2017 - http://react-native.eu/ Email: team@reactnative.eu

## Articles

Content published on the Web.

### Reference

* [React Native Styling Cheatsheet ★1468](https://github.com/vhpoet/react-native-styling-cheat-sheet)  

### Howtos

* [How to add Firebase Auth with react native ★4](https://github.com/g6ling/React-Native-Tips/tree/master/How_to_add_Firebase_Auth_with_react_native)  
* [React-Navigation Drawer](https://shift.infinite.red/react-navigation-drawer-tutorial-a802fc3ee6dc)  
* [Getting Started with React Native Development on Windows](https://shift.infinite.red/getting-started-with-react-native-development-on-windows-90d85a72ae65#.lygadl38g)  
* [Getting Started with React Native Development for Windows](https://shift.infinite.red/getting-started-with-react-native-development-for-windows-ba23a4be90b6#.n6vtqtikh)  
* [Blueprint to becoming a React Native Developer](https://medium.com/@spencer_carli/blueprint-to-becoming-a-react-native-developer-6cad2b894887#.t3uw4j4u8)  
* [How to Use the ListView Component](https://medium.com/@spencer_carli/react-native-basics-how-to-use-the-listview-component-a0ec44cf1fe8#.ur0hyi3h9)  
* [How to upload photo/file in react-native](https://github.com/g6ling/React-Native-Tips/tree/master/How_to_upload_photo%2Cfile_in%20react-native)  
* [Preview your Android & iOS React Native apps on your Github Pull Request](http://tech.m6web.fr/preview-android-ios-react-native-on-github-pull-request/)  
* [Change splash screen in React Native Android app](https://android.jlelse.eu/change-splash-screen-in-react-native-android-app-d3f99ac1ebd1#.pgjimxpgg)  
* [Remote Push Notifications with OneSignal](https://medium.com/differential/react-native-push-notifications-with-onesignal-9db6a7d75e1e#.d0zob0pdw)  
* [Release React Native App to Android Play Store](https://shift.infinite.red/simple-react-native-android-releases-319dc5e29605)  
* [React Native & Apple TV today](https://medium.com/@7ynk3r/react-native-apple-tv-today-48beb398a1ab#.5pp5drlyy)  

### Assorted

* [Top 15 React Native libraries that I use in my apps](https://codingislove.com/top-15-react-native-libraries/)  
* [Building 3 React Native Apps in One Summer](https://medium.com/@rpastorelle/building-3-react-native-apps-in-one-summer-dcd0c31454ff)  
* [React Native: Bringing modern web techniques to mobile](https://code.facebook.com/posts/1014532261909640/react-native-bringing-modern-web-techniques-to-mobile/)  
* [First impressions using React Native](http://jlongster.com/First-Impressions-using-React-Native)  
* [Wrapping Cocoapods for React Native](https://shift.infinite.red/beginner-s-guide-to-using-cocoapods-with-react-native-46cb4d372995#.wzp2qq1hn)  
* [React Native: Initial Thoughts (opinion)](http://unredacted.redalemeden.com/2015/initial-thoughts-about-react-native/)  
* [A Dynamic Crazy Native Mobile Future Powered by Javascript](https://medium.com/@clayallsopp/a-dynamic-crazy-native-mobile-future-powered-by-javascript-70f2d56b1987)  
* [ReactNative NES & More](http://moduscreate.com/react-native-has-landed/)  
* [React Native Installation and Setup](https://github.com/checkraiser/beginning-react-native/blob/master/1.Installation_and_setup.md)  
* [Diary of Building an iOS App with React Native](http://herman.asia/building-a-flashcard-app-with-react-native)  
* [Reflecting on React Native development](http://habd.as/reflecting-on-react-native-development/)  
* [React-Native layout examples](http://browniefed.com/blog/2015/06/07/react-native-layout-examples/)  
* [React Native in Production](https://medium.com/@clayallsopp/react-native-in-production-2b3c6e6078ad) - notes from Clay Allsop  
* [What we learned after using React Native for a year](https://hashnode.com/post/what-we-learned-after-using-react-native-for-a-year-civdr8zv6058l3853wqud7hqp) - Problem faced when building Smartwatch companion app with React Native  
* [An iOS Developer on React Native](https://medium.com/ios-os-x-development/an-ios-developer-on-react-native-1f24786c29f0)  
* [React Native and WebRTC](https://webrtchacks.com/reacting-to-react-native-for-native-webrtc-apps-alexey-aylarov/)  
* [How to bridge a Swift view](http://browniefed.com/blog/2015/11/28/react-native-how-to-bridge-a-swift-view/)  
* [Building a Native SoundCloud Android app with Redux](https://wiredcraft.com/blog/native-soundcloud-android-app/) - discussing redux, code reuse and performance on Android.  
* [React Native Twitter exploding heart](http://browniefed.com/blog/2015/11/07/react-native-how-to-create-twitter-exploding-hearts/) - hardcore animations with Animation and ReactART  
* [Using AI to discover UI components](https://www.youtube.com/watch?v=_iiKl0BB6ho) - fun image processing / AI assisted process to discover and generate React Native UI  
* [Writing Android Components](https://medium.com/@sejoker/writing-android-component-for-react-native-e34802bf3377)  
* [React Native and Fastlane](https://weluse.de/blog/react-native-deployment-with-fastlane.html) - small tweaks required to rig Fastlane with React Native  
* [Unit Testing React Native with Mocha and Enzyme](https://formidable.com/blog/2016/02/08/unit-testing-react-native-with-mocha-and-enzyme/)  
* [React Native's Layout Animation is Awesome](https://medium.com/@Jpoliachik/react-native-s-layoutanimation-is-awesome-4a4d317afd3e)  
* [Versioning React Native Application in elegant way (cross-platformely)](https://github.com/szhigunov/react-native-npm-version)  
* [Avoiding the Keyboard](https://shift.infinite.red/avoiding-the-keyboard-in-react-native-56d05b9a1e81#.g1lwixck6)  

### Continuous Integration

* [Deploying a React Native App with Fastlane](https://dbanck.svbtle.com/deploying-a-react-native-app-with-fastlane)  
* [Continuous Integration for React Native Apps With Fastlane and Bitrise (iOS)](http://blog.thebakery.io/continuous-integration-for-react-native-applications-with-fastlane-and-bitrise-ios-version/)  
* [How to automate Android build process on Bitrise CI](https://medium.com/@hesam.kamalan/how-to-automate-android-build-process-on-bitrise-ci-71ae3a94362e#.fryuiays4)  
* [fastlane for React Native iOS & Android app DevOps](https://medium.com/react-native-training/fastlane-for-react-native-ios-android-app-devops-8ca85bee614e)  
* [The simplest way to automate delivery of your React Native Application](https://jtway.co/the-simplest-way-to-automate-delivery-of-your-react-native-application-f37f2c71eb1d)

### Internals

* [Performance](https://facebook.github.io/react-native/docs/performance.html#common-sources-of-performance-problems)  
* [React Native Debugger Internals](https://medium.com/@shaheenghiassy/deep-diving-react-native-debugging-ea406ed3a691)  
* [Dirty-up and execute top-down](http://blog.vjeux.com/2015/javascript/dirty-up-and-execute-top-down.html) - @vjeux on React's optimizations for background color, layout, and more  
* [Optimizing React Native](https://www.youtube.com/watch?v=0MlT74erp60)  
* [Supported Babel/Javascript Features](https://github.com/facebook/react-native/blob/master/babel-preset/configs/main.js)  
* [Diving into React Native Performance](https://code.facebook.com/posts/895897210527114/)  

## Components

Components and native modules.

### UI

* [lottie-react-native ★7448](https://github.com/airbnb/lottie-react-native) - a mobile library for Android and iOS that parses Adobe After Effects animations exported as JSON with bodymovin and renders them natively on mobile!  
* [react-native-vector-icons ★6677](https://github.com/oblador/react-native-vector-icons) - Customizable Icons for React Native with support for NavBar/TabBar, image source and full styling. Choose from 3000+ bundled icons or use your own.  
* [react-native-maps ★5996](https://github.com/lelandrichardson/react-native-maps) - React Native Map components for iOS + Android  
* [react-native-swiper ★4915](https://github.com/leecade/react-native-swiper) - The best Swiper component for React Native.  
* [react-native-scrollable-tab-view ★4579](https://github.com/brentvatne/react-native-scrollable-tab-view) - This is probably my favorite navigation pattern on Android, I wish it were more common on iOS! This is a very simple JavaScript-only implementation of it for React Native. For more information about how the animations behind this work, check out the Rebou  
* [react-native-gifted-chat ★4048](https://github.com/FaridSafi/react-native-gifted-chat) - The most complete chat UI for React Native (formerly known as Gifted Messenger)  
* [react-native-animatable ★3841](https://github.com/oblador/react-native-animatable) - Standard set of easy to use animations and declarative transitions for React Native (built on react-native Animated  
* [react-native-material-kit ★3383](https://github.com/xinthink/react-native-material-kit) - Bringing Material Design to React Native  
* [react-native-image-picker ★3125](https://github.com/marcshilling/react-native-image-picker) - A React Native module that allows you to use the native UIImagePickerController UI to select a photo from the device library or directly from the camera.  
* [react-native-material-design ★2619](https://github.com/react-native-material-design/react-native-material-design) - React Native Material Design Components
* [react-native-ui-kitten ★2161](https://github.com/akveo/react-native-ui-kitten) - Customizable and reusable react-native component kit
* [react-native-drawer ★1918](https://github.com/root-two/react-native-drawer) - React Native Drawer  
* [react-native-svg ★1897](https://github.com/magicismight/react-native-svg) - SVG library that works on both iOS & Android  
* [react-native-snap-carousel ★1867](https://github.com/archriss/react-native-snap-carousel) - Swiper component for React Native with previews, multiple layouts, parallax images, performant handling of huge numbers of items, and RTL support
* [react-native-app-intro ★1680](https://github.com/FuYaoDe/react-native-app-intro) - A React Native parallax effect app intro  
* [react-native-blur ★1644](https://github.com/Kureev/react-native-blur) - React Native Blur component  
* [react-native-calendars ★1625](https://github.com/wix/react-native-calendars) - React Native Calendar Components 📆  
* [react-native-image-crop-picker ★1525](https://github.com/ivpusic/react-native-image-crop-picker) - iOS/Android image picker with support for multiple images and cropping  
* [gl-react-native ★1501](https://github.com/ProjectSeptemberInc/gl-react-native) - use OpenGL for performant effects on images and videos  
* [react-native-swipeout ★1486](https://github.com/dancormier/react-native-swipeout) - iOS-style swipeout buttons behind component  
* [react-native-textinput-effects ★1436](https://github.com/halilb/react-native-textinput-effects) - Text inputs with custom label and icon animations for iOS and android. Built by react native and inspired by Codrops.  
* [react-native-modalbox ★1429](https://github.com/maxs15/react-native-modalbox) - A component for react-native  
* [react-native-lightbox ★1404](https://github.com/oblador/react-native-lightbox) - a very Slick and modern mobile lightbox implementation  
* [nachos-ui ★1329](https://github.com/avocode/nachos-ui) - NACHOS UI kit for React Native. Pick from a bunch of pre-coded UI components ready for your next kick-ass app in JavaScript or React.  
* [react-native-splash-screen ★1311](https://github.com/crazycodeboy/react-native-splash-screen) - A splash screen for react-native, hide when application loaded ,it works on iOS and Android.  
* [react-native-action-button ★1269](https://github.com/mastermoo/react-native-action-button) - A customizable Float Button Component for React Native  
* [react-native-progress ★1260](https://github.com/oblador/react-native-progress) - Progress indicators and spinners for React Native using ReactART.  
* [react-native-foldview ★1247](https://github.com/jmurzy/react-native-foldview) - Animated FoldingCell implementation in React Native  
* [react-native-material-ui ★1244](https://github.com/xotahal/react-native-material-ui) - Highly customizable material design components for React Native  
* [react-native-gifted-listview ★1236](https://github.com/FaridSafi/react-native-gifted-listview) - A ListView that embed some recurrent features like pull-to-refresh, infinite scrolling and more for Android and iOS React-Native apps  
* [react-native-chart ★1208](https://github.com/onefold/react-native-chart) - react-native-chart is a simple module for adding line charts, area charts, or bar charts to your React Native app.  
* [react-native-viewpager ★1208](https://github.com/race604/react-native-viewpager) - ViewPager component for React Native  
* [react-native-icons ★1146](https://github.com/corymsmith/react-native-icons) - Quick and easy icons in React Native [video](https://www.youtube.com/watch?v=TEdM7IwTT1g#t=50)  
* [react-native-mapbox-gl ★1115](https://github.com/mapbox/react-native-mapbox-gl) - A Mapbox GL react native module for creating custom maps  
* [react-native-spinkit ★1110](https://github.com/maxs15/react-native-spinkit) - A collection of animated loading indicators for React Native  
* [react-virgin ★1108](https://github.com/Trixieapp/react-virgin) The react-native UI Kit you've been looking for.  
* [react-native-parallax-scroll-view ★1028](https://github.com/jaysoo/react-native-parallax-scroll-view) - A ScrollView-like component with parallax and sticky header support.  
* [react-native-looped-carousel ★914](https://github.com/appintheair/react-native-looped-carousel) - Create looped carousel of views or images  
* [react-native-tableview ★877](https://github.com/aksonov/react-native-tableview) - Native iOS TableView wrapper for React Native  
* [react-native-keyboard-spacer ★853](https://github.com/Andr3wHur5t/react-native-keyboard-spacer) - Plug and play react-Native keyboard spacer view.  
* [react-native-datepicker ★796](https://github.com/xgfe/react-native-datepicker) - React Native date, datetime and time picker for both Android and IOS  
* [react-native-orientation ★764](https://github.com/yamill/react-native-orientation) - Listen to device orientation changes in react-native and set preferred orientation on screen to screen basis  
* [react-native-picker ★748](https://github.com/beefe/react-native-picker) - react-native-picker  
* [react-native-circular-progress ★733](https://github.com/bgryszko/react-native-circular-progress) - React Native component for creating animated, circular progress with ReactART  
* [react-native-tinder-swipe-cards ★707](https://github.com/meteor-factory/react-native-tinder-swipe-cards) - Tinder card style swiping.  
* [react-native-collapsible ★690](https://github.com/oblador/react-native-collapsible) - Animated collapsible component for React Native using the new Animated API with fallback. Good for accordions, toggles etc  
* [react-native-sglistview ★665](https://github.com/sghiassy/react-native-sglistview) - A memory minded implementation of React Native's ListView  
* [react-native-pathjs-charts ★649](https://github.com/capitalone/react-native-pathjs-charts) - Android and iOS charts based on react-native-svg and paths-js  
* [react-native-button ★647](https://github.com/ide/react-native-button)  
* [react-native-fast-image ★641](https://github.com/DylanVann/react-native-fast-image) - FastImage, performant React Native image component.  
* [react-native-tabs ★626](https://github.com/aksonov/react-native-tabs) - React Native platform-independent tabs. Could be used for bottom tab bars as well as sectioned views (with tab buttons)  
* [react-native-loading-spinner-overlay ★595](https://github.com/niftylettuce/react-native-loading-spinner-overlay) - The only pure React Native, Native iOS and Android loading spinner (progress bar indicator) overlay  
* [react-native-popup-dialog ★591](https://github.com/jacklam718/react-native-popup-dialog) - A React Native Popup Dialog Easy Use & Support Use Custom Animation. For IOS & Android  
* [react-native-slider ★573](https://github.com/jeanregisser/react-native-slider) - A pure JavaScript component for react-native  
* [react-router-native ★572](https://github.com/jmurzy/react-router-native) - A routing library for React Native that strives for sensible API parity with [React Router](https://github.com/reactjs/react-router)  
* [react-native-search-bar ★556](https://github.com/umhan35/react-native-search-bar) - The native search bar for react native.  
* [react-native-calendar ★539](https://github.com/christopherdro/react-native-calendar) - Calendar Component for React Native  
* [apsl-react-native-button ★538](https://github.com/APSL/react-native-button) - React Native button component with rounded corners.  
* [react-native-masonry ★511](https://github.com/brh55/react-native-masonry) - A masonry~ish layout for rendering images.  
* [react-native-bottom-sheet-behavior ★500](https://github.com/cesardeazevedo/react-native-bottom-sheet-behavior) - A react native wrapper for android BottomSheetBehavior.  
* [react-native-credit-card-input ★480](https://github.com/sbycrosz/react-native-credit-card-input) - 💳 💳 Easy (and good looking) credit-card input for your React Native Project  
* [react-native-dropdownalert ★455](https://github.com/testshallpass/react-native-dropdownalert) - A simple drop down alert with 4 pre-defined types.  
* [react-native-photo-browser ★446](https://github.com/halilb/react-native-photo-browser) - Local and remote photo browser with captions, selections and grid view support.  
* [react-native-dropdown ★404](https://github.com/alinz/react-native-dropdown) - A better Select dropdown menu for react-native  
* [react-native-parallax ★387](https://github.com/oblador/react-native-parallax) - Parallax effects for React Native using Animated API  
* [react-native-parsed-text ★383](https://github.com/taskrabbit/react-native-parsed-text) - Parse text and make them into multiple React Native Text elements  
* [react-native-modal-dropdown ★378](https://github.com/sohobloo/react-native-modal-dropdown) - A react-native dropdown/picker/selector component for both Android & iOS.  
* [react-native-refresher ★376](https://github.com/syrusakbary/react-native-refresher) - A React Native pull to refresh ListView completely written in js. Also supports custom animations.  
* [react-native-popover-haobtc ★374](https://github.com/jeanregisser/react-native-popover) - A component for react-native  
* [react-native-carousel ★370](https://github.com/nick/react-native-carousel) - Simple carousel component for react-native  
* [react-native-dialogs ★362](https://github.com/aakashns/react-native-dialogs) - React Native wrappers for https://github.com/afollestad/material-dialogs  
* [react-native-activity-view ★361](https://github.com/naoufal/react-native-activity-view) - iOS share and action sheets for React Native  
* [react-native-qrcode ★351](https://github.com/cssivision/react-native-qrcode) - react-native qrcode generator  
* [react-native-radio-buttons ★343](https://github.com/ArnaudRinquin/react-native-radio-buttons) - A react component to implement custom radio buttons-like behaviors: multiple options, only on can be selected at once.  
* [react-native-button-component ★342](https://github.com/jacklam718/react-native-button-component) - A Beautiful, Customizable React Native Button component for iOS & Android  
* [react-native-sketch ★341](https://github.com/jgrancher/react-native-sketch) - A react-native &lt;Sketch /> component to draw with touch events.  
* [react-native-popup-menu ★334](https://github.com/instea/react-native-popup-menu) - Extensible popup menu component for React Native.  
* [react-native-invertible-scroll-view ★332](https://github.com/exponentjs/react-native-invertible-scroll-view) - An invertible ScrollView for React Native  
* [react-native-accordion ★321](https://github.com/naoufal/react-native-accordion) - An Accordion Component for React Native  
* [react-native-splashscreen ★317](https://github.com/remobile/react-native-splashscreen) - A splash screen for react-native  
* [rn-placeholder ★315](https://github.com/mfrachet/rn-placeholder) - Display some placeholder stuff before rendering your text or media content in React Native (+ React Native Web !)  
* [react-native-gesture-password ★315](https://github.com/spikef/react-native-gesture-password) - A gesture password component for React Native  
* [react-native-easy-toast ★307](https://github.com/crazycodeboy/react-native-easy-toast) - A react native module to show toast like android, it works on iOS and Android.  
* [react-native-message-bar ★300](https://github.com/KBLNY/react-native-message-bar) - A module for presenting notifications via an animated message bar at the top/bottom of the screen, highly customizable, for React Native (Android and iOS) projects.  
* [react-native-fit-image ★298](https://github.com/huiseoul/react-native-fit-image) - Responsive image component to fit perfectly itself.  
* [react-native-star-rating ★287](https://github.com/djchie/react-native-star-rating) - A React Native component for generating and displaying interactive star ratings  
* [react-native-toast ★285](https://github.com/remobile/react-native-toast) - A android like toast for react-native support for ios and android  
* [react-native-step-indicator ★282](https://github.com/24ark/react-native-step-indicator) - A simple react-native implementation of step indicator widget compatible with the ViewPager and ListView.  
* [react-native-responsive-image ★272](https://github.com/Dharmoslap/react-native-responsive-image) - Most elegant Responsive Image component  
* [react-native-effects-view ★271](https://github.com/voronianski/react-native-effects-view) - ReactNative Component that makes easy to use iOS8 UIVisualEffect  
* [react-native-alphabetlistview ★270](https://github.com/sunnylqm/react-native-alphabetlistview) - A ListView with a sidebar to jump to sections directly, based on johanneslumpe's react-native-selectablesectionlistview  
* [react-native-modal-picker ★261](https://github.com/d-a-n/react-native-modal-picker) - A cross-platform (iOS / Android), selector/picker component for React Native that is highly customizable and supports sections.  
* [react-native-gesture-recognizers ★260](https://github.com/johanneslumpe/react-native-gesture-recognizers) - Gesture recognizer decorators for react-native  
* [react-native-pdf-view ★258](https://github.com/cnjon/react-native-pdf-view) - view pdf file using react-native  
* [react-native-grid-view ★256](https://github.com/lucholaf/react-native-grid-view) - React Native Grid/Collection View component  
* [react-native-timeline-listview ★255](https://github.com/thegamenicorus/react-native-timeline-listview) - Timeline component for React Native App  
* [react-native-root-modal ★248](https://github.com/magicismight/react-native-root-modal) - react native modal component  
* [react-native-country-picker-modal ★246](https://github.com/xcarpentier/react-native-country-picker-modal) - Country picker provides a modal allowing a user to select a country from a list. It display a flag next to each country name.  
* [react-native-tabbar ★242](https://github.com/alinz/react-native-tabbar) - Tab bar with more freedom  
* [react-native-largelist ★241](https://github.com/bolan9999/react-native-largelist) - The best performance large list component for React Native.(iOS & Android)  
* [react-native-md-textinput ★241](https://github.com/evblurbs/react-native-md-textinput) - React Native TextInput styled with Material Design.  
* [react-native-simple-router ★240](https://github.com/react-native-simple-router-community/react-native-simple-router) - A community maintained router component for React Native  
* [react-native-off-canvas-menu ★239](https://github.com/shoumma/react-native-off-canvas-menu) - Beautifully crafted off canvas menu components for react native applications.  
* [react-native-keyboardevents ★239](https://github.com/johanneslumpe/react-native-keyboardevents) - Monitors keyboard show/hide notifications  
* [react-native-tableview-simple ★222](https://github.com/Purii/react-native-tableview-simple) - React Native component for TableView made with pure CSS  
* [react-native-sortable-list ★221](https://github.com/gitim/react-native-sortable-list) A sortable list for react native with both vertical and horizontal direction support.  
* [react-native-cacheable-image ★219](https://github.com/jayesbe/react-native-cacheable-image) - A filesystem cacheable image component for react-native  
* [react-native-timer-mixin ★219](https://github.com/reactjs/react-timer-mixin) - TimerMixin provides timer functions for executing code in the future that are safely cleaned up when the component unmounts. This is a fork that includes react-native InteractionManager support.  
* [react-native-circular-action-menu ★216](https://github.com/geremih/react-native-circular-action-menu) - An animated and customizable circular floating menu.  
* [react-native-canvas ★214](https://github.com/lwansbrough/react-native-canvas) - A Canvas element for React Native  
* [react-native-autocomplete-input ★210](https://github.com/l-urence/react-native-autocomplete-input) - Pure javascript autocomplete input for react-native  
* [react-native-timeago ★209](https://github.com/TylerLH/react-native-timeago) - Auto-updating timeago component for React Native  
* [react-native-check-box ★205](https://github.com/crazycodeboy/react-native-check-box) - Checkbox component for react native, it works on iOS and Android.  
* [react-native-mobx ★203](https://github.com/aksonov/react-native-mobx) - Make your app reactive with MobX and react-native-router-flux  
* [react-native-searchbar ★195](https://github.com/localz/react-native-searchbar) - An animated search bar for react native with inbuilt search (iOS and Android)  
* [react-native-awesome-button ★192](https://github.com/larsvinter/react-native-awesome-button) - A React Native component rendering a button supporting showing different appearances and functionality given the passed props  
* [react-native-progress-hud ★192](https://github.com/naoufal/react-native-progress-hud) - A clean and lightweight progress HUD for your React Native app  
* [react-native-search-box ★183](https://github.com/crabstudio/react-native-search-box) - A simple search box with animation, inspired from ios search bar.  
* [react-native-progress-bar ★181](https://github.com/lwansbrough/react-native-progress-bar) - An animated progress bar component for React Native  
* [react-native-masked-text ★168](https://github.com/benhurott/react-native-masked-text) - A simple masked text and input text component for React-Native.  
* [react-native-carousel-control ★162](https://github.com/machadogj/react-native-carousel-control) - React Native Carousel control with support for iOS and Android.  
* [react-native-tooltip ★161](https://github.com/chirag04/react-native-tooltip) - A react-native wrapper for showing tooltips  
* [react-native-emoji ★152](https://github.com/jorilallo/react-native-emoji) - Emoji component for React Native  
* [react-native-cache-image ★151](https://github.com/remobile/react-native-cache-image) - A cache-image for react-native  
* [react-native-selectme ★149](https://github.com/gs-akhan/react-native-select) - A better Select dropdown menu for react-native  
* [react-native-super-grid ★146](https://github.com/saleel97/react-native-super-grid) - Responsive Grid View for React Native.  
* [autoresponsive-react-native ★146](https://github.com/xudafeng/autoresponsive-react-native) - A Magical Layout Library For React  
* [react-native-autolink ★145](https://github.com/joshswan/react-native-autolink) - Autolinking component for React Native  
* [react-native-egg ★144](https://github.com/FuYaoDe/react-native-egg) - A easter egg component implementation simple gestures detection achieve trigger can make your react native app infinitely more fun.  
* [react-native-segmented-view ★144](https://github.com/lelandrichardson/react-native-segmented-view) - Segmented View for React Native (with animation)  
* [react-native-autocomplete ★139](https://github.com/nulrich/RCTAutoComplete) - React Native Component for MLPAutoCompleteTextField  
* [react-native-text-input-mask ★139](https://github.com/ivanzotov/react-native-text-input-mask) - Text input mask for Android and iOS, native implementation RedMadRobot libraries  
* [react-native-popup ★137](https://github.com/beefe/react-native-popup) - popup for react-native  
* [react-native-tab ★137](https://github.com/vczero/react-native-tab) - react-native-tab is a simple module for add a "Tab Menu" to your React Native app.  
* [react-native-keyboard-manager ★137](https://github.com/douglasjunior/react-native-keyboard-manager) - Library that allows to prevent issues of keyboard sliding up and cover on React-Native iOS projects.  
* [react-native-grid-component ★136](https://github.com/phil-r/react-native-grid-component) - Easy to use grid component for your react-native project. Supports iOS and Android.  
* [react-native-orientation-listener ★133](https://github.com/walmartreact/react-native-orientation-listener) - A react-native library for obtaining current device orientation  
* [react-native-cardview ★132](https://github.com/Kishanjvaghela/react-native-cardview) - CardView for react-native (All Android version and iOS)  
* [react-native-gestures ★129](https://github.com/kiddkai/react-native-gestures) - composable gesture system in react native  
* [react-native-webbrowser ★128](https://github.com/d-a-n/react-native-webbrowser) - A cross-platform (iOS / Android), full-featured, highly customizable web browser module for React Native apps.  
* [react-native-android-statusbar ★122](https://github.com/NishanthShankar/react-native-android-statusbar) - A react native android package to control the status bar.  
* [react-native-checkbox ★122](https://github.com/sconxu/react-native-checkbox) - Checkbox component for React native  
* [react-native-multi-slider ★119](https://github.com/JackDanielsAndCode/react-native-multi-slider) - Pure JS slider component with multiple markers for React Native  
* [react-native-page-control ★119](https://github.com/silentcloud/react-native-page-control) - React native page control, like ios UIPageControl  
* [rn-sliding-up-panel ★118](https://github.com/octopitus/rn-sliding-up-panel) - React Native draggable sliding up panel purly implemented in Javascript. Works nicely on both iOS and Android.  
* [react-native-qrcode-svg ★113](https://github.com/awesomejerry/react-native-qrcode-svg) - A QR Code generator for React Native based on react-native-svg and node-qrcode.  
* [react-native-google-place-picker ★112](https://github.com/q6112345/react-native-google-place-picker) - React Native Wrapper of Google Place Picker for both Android and iOS.  
* [react-native-paper ★109](https://github.com/callstack/react-native-paper.git) Material Design for React Native (Android & iOS).  
* [react-native-color-picker ★108](https://github.com/instea/react-native-color-picker) - React Native implementation of color picker for both Android and iOS.  
* [react-native-collapsing-toolbar ★108](https://github.com/cesardeazevedo/react-native-collapsing-toolbar) - wrapper for android CollapsingToolbarLayout  
* [react-native-radial-menu ★108](https://github.com/omulet/react-native-radial-menu) - A Radial Menu optimized for touch interfaces  
* [react-native-floating-labels ★107](https://github.com/mayank-patel/react-native-floating-labels) - Reusabe floating lable component for react native  
* [react-native-segmented-control-tab ★106](https://github.com/kirankalyan5/react-native-segmented-control-tab) react-native-segmented-control-tab(for Android/iOS)  
* [react-native-pulse-loader ★105](https://github.com/mastermoo/react-native-pulse-loader) - Tinder like loader for your React Native app  
* [react-native-wheel-picker ★105](https://github.com/lesliesam/react-native-wheel-picker) - React native cross platform picker.  
* [react-native-display ★103](https://github.com/sundayhd/react-native-display) - This module brings "Display: none" (css style) to turn on/off components from render. Using this module will improve your app performance and appearance with the enter/exit animations.  
* [react-native-device-display ★100](https://github.com/kkjdaniel/react-native-display-view) - A simple way to create dynamic views through device and display detection, allowing the creation of adaptable and universal apps.  
* [react-native-offline-mode ★96](https://github.com/rauchy/react-native-offline-mode) - Swap your app with an offline version while there's no connectivity  
* [react-native-custom-segmented-control ★96](https://github.com/wix/react-native-custom-segmented-control) - Native UI iOS component for Segmented Control with custom style  
* [react-native-card-view ★95](https://github.com/jacklam718/react-native-card-view) - A react native card component  
* [react-native-privacy-snapshot ★93](https://github.com/kayla-tech/react-native-privacy-snapshot) - Obscure passwords and other sensitive personal information when a react-native app transitions to the background  
* [react-native-gmaps ★93](https://github.com/teamrota/react-native-gmaps) - React Native Android Google Maps implementation.  
* [react-native-android-kit ★93](https://github.com/ayoubdev/react-native-android-kit) - A set of native Android UI components and modules for React Native framework (Android Design Support Library, TabLayout, Floating Action Button and more...).  
* [react-native-image-carousel ★92](https://github.com/anvilabs/react-native-image-carousel) - Image carousel with support for fullscreen mode, image swiping and pinch-to-zoom in fullscreen mode.  
* [react-native-hero ★91](https://github.com/brh55/react-native-hero) - A hero/banner component with support for dynamic or static images, dynamic sizing, color overlays, and more.  
* [react-native-swiper-animated ★87](https://github.com/chitezh/react-native-swiper-animated) - Tinder-like swiper for react-native  
* [react-native-pagination ★85](https://github.com/garrettmac/react-native-pagination) - A Beautiful Pagination Plugin For Lists.  
* [react-native-swiper2 ★85](https://github.com/sunnylqm/react-native-swiper2) - Swiper component for React Native. Supersede react-native-swiper  
* [react-native-swipe-a-lot ★84](https://github.com/nickjanssen/react-native-swipe-a-lot) - A swipe component for React Native that works on iOS and Android.  
* [react-native-size-matters ★84](https://github.com/nirsky/react-native-size-matters) - A React-Native utility belt for scaling the size your apps UI across different sized devices.  
* [react-native-listitem ★83](https://github.com/dancormier/react-native-listitem) - iOS-style listitem component for React Native  
* [react-native-scrollable-mixin ★83](https://github.com/exponentjs/react-native-scrollable-mixin) - A standard interface for your scrollable React Native components, making it easier to compose components.  
* [react-native-parallax-swiper ★80](https://github.com/zachgibson/react-native-parallax-swiper) - Configurable parallax swiper based on an iOS pattern. Uses Native Driver for super smooth parallax.  
* [react-native-cell-components ★78](https://github.com/lodev09/react-native-cell-components) - Awesome react-native cell components! From a Cell to more complex & awesome components.  
* [react-native-marquee-label ★75](https://github.com/remobile/react-native-marquee-label) - A marquee label for react-native  
* [react-native-page-swiper ★74](https://github.com/fixt/react-native-page-swiper) - Page Swiper component for React Native.  
* [react-native-submit-button ★74](https://github.com/ronak301/react-native-submit-button) - Animated Submit button. Works on both android and ios.  
* [react-native-fading-slides ★71](https://github.com/chagasaway/react-native-fading-slides) - Simple looped fading slides carousel for React Native  
* [react-native-parallax-scroll ★71](https://github.com/monterosalondon/react-native-parallax-scroll) - Parallax Scroll component with sticky header, foreground, native-driver and all scrollable components(FlatList, ListView, SectionList, ScrollView) support.  
* [react-native-viewport-units ★71](https://github.com/jmstout/react-native-viewport-units) - Incredibly simple utility for (sort of) using viewport units with React Native.  
* [react-native-shared-preferences ★69](https://github.com/sriraman/react-native-shared-preferences) - Android's Native key value storage system in React Native  
* [react-native-typography ★69](https://github.com/hectahertz/react-native-typography) Pixel–perfect, native–looking typographic styles for React Native  
* [react-native-triangle ★69](https://github.com/Jpoliachik/react-native-triangle) - draw triangle views in react native  
* [react-native-android-blurryoverlay ★68](https://github.com/kwaak/react-native-android-blurryoverlay) - A react native android package to show a blurry overlay.  
* [react-native-scrollview-lazyload ★65](https://github.com/IskenHuang/react-native-scrollview-lazyload) - react-native scrollview with image lazy load  
* [react-native-charts ★64](https://github.com/PrazAs/react-native-charts) - Delightfully-animated data visualization.  
* [react-native-emoji-picker ★63](https://github.com/yonahforst/react-native-emoji-picker) - Simple Emoji picker for react-native with optional modal-like component  
* [react-native-picker-android ★63](https://github.com/beefe/react-native-picker-android) - react-native-picker-android  
* [RNParallax ★63](https://github.com/kyaroru/RNParallax) - A react native scroll view component with Parallax header
* [react-native-bouncy-drawer ★62](https://github.com/SoftZen/react-native-bouncy-drawer) - Highly customizable Bouncy Drawer  
* [react-native-dropdown-android ★62](https://github.com/chymtt/ReactNativeDropdownAndroid) - Simple wrapper for Android's Spinner to use with react-native  
* [react-native-textinput-utils ★62](https://github.com/DickyT/react-native-textinput-utils) - A react native extension which allows you to control TextInput better.  
* [react-native-item-cell ★62](https://github.com/APSL/react-native-item-cell) - React Native default style iOS item cell  
* [react-native-progressive-input ★61](https://github.com/khaiql/react-native-progressive-input) - TextInput with clear button and activity indicator, used as part of autocomplete list.  
* [react-native-calendar-select ★60](https://github.com/Tinysymphony/react-native-calendar-select) - A component to select a date period from calendar modal, like Airbnb.  
* [react-native-nested-stylesheet ★60](https://github.com/pjjanak/react-native-nested-stylesheets) - Nestable stylesheets for react-native.  
* [react-native-drawer-menu ★59](https://github.com/Tinysymphony/react-native-drawer-menu) - React Native Drawer Menu  
* [react-native-beautiful-video-recorder ★59](https://github.com/phuochau/react-native-beautiful-video-recorder) - The video recorder component that extends from react-native-camera. It works for both iOS & Android.  
* [react-native-picker-xg ★58](https://github.com/xgfe/react-native-picker-xg) - A picker for both Android and iOS  
* [react-native-calendar-datepicker ★58](https://github.com/vlad-doru/react-native-calendar-datepicker) - A cross-platform calendar datepicker  
* [react-native-idle-timer ★55](https://github.com/marcshilling/react-native-idle-timer) - An Objective-C bridge that allows you to enable and disable the screen idle timer in your React Native app  
* [react-native-android-wheel-picker ★54](https://github.com/ElekenAgency/ReactNativeWheelPicker) - Simple and flexible React native wheel picker for Android, including DatePicker and TimePicker.  
* [react-native-phone-input ★54](https://github.com/thegamenicorus/react-native-phone-input) - Phone input box for React Native  
* [react-native-fs-modal ★51](https://github.com/kirkness/react-native-fs-modal) - React native full screen modal component.  
* [react-native-scrollview-smart ★49](https://github.com/bolket/react-native-scrollview-smart) - A Smart ScrollView component for IOS and Android.  
* [react-native-phone-picker ★49](https://github.com/Spikef/react-native-phone-picker) - a quick phone picker control  
* [k-react-native-swipe-unlocker ★48](https://github.com/leowang721/k-react-native-swipe-unlocker) - A simple swipe unlock for React Native  
* [react-native-label-select ★47](https://github.com/Tinysymphony/react-native-label-select) - A modal selector for React Native with selected items displayed as labels.  
* [react-native-adbannerview ★47](https://github.com/Purii/react-native-adbannerview) - React Native Bridge for ADBannerView  
* [react-native-masked-view ★46](https://github.com/gilbox/react-native-masked-view) - A element for react-native  
* [react-native-date ★45](https://github.com/nucleartux/react-native-date) - React Native date and time pickers for Android  
* [react-native-multiple-choice ★45](https://github.com/d-a-n/react-native-multiple-choice) - A cross-platform (iOS / Android) single and multiple-choice React Native component.  
* [react-native-flexi-radio-button ★45](https://github.com/thegamenicorus/react-native-flexi-radio-button) - Simple and flexible Radio button for React Native  
* [react-native-message-composer ★44](https://github.com/anarchicknight/react-native-message-composer) - React Native module bridge to iOS MFMessageComposeViewController  
* [react-native-infinite-scrollview ★44](https://github.com/baspellis/react-native-infinite-scrollview) - ScrollView with infinite paged scrolling (no looping)  
* [react-native-snackbar-component ★44](https://github.com/SiDevesh/React-Native-SnackBar-Component) - A snackbar component for Android and iOS, customizable and simple.  
* [react-native-fxblurview ★44](https://github.com/magus/react-native-fxblurview) - React Native wrapper for popular FXBlurView library for realtime, fine-tuned blur effects  
* [react-native-calendar-android ★44](https://github.com/chymtt/ReactNativeCalendarAndroid) - A simple material-themed calendar for react native android  
* [react-native-viewport ★42](https://github.com/pjjanak/react-native-viewport) - Viewport dimensions for react-native  
* [react-native-simple-picker ★42](https://github.com/puredazzle/react-native-simple-picker) - A simple react-native select picker  
* [react-native-simpledialog-android ★41](https://github.com/lucasferreira/react-native-simpledialog-android) - React Native Android module to use Android's AlertDialog - same idea of AlertIOS  
* [react-native-touchable-bounce ★41](https://github.com/grabbou/react-native-touchable-bounce) - React Native Touchable Bounce  
* [react-native-zoom-image ★41](https://github.com/Tinysymphony/react-native-zoom-image) - An image viewer component for react-native, like twitter's image viewer.  
* [react-native-swipeview ★41](https://github.com/rishabhbhatia/react-native-swipeview) - SwipeView component used to perform actions like swipe to delete, works on iOS and Android
* [react-native-scalable-image ★40](https://github.com/ihor/react-native-scalable-image) - React Native Image component which scales width or height automatically to keep the original aspect ratio.
* [react-native-beautiful-image ★40](https://github.com/phuochau/react-native-beautiful-image) - The Beautiful Image component that supports fadeIn animation and shows placeholderSource if the main source can't be loaded.  
* [react-native-radio-button-classic ★40](https://github.com/pressly/react-native-radio-button-classic) - Bring Classic Radio to React-Native  
* [react-native-tween-animation ★40](https://github.com/kirkness/react-native-tween-animation) - A simple react native state tween animation module.  
* [react-native-custom-actsheet ★39](https://github.com/guodong000/react-native-custom-actsheet) - A custom ActionSheet for react-native  
* [react-native-drop-refresh ★39](https://github.com/Obooman/RCTRefreshControl) - A pull down to refresh control for react native.  
* [react-native-layout ★39](https://github.com/jerolimov/react-native-layout) - Semantic JSX layout components for react-native  
* [react-native-image-intent ★38](https://github.com/sonnylazuardi/react-native-image-intent) - Image intent receiver for React Native android  
* [react-native-toolkit ★38](https://github.com/marty-wang/react-native-toolkit) - A collection of common UI components for react native mobile apps.  
* [react-native-card-media ★37](https://github.com/dondoko-susumu/react-native-card-media) - Card media component & Support multiple image layout  
* [react-native-popupwindow ★37](https://github.com/beefe/react-native-popupwindow) - Android PopupWindow for react-native module  
* [react-native-progress-circular ★36](https://github.com/andy9775/React-Native-CircularProgress) - A pure React Native Component for circular progress bars for both iOS and Android.  
* [react-native-simple-stepper ★35](https://github.com/testshallpass/react-native-simple-stepper) - A super simple react-native implementation of the UIStepper iOS control.  
* [react-native-streetview ★35](https://github.com/nesterapp/react-native-streetview) - Google's Panorama/StreetView component for iOS and Android.  
* [react-native-draggable-drawer ★34](https://github.com/llanox/react-native-draggable-drawer) - DraggableDrawer component for React Native.  
* [react-native-slack-webhook ★34](https://github.com/xcarpentier/react-native-slack-webhook) - Follow some activities (new user, payment, ...) from your app via Slack and this webhook lib.  
* [react-native-slot-machine ★32](https://github.com/atlanteh/react-native-slot-machine) - A text slot machine component for react-native  
* [react-native-material-cards ★32](https://github.com/SiDevesh/React-Native-Material-Cards) - A material design card component, customizable and versatile.  
* [photo-viewer ★32](https://github.com/merryjs/photo-viewer) - A photo viewer for react native build on top of NYTPhotoViewer and FrescoImageViewer.  
* [react-native-circle-view ★32](https://github.com/nucleartux/react-native-circle-view) - circle progress for react native android using CircleView  
* [react-native-slidable-tab-bar ★32](https://github.com/pwbrown/react-native-slidable-tab-bar) - Slidable tab bar for instant view rendering(react-native)  
* [react-native-color-wheel ★31](https://github.com/netbeast/react-native-color-wheel) - A react native reusable color picker wheel  
* [react-native-simple-dialogs ★31](https://github.com/douglasjunior/react-native-simple-dialogs) - Cross-platform simple dialogs for React Native based on the Modal component.  
* [react-native-full-screen ★31](https://github.com/Anthonyzou/react-native-full-screen) - React Native FullScreen api and element  
* [react-native-scrollable-decorator ★31](https://github.com/exponentjs/react-native-scrollable-decorator) - A standard interface for your scrollable React Native components, making it easier to compose components  
* [react-native-3dcube-navigation ★30](https://github.com/zehfernandes/react-native-3dcube-navigation) - Page Swiper component with 3D cube transition (horizontal and vertical)  
* [react-native-touch-visualizer ★30](https://github.com/zachgibson/react-native-touch-visualizer) - Visualize touches and drags on React Native apps for iOS.  
* [react-native-view ★30](https://github.com/i6mi6/react-native-view) - Lightweight View component for quick styling.  
* [react-native-newsticker ★30](https://github.com/moschan/react-native-newsticker) - The News Ticker component for React Native  
* [react-native-android-iconify ★30](https://github.com/lwhiteley/react-native-android-iconify) - icons for react native android using android-iconify  
* [react-native-auto-typing-text ★29](https://github.com/phuongla/react-native-auto-typing-text) - An auto typing text component for react-native  
* [react-native-svg-charts ★28](https://github.com/JesperLekland/react-native-svg-charts) - One library to rule all charts for React Native  
* [react-native-touchable-set-active ★28](https://github.com/jmstout/react-native-TouchableSetActive) - Touchable component for React Native that enables more advanced styling by setting an active state. Most useful for building your own touchable/button components on top of.  
* [react-native-flanimatedimage ★28](https://github.com/nihgwu/react-native-flanimatedimage) - FLAnimatedImage for React Native.  
* [react-native-dial ★28](https://github.com/netbeast/react-native-dial) - A react native reusable and efficient dial knob element.  
* [react-native-air-progress-bar ★28](https://github.com/kis/react-native-air-progress-bar) - React Native progress-bar component, customizable and animated  
* [react-native-dashed-border ★28](https://github.com/chirag04/react-native-dashed-border) - A element for react-native  
* [react-native-bar-collapsible ★27](https://github.com/caroaguilar/react-native-bar-collapsible) - A Bar component that can be collapsible (toggle/accordion), clickable or text-only.  
* [react-native-grading ★27](https://github.com/Tinysymphony/react-native-grading) - RN Component for grading scores using ReactART.  
* [react-native-md-motion-buttons ★27](https://github.com/zecaptus/react-native-md-motion-buttons) - Material design motion button inspired by inVision app.  
* [react-native-in-app-notification ★26](https://github.com/robcalcroft/react-native-in-app-notification) - Customisable in-app notification component for React Native  
* [react-native-telephone-input ★26](https://github.com/kundigo/react-native-telephone-input) - React Native Telephone Input, discover country and mask telephone Input  
* [react-native-circle-checkbox ★26](https://github.com/ParamoshkinAndrew/ReactNativeCircleCheckbox) - Circle checkbox component for React Native  
* [react-native-open-maps ★25](https://github.com/brh55/react-native-open-maps) - A simple lib to open up the corresponding map application (Google or Apple Maps) from a set of coordinates (latitude & longitude) within react-native  
* [react-native-wheel ★25](https://github.com/shexiaoheng/react-native-wheel) - android wheel view for react-native  
* [react-native-taptargetview ★25](https://github.com/prscX/react-native-taptargetview) - React Native Bridge for Android KeepSafe/TapTargetView. An implementation of tap targets from the Material Design guidelines for feature discovery.  
* [rn-render-perfs ★25](https://github.com/mfrachet/rn-render-perfs) - Measure React rendering lifecycles using UI controls  
* [react-native-countdown ★25](https://github.com/buhe/react-native-countdown) - react native countdown button  
* [react-native-photo-grid ★24](https://github.com/christopherabouabdo/react-native-photo-grid) - React Native component that handles the complexities of building a grid of photos with a flexible number of photos per row.  
* [react-native-nmrangeslider-ios ★24](https://github.com/Enrise/react-native-nmrangeslider-ios) - The NMRangeSlider component for React Native  
* [react-native-animated-check-mark ★24](https://github.com/AppliKeySolutions/RocketButton) - A small react component for animated cross-mark transformation.  
* [react-native-circle-progress ★23](https://github.com/guodong000/react-native-circle-progress) - A custom Circle Progress Indicator for React Native  
* [react-native-thumbnail ★22](https://github.com/phuochau/react-native-thumbnail) - Get thumbnail from local media.  
* [react-native-orientation-controller ★22](https://github.com/inProgress-team/react-native-orientation-controller) - A react-native library for obtaining and controlling the current device and application orientation  
* [react-native-multi-select ★21](https://github.com/hasangilak/react-native-multi-select) - you know select2 on web ? now you have it in react native at your command :)  
* [react-native-starrating ★21](https://github.com/bluesky0109/react-native-starRating) - a react-native component for display interactive star ratings  
* [react-native-showdown ★21](https://github.com/jerolimov/react-native-showdown) - React-native component which renders markdown into a webview!  
* [react-native-toast-native ★21](https://github.com/onemolegames/react-native-toast-native) React Native Toast component for both Android and iOS.  
* [react-native-actionsheet-native ★21](https://github.com/slowpath/react-native-actionsheet) - Android ActionSheet support for React Native  
* [react-native-switch-selector ★20](https://github.com/App2Sales/react-native-switch-selector) - A custom Switch Selector component for Android and iOS.  
* [react-native-fab ★20](https://github.com/SiDevesh/React-Native-FAB) - A FAB button component for Android and iOS, customizable, simple and as per material design specs.  
* [react-native-square-view ★20](https://github.com/Shuangzuan/react-native-square-view) - A square view component for react native.  
* [react-native-writebox ★20](https://github.com/bdryanovski/react-native-writebox) - (iOS / Android) Facebook/Twitter textarea that autogrow and count characters.  
* [react-native-match-media ★19](https://github.com/tuckerconnelly/match-media-mocks) - window.matchMedia mock for React Native  
* [react-native-ibeacon-simulator ★19](https://github.com/williamtran29/react-native-ibeacon-simulator) - React Native Library to simulate device act as an iBeacon  
* [react-native-dropbox-chooser ★18](https://github.com/tinycreative/react-native-dropbox-chooser) - React Native dropbox chooser module  
* [react-native-timepicker ★18](https://github.com/milasevicius/react-native-timepicker) - React Native timepicker for iOS  
* [react-native-ichart ★18](https://github.com/AdonRain/react-native-ichart) - ichart for react-native  
* [react-native-material-showcase-ios ★18](https://github.com/prscX/react-native-material-showcase-ios) - React Native Bridge for iOS aromajoin/material-showcase-ios. An elegant and beautiful showcase for iOS apps.  
* [rn-ab-hoc ★17](https://github.com/mfrachet/rn-ab-hoc) - Poor intrusive way to make A/B Testing by using an HoC instead of components.  
* [react-native-awesome-alert ★18](https://github.com/heyman333/react-native-awesome-alert) - Customizable modal components with ✔️check options in React Native
* [react-native-store-view ★16](https://github.com/rh389/react-native-store-view) - Wraps SKStoreProductViewController for use in react-native projects  
* [react-native-grid ★16](https://github.com/thewei/react-native-grid) - The 24-column grid component for react-native  
* [react-native-android-circles ★15](https://github.com/kwaak/react-native-android-circles) - A react native android package to show a circle progress view.  
* [react-native-search ★15](https://github.com/StevenIseki/react-native-search) - Native Search component for react native.  
* [react-native-focus-scroll ★14](https://github.com/c-bata/react-native-focus-scroll) - react-native-focus-scroll can detect which children are focused when scrolling.  
* [react-native-avatar-gravatar ★13](https://github.com/niborb/react-native-gravatar) - React Native Gravatar component  
* [react-native-custom-checkbox ★13](https://github.com/caroaguilar/react-native-custom-checkbox) - React Native checkbox that can be customize. Works for both Android and iOS.  
* [react-native-expand ★13](https://github.com/hejiaji/react-native-expand) - A react-native expandable component for both Android and iOS  
* [react-native-markdown-editor ★13](https://github.com/kunall17/react-native-markdown-editor) - Markdown editor like github comment editor (contains preview, markdown buttons)  
* [react-native-fade-in-view ★13](https://github.com/robcalcroft/react-native-fade-in-view) - A simple and lightweight RN component that fades in its children  
* [react-native-multiselect ★12](https://github.com/robcalcroft/react-native-multiselect) - A simple multi select component with events and a flexible API.  
* [react-native-tilt ★12](https://github.com/psicotropicos/react-native-tilt) - Tilt effect with accelerometer for React Native components.  
* [react-native-rebound-scrollview ★11](https://github.com/jaxchow/react-native-rebound-scrollview) - React Native Android ReboundScrollView implementation.  
* [react-native-imagewand ★11](https://github.com/NorthFoxz/react-native-imagewand) - image wand for react native  
* [react-native-elastic-stack ★11](https://github.com/monterosalondon/react-native-elastic-stack) - ReactNative component that implements [elastic stack effect](https://tympanus.net/Development/ElasticStack/)  
* [react-native-big-slider ★11](https://github.com/netbeast/react-native-big-slider) - Yet another, big one, pure JS easily customisable and hackable react-native slider component.  
* [react-native-piechart ★10](https://github.com/frostney/react-native-piechart) - A component for React Native  
* [react-native-app-intro-v2 \*5 ★10](https://github.com/Sh1n1x/react-native-app-intro) - Latest App intro  
* [react-native-seekbar-android ★10](https://github.com/DispatcherInc/react-native-seekbar-android) - A React Native wrapper Android's SeekBar  
* [react-native-hijri-date-picker ★10](https://github.com/Codelabsys/react-native-hijri-date-picker-android) - Date Picker Dialog for Hijri calendar for android.  
* [react-native-compress ★9](https://github.com/phuochau/react-native-compress) - Compress video for react native. Only for iOS, Android will be coming.  
* [react-native-gravatar ★9](https://github.com/lwhiteley/react-native-gravatar) - react-native wrapper for gravatar-api  
* [react-native-quiltview ★8](https://github.com/mmslate/react-native-quiltview) - Native iOS UICollectionView wrapper with RFQuiltLayout for React Native  
* [react-native-comparison-slider ★8](https://github.com/charlot567/react-native-comparison-slider) - A simple component to display two image in comparison with a slide-over feature.  
* [react-native-relative-units ★8](https://github.com/benzhe/react-native-relative-units) - Relative units for React Native  
* [react-native-simple-button ★7](https://github.com/remobile/react-native-simple-button) - A simple react-native button  
* [react-native-country-picker ★7](https://github.com/tofugear/react-native-country-picker) - React Native Country Picker  
* [react-native-flex-label ★7](https://github.com/eccolabs/react-native-flex-label) - A text label for React Native that handles multiple lines of text with ellipses truncation as well as vertical alignment within it's view container.  
* [react-native-link ★7](https://github.com/650Industries/react-native-link) - A link component  
* [react-native-stylesheet-xg ★6](https://github.com/xgfe/react-native-stylesheet-xg) - extension stylesheet for cross platforms and responsive  
* [react-native-loading ★5](https://github.com/alcat2008/react-native-loading) - A lightweight loading for your React Native app.  
* [react-native-progress-button ★4](https://github.com/xinghui0000/react-native-progress-button) - A react native button component that can show progress.  
* [react-native-loader-hud ★3](https://github.com/EdgeJay/react-native-loader-hud) - Loader animation library for React Native  
* [react-native-double-buffer ★3](https://github.com/alinz/react-native-double-buffer) - Simple React Native Double Buffer View  
* [react-native-custom-actionsheet ★3](https://github.com/valerybugakov/react-native-custom-actionsheet) - Fully customizable ActionSheet for React Native.  
* [react-native-easy-checkbox ★2](https://github.com/BhavanPatel/react-native-easy-checkbox) - Simple CheckBox for react-native  
* [react-native-animated-styles ★2](https://github.com/ericpkerr/react-native-animated-styles) - Easily animate/transition react components between two style states.  
* [react-native-scene-manager ★2](https://github.com/alinz/react-native-scene-manager) - Simple Scene Manager for React-Native  
* [react-native-fontbase ★2](https://github.com/frostney/react-native-fontbase) - Defining font sizes in React Native  
* [react-native-censored ★2](https://github.com/redpandatronicsuk/react-native-censored) - React Native component to censor content.  
* [rn-displayable ★1](https://github.com/mfrachet/rn-displayable) - Display your components based on props or a set of rules  
* [react-native-create-new-file-ios ★1](https://github.com/rhaker/react-native-create-new-file-ios) - A react-native interface for creating a blank new file on ios. File must not already exist.  
* [react-native-image-container ★0](https://github.com/frostney/react-native-image-container) - Image container for React Native  
* [react-native-select-box ★0](https://github.com/akiran/react-native-select-box) - react native select box  

### Navigation

* [react-navigation ★8319](https://github.com/react-community/react-navigation) - Easy to use Navigation for React Native  
* [react-native-router-flux ★5909](https://github.com/aksonov/react-native-router-flux) - React Native Router based on new React Native Navigation API  
* [react-native-navigation ★5429](https://github.com/wix/react-native-navigation) - App-wide support for 100% native navigation with an easy cross-platform interface.  
* [kittenTricks ★3086](https://github.com/akveo/kittenTricks) - A react native mobile starter kit with over 40 screens and theme hot reload support  
* [native-navigation ★2621](https://github.com/airbnb/native-navigation) - Native navigation library for React Native applications  
* [react-native-navbar ★1682](https://github.com/Kureev/react-native-navbar) - Simple customizable navbar component for react-native  
* [react-native-router ★1195](https://github.com/t4t5/react-native-router) - Awesome navigation for your native app.  
* [ex-navigation ★984](https://github.com/exponentjs/ex-navigation) - A route-centric, batteries-included navigation library for Exponent and React Native that works seamlessly on Android and iOS.  
* [ex-navigator ★526](https://github.com/exponentjs/ex-navigator) - Route-centric navigation built on top of React Native's Navigator  
* [react-native-controllers ★523](https://github.com/wix/react-native-controllers) - Truly native no-compromise iOS navigation for React Native.  
* [react-native-nav ★232](https://github.com/jineshshah36/react-native-nav) - A cross-platform (iOS / Android), fully customizable, React Native Navigation Bar component  
* [react-native-ya-navigator ★89](https://github.com/xxsnakerxx/react-native-ya-navigator) - Yet another react native navigator component  
* [react-native-navigation-drawer ★86](https://github.com/ilansas/react-native-navigation-drawer) - A slide menu inspired from Android for React-Native  
* [navbar-native ★79](https://github.com/redbaron76/navbar-native) - A new, fully customizable Navbar component for React-Native  
* [react-native-navigator ★76](https://github.com/thewei/react-native-navigator) - A simple router for react native  
* [react-native-navigation-bar ★56](https://github.com/beefe/react-native-navigation-bar) - react-native-navigation-bar  
* [react-native-url-handler ★34](https://github.com/exponentjs/react-native-url-handler) - Navigate to external URLs, handle in-app URLs, and access system URLs  
* [react-native-route-navigator ★27](https://github.com/Andr3wHur5t/react-native-route-navigator) - React-Native page navigation using URIs.  
* [react-native-transparent-bar ★16](https://github.com/23c/react-native-transparent-bar) - react native navigator transparent bar  
* [react-native-router-sinux ★ ★3](https://github.com/jbpin/react-native-router-sinux) - React Native Router based on new NavigationExperimental that use Sinux as Flux implementation.  
* [react-native-grid-list ★ ★3](https://github.com/gusgard/react-native-grid-list) - React Native Grid List component  
* [react-native-navigation-buttons ★2](https://github.com/shayne/react-native-navigation-buttons) - iOS navigation buttons for the React Native Navigator  
* [react-native-swiper-flatlist ★★](https://github.com/gusgard/react-native-swiper-flatlist) - 👆 React Native Swiper component implemented with FlatList  
* [react-native-yynavigator ★0](https://github.com/yiyangest/react-native-yynavigator) - custom navigation bar for react-native  

#### Navigation/Routing Articles

* [Basics of using react-native-router-flux](https://medium.com/@spencer_carli/react-native-basics-using-react-native-router-flux-f11e5128aff9#.di5mvrbdr)  
* [Routing and Navigation in React Native](http://blog.paracode.com/2016/01/05/routing-and-navigation-in-react-native/)  
* [NavigatorIOS: Accessing onRightButtonPress from within child component](https://github.com/facebook/react-native/issues/31)  

#### Navigation Demos

* [movieapp ★913](https://github.com/JuneDomingo/movieapp) – Discover Movies and TV shows - it uses redux and wix/react-native-navigation  
* [Navigator Demo ★188](https://github.com/h87kg/NavigatorDemo)  
* [ExNavRelay ★20](https://github.com/sibelius/ExNavRelay) - React Native + Ex-navigation + Relay integration template  
* [React Native Example App: Navigation](http://tech.taskrabbit.com/blog/2015/09/21/react-native-example-app/)  

### Text & Rich Content

* [react-native-hyperlink ★173](https://github.com/obipawan/hyperlink) - A `<Hyperlink />` component for react-native that makes urls, fuzzy links, emails etc clickable and stylable  
* [react-native-draftjs-render ★157](https://github.com/globocom/react-native-draftjs-render) - A React Native render for Draft.js model  
* [react-native-htmltext ★118](https://github.com/siuying/react-native-htmltext) - Use HTML like markup to create stylized text in react-native.  
* [react-native-html-to-pdf ★113](https://github.com/christopherdro/react-native-html-to-pdf) - Convert html strings to PDF documents using React Native  
* [react-native-html-webview ★97](https://github.com/almost/react-native-html-webview) - Display (possibly untrusted) HTML using a UIWebView in React Native.  
* [react-native-html-render ★93](https://github.com/soliury/react-native-html-render) - A html render for react-native  
* [react-native-hypertext ★21](https://github.com/agentcooper/react-native-hypertext) - React Native module to render hypertext (text with links)  
* [react-native-asciimage ★16](https://github.com/turley/react-native-asciimage) - An ASCIImage component for React Native  
* [react-native-universal-modal ★16](https://github.com/bokuweb/react-native-universal-modal) - Universal simple modal component for React Native  
* [react-native-measure-text ★16](https://github.com/airamrguez/react-native-measure-text) - Measure text height without laying it out.  
* [react-native-html ★11](https://github.com/turingou/react-native-html) - render html as react native custom elements  

### Analytics

* [react-native-fabric ★777](https://github.com/corymsmith/react-native-fabric) - A React Native library for Fabric, Crashlytics and Answers  
* [react-native-google-analytics-bridge ★767](https://github.com/idehub/react-native-google-analytics-bridge) - A native Google Analytics bridge for React Native. Uses the official libraries on both iOS and Android.  
* [react-native-google-analytics ★245](https://github.com/lwansbrough/react-native-google-analytics) - Google Analytics for React Native!  
* [react-native-mixpanel ★211](https://github.com/davodesign84/react-native-mixpanel) - A React Native wrapper for Mixpanel tracking  
* [react-native-ab ★137](https://github.com/lwansbrough/react-native-ab) - A component for rendering A/B tests in React Native  
* [react-native-segment-io-analytics ★62](https://github.com/smore-inc/react-native-segment-io-analytics) - A React Native Segment wrapper!  
* [react-native-td ★14](https://github.com/quipper/react-native-td) - An unofficial React Native SDK for Treasure Data.
* [react-native-ux-cam ★13](https://github.com/negativetwelve/react-native-ux-cam) - React Native wrapper for uxcam.com.  

### Utils & Infra

* [detox ★1511](https://github.com/wix/detox) - Graybox End-to-End (functional) Tests and Automation Library for Mobile with first class support for React Native  
* [react-native-workers ★458](https://github.com/devfd/react-native-workers) - Background services and web workers for react-native  
* [react-native-mock ★425](https://github.com/RealOrangeOne/react-native-mock) - A fully mocked and test-friendly version of react native  
* [react-native-crypto ★115](https://github.com/mvayngrib/react-native-crypto) - implementation of crypto for React Native  
* [react-native-zip-archive ★106](https://github.com/plrthink/react-native-zip-archive) - Zip / Unzip archive utility  
* [codemod-RN24-to-RN25 ★100](https://github.com/sibeliusseraphini/codemod-RN24-to-RN25) - a simple codemod to handle the new import style on >=RN25  
* [react-native-slowlog ★93](https://github.com/jondot/react-native-slowlog) - A high-performance timer based profiler for React Native that helps you track big performance problems  
* [react-native-eval ★64](https://github.com/artemyarulin/react-native-eval) - Call any JS functions from your native code  
* [react-native-userdefaults-ios ★59](https://github.com/dsibiski/react-native-userdefaults-ios) - React Native Module for NSUserDefaults  
* [react-native-user-defaults ★47](https://github.com/wwayne/react-native-user-defaults) - ios UserDefaults used by react-native  
* [react-native-device-log ★46](https://github.com/olofd/react-native-device-log) - A UI and service for displaying dev-logs on devices.  
* [react-native-webp ★46](https://github.com/dbasedow/react-native-webp) - react-native-webp adds support for WebP images for react-native components.  
* [react-native-global-event-emitter ★43](https://github.com/paramaggarwal/react-native-global-event-emitter) - Shared event emitter between native and JS for React Native.  
* [react-native-linkedin ★42](https://github.com/xcarpentier/react-native-linkedin) React-Native LinkedIn, a simple LinkedIn login library for React-Native or Expo with WebView and Modal  
* [react-native-call-detection ★40](https://github.com/priteshrnandgaonkar/react-native-call-detection) - Helps to detect different call states like Incoming, Disconnected, Dialing and Connected  
* [react-native-aws-signature ★38](https://github.com/leimd/react-native-aws-signature) - help generate signature required for using AWS API. Necessary to use S3, ec2, or other services.  
* [react-native-html-parser ★26](https://github.com/g6ling/react-native-html-parser) - parse html in react-native  
* [react-native-rsa ★22](https://github.com/z-hao-wang/react-native-rsa) - RSA crypto lib for react native  
* [react-native-aes ★21](https://github.com/mvayngrib/react-native-aes) - AES in react-native  
* [react-native-console-time-polyfill ★16](https://github.com/MaxGraey/react-native-console-time-polyfill) - console.time and console.timeEnd polyfill for react-native  
* [react-native-hour-format ★15](https://github.com/SoftwareMansion/react-native-hour-format) - Get hour format from OS settings.  
* [react-native-des ★15](https://github.com/remobile/react-native-des) - A des crypto for react-native  
* [react-native-babel-jest ★13](https://github.com/apentle/react-native-babel-jest) - Simple testing configuration for React Native with Jest  
* [react-native-immutable ★12](https://github.com/thewei/react-native-immutable) - using immutable.js library with react-native  
* [react-native-simple-encryption ★11](https://github.com/BhavanPatel/react-native-simple-encryption) - Simple XOR and base\_64 encryption decryption for react-native  
* [react-native-util ★10](https://github.com/exponentjs/react-native-util) - A fork of io.js's util module that works with React Native  
* [react-native-webpackager-server ★5](https://github.com/changfuguo/react-native-webpackager-server) - react native webpackager server  
* [react-native-fluxbone ★5](https://github.com/jgable/react-native-fluxbone) - A group of libraries that help with the FluxBone pattern in React Native  
* [react-native-HsvToRgb ★2](https://github.com/Copypeng/react-native-HsvToRgb) - a helper to convert HSV(HSB) color to RGB.  
* [react-native-tools ★0](https://github.com/kkennis/react-native-tools) - Tools for react native project development  

### Forms

* [redux-form ★4829](http://redux-form.com) - Redux form state management (Web and Native)  
* [formik ★3822](https://github.com/jaredpalmer/formik) - Forms in React, without tears.  
* [tcomb-form-native ★2293](https://github.com/gcanti/tcomb-form-native) - Generate React Native forms  
* [react-native-gifted-form ★1052](https://github.com/FaridSafi/react-native-gifted-form) - Form component for react-native  
* [react-native-clean-form ★315](https://github.com/esbenp/react-native-clean-form) - Good looking form elements with redux-form integration. Stylable with styled-components.  
* [react-native-form-generator ★312](https://github.com/MichaelCereda/react-native-form-generator) - Generate amazing React Native forms in a breeze  
* [react-native-form ★127](https://github.com/julianocomg/react-native-form) - A simple react-native component to wrap your form fields!  
* [react-native-forms ★78](https://github.com/michaelhelvey/react-native-forms) - A declarative API for creating, validating, and serializing native-looking forms.  
* [foect ★28](https://github.com/unexge/foect) - Simple form validation library for React Native  
* [react-native-fm-form ★13](https://github.com/peter4k/react-native-fm-form) - Generate list view form of React Native in few line of codes  
* [react-native-form-flux ★2](https://github.com/aksonov/react-native-form-flux) - React Native Form management using Flux architecture  

### Geolocation

* [react-native-background-geolocation ★826](https://github.com/transistorsoft/react-native-background-geolocation) - Sophisticated cross-platform background location-tracking & geofencing module with battery-conscious motion-detection intelligence (Android requires paid license).  
* [react-native-mauron85-background-geolocation ★302](https://github.com/mauron85/react-native-background-geolocation) - React Native Android and iOS module for background and foreground geolocation with battery-saving "circular region monitoring" and "stop detection"  
* [react-native-geocoder ★266](https://github.com/devfd/react-native-geocoder) - react native geocoding and reverse geocoding  
* [react-native-geo-fencing ★68](https://github.com/surialabs/react-native-geo-fencing) - Native modules to determine if a location is within defined geographical boundaries using Google Geometry library  
* [react-native-fused-location ★33](https://github.com/MustansirZia/react-native-fused-location) - Finest location for react-native on Android using the new Fused API.  
* [react-native-android-geolocation ★18](https://github.com/garysye/react-native-android-geolocation) - React Native Module to use Android Geolocation via Google Play API  
* [react-native-reverse-geo ★16](https://github.com/aaronksaunders/react-native-reverse-geo) - React Native module bridge to convert address to geo coordinates.  
* [react-native-geolocation-android ★3](https://github.com/lxsameer/react-native-geolocation-android) - Geolocation module for react native android  

### Internationalization

* [react-native-i18n ★1051](https://github.com/AlexanderZaytsev/react-native-i18n) - React Native + i18n.js  
* [react-native-globalize ★134](https://github.com/joshswan/react-native-globalize) - Globalization helper for React Native  
* [react-native-languages ★47](https://github.com/react-community/react-native-languages) - React Native properties and methods related to the language of the device  
* [react-native-intl ★31](https://github.com/taggon/react-native-intl) - React Native module shipped native Intl implementation and Translation extension  
* [redux-react-native-i18n ★23](https://github.com/derzunov/redux-react-native-i18n) - An i18n solution for React Native apps on Redux  
* [rn-translate-template ★15](https://github.com/hiaw/rn-translate-template) - I18n template for all iOS and Android supported languages  

### Build & Development

* [reactotron ★7080](https://github.com/skellock/reactotron) - Control, monitor, and instrument your React Native apps from the comfort of your terminal.  
* [react-native-code-push ★3811](https://github.com/Microsoft/react-native-code-push) - React Native plugin for the CodePush service  
* [react-native-webpack-server ★905](https://github.com/mjohnston/react-native-webpack-server) - Build React Native apps with Webpack  
* [generator-rn-toolbox ★421](https://github.com/bamlab/generator-rn-toolbox) - Yeoman generators to kickstart your project and setup continuous deployment.  
* [babel-preset-react-native-stage-0 ★80](https://github.com/skevy/babel-preset-react-native-stage-0) - a Babel preset with latest Javascript goodies  
* [react-native-debug-stylesheet ★65](https://github.com/brentvatne/react-native-debug-stylesheet) - Add coloured borders or backgrounds to all views to make it easier to debug layout issues  
* [react-native-console-panel ★60](https://github.com/sospartan/react-native-console-panel) - react native component for display console messages.  
* [react-native-css-loader ★35](https://github.com/thewei/react-native-css-loader) - You can use react-native-css-loader with react-native-webpack-server, which can use webpack to built react-native app better.  
* [react-native-assets ★30](https://github.com/llanox/react-native-assests) - Module to manage assets. It allows you download assets from a network and store into a specific local folder on iOS  
* [react-native-cosmos ★16](https://github.com/jerolimov/react-native-cosmos) - DX tool to test react-native components with defined props/state fixtures.  
* [react-native-kill-packager ★9](https://github.com/livioso/react-native-kill-packager) - kill running react native packager.  
* [react-native-build-cli ★3](https://github.com/adonpro/react-native-build-cli) - a cli tool for react-native build  

### Styling

* [styled-components ★11618](https://github.com/styled-components/styled-components) - Style React and React Native with utilising tagged template literals.  
* [react-native-extended-stylesheet ★1042](https://github.com/vitalets/react-native-extended-stylesheet) - Extend React Native stylesheet with variables, relative units, percents, math operations, scaling and other stuff.  
* [react-native-css ★678](https://github.com/sabeurthabti/react-native-css) - Style React-Native components with css and built in support for SASS.  
* [react-native-style-tachyons ★382](https://github.com/tachyons-css/react-native-style-tachyons) - functional, maintainable design for everyone based on tachyons.css.  
* [glamorous-native ★265](https://github.com/robinpowered/glamorous-native) - A React Native version of glamorous - a component styling library.  
* [react-native-responsive ★216](https://github.com/ayoubdev/react-native-responsive) - The power of Media Queries now in your React Native project (ios and android) ! Responsive Design can now be easily managed !  
* [cairn ★108](https://github.com/adamterlson/cairn) - Simple, string-based style selector engine with support for basic inheritance.  
* [react-native-theme ★74](https://github.com/apentle/react-native-theme) - Theme manager for react native project!  
* [rn-less ★11](https://github.com/blackmiaool/rn-less) - Style react-native with less (with VS Code extension support)  

### System

* [react-native-push-notification ★2224](https://github.com/zo0r/react-native-push-notification) - React Native Local and Remote Notifications  
* [react-native-device-info ★1810](https://github.com/rebeccahughes/react-native-device-info) - Get device information using react-native  
* [react-native-firebase ★1685](https://github.com/invertase/react-native-firebase) - A well tested feature rich Firebase implementation for React Native, supporting both iOS & Android platforms for 10+ Firebase modules (including Cloud Firestore).  
* [react-native-fs ★1622](https://github.com/johanneslumpe/react-native-fs) - Native filesystem access for react-native  
* [react-native-fcm ★1052](https://github.com/evollu/react-native-fcm) - react native module for firebase cloud messaging and local notification  
* [react-native-config ★990](https://github.com/luggit/react-native-config) - Config variables for React Native apps  
* [react-native-arkit ★767](https://github.com/HippoAR/react-native-arkit) - React Native binding for iOS ARKit  
* [react-native-notifications ★757](https://github.com/wix/react-native-notifications) - React native notifications  
* [react-native-communications ★651](https://github.com/anarchicknight/react-native-communications) - Easily call, email, text or iMessage someone in React Native  
* [react-native-contacts ★571](https://github.com/rt2zz/react-native-contacts) - React Native Contacts (android & ios)  
* [react-native-onesignal ★556](https://github.com/geektimecoil/react-native-onesignal) - React Native Library for OneSignal Push Notifications Service (iOS + Android)  
* [react-native-touch-id ★522](https://github.com/naoufal/react-native-touch-id) - React Native authentication with the native Touch ID popup.  
* [react-native-permissions ★518](https://github.com/yonahforst/react-native-permissions) - Check and request all permissions with a single api  
* [react-native-keychain ★517](https://github.com/oblador/react-native-keychain) - Keychain Access for React Native  
* [react-native-in-app-utils ★508](https://github.com/chirag04/react-native-in-app-utils) - A react-native wrapper for handling in-app payments.  
* [react-native-quick-actions ★481](https://github.com/madriska/react-native-quick-actions) - A react-native interface for 3D Touch home screen quick actions  
* [react-native-barcodescanner ★420](https://github.com/ideacreation/react-native-barcodescanner) - A barcode scanner component for react native - not maintained anymore - use react-native-camera.  
* [react-native-image-resizer ★411](https://github.com/bamlab/react-native-image-resizer) - Rescale local image files with React Native.  
* [react-native-location ★356](https://github.com/timfpark/react-native-location) - Native GPS location support for React Native.  
* [react-native-billing ★351](https://github.com/idehub/react-native-billing) - In-app purchase implementation for React Native on Android.  
* [react-native-ibeacon ★294](https://github.com/geniuxconsulting/react-native-ibeacon) - iBeacon support for React Native. The API is very similar to the CoreLocation Objective-C one with the only major difference that regions are plain JavaScript objects. Beacons don't work in the iOS simulator.  
* [react-native-lock-ios ★289](https://github.com/auth0/react-native-lock-ios) - Auth0 Lock for React Native (iOS)  
* [react-native-social-share ★281](https://github.com/doefler/react-native-social-share) - Use the iOS native Twitter and Facebook share view from react native  
* [react-native-dotenv ★209](https://github.com/zetachang/react-native-dotenv) - A Babel preset let you import application configs from .env file (zero runtime dependency)  
* [react-native-motion-manager ★194](https://github.com/pwmckenna/react-native-motion-manager) - A react-native interface for using the Gyroscope, Accelerometer and Magnetometer  
* [react-native-device ★181](https://github.com/GertjanReynaert/react-native-device) - UIDevice wrapper for React Native  
* [react-native-background-fetch ★177](https://github.com/transistorsoft/react-native-background-fetch) - iOS BackgroundFetch API implementation. Awakens a suspended iOS app in the background to execute a `callbackFn` about every 15 min.  
* [react-native-gcm-android ★168](https://github.com/oney/react-native-gcm-android) - GCM for Android  
* [react-native-ble ★143](https://github.com/jacobrosenthal/react-native-ble) - React Native BLE using noble api surface  
* [react-native-sensor-manager ★133](https://github.com/kprimice/react-native-sensor-manager) - Wrapper for react-native providing native sensors access. (Gyroscope, accelerometer, magnetometer, thermometer...)  
* [react-native-android-sms-listener ★123](https://github.com/CentaurWarchief/react-native-android-sms-listener) - Allows you to listen for incoming SMS messages  
* [react-native-unified-contacts ★94](https://github.com/joshuapinter/react-native-unified-contacts) - React Native iOS 9+ Contacts (ios)  
* [react-native-addressbook ★78](https://github.com/rt2zz/react-native-addressbook) - AddressBook module for react-native  
* [react-native-fingerprint-identify ★69](https://github.com/williamtran29/react-native-fingerprint-identify) - React Native authentication with the Fingerprint on Android, fingerprint API compatible lib, which also combines Samsung, Xiaomi and MeiZu's official Fingerprint API.  
* [react-native-pinch ★69](https://github.com/localz/react-native-pinch) - SSL pinning for react native  
* [react-native-passcode-auth ★62](https://github.com/naoufal/react-native-passcode-auth) - React Native authentication with iOS Passcode.  
* [react-native-calendar-reminders ★57](https://github.com/wmcmahan/React-Native-CalendarReminders) - React Native module for IOS EventKit Reminders  
* [react-native-haptic ★56](https://github.com/charlesvinette/react-native-haptic) - iOS 10 + haptic feedback for React Native applications  
* [react-native-barcode-scanner ★55](https://github.com/lifuzu/ReactNativeBarcodeScanner) - Barcode scanner for React Native  
* [react-native-discovery ★54](https://github.com/yonahforst/react-native-discovery) - Discover nearby devics using BLE. Turn iOS and Android devices into beacons  
* [react-native-bluetooth-state ★54](https://github.com/frostney/react-native-bluetooth-state) - Answering the question of "Is my bluetooth on?" in React Native  
* [react-native-clipboard ★53](https://github.com/silentcloud/react-native-clipboard) - React Native component for getting or setting clipboard content  
* [react-native-callkit ★49](https://github.com/ianlin/react-native-callkit) - iOS 10 CallKit framework for React Native  
* [react-native-android-speech ★44](https://github.com/mihirsoni/react-native-android-speech) - A text-to-speech library for Android React Native.  
* [react-native-android-sms ★42](https://github.com/msmakhlouf/react-native-android-sms) - A react native android module to list/send sms.  
* [react-native-queue ★41](https://github.com/billmalarky/react-native-queue) - A React Native Job Queue  
* [react-native-app-info ★37](https://github.com/Iragne/react-native-app-info) - React Native app info and version  
* [react-native-icloud-sync ★33](https://github.com/chirag04/react-native-icloud-sync) - A react-native wrapper for syncing with icloud  
* [react-native-nfc-ios ★33](https://github.com/barodeur/react-native-nfc-ios) - Easy to use CoreNFC for React Native  
* [react-native-android-sqlite ★27](https://github.com/jbrodriguez/react-native-android-sqlite) - A react native android wrapper for SQLite  
* [react-native-sms-android ★26](https://github.com/rhaker/react-native-sms-android) - A react-native module for sending a sms message to a phone number.  
* [react-native-voip-push-notification ★26](https://github.com/ianlin/react-native-voip-push-notification) - iOS prioritized VoIP Push Notification  
* [react-native-device-motion ★26](https://github.com/paramaggarwal/react-native-device-motion) - iOS device motion wrapper for React Native.  
* [react-native-carrier-info ★22](https://github.com/anarchicknight/react-native-carrier-info) - React Native module bridge to obtain information about the user’s home cellular service provider.  
* [react-native-phone-call ★22](https://github.com/tiaanduplessis/react-native-phone-call) - A simple way to initiate a phone call in React Native  
* [react-native-touch-id-android ★22](https://github.com/ElekenAgency/react-native-touch-id-android) - React Native authentication with the Fingerprint on Android.  
* [react-native-wifi-manager ★22](https://github.com/skierkowski/react-native-wifi-manager) - Wifi Connection Manager for React Native on Android  
* [react-native-search-api ★21](https://github.com/ombori/react-native-search-api) - The SearchApi module gives you a general React Native interface to interact with the iOS Search API, Core Spotlight.  
* [react-native-heading ★21](https://github.com/yonahforst/react-native-heading) - Get device heading (compass) information on iOS or Android  
* [react-native-battery ★17](https://github.com/oojr/react-native-battery) - A React Native module that returns the battery level/status of a device
* [react-native-device-battery ★17](https://github.com/robinpowered/react-native-device-battery) - Observe battery state changes in your react native application  
* [react-native-localsearch ★14](https://github.com/wmcmahan/React-Native-LocalSearch) - React Native Module for MapKit Local Search  
* [react-native-contacts-rx ★12](https://github.com/JeanLebrument/react-native-contacts-rx) - react-native-contacts counterpart that include the support of RxJS.  
* [react-native-mipush ★11](https://github.com/cpunion/react-native-mipush) - MiPush for React Native  
* [react-native-detect-device ★11](https://github.com/peachmeco/react-native-detect-device) - Detect a device on iOS or android in react-native.  
* [react-native-haptic-feedback ★10](https://github.com/mkuczera/react-native-haptic-feedback) - Trigger Haptic Native Feedback on iOS and Android 
* [react-native-device-angles ★9](https://github.com/cristianszwarc/RNDeviceAngles) - Get rotation information in degrees (pitch, yaw, roll) - ios  
* [react-native-lock-android ★7](https://github.com/auth0/react-native-lock-android) - Auth0 Lock for React Native (Android)  
* [react-native-system-notification ★6](https://github.com/Neson/react-native-system-notification) - Notification for React Native  
* [react-native-battery-status ★6](https://github.com/remobile/react-native-battery-status) - A battery-status for react-native  
* [react-native-push-with-gcm ★5](https://github.com/lilach/react-native-push-with-gcm) - Register device for GCM push notifications services (supported only for iOS)  
* [react-native-device-info-pod ★2](https://github.com/mchinyakov/react-native-device-info) - Get device information using react-native  

### Web

* [react-native-webrtc ★1193](https://github.com/oney/react-native-webrtc) - A WebRTC module for React Native.  
* [react-native-webview-bridge ★918](https://github.com/alinz/react-native-webview-bridge) - React Native WebView Javascript Bridge  
* [react-native-safari-view ★289](https://github.com/naoufal/react-native-safari-view) - A React Native wrapper for Safari View Controller  
* [react-native-for-web ★234](https://github.com/KodersLab/react-native-for-web) - A set of classes and react components to make work your react-native app in a browser. (with some limitations obviously)  
* [react-native-webview-android ★209](https://github.com/lucasferreira/react-native-webview-android) - Simple React Native Android module to use Android's WebView inside your app  
* [react-native-browser ★78](https://github.com/PrestoDoctor/react-native-browser) - Full-featured web browser module for React Native apps, based on TOWebViewController  
* [react-native-webview-crosswalk ★71](https://github.com/jordansexton/react-native-webview-crosswalk) - Crosswalk's WebView for React Native on Android  
* [react-native-webintent ★51](https://github.com/ivanph/react-native-webintent) - React native android module to open links in the default browser  
* [react-native-web-container ★28](https://github.com/danrigsby/react-native-web-container) - A wrapper around the react native WebView to add autoHeight, scrub html, etc  
* [react-native-browser-polyfill ★24](https://github.com/johanneslumpe/react-native-browser-polyfill) - A collection of polyfills for the react-native Javascript environment.  
* [react-native-web-polyfill ★23](https://github.com/mattiamanzati/react-native-web-polyfill) - A set of classes and react components to make work your react-native app in a browser. (with some limitations obviously)  
* [react-native-inapp-browser ★17](https://github.com/DickyT/react-native-inapp-browser) - A in-app browser for react native apps.  
* [react-native-bridgeable-webview ★14](https://github.com/Intellicode/react-native-bridgeable-webview) - A react-native webview with bridge to react-native code  
* [react-native-cookiemanager ★12](https://github.com/beefe/react-native-cookiemanager) - react-native cookie manager library.  
* [react-native-html2native ★3](https://github.com/labithiotis/react-native-html-render) - A html render for react-native  
* [react-native-webview ★2](https://github.com/beefe/react-native-webview) - android webview for react-native  
* [react-native-h5 ★0](https://github.com/dingui/react-native-h5) - react native web  

### Media

* [react-native-camera ★4230](https://github.com/lwansbrough/react-native-camera) - Camera component  
* [react-native-video ★2379](https://github.com/brentvatne/react-native-video) - A Video component for react-native  
* [react-native-sound ★957](https://github.com/zmxv/react-native-sound) - React Native module for playing sound clips  
* [react-native-audio-streaming ★531](https://github.com/tlenclos/react-native-audio-streaming) - iOS & Android module to play an audio stream, with background support and media controls :speaker:  
* [react-native-audio ★530](https://github.com/jsierles/react-native-audio) - Record and play back audio in your iOS or Android React Native apps.  
* [react-native-camera-kit ★360](https://github.com/wix/react-native-camera-kit) - Advanced native camera and gallery components and device photos API.  
* [react-native-video-processing ★309](https://github.com/shahen94/react-native-video-processing) - Native Video editing/trimming/filtering library for React-Native  
* [react-native-camera-roll-picker ★227](https://github.com/jeanpan/react-native-camera-roll-picker) - A React Native component providing images selection from camera roll  
* [react-native-screcorder ★198](https://github.com/maxs15/react-native-screcorder) - Capture pictures and record Video with Vine-like tap to record  
* [react-native-speech ★188](https://github.com/naoufal/react-native-speech) - A text-to-speech library for React Native.  
* [react-native-incall-manager ★174](https://github.com/zxcpoiu/react-native-incall-manager) - Handling media-routes/sensors/events during a audio/video chat like webrtc  
* [react-native-audioplayer ★94](https://github.com/andreaskeller/react-native-audioplayer) - Small audio player library for react native  
* [react-native-photos-framework ★92](https://github.com/olofd/react-native-photos-framework) - A modern and comprehensive CameraRoll/iCloud-library for React Native  
* [react-native-player ★73](https://github.com/xeodou/react-native-player) - Media player for react-native  
* [react-native-track-player ★59](https://github.com/react-native-kit/react-native-track-player) - A fully fledged audio module created for music apps. Provides audio playback, external media controls, chromecast support and background mode for Android, iOS and Windows.  
* [react-native-vlc-player ★56](https://github.com/ghondar/react-native-vlc-player) - VLC Player for react-native  
* [react-native-volume-slider ★46](https://github.com/IFours/react-native-volume-slider) - React Native VolumeView component  
* [react-native-color-grabber ★40](https://github.com/bsudekum/react-native-color-grabber) - React native component for finding dominant colors in an image  
* [react-native-sound-demo ★31](https://github.com/zmxv/react-native-sound-demo) - react-native-sound demo project  
* [react-native-android-audio-streaming-aac ★22](https://github.com/EstebanFuentealba/react-native-android-audio-streaming-aac) - A react native streaming player  
* [react-native-fullscreen-video ★17](https://github.com/mostafa/react-native-fullscreen-video) - A full-screen video component on top of react-native-video  
* [react-native-media-meta ★15](https://github.com/mybigday/react-native-media-meta) - Get media file metadata in your React Native app  
* [react-native-audio-manager ★14](https://github.com/Tricy/react-native-audio-manager) - Audio player library for react native Android  
* [react-native-audio-player ★11](https://github.com/sh3rawi/react-native-audio-player) - A React Native module to play audio on Android  
* [react-native-simple-sound ★10](https://github.com/mikehedman/react-native-simple-sound) - Start, stop, and pause a sound. iOS only. Derived from https://github.com/zmxv/react-native-sound  
* [react-native-sound-recorder ★9](https://github.com/kevinresol/react-native-sound-recorder) - No-hassle Sound Recorder for React Native.  
* [react-native-mediaplayer ★9](https://github.com/chriselly/react-native-mediaplayer) - Simple full screen media player for React Native.  
* [react-native-interactive-image-gallery ★6](https://github.com/InterfaceKit/react-native-interactive-image-gallery) - A React Native component to display a gallery of images.  
* [react-native-media-capture ★5](https://github.com/remobile/react-native-media-capture) - A media-capture for react-native  
* [react-native-hue-player](https://github.com/App2Sales/react-native-hue-player) - Audio Player to offline/local and online/streaming audio.  

### Storage

* [realm ★2480](https://github.com/realm/realm-js) - An alternative mobile database to SQLite & key-value stores.  
* [react-native-storage ★1427](https://github.com/sunnylqm/react-native-storage) - This is a local storage wrapper for both react-native(AsyncStorage) and browser(localStorage). ES6/babel is needed.  
* [react-native-sqlite-storage ★1054](https://github.com/andpor/react-native-sqlite-storage) - SQLite3 bindings for React Native (Android & iOS)  
* [react-native-simple-store ★536](https://github.com/jasonmerino/react-native-simple-store) - A minimalistic wrapper around React Native's AsyncStorage.  
* [react-native-store ★525](https://github.com/thewei/react-native-store) - A simple database base on react-native AsyncStorage.  
* [react-native-sqlite ★523](https://github.com/almost/react-native-sqlite) - SQLite3 bindings for React Native  
* [react-native-db-models ★158](https://github.com/darkrishabh/react-native-db-models) - Local DB Models for React Native Apps  
* [react-native-couchbase-lite ★91](https://github.com/fraserxu/react-native-couchbase-lite) - couchbase lite binding for react-native  
* [react-native-persistent-job ★57](https://github.com/Gabrn/react-native-persistent-job) - Run async tasks that retry after a crash, connection loss or exception  
* [react-native-sqlite-2 ★46](https://github.com/noradaiko/react-native-sqlite-2) - SQLite3 Native Plugin for React Native for both Android and iOS  
* [react-native-pouchdb ★35](https://github.com/carbureted/react-native-pouchdb) - Run pouchdb in React Native!  
* [pouchdb-adapter-react-native-sqlite ★29](https://github.com/noradaiko/pouchdb-adapter-react-native-sqlite) - PouchDB adapter using ReactNative SQLite as its backing store  
* [react-native-level-fs ★16](https://github.com/tradle/react-native-level-fs) - fs for react-native using level-filesystem and asyncstorage-down  
* [react-native-mongoose ★14](https://github.com/remobile/react-native-mongoose) - A AsyncStorage based mongoose like storage for react-native  

### Backend

* [react-native-fetch-blob ★1702](https://github.com/wkh237/react-native-fetch-blob) - A module integrates network and file system. Supports file stream.  
* [react-native-meteor ★600](https://github.com/inProgress-team/react-native-meteor) - Full Meteor Client  
* [aws-sdk-react-native ★579](https://github.com/awslabs/aws-sdk-react-native) - AWS SDK for React Native (Official developer preview)  
* [react-native-simple-auth ★469](https://github.com/adamjmcgrath/react-native-simple-auth) - Native social authentication for React Native on iOS  
* [react-native-uploader ★357](https://github.com/aroth/react-native-uploader) - A React Native module to upload files and camera roll assets. Supports progress notification.  
* [react-native-lazyload ★263](https://github.com/magicismight/react-native-lazyload) - lazyload for react native  
* [react-native-aws3 ★199](https://github.com/benjreinhart/react-native-aws3) - Pure JavaScript React Native library for uploading to AWS S3  
* [react-native-xmpp ★177](https://github.com/aksonov/react-native-xmpp) - XMPP Library for React Native  
* [react-native-tcp ★132](https://github.com/PeelTechnologies/react-native-tcp) - node's net API for react-native  
* [react-native-udp ★109](https://github.com/tradle/react-native-udp) - node's dgram API for react-native  
* [react-native-swift-socketio ★103](https://github.com/kirkness/react-native-swift-socketio) - A react native wrapper for socket.io-client-swift  
* [feathers-client ★102](https://github.com/feathersjs/feathers-client) - Feathers client that works with React Native, NodeJS and any client framework.  
* [react-native-multipeer ★95](https://github.com/lwansbrough/react-native-multipeer) - Communicate over ad hoc wifi using Multipeer Connectivity  
* [react-native-networking ★93](https://github.com/eduedix/react-native-networking) - react-native module to download and upload files with AFNetworking  
* [react-native-aws-cognito-js ★90](https://github.com/AirLabsTeam/react-native-aws-cognito-js) - An adaptation of Amazon Cognito Identity SDK for JavaScript in combination with AWS SDK for JavaScript for React Native.  
* [react-native-file-upload ★89](https://github.com/booxood/react-native-file-upload) - A file upload plugin for react-native  
* [react-native-s3 ★70](https://github.com/mybigday/react-native-s3) - A React Native wrapper for AWS iOS/Android S3 SDK (TransferUtility)  
* [react-native-rest-kit ★62](https://github.com/peter4k/react-native-rest-kit) - A React Native RESTful API kit that use the fetch method  
* [react-native-cognito ★58](https://github.com/morcmarc/react-native-cognito) - AWS Cognito-based authentication module for React Native.  
* [react-native-file-download ★41](https://github.com/plrthink/react-native-file-download) - A simple file download module for react-native  
* [react-native-jwt ★25](https://github.com/StanScates/react-native-jwt) - React native compatible JSON web token utility  
* [react-native-ssdp ★15](https://github.com/netbeast/react-native-ssdp) - A React Native fork of the SSDP protocol to discover plug and play devices.  
* [react-native-http ★11](https://github.com/iktw/react-native-jwt) - React native http  
* [react-native-async-http ★3](https://github.com/szq4119/react-native-async-http) - React Native component for async-http  
* [react-native-nchan ★1](https://github.com/indatawetrust/react-native-nchan) - Nchan (pub/sub server) module for React Native  

### Integrations

* [react-native-wechat ★1380](https://github.com/weflex/react-native-wechat) - react-native library for wechat app  
* [react-native-facebook-login ★965](https://github.com/magus/react-native-facebook-login) - React Native wrapper for native iOS Facebook SDK login button and manager  
* [react-native-google-signin ★677](https://github.com/apptailor/react-native-google-signin) - Google Signin for your react native applications  
* [react-native-google-places-autocomplete ★563](https://github.com/FaridSafi/react-native-google-places-autocomplete) - Customizable Google Places autocomplete component for iOS and Android React-Native apps  
* [react-instantsearch ★296](https://github.com/algolia/react-instantsearch) - Lightning-fast search for React and React Native apps, by Algolia  
* [react-native-qq ★230](https://github.com/reactnativecn/react-native-qq) - QQ Login&Share support in React Native.  
* [react-native-awesome-card-io ★204](https://github.com/Kerumen/react-native-awesome-card-io) - A complete and cross-platform card.io component for React Native (iOS and Android)  
* [react-native-wechat-ios ★191](https://github.com/beefe/react-native-wechat-ios) - Wechat SDK for React Native(iOS).  
* [react-native-card-io ★151](https://github.com/kayla-tech/react-native-card-io) - React Native component for card.io  
* [react-native-facebook-account-kit ★143](https://github.com/underscopeio/react-native-facebook-account-kit) - A Facebook Account Kit SDK wrapper for React Native.  
* [react-native-fabric-digits ★113](https://github.com/JeanLebrument/react-native-fabric-digits) Fabric Digits wrapper for React-Native  
* [react-native-voximplant ★92](https://github.com/voximplant/react-native-voximplant) - VoxImplant Mobile SDK for embedding voice and video communication into React Native apps.  
* [react-native-braintree ★85](https://github.com/alawong/react-native-braintree) - A react native interface for integrating payments using Braintree's v.zero SDK (currently iOS only)  
* [react-native-signalr ★76](https://github.com/olofd/react-native-signalr) - SignalR-client for react-native  
* [react-native-android-vitamio ★69](https://github.com/sejoker/react-native-android-vitamio) - React-native component for android Vitamio video player  
* [react-native-twilio ★69](https://github.com/rogchap/react-native-twilio) - A React Native wrapper for the Twilio Client SDK.  
* [react-native-qqsdk ★60](https://github.com/iVanPan/react-native-qqsdk) - A React Native wrapper around the Tencent QQ SDK for Android and iOS. Provides access to QQ ssoLogin, QQ Sharing, QQ Zone Sharing etc.  
* [react-native-digits ★58](https://github.com/fixt/react-native-digits) - Digits wrapper to use in React Native  
* [react-native-braintree-xplat ★52](https://github.com/kraffslol/react-native-braintree-xplat) - Cross-platform Braintree v.zero module.  
* [react-native-realtimemessaging-android ★50](https://github.com/realtime-framework/RCTRealtimeMessagingAndroid) - The Realtime Framework Cloud Messaging Pub/Sub client for React-Native Android  
* [react-native-instagram-oauth ★50](https://github.com/watzak/react-native-instagram-oauth) - react-native instagram login  
* [instabug-reactnative ★47](https://github.com/Instabug/instabug-reactnative) - A React Native wrapper for Bug reporting Instabug SDK.  
* [react-native-linkedin-login ★47](https://github.com/jodybrewster/react-native-linkedin-login) - Linkedin Login for your react native applications  
* [react-native-twilio-programmable-voice ★41](https://github.com/hoxfon/react-native-twilio-programmable-voice) - A React Native wrapper for the Twilio Programmable Voice SDK.  
* [react-native-onepassword ★39](https://github.com/DriveWealth/react-native-onepassword) - React Native integration with the OnePassword extension.  
* [react-native-new-relic ★37](https://github.com/wix/react-native-newrelic) - New Relic event reporting for react-native.  
* [react-native-level ★36](https://github.com/tradle/react-native-level) - levelup API for react-native AsyncStorage.  
* [react-native-dialogflow ★34](https://github.com/innFactory/react-native-dialogflow) - A React-Native bridge for Google's Dialogflow (api.ai)  
* [react-native-instagram-share ★22](https://github.com/watzak/react-native-instagram-share) - A react-native interface to share images and videos within instagram (iOS)  
* [react-native-braintree-android ★20](https://github.com/surialabs/react-native-braintree-android) - Braintree's native Drop-in Payment UI for Android  
* [react-native-amap ★16](https://github.com/laoqiu/react-native-amap) - A React Native component for building maps with the AMap Android SDK  
* [react-native-realtime-pusher ★14](https://github.com/gijoehosaphat/react-native-realtime-pusher) - React Native module implementing the Pusher Realtime API  
* [react-native-woopra ★11](https://github.com/isair/react-native-woopra) - Promise based Woopra library for react-native  
* [react-native-sinch-verification ★10](https://github.com/kevinresol/react-native-sinch-verification) - Sinch verification for react native  
* [react-native-leancloud ★9](https://github.com/turingou/react-native-leancloud) - a react native LeanCloud component  
* [react-native-testfairy ★9](https://github.com/testfairy/react-native-testfairy) - TestFairy for React Native  
* [react-native-flurry ★8](https://github.com/amitkothari/react-native-flurry) - React Native wrapper for Flurry  
* [react-native-realtimemessaging-ios ★7](https://github.com/realtime-framework/RCTRealtimeMessaging) - The Realtime Framework Cloud Messaging Pub/Sub client for React-Native  
* [react-native-realtimestorage-ios ★7](https://github.com/realtime-framework/RCTRealtimeCloudStorage) - The Realtime Framework Cloud Storage client for React-Native  
* [react-native-conekta ★6](https://github.com/zo0r/react-native-conekta) - Conekta SDK for React Native  
* [react-native-axmall-alipay ★5](https://github.com/szq4119/react-native-alipay) - react-native alipay  
* [react-native-youtube-oauth ★4](https://github.com/indatawetrust/react-native-youtube-oauth) - react-native interface to login to youtube (iOS)  
* [react-native-hawk ★4](https://github.com/andyscott/react-native-hawk) - Hawk wrapper for react-native  
* [react-native-realtimestorage-android ★4](https://github.com/realtime-framework/RCTRealtimeStorageAndroid) - The Realtime Cloud Storage client for React-Native Android  
* [react-native-sumup ★4](https://github.com/APSL/react-native-sumup) - A React Native implementation of SumupSDK.  
* [react-native-fbintent ★3](https://github.com/syarul/react-native-fbintent) - A React Native intent for Android Facebook App  
* [react-native-instagram ★2](https://github.com/watzak/react-native-instagram) - react-native instagram wrapper api (iOS)  
* [react-native-heyzap](https://github.com/react-native-contrib/react-native-heyzap)- Heyzap plugin for React Native  

### Monetization

* [react-native-admob ★457](https://github.com/sbugert/react-native-admob) - A react-native component for Google AdMob banners.  
* [react-native-stripe-api ★94](https://github.com/xcarpentier/react-native-stripe-api) - A small React Native library for Stripe Rest API  
* [react-native-revmob ★10](https://github.com/RevMob/react-native-revmob) - RevMob wrapper for React Native.  

### Animation

* [react-native-interactable ★3016](https://github.com/wix/react-native-interactable) - experimental implementation of high performance interactable views in React Native  
* [react-native-gl-model-view ★149](https://github.com/rastapasta/react-native-gl-model-view) - Display and animate textured Wavefront .OBJ 3D models with 60fps (iOS)  
* [react-native-spruce ★88](https://github.com/prscX/react-native-spruce) - React Native Bridge for Spruce Animation Library  
* [react-native-animated-sprite ★54](https://github.com/micahrye/react-native-animated-sprite) - A feature rich declarative component for animation, tweening, and dragging sprites.  

### Other Platforms

* [react-native-desktop ★9725](https://github.com/ptmt/react-native-desktop) - React Native for OS X  
* [react-native-web ★6831](https://github.com/necolas/react-native-web) - React Native for Web  
* [reactxp ★5553](https://github.com/Microsoft/reactxp) - Library for cross-platform app development  
* [react-native-windows ★3169](https://github.com/ReactWindows/react-native-windows) - React Native for Universal Windows Platform  
* [react-native-tvos-controller ★9](https://github.com/ycinfinity/react-native-tvos-controller) - TvOS remote controller module for react native.  
* [react-native-watchkit ★0](https://github.com/MystK/react-native-watchkit) - react native for WatchKit  

## Utilities

Useful React Native tooling.

* [rnpm ★2256](https://github.com/rnpm/rnpm) - react native package manager  
* [react-native-debugger ★1908](https://github.com/jhen0409/react-native-debugger) - The standalone app for React Native Debugger, with React DevTools / Redux DevTools  
* [haul ★1905](https://github.com/callstack-io/haul) - command line tool for developing React Native apps  
* [generact ★718](https://github.com/diegohaz/generact) - CLI that generates components based on existing ones no matter how you structure your app  
* [react-native-rename ★468](https://github.com/junedomingo/react-native-rename) - Rename react-native app with just one command  
* [Ruby React Native (via Opal) ★389](https://github.com/zetachang/opal-native) - Use Ruby for building React Native apps  
* [Electrode Native ★235](https://github.com/electrode-io/electrode-native) - A platform to ease the integration of React Native components in existing mobile applications.  
* [react-native-snippets ★225](https://github.com/Shrugs/react-native-snippets) - A collection of Sublime Text Snippets for react-native  
* [rn-nodeify ★189](https://github.com/mvayngrib/rn-nodeify) - hack to allow react-native projects to use node core modules  
* [rn-snoopy ★189](https://github.com/jondot/rn-snoopy) - Profiling, monitoring and alerting over the React Native bridge. [More here](https://medium.com/@jondot/debugging-react-native-performance-snoopy-and-the-messagequeue-fe014cd047ac).
* [react-native-exception-handler ★185](https://github.com/master-atul/react-native-exception-handler) – Avoid silent crash and errors on the production build of your app  
* [react-native-bundle-visualizer ★90](https://github.com/IjzerenHein/react-native-bundle-visualizer) - See what's inside your RN bundle; useful for optimizing the bundle size  
* [Makeicon ★40](https://github.com/beplus/makeicon) - Generates mobile app icons in all resolutions for both iOS and Android  
* [React Native Actions ★37](https://github.com/lucasbento/react-native-actions) - Run React Native actions from within VSCode.  
* [rsx ★29](https://github.com/react-native-contrib/rsx) - An alternative to the `react-native` CLI tool  
* [AsyncStorage Dev Menu Item ★15](https://github.com/jsoendermann/react-native-async-storage-dev-menu-item) - Adds an option to your dev menu to log the content of your AsyncStorage.  
* [ADB Auto Restarter ★5](https://github.com/mahanhaz/adb-auto-restarter) - Restart ADB service Automatically in case of crashing while debugging app with device .  
* [BuilderX](https://builderx.io/) - A design tool which writes React Native code for you , Desktop Mac app to replace your traditional UX design tools.  
* [CodePush](http://microsoft.github.io/code-push/) - Push code updates to your apps, instantly  
* [Storybook](https://storybook.js.org) - UI development environment for your React components  
* [AppHub](https://apphub.io/) - Update React Native apps, instantly  
* [BugSnag](https://www.bugsnag.com/platforms/react-native-error-reporting/) - A tool that logs native & JS errors. Has a free tier. Includes useful data about the user, environment, session, release, etc.  
* [React Native Playground](https://rnplay.org/) - Run React Native apps in your browser via real time simulator  
* [exponent](https://expo.io/) - Use React Native without XCode (a previewer app + local server infrastructure)  
* [Deco IDE](https://www.decosoftware.com/) - React Native IDE with components manager  

## Seeds

Get a head start on development with an existing seed.

* [🔥 Ignite ★6704](https://github.com/infinitered/ignite) - An unfair start for React Native - Generator CLI for redux/sagas and more.  
* [Pepperoni ★3950](https://github.com/futurice/pepperoni-app-kit) - Starter kit for Android & iOS, Redux, Immutable.js, disk-persisted app state  
* [Snowflake ★3829](https://github.com/bartonhammond/snowflake) - Android & iOS, Redux, Jest (88% coverage), Immutable, Parse.com  
* [native-starter-kit ★1294](https://github.com/start-react/native-starter-kit) - A Starter Kit for React Native + NativeBase + React Navigation + Redux + CodePush Apps (iOS & Android)  
* [react-native-webpack-starter-kit ★878](https://github.com/jhabdas/react-native-webpack-starter-kit)  
* [React Native Meteor Boilerplate ★540](https://github.com/spencercarli/react-native-meteor-boilerplate)  
* [React Native Hackathon Starter ★352](https://github.com/dabit3/react-native-hackathon-starter) - React Native Starter Project, great for hackathons or rapid prototyping. Includes tabs, navigation, Redux, React Native Vector Icons, & React Native Elements  
* [ReactNativeTS ★337](https://github.com/mrpatiwi/ReactNativeTS) - Boilerplate of a React Native project in Typescript.  
* [React Native Seed ★286](https://github.com/GeekyAnts/react-native-seed) - A set of React Native Boilerplates to choose from. MobX or Redux for state-management, TypeScript or Flow for static type checking and CRNA or plain React Native for the stack - By the creators of Native Base.  
* [react-native-babel ★239](https://github.com/roman01la/react-native-babel)  
* [react-native-es6-reflux ★145](https://github.com/filp/react-native-es6-reflux)  
* [react-native-hot-redux-starter ★136](https://github.com/adampash/react-native-hot-redux-starter)  
* [react-native-redux ★126](https://github.com/sibelius/react-native-redux) - React Native + Redux + Redux Saga  
* [Rhinos-app ★72](https://github.com/rhinos-app/rhinos-app-dev) - Cross-platform React Native boilerplate (iOS, Android, Web) built on react-native-web.  
* [react-native-web-boilerplate ★46](https://github.com/agrcrobles/react-native-web-boilerplate) - A react-native-web stateless hmr boilerplate  
* [🍞 Baker ★46](http://baker.thebakery.io/) - An opinionated MVP toolkit that helps you build mobile apps crazy fast using React Native and Parse Server  
* [React-Native-Starter-Pack ★39](https://github.com/iSimar/React-Native-Starter-Pack) - React Native 0.34 + React-Redux (w/ Redux-Storage) + Native Base + Code Push  
* [react-native-boilerplate ★39](https://github.com/pcofilada/react-native-boilerplate) - Simple boilerplate for mobile development using React Native and Redux  
* [react-native-relay-example ★33](https://github.com/sibelius/react-native-relay-example) - React Native working with Relay  
* [react-native-web-workspace ★30](https://github.com/agrcrobles/react-native-web-workspace) - A cross platform app with react in a monorepo  
* [react-native-tabbed ★23](https://github.com/rxb/react-native-tabbed)  
* [MeteorNative Boilerplate ★22](https://github.com/redbaron76/MeteorNative) - a React Native and Meteor boilerplate with Redux.  
* [rn-mobx-template ★16](https://github.com/hiaw/rn_mobx_template) - React Native with MobX template  
* [react-native-boilerplate-chucknorris ★13](https://github.com/Ali-Ayyad/react-native-boilerplate-chucknorris) - A boilerplate for React Native + React Navigation + React Native Elements (iOS & Android)  
* [rn-relay-drawer-template ★4](https://github.com/hiaw/rn-relay-drawer-template) - React Native working with RNRF, drawer and relay  
* [react-native-template-super ★2](https://github.com/lohanitech/react-native-template-super) - A turbo starter template for react-native + React Navigation + Redux + Redux Persist  

## Libraries

Libraries / SDK type additions for React Native development.

* [React Native Elements ★8157](https://github.com/dabit3/React-Native-Elements) - a collection of React Native UI Elements and components.  
* [Shoutem UI ★2880](https://github.com/shoutem/ui) - a complete UI toolkit for React Native from Shoutem  
* [Panza ★208](https://github.com/bmcmahen/panza) - a collection of stateless, functional, cross-platform ui components for react-native  
* [BlankApp UI ★30](https://github.com/blankapp/ui) - Highly customizable and theming components for React Native  

## Open Source Apps

Open source React Native apps and other examples.

* [react-native-nw-react-calculator ★4076](https://github.com/benoitvallon/react-native-nw-react-calculator) - A mobile, desktop and website App with the same code  
* [30-days-of-react-native ★3787](https://github.com/fangwei716/30-days-of-react-native) - 30 days of React Native examples (inspired by 30DaysofSwift)  
* [Hacker News (iOS & Android) ★3221](https://github.com/iSimar/HackerNews-React-Native)  
* [GitPoint ★2875](https://github.com/gitpoint/git-point) - A mobile GitHub client for both iOS and Android.  
* [reading ★2335](https://github.com/attentiveness/reading) - Reading App Write In React-Native.  
* [GitHub Popular ★1824](https://github.com/crazycodeboy/GitHubPopular) - This is a GitHub most popular repositories viewer with React Native.  
* [Dribbble React Native ★1775](https://github.com/catalinmiron/react-native-dribbble-app)  
* [react-native-gitfeed ★1632](https://github.com/xiekw2010/react-native-gitfeed) - Yet another Github client written with react-native(iOS & android)  
* [Finance React Native ★1348](https://github.com/7kfpun/FinanceReactNative) - iOS's stocks app clone written in React Native for demo purpose.  
* [TaskRabbit's Sample App ★670](https://github.com/taskrabbit/ReactNativeSampleApp) - a testing ground for Task Rabbit's app making  
* [React Weather ★528](https://github.com/stage88/react-weather) - A simple weather app built with React Native  
* [react-native-sudoku ★482](https://github.com/nihgwu/react-native-sudoku) - a sudoku game written in React Native  
* [react-native-hiapp ★416](https://github.com/BelinChung/react-native-hiapp) - A simple and Twitter like demo app written in react-native  
* [An example React Native project for client login authentication ★346](https://github.com/ryanmcdermott/react-native-login)  
* [what the thing? ★344](https://github.com/vigzmv/what_the_thing) - Point camera at things to learn how to say them in a different language.  
* [react-native-basketball ★343](https://github.com/FaridSafi/react-native-basketball) - a clone of the Facebook Basketball game  
* [ReactNativeRedditReader ★323](https://github.com/akveo/react-native-reddit-reader)  
* [Assemblies ★284](https://github.com/buildreactnative/assemblies) - a Meetup clone  
* [Surmon.me.native ★282](https://github.com/surmon-china/surmon.me.native) A react-native applaction for surmon.me  
* [Ziliun React Native ★252](https://github.com/sonnylazuardi/ziliun-react-native) - Wordpress based article reader built with react native  
* [Luno ★246](https://github.com/alwx/luno-react-native) - A ClojureScript React Native app demonstration  
* [GitterMobile ★235](https://github.com/terrysahaidak/GitterMobile) - Gitter (chat for github) client for iOS and Android  
* [ReactNativeHackerNews ★231](https://github.com/jsdf/ReactNativeHackerNews)  
* [MagicMirror ★226](https://github.com/ajwhite/MagicMirror)  
* [iOS Conference App made with React Native ★224](https://github.com/mikkoj/NortalTechDay)  
* [Redux Demo ★213](https://github.com/chentsulin/react-native-counter-ios-android) - Minimal implement of redux counter example on ReactNative iOS and Android  
* [DuckDuckGo App (Unofficial) ★205](https://github.com/kiok46/duckduckgo)  
* [React Native Embedded App ★197](https://github.com/dsibiski/react-native-embedded-app-example) -A collection of examples for using React Native in an existing iOS application  
* [React Native Example, Geo and Location ★188](https://github.com/bgryszko/react-native-example)  
* [uestc-bbs-react-native ★182](https://github.com/just4fun/uestc-bbs-react-native) - An iOS client for http://bbs.uestc.edu.cn/ written in React Native with Redux  
* [BBC News (Unofficial) ★172](https://github.com/joeltrew/BBCNews-React-Native) - a BBC news app  
* [Lumpen Radio ★170](https://github.com/jhabdas/lumpen-radio)  
* [Buyscreen sample ★144](https://github.com/appintheair/react-native-buyscreen)  
* [HackerWeb ★135](https://github.com/cheeaun/hackerweb-native) - A simply readable Hacker News web app for iOS & Android.  
* [NewsWatch video viewer ★124](https://github.com/bradoyler/newswatch-react-native)  
* [Kakapo - ambient sound mixer ★116](https://github.com/bluedaniel/Kakapo-native)  
* [Look Lock ★115](https://github.com/7kfpun/PhotosReactNative) - An app for showing photos without worries.  
* [PxView ★110](https://github.com/alphasp/pxview) - An unofficial Pixiv app client for Android and iOS  
* [Alt/Flux Demo ★107](https://github.com/mrblueblue/react-native-alt-demo)  
* [YouTrack Mobile ★103](https://github.com/JetBrains/youtrack-mobile) – a client for YouTrack – issue tracker from JetBrains.  
* [Appointments ★94](https://github.com/iZaL/my-appointment) - Full-fledged ReactNative App for Booking Appointments  
* [Insta Snap ★87](https://github.com/iZaL/insta-snap) - Image Sharing App  
* [Reddit made with React Native and Redux ★81](https://github.com/KevinOfNeu/xReddit)  
* [react-native-redux-facebook ★77](https://github.com/bkspace/react-native-redux-facebook) - A simple React Redux Facebook authentication demo app.  
* [Finance MacOS React Native ★76](https://github.com/7kfpun/FinanceMacOSReactNative) - iOS's Stocks App clone written for MacOS with Touch Bar support. Data is pulled from Yahoo Finance.  
* [NBAreact ★60](https://github.com/jbkuczma/NBAreact)  
* [ASOS ★60](https://github.com/edwinbosire/ASOS) - E-commerce app for ASOS (clone)  
* [live translator ★57](https://github.com/agrcrobles/react-native-live-translator) - An app that translates in real time what you see from your mobile.  
* [Native iOS font list ★55](https://github.com/yayolius/react-native-font-list)  
* [React Native Chromecast App ★51](https://github.com/holoed/ChromeCast_ReactNative)  
* [Nearby Live ★51](https://github.com/N3TC4T/Nearby-Live) - An unofficial NearbyLive app for Android and iOS  
* [AudienceNetworkReactNative ★48](https://github.com/7kfpun/AudienceNetworkReactNative) - Facebook Audience Network Performance Tool.  
* [Urban Dictionary ★48](https://github.com/edwinbosire/Urbandict) - Mobile implementation of the popular Urban Dictionary website.  
* [rndrawer-implemented-rnrouter ★48](https://github.com/efkan/rndrawer-implemented-rnrouter) - A react-native-drawer implemented example and scaffolding for react-native-router-flux  
* [iTunesConnect ★46](https://github.com/oney/iTunesConnect) - Unofficial iTunes Connect App  
* [QRCode App ★46](https://github.com/insiderdev/react-native-qrcode-app) - application for scanning and generating QR codes.  
* [Buttercup Mobile ★44](https://github.com/buttercup/buttercup-mobile) - Mobile password manager  
* [iOS app that transcript your voice with IBM Watson Cloud ★40](https://github.com/yrezgui/meowth-ios)  
* [Sequent ★35](https://github.com/sobstel/sequent) - short-term memory training game (W/ Redux).  
* [SoundcloudMboX ★33](https://github.com/trazyn/SoundcloudMboX) SoundcloudMobX is the Soundcloud for iOS, Build with React-Native and MobX.  
* [Confreaks ★29](https://github.com/cabaret/confreaks-react-native)  
* [MoeFM ★25](https://github.com/codeestX/MoeFM) - A light MusicPlayer build with React Native & Redux for both Android and iOS.  
* [Premier League ★20](https://github.com/ennioma/react-native-premier-league)  
* [Vocab React Native ★19](https://github.com/thaiinhk/VocabReactNative) - Thai Vocabulary Learning App  
* [Text Blast ★19](https://github.com/SeshApp/text-blast-react-native) - iOS client for MMS text blasting app with analogous [ionic version](https://github.com/SeshApp/text-blast-ionic) for comparison  
* [Paramap ★19](https://github.com/twist900/paramap) - Accessability map. React-native with Redux and Firebase. iOS and Android.  
* [NewYorkTimesTopStories ★15](https://github.com/vidyuthd/NYTimesTopStories-React-Native) - Read Topstories of NewYorkTimes using its api written for android in react-native.  
* [Posters\_Galore\_Android ★11](https://github.com/marmelab/Posters_Galore_Android) - An experimental Android application using Redux and a REST API  
* [Todo List ★9](https://github.com/rishabhbhatia/react-native-todo) - Todo-List app using SwipeView with ES6 standards for iOS and Android.  
* [f8app](https://github.com/fbsamples/f8app) - Official F8 (Facebook Developer Conference) app of 2017. See [blog post](http://makeitopen.com/blog/2017/12/04/blog-post-f82017-open-source.html).  
* [react-native-otello ★5](https://github.com/hiaw/react_native_otello) - a reversi game written in React Native  
* [Hello Bemans ★5](https://github.com/rapportyou/HelloBemans) - Health Trainer Connection App (Android Version)  
* [RNV2ex ★3](https://github.com/dyygtfx/RNV2ex) - react-native for v2ex  
* [Quick-Sample ★2](https://github.com/innFactory/react-native-quick-sample) - A small and simple example app with navigation, data persistence, redux, listview and animation.  
* [React Native Netflix](https://github.com/mariodev12/react-native-netflix) - A Netflix-like app.  
* [Bristol Pound](http://blog.scottlogic.com/2017/11/22/developing-bristol-pound-an-open-source-react-native-app.html) - An app for the Bristol Pound, a UK-based local currency.  
* [React Native Showcase](https://facebook.github.io/react-native/showcase.html)  
* [Status.im](https://github.com/status-im/status-react/) - Ethereum client.  
* [HackerBuzz](https://github.com/RCiesielczuk/HackerBuzz-ReactNative) - a Hacker News reader.  
* [ndash](https://github.com/alexindigo/ndash) - npm dashboard.  
* [Boostnote](https://github.com/BoostIO/boostnote-mobile) - Boostnote: open source note taking.  
* [Roxie](https://github.com/venepe/react-native-roxie) - Sound processing and bluetooth hardware control.  
* [Splitcloud](https://github.com/egm0121/splitcloud-app) - Share listening to two songs at the same time from Soundcloud (by splitting right/left channels).  
* [Instagram clone](https://github.com/reindexio/reindex-examples/tree/master/react-native-gallery) - an Instagram clone  
* [Joplin](https://github.com/laurent22/joplin/tree/master/ReactNativeClient) - A note taking app for desktop, CLI, and mobile (linked here is the mobile app).  

## Frameworks

* [NativeBase ★7062](https://github.com/GeekyAnts/NativeBase) - builds a layer on top of React Native that provides you with basic set of components for mobile application development  
* [Teaset ★521](https://github.com/rilyu/teaset) - A UI library for react native, provides 20+ pure JS(ES6) components, focusing on content display and action control.  
* [Awesome React Native Meteor ★145](https://github.com/meteor-factory/awesome-react-native-meteor) - An awesome list of resources for using Meteor and React Native together  
* [React Native Diagnose ★5](https://github.com/netbeast/react-native-diagnose) - A framework to test a React Native app during runtime and production  

## Tutorials

Walkthroughs and tutorials that help you learn React Native.

* [Fully-immersive, hands-on, and fun learning experience for React Native ★672](https://github.com/jondot/ReactNativeKatas)  
* [React Native Android Widget Proof of Concept ★54](https://github.com/netbeast/react-native-android-widget-poc)  
* [React Native with Django backend ★8](https://github.com/shunpochang/connect_love_mobile_demo)  
* [Animate React Native UI Elements](https://egghead.io/courses/animate-react-native-ui-elements)  
* [Build a streaming audio app with React Native](http://slides.com/jhabdas/streaming-audio-react-native/)  
* [Building a Calculator for Android and iOS with React Native](https://kylewbanks.com/blog/react-native-tutorial-part-1-hello-react)  
* [Building Custom React Native Components From Scratch](http://moduscreate.com/react_native_custom_components_ios/)  
* [Custom Native iOS Views with React Native](http://almostobsolete.net/react-native/custom-ios-views-with-react-native.html)  
* [Deploying React Native using Fastlane](https://shift.infinite.red/simple-react-native-ios-releases-4c28bb53a97b#.bjifers3r)  
* [Easily Connect React Native and Meteor](http://blog.differential.com/easily-connect-react-native-to-a-meteor-server/)  
* [Enabling Live Reload](https://www.reddit.com/r/reactnative/comments/30hbg3/enabling_live_reload/)  
* [Facebook's F8 App Walkthrough Tutorial: React Native, Redux, Relay, Flow, Jest](http://makeitopen.com/)  
* [Facebook Login With React Native](http://brentvatne.ca/facebook-login-with-react-native)  
* [Integrating Parse and React Native for iOS](http://www.raywenderlich.com/106369/integrating-parse-react-native-ios)  
* [Introducing React Native (on Ray Wenderlich's)](http://www.raywenderlich.com/99473/introducing-react-native-building-apps-javascript)  
* [Leverage Existing iOS Views In Your React Native App](http://moduscreate.com/leverage-existing-ios-views-react-native-app/)  
* [Official React Native tutorial](http://facebook.github.io/react-native/docs/tutorial.html#content)  
* [React Native Periscope Hearts Animation](http://browniefed.com/blog/2015/09/07/react-native-periscope-hearts-animation/)  
* [React Native Youtube Animated Video Slide](http://browniefed.com/blog/2015/08/31/react-native-youtube-animated-video-slide/)  
* [React Native and Socket.io](https://bullpen.bullish.io/how-to-actually-use-socket-io-in-react-native-39082d8d6172)  
* [React-Native Animated with React-Art - Firework Tap To Shoot](http://browniefed.com/blog/2015/08/29/react-native-animated-with-react-art-firework-show/)  
* [React-native Animated API Basic Example](http://browniefed.com/blog/2015/07/26/react-native-animated-api-basic-example/)  
* [React-native Animated API with PanResponder](http://browniefed.com/blog/2015/08/15/react-native-animated-api-with-panresponder/)  
* [React-native Animated ScrollView Row Swipe Actions](http://browniefed.com/blog/2015/08/01/react-native-animated-listview-row-swipe/)  
* [React-native press and hold button actions](http://browniefed.com/blog/2015/08/22/react-native-press-and-hold-button-actions/)  
* [React Native Express](http://www.reactnativeexpress.com/)  
* [Simple React Native forms with redux-form, immutable.js and styled-components](http://esbenp.github.io/2017/01/06/react-native-redux-form-immutable-styled-components/)  
* [A Mini-Course on React Native Flexbox](https://medium.com/@yoniweisbrod/a-mini-course-on-react-native-flexbox-2832a1ccc6)  
* [The beauty of react-native -Build a stunning wallpaper app](https://www.smashingmagazine.com/2016/04/the-beauty-of-react-native-building-your-first-ios-app-with-javascript-part-1/)  
* [Adding and removing custom fonts in React Native IOS Android](https://medium.com/@danielskripnik/how-to-add-and-remove-custom-fonts-in-react-native-b2830084b0e4#.s73pqh4ez)  
* [Adding Custom Fonts to A React Native Application](https://medium.com/@dabit3/adding-custom-fonts-to-react-native-b266b41bff7f)  


## Books

Books - free and commercial (but only good ones).

* [Programming React Native](https://leanpub.com/programming-react-native) - (Free) An in-depth React Native book that you should read after you've done a couple tutorials of the many out there.  
* [React Native Animation Book](http://browniefed.com/react-native-animation-book/) - (Free) React Native Animation  

Books - for sale.

* [React Native In Action](https://www.manning.com/books/react-native-in-action) - Learn how to build applications using React Native from the ground up  

## Videos

Assortment of conference and training videos. 

### Talks

* [awesome-react-native-talks ★262](https://github.com/mightyCrow/awesome-react-native-talks) - A curated list of talks about React Native or topics related to React Native.  
* React Conf 2015: [Introducing React Native](https://youtu.be/KVZ-P-ZI6W4)  
* React Conf 2015: [A Deep Dive into React Native](https://youtu.be/7rDsRXj9-cU)  
* F8 2015: [React Native and Relay](https://www.youtube.com/watch?v=X6YbAKiLCLU)  
* [Actually Building Things In React Native , Jani Eväkallio, Futurice](https://www.youtube.com/watch?v=ZqKYk0aTaYk)  
* [Using Redux, Jonas Ohlsson, State](https://www.youtube.com/watch?v=Ola8U-SpL6U)  
* [Native Testing](https://www.youtube.com/watch?v=6aVDe2Y-co4)  
* [Reactotron](https://www.youtube.com/watch?v=tPBRfxswDjA)
* [React Native In The Wild - Bonnie Eisenman](https://www.youtube.com/watch?v=KWEhFWm0SL8)  

### Training & tutorials

* [Awesome React Native Education ★326](https://github.com/hsavit1/Awesome-React-Native-Education)  
* [React Native training ★238](https://www.gitbook.com/book/unbug/react-native-training/details)  
* [Let's build a React Native app in 20 minutes](https://www.youtube.com/watch?v=9ArhJiMGVDc) and [Gist](https://gist.github.com/peterjmag/2ef39ba5d25f3f1e0008)  
* Egghead.io: [React Native Fundamentals](https://egghead.io/series/react-native-fundamentals)  
* Pluralsight.com: [Build iOS Apps with React Native](http://www.pluralsight.com/courses/build-ios-apps-react-native)  
* Udemy.com: [Build apps with React Native](https://www.udemy.com/the-complete-react-native-and-redux-course/)  
* Dailydrip.com: [Learn React Native in 5min per day](https://www.dailydrip.com/topics/react-native/)  
* [Mario Díez Channel](https://www.youtube.com/channel/UCisGMoxaVxJMcbio2FBHORg/search?query=React+Native) - Youtube channel in spanish about with a series of videos talking about react native  
* Udemy.com: [Create Your First React Native App](https://www.udemy.com/create-your-first-react-native-app/?couponCode=AWESOME-REACT-NATIVE) - Introduction to building a React Native app and learning the foundational pieces.  
* Handlebarlabs.com: [Learn React Native + Meteor](http://reactnativemeteor.com) - Comprehensive course & community on building an application with React Native and Meteor.  
* [React Native Basics: Build a Currency Converter](http://learn.handlebarlabs.com/p/react-native-basics-build-a-currency-converter?ref=awesome-react-native) - (Free) A multi-hour in-depth video course showing you how to build apps with React Native.
* [React Native in Arabic: Build a newspaper app](https://www.youtube.com/playlist?list=PLk-CkzAysw4BLLNtATmnZOA8E8I6TP8MS) - (Free) A simple to follow video series in Arabic showing you how to build a newspaper app with React Native.
* [Build a Weather app ](https://cloneable.io/courses/enrolled/103341) - (Free) A course to build a weather app with React Native.
* [Building Youtube UI in 30 Minutes](https://www.youtube.com/watch?v=LdKtugH-sb8) - A quick tutorial showing how to build Youtube Mobile app's UI using React Native. This tutorial helps in getting started with coding designs from scratch.

* Udemy.com: [Automate Your React Native Releases with Fastlane & Bitrise](https://www.udemy.com/automate-your-react-native-releases-with-fastlane-and-bitrise/?couponCode=AWESOME-REACT-NATIVE) - Learn step-by-step how to release your React Native applications into Stores automatically by using Fastlane & Bitrise.  
* [Generate React Native Forms](http://react.rocks/example/tcomb-form-native) with `tcomb-form-native`  

## Blogs

* [React Native Training](https://medium.com/react-native-training)  
* [Use React Native Blog](http://www.reactnative.com/)  
* [Facebook Code Blog](https://code.facebook.com/)  
* [The Bakery](http://blog.thebakery.io/) - JavaScript, React, React Native posts.  
* [Christopher Chedeau aka Vjeux](http://blog.vjeux.com/)  
* [Brent Vatne](http://brentvatne.ca/)  
* [Kyle Corbitt](https://corbt.com/posts/) - Cofounder at Emberall.  
* [Made with React](http://madewithreact.com/) - Showcase of apps using React or React Native.  
* [Spencer Carli](https://medium.com/@spencer_carli)  
* [Official React Native Blog](http://facebook.github.io/react-native/blog/)  

## Releases

* [Stable: 0.51.0](https://github.com/facebook/react-native/releases/tag/v0.51.0)  
* [Release Process](http://facebook.github.io/react/blog/2015/05/22/react-native-release-process.html)  
* [Next: latest](https://github.com/facebook/react-native/releases/latest)  

