//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhealthcareapis

import "time"

// CheckNameAvailabilityParameters - Input values.
type CheckNameAvailabilityParameters struct {
	// REQUIRED; The name of the service instance to check.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The fully qualified resource type which includes provider namespace.
	Type *string `json:"type,omitempty"`
}

// DicomService - The description of Dicom Service
type DicomService struct {
	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// Dicom Service configuration.
	Properties *DicomServiceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DicomServiceAuthenticationConfiguration - Authentication configuration information
type DicomServiceAuthenticationConfiguration struct {
	// READ-ONLY; The audiences for the service
	Audiences []*string `json:"audiences,omitempty" azure:"ro"`

	// READ-ONLY; The authority url for the service
	Authority *string `json:"authority,omitempty" azure:"ro"`
}

// DicomServiceCollection - The collection of Dicom Services.
type DicomServiceCollection struct {
	// The link used to get the next page of Dicom Services.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of Dicom Services.
	Value []*DicomService `json:"value,omitempty"`
}

// DicomServicePatchResource - Dicom Service patch properties
type DicomServicePatchResource struct {
	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// DicomServiceProperties - Dicom Service properties.
type DicomServiceProperties struct {
	// Dicom Service authentication configuration.
	AuthenticationConfiguration *DicomServiceAuthenticationConfiguration `json:"authenticationConfiguration,omitempty"`

	// Control permission for data plane traffic coming from public networks while private endpoint is enabled.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// READ-ONLY; The list of private endpoint connections that are set up for this resource.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The url of the Dicom Services.
	ServiceURL *string `json:"serviceUrl,omitempty" azure:"ro"`
}

// DicomServicesClientBeginCreateOrUpdateOptions contains the optional parameters for the DicomServicesClient.BeginCreateOrUpdate
// method.
type DicomServicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DicomServicesClientBeginDeleteOptions contains the optional parameters for the DicomServicesClient.BeginDelete method.
type DicomServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DicomServicesClientBeginUpdateOptions contains the optional parameters for the DicomServicesClient.BeginUpdate method.
type DicomServicesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DicomServicesClientGetOptions contains the optional parameters for the DicomServicesClient.Get method.
type DicomServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DicomServicesClientListByWorkspaceOptions contains the optional parameters for the DicomServicesClient.ListByWorkspace
// method.
type DicomServicesClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// Error details.
type Error struct {
	// Error details
	Error *ErrorDetailsInternal `json:"error,omitempty"`
}

// ErrorDetails - Error details.
type ErrorDetails struct {
	// Error details
	Error *ErrorDetailsInternal `json:"error,omitempty"`
}

// ErrorDetailsInternal - Error details.
type ErrorDetailsInternal struct {
	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The target of the particular error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// FhirDestinationsClientListByIotConnectorOptions contains the optional parameters for the FhirDestinationsClient.ListByIotConnector
// method.
type FhirDestinationsClientListByIotConnectorOptions struct {
	// placeholder for future optional parameters
}

// FhirService - The description of Fhir Service
type FhirService struct {
	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`

	// The kind of the service.
	Kind *FhirServiceKind `json:"kind,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// Fhir Service configuration.
	Properties *FhirServiceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FhirServiceAccessPolicyEntry - An access policy entry.
type FhirServiceAccessPolicyEntry struct {
	// REQUIRED; An Azure AD object ID (User or Apps) that is allowed access to the FHIR service.
	ObjectID *string `json:"objectId,omitempty"`
}

// FhirServiceAcrConfiguration - Azure container registry configuration information
type FhirServiceAcrConfiguration struct {
	// The list of the Azure container registry login servers.
	LoginServers []*string `json:"loginServers,omitempty"`

	// The list of Open Container Initiative (OCI) artifacts.
	OciArtifacts []*ServiceOciArtifactEntry `json:"ociArtifacts,omitempty"`
}

// FhirServiceAuthenticationConfiguration - Authentication configuration information
type FhirServiceAuthenticationConfiguration struct {
	// The audience url for the service
	Audience *string `json:"audience,omitempty"`

	// The authority url for the service
	Authority *string `json:"authority,omitempty"`

	// If the SMART on FHIR proxy is enabled
	SmartProxyEnabled *bool `json:"smartProxyEnabled,omitempty"`
}

// FhirServiceCollection - A collection of Fhir services.
type FhirServiceCollection struct {
	// The link used to get the next page of Fhir Services.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of Fhir Services.
	Value []*FhirService `json:"value,omitempty"`
}

// FhirServiceCorsConfiguration - The settings for the CORS configuration of the service instance.
type FhirServiceCorsConfiguration struct {
	// If credentials are allowed via CORS.
	AllowCredentials *bool `json:"allowCredentials,omitempty"`

	// The headers to be allowed via CORS.
	Headers []*string `json:"headers,omitempty"`

	// The max age to be allowed via CORS.
	MaxAge *int32 `json:"maxAge,omitempty"`

	// The methods to be allowed via CORS.
	Methods []*string `json:"methods,omitempty"`

	// The origins to be allowed via CORS.
	Origins []*string `json:"origins,omitempty"`
}

// FhirServiceExportConfiguration - Export operation configuration information
type FhirServiceExportConfiguration struct {
	// The name of the default export storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
}

// FhirServiceImportConfiguration - Import operation configuration information
type FhirServiceImportConfiguration struct {
	// If the import operation is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// If the FHIR service is in InitialImportMode.
	InitialImportMode *bool `json:"initialImportMode,omitempty"`

	// The name of the default integration storage account.
	IntegrationDataStore *string `json:"integrationDataStore,omitempty"`
}

// FhirServicePatchResource - FhirService patch properties
type FhirServicePatchResource struct {
	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// FhirServiceProperties - Fhir Service properties.
type FhirServiceProperties struct {
	// Fhir Service access policies.
	AccessPolicies []*FhirServiceAccessPolicyEntry `json:"accessPolicies,omitempty"`

	// Fhir Service Azure container registry configuration.
	AcrConfiguration *FhirServiceAcrConfiguration `json:"acrConfiguration,omitempty"`

	// Fhir Service authentication configuration.
	AuthenticationConfiguration *FhirServiceAuthenticationConfiguration `json:"authenticationConfiguration,omitempty"`

	// Fhir Service Cors configuration.
	CorsConfiguration *FhirServiceCorsConfiguration `json:"corsConfiguration,omitempty"`

	// Fhir Service export configuration.
	ExportConfiguration *FhirServiceExportConfiguration `json:"exportConfiguration,omitempty"`

	// Fhir Service import configuration.
	ImportConfiguration *FhirServiceImportConfiguration `json:"importConfiguration,omitempty"`

	// Control permission for data plane traffic coming from public networks while private endpoint is enabled.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Determines tracking of history for resources.
	ResourceVersionPolicyConfiguration *ResourceVersionPolicyConfiguration `json:"resourceVersionPolicyConfiguration,omitempty"`

	// READ-ONLY; Fhir Service event support status.
	EventState *ServiceEventState `json:"eventState,omitempty" azure:"ro"`

	// READ-ONLY; The list of private endpoint connections that are set up for this resource.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// FhirServicesClientBeginCreateOrUpdateOptions contains the optional parameters for the FhirServicesClient.BeginCreateOrUpdate
// method.
type FhirServicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FhirServicesClientBeginDeleteOptions contains the optional parameters for the FhirServicesClient.BeginDelete method.
type FhirServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FhirServicesClientBeginUpdateOptions contains the optional parameters for the FhirServicesClient.BeginUpdate method.
type FhirServicesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FhirServicesClientGetOptions contains the optional parameters for the FhirServicesClient.Get method.
type FhirServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// FhirServicesClientListByWorkspaceOptions contains the optional parameters for the FhirServicesClient.ListByWorkspace method.
type FhirServicesClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// IotConnector - IoT Connector definition.
type IotConnector struct {
	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// IoT Connector configuration.
	Properties *IotConnectorProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IotConnectorCollection - A collection of IoT Connectors.
type IotConnectorCollection struct {
	// The link used to get the next page of IoT Connectors.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of IoT Connectors.
	Value []*IotConnector `json:"value,omitempty"`
}

// IotConnectorFhirDestinationClientBeginCreateOrUpdateOptions contains the optional parameters for the IotConnectorFhirDestinationClient.BeginCreateOrUpdate
// method.
type IotConnectorFhirDestinationClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IotConnectorFhirDestinationClientBeginDeleteOptions contains the optional parameters for the IotConnectorFhirDestinationClient.BeginDelete
// method.
type IotConnectorFhirDestinationClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IotConnectorFhirDestinationClientGetOptions contains the optional parameters for the IotConnectorFhirDestinationClient.Get
// method.
type IotConnectorFhirDestinationClientGetOptions struct {
	// placeholder for future optional parameters
}

// IotConnectorPatchResource - Iot Connector patch properties
type IotConnectorPatchResource struct {
	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// IotConnectorProperties - IoT Connector properties.
type IotConnectorProperties struct {
	// Device Mappings.
	DeviceMapping *IotMappingProperties `json:"deviceMapping,omitempty"`

	// Source configuration.
	IngestionEndpointConfiguration *IotEventHubIngestionEndpointConfiguration `json:"ingestionEndpointConfiguration,omitempty"`

	// READ-ONLY; The provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// IotConnectorsClientBeginCreateOrUpdateOptions contains the optional parameters for the IotConnectorsClient.BeginCreateOrUpdate
// method.
type IotConnectorsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IotConnectorsClientBeginDeleteOptions contains the optional parameters for the IotConnectorsClient.BeginDelete method.
type IotConnectorsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IotConnectorsClientBeginUpdateOptions contains the optional parameters for the IotConnectorsClient.BeginUpdate method.
type IotConnectorsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IotConnectorsClientGetOptions contains the optional parameters for the IotConnectorsClient.Get method.
type IotConnectorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// IotConnectorsClientListByWorkspaceOptions contains the optional parameters for the IotConnectorsClient.ListByWorkspace
// method.
type IotConnectorsClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// IotDestinationProperties - Common IoT Connector destination properties.
type IotDestinationProperties struct {
	// READ-ONLY; The provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// IotEventHubIngestionEndpointConfiguration - Event Hub ingestion endpoint configuration
type IotEventHubIngestionEndpointConfiguration struct {
	// Consumer group of the event hub to connected to.
	ConsumerGroup *string `json:"consumerGroup,omitempty"`

	// Event Hub name to connect to.
	EventHubName *string `json:"eventHubName,omitempty"`

	// Fully qualified namespace of the Event Hub to connect to.
	FullyQualifiedEventHubNamespace *string `json:"fullyQualifiedEventHubNamespace,omitempty"`
}

// IotFhirDestination - IoT Connector FHIR destination definition.
type IotFhirDestination struct {
	// REQUIRED; IoT FHIR Destination settings.
	Properties *IotFhirDestinationProperties `json:"properties,omitempty"`

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IotFhirDestinationCollection - A collection of IoT Connector FHIR destinations.
type IotFhirDestinationCollection struct {
	// The link used to get the next page of IoT FHIR destinations.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of IoT Connector FHIR destinations.
	Value []*IotFhirDestination `json:"value,omitempty"`
}

// IotFhirDestinationProperties - IoT Connector destination properties for an Azure FHIR service.
type IotFhirDestinationProperties struct {
	// REQUIRED; FHIR Mappings
	FhirMapping *IotMappingProperties `json:"fhirMapping,omitempty"`

	// REQUIRED; Fully qualified resource id of the FHIR service to connect to.
	FhirServiceResourceID *string `json:"fhirServiceResourceId,omitempty"`

	// REQUIRED; Determines how resource identity is resolved on the destination.
	ResourceIdentityResolutionType *IotIdentityResolutionType `json:"resourceIdentityResolutionType,omitempty"`

	// READ-ONLY; The provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// IotMappingProperties - The mapping content.
type IotMappingProperties struct {
	// The mapping.
	Content interface{} `json:"content,omitempty"`
}

// ListOperations - Available operations of the service
type ListOperations struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; Collection of available operation details
	Value []*OperationDetail `json:"value,omitempty" azure:"ro"`
}

// LocationBasedResource - The common properties for any location based resource, tracked or proxy.
type LocationBasedResource struct {
	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LogSpecification - Specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`

	// Localized friendly display name of the log
	DisplayName *string `json:"displayName,omitempty"`

	// Name of the log
	Name *string `json:"name,omitempty"`
}

// MetricDimension - Specifications of the Dimension of metrics
type MetricDimension struct {
	// Localized friendly display name of the dimension
	DisplayName *string `json:"displayName,omitempty"`

	// Name of the dimension
	Name *string `json:"name,omitempty"`

	// Whether this dimension should be included for the Shoebox export scenario
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MetricSpecification - Specifications of the Metrics for Azure Monitoring
type MetricSpecification struct {
	// Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string `json:"aggregationType,omitempty"`

	// Name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string `json:"category,omitempty"`

	// Dimensions of the metric
	Dimensions []*MetricDimension `json:"dimensions,omitempty"`

	// Localized friendly description of the metric
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Localized friendly display name of the metric
	DisplayName *string `json:"displayName,omitempty"`

	// Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// Name of the metric
	Name *string `json:"name,omitempty"`

	// Name of the MDM namespace. Optional.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`

	// Supported aggregation types
	SupportedAggregationTypes []*string `json:"supportedAggregationTypes,omitempty"`

	// Supported time grain types
	SupportedTimeGrainTypes []*string `json:"supportedTimeGrainTypes,omitempty"`

	// Unit that makes sense for the metric
	Unit *string `json:"unit,omitempty"`
}

// OperationDetail - Service REST API operation.
type OperationDetail struct {
	// Display of the operation
	Display *OperationDisplay `json:"display,omitempty"`

	// Properties of the operation
	Properties *OperationProperties `json:"properties,omitempty"`

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType `json:"actionType,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; Name of the operation
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Default value is 'user,system'.
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Friendly description for the operation,
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Name of the operation
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Service provider: Microsoft.HealthcareApis
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type: Services
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationProperties - Extra Operation properties
type OperationProperties struct {
	// Service specifications of the operation
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationResultsClientGetOptions contains the optional parameters for the OperationResultsClient.Get method.
type OperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationResultsDescription - The properties indicating the operation result of an operation on a service.
type OperationResultsDescription struct {
	// Additional properties of the operation result.
	Properties interface{} `json:"properties,omitempty"`

	// READ-ONLY; The time that the operation finished.
	EndTime *string `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the operation returned.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation result.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The time that the operation was started.
	StartTime *string `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The status of the operation being performed.
	Status *OperationResultStatus `json:"status,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionDescription - The Private Endpoint Connection resource.
type PrivateEndpointConnectionDescription struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionListResultDescription - List of private endpoint connection associated with the specified storage
// account
type PrivateEndpointConnectionListResultDescription struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnectionDescription `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByServiceOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByService
// method.
type PrivateEndpointConnectionsClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceDescription - The Private Endpoint Connection resource.
type PrivateLinkResourceDescription struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResultDescription - A list of private link resources
type PrivateLinkResourceListResultDescription struct {
	// Array of private link resources
	Value []*PrivateLinkResourceDescription `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListByServiceOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByService
// method.
type PrivateLinkResourcesClientListByServiceOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceCore - The common properties for any resource, tracked or proxy.
type ResourceCore struct {
	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceTags - List of key value pairs that describe the resource. This will overwrite the existing tags.
type ResourceTags struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ResourceVersionPolicyConfiguration - The settings for history tracking for FHIR resources.
type ResourceVersionPolicyConfiguration struct {
	// The default value for tracking history across all resources.
	Default *FhirResourceVersionPolicy `json:"default,omitempty"`

	// A list of FHIR Resources and their version policy overrides.
	ResourceTypeOverrides map[string]*FhirResourceVersionPolicy `json:"resourceTypeOverrides,omitempty"`
}

// ServiceAccessPolicyEntry - An access policy entry.
type ServiceAccessPolicyEntry struct {
	// REQUIRED; An Azure AD object ID (User or Apps) that is allowed access to the FHIR service.
	ObjectID *string `json:"objectId,omitempty"`
}

// ServiceAcrConfigurationInfo - Azure container registry configuration information
type ServiceAcrConfigurationInfo struct {
	// The list of the ACR login servers.
	LoginServers []*string `json:"loginServers,omitempty"`

	// The list of Open Container Initiative (OCI) artifacts.
	OciArtifacts []*ServiceOciArtifactEntry `json:"ociArtifacts,omitempty"`
}

// ServiceAuthenticationConfigurationInfo - Authentication configuration information
type ServiceAuthenticationConfigurationInfo struct {
	// The audience url for the service
	Audience *string `json:"audience,omitempty"`

	// The authority url for the service
	Authority *string `json:"authority,omitempty"`

	// If the SMART on FHIR proxy is enabled
	SmartProxyEnabled *bool `json:"smartProxyEnabled,omitempty"`
}

// ServiceCorsConfigurationInfo - The settings for the CORS configuration of the service instance.
type ServiceCorsConfigurationInfo struct {
	// If credentials are allowed via CORS.
	AllowCredentials *bool `json:"allowCredentials,omitempty"`

	// The headers to be allowed via CORS.
	Headers []*string `json:"headers,omitempty"`

	// The max age to be allowed via CORS.
	MaxAge *int32 `json:"maxAge,omitempty"`

	// The methods to be allowed via CORS.
	Methods []*string `json:"methods,omitempty"`

	// The origins to be allowed via CORS.
	Origins []*string `json:"origins,omitempty"`
}

// ServiceCosmosDbConfigurationInfo - The settings for the Cosmos DB database backing the service.
type ServiceCosmosDbConfigurationInfo struct {
	// The URI of the customer-managed key for the backing database.
	KeyVaultKeyURI *string `json:"keyVaultKeyUri,omitempty"`

	// The provisioned throughput for the backing database.
	OfferThroughput *int32 `json:"offerThroughput,omitempty"`
}

// ServiceExportConfigurationInfo - Export operation configuration information
type ServiceExportConfigurationInfo struct {
	// The name of the default export storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
}

// ServiceImportConfigurationInfo - Import operation configuration information
type ServiceImportConfigurationInfo struct {
	// If the import operation is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// If the FHIR service is in InitialImportMode.
	InitialImportMode *bool `json:"initialImportMode,omitempty"`

	// The name of the default integration storage account.
	IntegrationDataStore *string `json:"integrationDataStore,omitempty"`
}

// ServiceManagedIdentity - Managed service identity (system assigned and/or user assigned identities)
type ServiceManagedIdentity struct {
	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServiceManagedIdentityIdentity `json:"identity,omitempty"`
}

// ServiceManagedIdentityIdentity - Setting indicating whether the service has a managed identity associated with it.
type ServiceManagedIdentityIdentity struct {
	// REQUIRED; Type of identity being specified, currently SystemAssigned and None are allowed.
	Type *ServiceManagedIdentityType `json:"type,omitempty"`

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ServiceOciArtifactEntry - An Open Container Initiative (OCI) artifact.
type ServiceOciArtifactEntry struct {
	// The artifact digest.
	Digest *string `json:"digest,omitempty"`

	// The artifact name.
	ImageName *string `json:"imageName,omitempty"`

	// The Azure Container Registry login server.
	LoginServer *string `json:"loginServer,omitempty"`
}

// ServiceSpecification - Service specification payload
type ServiceSpecification struct {
	// Specifications of the Log for Azure Monitoring
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty"`

	// Specifications of the Metrics for Azure Monitoring
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// ServicesClientBeginCreateOrUpdateOptions contains the optional parameters for the ServicesClient.BeginCreateOrUpdate method.
type ServicesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginDeleteOptions contains the optional parameters for the ServicesClient.BeginDelete method.
type ServicesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientBeginUpdateOptions contains the optional parameters for the ServicesClient.BeginUpdate method.
type ServicesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServicesClientCheckNameAvailabilityOptions contains the optional parameters for the ServicesClient.CheckNameAvailability
// method.
type ServicesClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientGetOptions contains the optional parameters for the ServicesClient.Get method.
type ServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListByResourceGroupOptions contains the optional parameters for the ServicesClient.ListByResourceGroup method.
type ServicesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListOptions contains the optional parameters for the ServicesClient.List method.
type ServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// ServicesDescription - The description of the service.
type ServicesDescription struct {
	// REQUIRED; The kind of the service.
	Kind *Kind `json:"kind,omitempty"`

	// REQUIRED; The resource location.
	Location *string `json:"location,omitempty"`

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity `json:"identity,omitempty"`

	// The common properties of a service.
	Properties *ServicesProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServicesDescriptionListResult - A list of service description objects with a next link.
type ServicesDescriptionListResult struct {
	// The link used to get the next page of service description objects.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of service description objects.
	Value []*ServicesDescription `json:"value,omitempty"`
}

// ServicesNameAvailabilityInfo - The properties indicating whether a given service name is available.
type ServicesNameAvailabilityInfo struct {
	// The detailed reason message.
	Message *string `json:"message,omitempty"`

	// READ-ONLY; The value which indicates whether the provided name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty" azure:"ro"`

	// READ-ONLY; The reason for unavailability.
	Reason *ServiceNameUnavailabilityReason `json:"reason,omitempty" azure:"ro"`
}

// ServicesPatchDescription - The description of the service.
type ServicesPatchDescription struct {
	// The properties for updating a service instance.
	Properties *ServicesPropertiesUpdateParameters `json:"properties,omitempty"`

	// Instance tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// ServicesProperties - The properties of a service instance.
type ServicesProperties struct {
	// The access policies of the service instance.
	AccessPolicies []*ServiceAccessPolicyEntry `json:"accessPolicies,omitempty"`

	// The azure container registry settings used for convert data operation of the service instance.
	AcrConfiguration *ServiceAcrConfigurationInfo `json:"acrConfiguration,omitempty"`

	// The authentication configuration for the service instance.
	AuthenticationConfiguration *ServiceAuthenticationConfigurationInfo `json:"authenticationConfiguration,omitempty"`

	// The settings for the CORS configuration of the service instance.
	CorsConfiguration *ServiceCorsConfigurationInfo `json:"corsConfiguration,omitempty"`

	// The settings for the Cosmos DB database backing the service.
	CosmosDbConfiguration *ServiceCosmosDbConfigurationInfo `json:"cosmosDbConfiguration,omitempty"`

	// The settings for the export operation of the service instance.
	ExportConfiguration *ServiceExportConfigurationInfo `json:"exportConfiguration,omitempty"`

	// The settings for the import operation of the service instance.
	ImportConfiguration *ServiceImportConfigurationInfo `json:"importConfiguration,omitempty"`

	// The list of private endpoint connections that are set up for this resource.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`

	// Control permission for data plane traffic coming from public networks while private endpoint is enabled.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// READ-ONLY; The provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ServicesPropertiesUpdateParameters - The properties for updating a service instance.
type ServicesPropertiesUpdateParameters struct {
	// Control permission for data plane traffic coming from public networks while private endpoint is enabled.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// ServicesResource - The common properties of a service.
type ServicesResource struct {
	// REQUIRED; The kind of the service.
	Kind *Kind `json:"kind,omitempty"`

	// REQUIRED; The resource location.
	Location *string `json:"location,omitempty"`

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity `json:"identity,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServicesResourceIdentity - Setting indicating whether the service has a managed identity associated with it.
type ServicesResourceIdentity struct {
	// Type of identity being specified, currently SystemAssigned and None are allowed.
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// READ-ONLY; The principal ID of the resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of the resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TaggedResource - The common properties of tracked resources in the service.
type TaggedResource struct {
	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// Workspace resource.
type Workspace struct {
	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string `json:"etag,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// Workspaces resource specific properties.
	Properties *WorkspaceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkspaceList - Collection of workspace object with a next link
type WorkspaceList struct {
	// The link used to get the next page.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of resources.
	Value []*Workspace `json:"value,omitempty"`
}

// WorkspacePatchResource - Workspace patch properties
type WorkspacePatchResource struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// WorkspacePrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the WorkspacePrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type WorkspacePrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacePrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the WorkspacePrivateEndpointConnectionsClient.BeginDelete
// method.
type WorkspacePrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacePrivateEndpointConnectionsClientGetOptions contains the optional parameters for the WorkspacePrivateEndpointConnectionsClient.Get
// method.
type WorkspacePrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspacePrivateEndpointConnectionsClientListByWorkspaceOptions contains the optional parameters for the WorkspacePrivateEndpointConnectionsClient.ListByWorkspace
// method.
type WorkspacePrivateEndpointConnectionsClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// WorkspacePrivateLinkResourcesClientGetOptions contains the optional parameters for the WorkspacePrivateLinkResourcesClient.Get
// method.
type WorkspacePrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspacePrivateLinkResourcesClientListByWorkspaceOptions contains the optional parameters for the WorkspacePrivateLinkResourcesClient.ListByWorkspace
// method.
type WorkspacePrivateLinkResourcesClientListByWorkspaceOptions struct {
	// placeholder for future optional parameters
}

// WorkspaceProperties - Workspaces resource specific properties.
type WorkspaceProperties struct {
	// Control permission for data plane traffic coming from public networks while private endpoint is enabled.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// READ-ONLY; The list of private endpoint connections that are set up for this resource.
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// WorkspacesClientBeginCreateOrUpdateOptions contains the optional parameters for the WorkspacesClient.BeginCreateOrUpdate
// method.
type WorkspacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientBeginDeleteOptions contains the optional parameters for the WorkspacesClient.BeginDelete method.
type WorkspacesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientBeginUpdateOptions contains the optional parameters for the WorkspacesClient.BeginUpdate method.
type WorkspacesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkspacesClientGetOptions contains the optional parameters for the WorkspacesClient.Get method.
type WorkspacesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListByResourceGroupOptions contains the optional parameters for the WorkspacesClient.ListByResourceGroup
// method.
type WorkspacesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// WorkspacesClientListBySubscriptionOptions contains the optional parameters for the WorkspacesClient.ListBySubscription
// method.
type WorkspacesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}
