//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdevtestlabs

import "time"

// ApplicableSchedule - Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on lab level.
type ApplicableSchedule struct {
	// REQUIRED; The properties of the resource.
	Properties *ApplicableScheduleProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicableScheduleFragment - Schedules applicable to a virtual machine. The schedules may have been defined on a VM or
// on lab level.
type ApplicableScheduleFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ApplicableScheduleProperties - Properties of a schedules applicable to a virtual machine.
type ApplicableScheduleProperties struct {
	// The auto-shutdown schedule, if one has been set at the lab or lab resource level.
	LabVMsShutdown *Schedule `json:"labVmsShutdown,omitempty"`

	// The auto-startup schedule, if one has been set at the lab or lab resource level.
	LabVMsStartup *Schedule `json:"labVmsStartup,omitempty"`
}

// ApplyArtifactsRequest - Request body for applying artifacts to a virtual machine.
type ApplyArtifactsRequest struct {
	// The list of artifacts to apply.
	Artifacts []*ArtifactInstallProperties `json:"artifacts,omitempty"`
}

// ArmTemplate - An Azure Resource Manager template.
type ArmTemplate struct {
	// REQUIRED; The properties of the resource.
	Properties *ArmTemplateProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ArmTemplateInfo - Information about a generated ARM template.
type ArmTemplateInfo struct {
	// The parameters of the ARM template.
	Parameters interface{} `json:"parameters,omitempty"`

	// The template's contents.
	Template interface{} `json:"template,omitempty"`
}

// ArmTemplateList - The response of a list operation.
type ArmTemplateList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*ArmTemplate `json:"value,omitempty"`
}

// ArmTemplateParameterProperties - Properties of an Azure Resource Manager template parameter.
type ArmTemplateParameterProperties struct {
	// The name of the template parameter.
	Name *string `json:"name,omitempty"`

	// The value of the template parameter.
	Value *string `json:"value,omitempty"`
}

// ArmTemplateProperties - Properties of an Azure Resource Manager template.
type ArmTemplateProperties struct {
	// READ-ONLY; The contents of the ARM template.
	Contents interface{} `json:"contents,omitempty" azure:"ro"`

	// READ-ONLY; The creation date of the armTemplate.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The description of the ARM template.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the ARM template.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Whether or not ARM template is enabled for use by lab user.
	Enabled *bool `json:"enabled,omitempty" azure:"ro"`

	// READ-ONLY; The URI to the icon of the ARM template.
	Icon *string `json:"icon,omitempty" azure:"ro"`

	// READ-ONLY; File name and parameter values information from all azuredeploy.*.parameters.json for the ARM template.
	ParametersValueFilesInfo []*ParametersValueFileInfo `json:"parametersValueFilesInfo,omitempty" azure:"ro"`

	// READ-ONLY; The publisher of the ARM template.
	Publisher *string `json:"publisher,omitempty" azure:"ro"`
}

// ArmTemplatesClientGetOptions contains the optional parameters for the ArmTemplatesClient.Get method.
type ArmTemplatesClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=displayName)'
	Expand *string
}

// ArmTemplatesClientListOptions contains the optional parameters for the ArmTemplatesClient.List method.
type ArmTemplatesClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=displayName)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// Artifact - An artifact.
type Artifact struct {
	// REQUIRED; The properties of the resource.
	Properties *ArtifactProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ArtifactDeploymentStatusProperties - Properties of an artifact deployment.
type ArtifactDeploymentStatusProperties struct {
	// The total count of the artifacts that were successfully applied.
	ArtifactsApplied *int32 `json:"artifactsApplied,omitempty"`

	// The deployment status of the artifact.
	DeploymentStatus *string `json:"deploymentStatus,omitempty"`

	// The total count of the artifacts that were tentatively applied.
	TotalArtifacts *int32 `json:"totalArtifacts,omitempty"`
}

// ArtifactInstallProperties - Properties of an artifact.
type ArtifactInstallProperties struct {
	// The artifact's identifier.
	ArtifactID *string `json:"artifactId,omitempty"`

	// The artifact's title.
	ArtifactTitle *string `json:"artifactTitle,omitempty"`

	// The status message from the deployment.
	DeploymentStatusMessage *string `json:"deploymentStatusMessage,omitempty"`

	// The time that the artifact starts to install on the virtual machine.
	InstallTime *time.Time `json:"installTime,omitempty"`

	// The parameters of the artifact.
	Parameters []*ArtifactParameterProperties `json:"parameters,omitempty"`

	// The status of the artifact.
	Status *string `json:"status,omitempty"`

	// The status message from the virtual machine extension.
	VMExtensionStatusMessage *string `json:"vmExtensionStatusMessage,omitempty"`
}

// ArtifactList - The response of a list operation.
type ArtifactList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*Artifact `json:"value,omitempty"`
}

// ArtifactParameterProperties - Properties of an artifact parameter.
type ArtifactParameterProperties struct {
	// The name of the artifact parameter.
	Name *string `json:"name,omitempty"`

	// The value of the artifact parameter.
	Value *string `json:"value,omitempty"`
}

// ArtifactProperties - Properties of an artifact.
type ArtifactProperties struct {
	// READ-ONLY; The artifact's creation date.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The artifact's description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The file path to the artifact.
	FilePath *string `json:"filePath,omitempty" azure:"ro"`

	// READ-ONLY; The URI to the artifact icon.
	Icon *string `json:"icon,omitempty" azure:"ro"`

	// READ-ONLY; The artifact's parameters.
	Parameters interface{} `json:"parameters,omitempty" azure:"ro"`

	// READ-ONLY; The artifact's publisher.
	Publisher *string `json:"publisher,omitempty" azure:"ro"`

	// READ-ONLY; The artifact's target OS.
	TargetOsType *string `json:"targetOsType,omitempty" azure:"ro"`

	// READ-ONLY; The artifact's title.
	Title *string `json:"title,omitempty" azure:"ro"`
}

// ArtifactSource - Properties of an artifact source.
type ArtifactSource struct {
	// REQUIRED; The properties of the resource.
	Properties *ArtifactSourceProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ArtifactSourceFragment - Properties of an artifact source.
type ArtifactSourceFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ArtifactSourceList - The response of a list operation.
type ArtifactSourceList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*ArtifactSource `json:"value,omitempty"`
}

// ArtifactSourceProperties - Properties of an artifact source.
type ArtifactSourceProperties struct {
	// The folder containing Azure Resource Manager templates.
	ArmTemplateFolderPath *string `json:"armTemplateFolderPath,omitempty"`

	// The artifact source's branch reference.
	BranchRef *string `json:"branchRef,omitempty"`

	// The artifact source's display name.
	DisplayName *string `json:"displayName,omitempty"`

	// The folder containing artifacts.
	FolderPath *string `json:"folderPath,omitempty"`

	// The security token to authenticate to the artifact source.
	SecurityToken *string `json:"securityToken,omitempty"`

	// The artifact source's type.
	SourceType *SourceControlType `json:"sourceType,omitempty"`

	// Indicates if the artifact source is enabled (values: Enabled, Disabled).
	Status *EnableStatus `json:"status,omitempty"`

	// The artifact source's URI.
	URI *string `json:"uri,omitempty"`

	// READ-ONLY; The artifact source's creation date.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// ArtifactSourcesClientCreateOrUpdateOptions contains the optional parameters for the ArtifactSourcesClient.CreateOrUpdate
// method.
type ArtifactSourcesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ArtifactSourcesClientDeleteOptions contains the optional parameters for the ArtifactSourcesClient.Delete method.
type ArtifactSourcesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ArtifactSourcesClientGetOptions contains the optional parameters for the ArtifactSourcesClient.Get method.
type ArtifactSourcesClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=displayName)'
	Expand *string
}

// ArtifactSourcesClientListOptions contains the optional parameters for the ArtifactSourcesClient.List method.
type ArtifactSourcesClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=displayName)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// ArtifactSourcesClientUpdateOptions contains the optional parameters for the ArtifactSourcesClient.Update method.
type ArtifactSourcesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ArtifactsClientGenerateArmTemplateOptions contains the optional parameters for the ArtifactsClient.GenerateArmTemplate
// method.
type ArtifactsClientGenerateArmTemplateOptions struct {
	// placeholder for future optional parameters
}

// ArtifactsClientGetOptions contains the optional parameters for the ArtifactsClient.Get method.
type ArtifactsClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=title)'
	Expand *string
}

// ArtifactsClientListOptions contains the optional parameters for the ArtifactsClient.List method.
type ArtifactsClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=title)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// AttachDiskProperties - Properties of the disk to attach.
type AttachDiskProperties struct {
	// The resource ID of the Lab virtual machine to which the disk is attached.
	LeasedByLabVMID *string `json:"leasedByLabVmId,omitempty"`
}

// AttachNewDataDiskOptions - Properties to attach new disk to the Virtual Machine.
type AttachNewDataDiskOptions struct {
	// The name of the disk to be attached.
	DiskName *string `json:"diskName,omitempty"`

	// Size of the disk to be attached in Gibibytes.
	DiskSizeGiB *int32 `json:"diskSizeGiB,omitempty"`

	// The storage type for the disk (i.e. Standard, Premium).
	DiskType *StorageType `json:"diskType,omitempty"`
}

// BulkCreationParameters - Parameters for creating multiple virtual machines as a single action.
type BulkCreationParameters struct {
	// The number of virtual machine instances to create.
	InstanceCount *int32 `json:"instanceCount,omitempty"`
}

// CloudError - Error from a REST request.
type CloudError struct {
	// The cloud error that occurred
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - Body of an error from a REST request.
type CloudErrorBody struct {
	// The error code.
	Code *string `json:"code,omitempty"`

	// Inner errors.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// The error message.
	Message *string `json:"message,omitempty"`

	// The error target.
	Target *string `json:"target,omitempty"`
}

// ComputeDataDisk - A data disks attached to a virtual machine.
type ComputeDataDisk struct {
	// Gets data disk size in GiB.
	DiskSizeGiB *int32 `json:"diskSizeGiB,omitempty"`

	// When backed by a blob, the URI of underlying blob.
	DiskURI *string `json:"diskUri,omitempty"`

	// When backed by managed disk, this is the ID of the compute disk resource.
	ManagedDiskID *string `json:"managedDiskId,omitempty"`

	// Gets data disk name.
	Name *string `json:"name,omitempty"`
}

// ComputeVMInstanceViewStatus - Status information about a virtual machine.
type ComputeVMInstanceViewStatus struct {
	// Gets the status Code.
	Code *string `json:"code,omitempty"`

	// Gets the short localizable label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`

	// Gets the message associated with the status.
	Message *string `json:"message,omitempty"`
}

// ComputeVMProperties - Properties of a virtual machine returned by the Microsoft.Compute API.
type ComputeVMProperties struct {
	// Gets data disks blob uri for the virtual machine.
	DataDiskIDs []*string `json:"dataDiskIds,omitempty"`

	// Gets all data disks attached to the virtual machine.
	DataDisks []*ComputeDataDisk `json:"dataDisks,omitempty"`

	// Gets the network interface ID of the virtual machine.
	NetworkInterfaceID *string `json:"networkInterfaceId,omitempty"`

	// Gets OS disk blob uri for the virtual machine.
	OSDiskID *string `json:"osDiskId,omitempty"`

	// Gets the OS type of the virtual machine.
	OSType *string `json:"osType,omitempty"`

	// Gets the statuses of the virtual machine.
	Statuses []*ComputeVMInstanceViewStatus `json:"statuses,omitempty"`

	// Gets the size of the virtual machine.
	VMSize *string `json:"vmSize,omitempty"`
}

// CostThresholdProperties - Properties of a cost threshold item.
type CostThresholdProperties struct {
	// Indicates whether this threshold will be displayed on cost charts.
	DisplayOnChart *CostThresholdStatus `json:"displayOnChart,omitempty"`

	// Indicates the datetime when notifications were last sent for this threshold.
	NotificationSent *string `json:"notificationSent,omitempty"`

	// The value of the percentage cost threshold.
	PercentageThreshold *PercentageCostThresholdProperties `json:"percentageThreshold,omitempty"`

	// Indicates whether notifications will be sent when this threshold is exceeded.
	SendNotificationWhenExceeded *CostThresholdStatus `json:"sendNotificationWhenExceeded,omitempty"`

	// The ID of the cost threshold item.
	ThresholdID *string `json:"thresholdId,omitempty"`
}

// CostsClientCreateOrUpdateOptions contains the optional parameters for the CostsClient.CreateOrUpdate method.
type CostsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// CostsClientGetOptions contains the optional parameters for the CostsClient.Get method.
type CostsClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($expand=labCostDetails)'
	Expand *string
}

// CustomImage - A custom image.
type CustomImage struct {
	// REQUIRED; The properties of the resource.
	Properties *CustomImageProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomImageFragment - A custom image.
type CustomImageFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// CustomImageList - The response of a list operation.
type CustomImageList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*CustomImage `json:"value,omitempty"`
}

// CustomImageProperties - Properties of a custom image.
type CustomImageProperties struct {
	// The author of the custom image.
	Author *string `json:"author,omitempty"`

	// Storage information about the plan related to this custom image
	CustomImagePlan *CustomImagePropertiesFromPlan `json:"customImagePlan,omitempty"`

	// Storage information about the data disks present in the custom image
	DataDiskStorageInfo []*DataDiskStorageTypeInfo `json:"dataDiskStorageInfo,omitempty"`

	// The description of the custom image.
	Description *string `json:"description,omitempty"`

	// Whether or not the custom images underlying offer/plan has been enabled for programmatic deployment
	IsPlanAuthorized *bool `json:"isPlanAuthorized,omitempty"`

	// The Managed Image Id backing the custom image.
	ManagedImageID *string `json:"managedImageId,omitempty"`

	// The Managed Snapshot Id backing the custom image.
	ManagedSnapshotID *string `json:"managedSnapshotId,omitempty"`

	// The virtual machine from which the image is to be created.
	VM *CustomImagePropertiesFromVM `json:"vm,omitempty"`

	// The VHD from which the image is to be created.
	Vhd *CustomImagePropertiesCustom `json:"vhd,omitempty"`

	// READ-ONLY; The creation date of the custom image.
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// CustomImagePropertiesCustom - Properties for creating a custom image from a VHD.
type CustomImagePropertiesCustom struct {
	// REQUIRED; The OS type of the custom image (i.e. Windows, Linux)
	OSType *CustomImageOsType `json:"osType,omitempty"`

	// The image name.
	ImageName *string `json:"imageName,omitempty"`

	// Indicates whether sysprep has been run on the VHD.
	SysPrep *bool `json:"sysPrep,omitempty"`
}

// CustomImagePropertiesFromPlan - Properties for plan on a custom image.
type CustomImagePropertiesFromPlan struct {
	// The id of the plan, equivalent to name of the plan
	ID *string `json:"id,omitempty"`

	// The offer for the plan from the marketplace image the custom image is derived from
	Offer *string `json:"offer,omitempty"`

	// The publisher for the plan from the marketplace image the custom image is derived from
	Publisher *string `json:"publisher,omitempty"`
}

// CustomImagePropertiesFromVM - Properties for creating a custom image from a virtual machine.
type CustomImagePropertiesFromVM struct {
	// The Linux OS information of the VM.
	LinuxOsInfo *LinuxOsInfo `json:"linuxOsInfo,omitempty"`

	// The source vm identifier.
	SourceVMID *string `json:"sourceVmId,omitempty"`

	// The Windows OS information of the VM.
	WindowsOsInfo *WindowsOsInfo `json:"windowsOsInfo,omitempty"`
}

// CustomImagesClientBeginCreateOrUpdateOptions contains the optional parameters for the CustomImagesClient.BeginCreateOrUpdate
// method.
type CustomImagesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomImagesClientBeginDeleteOptions contains the optional parameters for the CustomImagesClient.BeginDelete method.
type CustomImagesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CustomImagesClientGetOptions contains the optional parameters for the CustomImagesClient.Get method.
type CustomImagesClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=vm)'
	Expand *string
}

// CustomImagesClientListOptions contains the optional parameters for the CustomImagesClient.List method.
type CustomImagesClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=vm)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// CustomImagesClientUpdateOptions contains the optional parameters for the CustomImagesClient.Update method.
type CustomImagesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DataDiskProperties - Request body for adding a new or existing data disk to a virtual machine.
type DataDiskProperties struct {
	// Specifies options to attach a new disk to the virtual machine.
	AttachNewDataDiskOptions *AttachNewDataDiskOptions `json:"attachNewDataDiskOptions,omitempty"`

	// Specifies the existing lab disk id to attach to virtual machine.
	ExistingLabDiskID *string `json:"existingLabDiskId,omitempty"`

	// Caching option for a data disk (i.e. None, ReadOnly, ReadWrite).
	HostCaching *HostCachingOptions `json:"hostCaching,omitempty"`
}

// DataDiskStorageTypeInfo - Storage information about the data disks present in the custom image
type DataDiskStorageTypeInfo struct {
	// Disk Lun
	Lun *string `json:"lun,omitempty"`

	// Disk Storage Type
	StorageType *StorageType `json:"storageType,omitempty"`
}

// DayDetails - Properties of a daily schedule.
type DayDetails struct {
	// The time of day the schedule will occur.
	Time *string `json:"time,omitempty"`
}

// DetachDataDiskProperties - Request body for detaching data disk from a virtual machine.
type DetachDataDiskProperties struct {
	// Specifies the disk resource ID to detach from virtual machine.
	ExistingLabDiskID *string `json:"existingLabDiskId,omitempty"`
}

// DetachDiskProperties - Properties of the disk to detach.
type DetachDiskProperties struct {
	// The resource ID of the Lab VM to which the disk is attached.
	LeasedByLabVMID *string `json:"leasedByLabVmId,omitempty"`
}

// Disk - A Disk.
type Disk struct {
	// REQUIRED; The properties of the resource.
	Properties *DiskProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiskFragment - A Disk.
type DiskFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// DiskList - The response of a list operation.
type DiskList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*Disk `json:"value,omitempty"`
}

// DiskProperties - Properties of a disk.
type DiskProperties struct {
	// When backed by a blob, the name of the VHD blob without extension.
	DiskBlobName *string `json:"diskBlobName,omitempty"`

	// The size of the disk in Gibibytes.
	DiskSizeGiB *int32 `json:"diskSizeGiB,omitempty"`

	// The storage type for the disk (i.e. Standard, Premium).
	DiskType *StorageType `json:"diskType,omitempty"`

	// When backed by a blob, the URI of underlying blob.
	DiskURI *string `json:"diskUri,omitempty"`

	// The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite).
	HostCaching *string `json:"hostCaching,omitempty"`

	// The resource ID of the VM to which this disk is leased.
	LeasedByLabVMID *string `json:"leasedByLabVmId,omitempty"`

	// When backed by managed disk, this is the ID of the compute disk resource.
	ManagedDiskID *string `json:"managedDiskId,omitempty"`

	// When backed by a blob, the storage account where the blob is.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// READ-ONLY; The creation date of the disk.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// DisksClientBeginAttachOptions contains the optional parameters for the DisksClient.BeginAttach method.
type DisksClientBeginAttachOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DisksClientBeginCreateOrUpdateOptions contains the optional parameters for the DisksClient.BeginCreateOrUpdate method.
type DisksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DisksClientBeginDeleteOptions contains the optional parameters for the DisksClient.BeginDelete method.
type DisksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DisksClientBeginDetachOptions contains the optional parameters for the DisksClient.BeginDetach method.
type DisksClientBeginDetachOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DisksClientGetOptions contains the optional parameters for the DisksClient.Get method.
type DisksClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=diskType)'
	Expand *string
}

// DisksClientListOptions contains the optional parameters for the DisksClient.List method.
type DisksClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=diskType)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// DisksClientUpdateOptions contains the optional parameters for the DisksClient.Update method.
type DisksClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DtlEnvironment - An environment, which is essentially an ARM template deployment.
type DtlEnvironment struct {
	// REQUIRED; The properties of the resource.
	Properties *EnvironmentProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DtlEnvironmentFragment - An environment, which is essentially an ARM template deployment.
type DtlEnvironmentFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// DtlEnvironmentList - The response of a list operation.
type DtlEnvironmentList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*DtlEnvironment `json:"value,omitempty"`
}

// EnvironmentDeploymentProperties - Properties of an environment deployment.
type EnvironmentDeploymentProperties struct {
	// The Azure Resource Manager template's identifier.
	ArmTemplateID *string `json:"armTemplateId,omitempty"`

	// The parameters of the Azure Resource Manager template.
	Parameters []*ArmTemplateParameterProperties `json:"parameters,omitempty"`
}

// EnvironmentProperties - Properties of an environment.
type EnvironmentProperties struct {
	// The display name of the Azure Resource Manager template that produced the environment.
	ArmTemplateDisplayName *string `json:"armTemplateDisplayName,omitempty"`

	// The deployment properties of the environment.
	DeploymentProperties *EnvironmentDeploymentProperties `json:"deploymentProperties,omitempty"`

	// READ-ONLY; The creator of the environment.
	CreatedByUser *string `json:"createdByUser,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The identifier of the resource group containing the environment's resources.
	ResourceGroupID *string `json:"resourceGroupId,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// EnvironmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the EnvironmentsClient.BeginCreateOrUpdate
// method.
type EnvironmentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientBeginDeleteOptions contains the optional parameters for the EnvironmentsClient.BeginDelete method.
type EnvironmentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientGetOptions contains the optional parameters for the EnvironmentsClient.Get method.
type EnvironmentsClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=deploymentProperties)'
	Expand *string
}

// EnvironmentsClientListOptions contains the optional parameters for the EnvironmentsClient.List method.
type EnvironmentsClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=deploymentProperties)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// EnvironmentsClientUpdateOptions contains the optional parameters for the EnvironmentsClient.Update method.
type EnvironmentsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// EvaluatePoliciesProperties - Properties for evaluating a policy set.
type EvaluatePoliciesProperties struct {
	// The fact data.
	FactData *string `json:"factData,omitempty"`

	// The fact name.
	FactName *string `json:"factName,omitempty"`

	// The user for which policies will be evaluated
	UserObjectID *string `json:"userObjectId,omitempty"`

	// The value offset.
	ValueOffset *string `json:"valueOffset,omitempty"`
}

// EvaluatePoliciesRequest - Request body for evaluating a policy set.
type EvaluatePoliciesRequest struct {
	// Policies to evaluate.
	Policies []*EvaluatePoliciesProperties `json:"policies,omitempty"`
}

// EvaluatePoliciesResponse - Response body for evaluating a policy set.
type EvaluatePoliciesResponse struct {
	// Results of evaluating a policy set.
	Results []*PolicySetResult `json:"results,omitempty"`
}

// Event - An event to be notified for.
type Event struct {
	// The event type for which this notification is enabled (i.e. AutoShutdown, Cost)
	EventName *NotificationChannelEventType `json:"eventName,omitempty"`
}

// ExportResourceUsageParameters - The parameters of the export operation.
type ExportResourceUsageParameters struct {
	// The blob storage absolute sas uri with write permission to the container which the usage data needs to be uploaded to.
	BlobStorageAbsoluteSasURI *string `json:"blobStorageAbsoluteSasUri,omitempty"`

	// The start time of the usage. If not provided, usage will be reported since the beginning of data collection.
	UsageStartDate *time.Time `json:"usageStartDate,omitempty"`
}

// ExternalSubnet - Subnet information as returned by the Microsoft.Network API.
type ExternalSubnet struct {
	// Gets or sets the identifier.
	ID *string `json:"id,omitempty"`

	// Gets or sets the name.
	Name *string `json:"name,omitempty"`
}

// Formula - A formula for creating a VM, specifying an image base and other parameters
type Formula struct {
	// REQUIRED; The properties of the resource.
	Properties *FormulaProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FormulaFragment - A formula for creating a VM, specifying an image base and other parameters
type FormulaFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// FormulaList - The response of a list operation.
type FormulaList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*Formula `json:"value,omitempty"`
}

// FormulaProperties - Properties of a formula.
type FormulaProperties struct {
	// The description of the formula.
	Description *string `json:"description,omitempty"`

	// The content of the formula.
	FormulaContent *LabVirtualMachineCreationParameter `json:"formulaContent,omitempty"`

	// The OS type of the formula.
	OSType *string `json:"osType,omitempty"`

	// Information about a VM from which a formula is to be created.
	VM *FormulaPropertiesFromVM `json:"vm,omitempty"`

	// READ-ONLY; The author of the formula.
	Author *string `json:"author,omitempty" azure:"ro"`

	// READ-ONLY; The creation date of the formula.
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// FormulaPropertiesFromVM - Information about a VM from which a formula is to be created.
type FormulaPropertiesFromVM struct {
	// The identifier of the VM from which a formula is to be created.
	LabVMID *string `json:"labVmId,omitempty"`
}

// FormulasClientBeginCreateOrUpdateOptions contains the optional parameters for the FormulasClient.BeginCreateOrUpdate method.
type FormulasClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FormulasClientDeleteOptions contains the optional parameters for the FormulasClient.Delete method.
type FormulasClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// FormulasClientGetOptions contains the optional parameters for the FormulasClient.Get method.
type FormulasClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=description)'
	Expand *string
}

// FormulasClientListOptions contains the optional parameters for the FormulasClient.List method.
type FormulasClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=description)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// FormulasClientUpdateOptions contains the optional parameters for the FormulasClient.Update method.
type FormulasClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// GalleryImage - A gallery image.
type GalleryImage struct {
	// REQUIRED; The properties of the resource.
	Properties *GalleryImageProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GalleryImageList - The response of a list operation.
type GalleryImageList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*GalleryImage `json:"value,omitempty"`
}

// GalleryImageProperties - Properties of a gallery image.
type GalleryImageProperties struct {
	// The author of the gallery image.
	Author *string `json:"author,omitempty"`

	// The description of the gallery image.
	Description *string `json:"description,omitempty"`

	// Indicates whether this gallery image is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// The icon of the gallery image.
	Icon *string `json:"icon,omitempty"`

	// The image reference of the gallery image.
	ImageReference *GalleryImageReference `json:"imageReference,omitempty"`

	// Indicates if the plan has been authorized for programmatic deployment.
	IsPlanAuthorized *bool `json:"isPlanAuthorized,omitempty"`

	// The third party plan that applies to this image
	PlanID *string `json:"planId,omitempty"`

	// READ-ONLY; The creation date of the gallery image.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`
}

// GalleryImageReference - The reference information for an Azure Marketplace image.
type GalleryImageReference struct {
	// The OS type of the gallery image.
	OSType *string `json:"osType,omitempty"`

	// The offer of the gallery image.
	Offer *string `json:"offer,omitempty"`

	// The publisher of the gallery image.
	Publisher *string `json:"publisher,omitempty"`

	// The SKU of the gallery image.
	SKU *string `json:"sku,omitempty"`

	// The version of the gallery image.
	Version *string `json:"version,omitempty"`
}

// GalleryImagesClientListOptions contains the optional parameters for the GalleryImagesClient.List method.
type GalleryImagesClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=author)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// GenerateArmTemplateRequest - Parameters for generating an ARM template for deploying artifacts.
type GenerateArmTemplateRequest struct {
	// Options for uploading the files for the artifact. UploadFilesAndGenerateSasTokens is the default value.
	FileUploadOptions *FileUploadOptions `json:"fileUploadOptions,omitempty"`

	// The location of the virtual machine.
	Location *string `json:"location,omitempty"`

	// The parameters of the ARM template.
	Parameters []*ParameterInfo `json:"parameters,omitempty"`

	// The resource name of the virtual machine.
	VirtualMachineName *string `json:"virtualMachineName,omitempty"`
}

// GenerateUploadURIParameter - Properties for generating an upload URI.
type GenerateUploadURIParameter struct {
	// The blob name of the upload URI.
	BlobName *string `json:"blobName,omitempty"`
}

// GenerateUploadURIResponse - Response body for generating an upload URI.
type GenerateUploadURIResponse struct {
	// The upload URI for the VHD.
	UploadURI *string `json:"uploadUri,omitempty"`
}

// GlobalSchedulesClientBeginExecuteOptions contains the optional parameters for the GlobalSchedulesClient.BeginExecute method.
type GlobalSchedulesClientBeginExecuteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GlobalSchedulesClientBeginRetargetOptions contains the optional parameters for the GlobalSchedulesClient.BeginRetarget
// method.
type GlobalSchedulesClientBeginRetargetOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GlobalSchedulesClientCreateOrUpdateOptions contains the optional parameters for the GlobalSchedulesClient.CreateOrUpdate
// method.
type GlobalSchedulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// GlobalSchedulesClientDeleteOptions contains the optional parameters for the GlobalSchedulesClient.Delete method.
type GlobalSchedulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GlobalSchedulesClientGetOptions contains the optional parameters for the GlobalSchedulesClient.Get method.
type GlobalSchedulesClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=status)'
	Expand *string
}

// GlobalSchedulesClientListByResourceGroupOptions contains the optional parameters for the GlobalSchedulesClient.ListByResourceGroup
// method.
type GlobalSchedulesClientListByResourceGroupOptions struct {
	// Specify the $expand query. Example: 'properties($select=status)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// GlobalSchedulesClientListBySubscriptionOptions contains the optional parameters for the GlobalSchedulesClient.ListBySubscription
// method.
type GlobalSchedulesClientListBySubscriptionOptions struct {
	// Specify the $expand query. Example: 'properties($select=status)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// GlobalSchedulesClientUpdateOptions contains the optional parameters for the GlobalSchedulesClient.Update method.
type GlobalSchedulesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// HourDetails - Properties of an hourly schedule.
type HourDetails struct {
	// Minutes of the hour the schedule will run.
	Minute *int32 `json:"minute,omitempty"`
}

// IdentityProperties - Properties of a managed identity
type IdentityProperties struct {
	// The client secret URL of the identity.
	ClientSecretURL *string `json:"clientSecretUrl,omitempty"`

	// The principal id of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`

	// The tenant identifier of resource.
	TenantID *string `json:"tenantId,omitempty"`

	// Managed identity.
	Type *ManagedIdentityType `json:"type,omitempty"`
}

// ImportLabVirtualMachineRequest - This represents the payload required to import a virtual machine from a different lab
// into the current one
type ImportLabVirtualMachineRequest struct {
	// The name of the virtual machine in the destination lab
	DestinationVirtualMachineName *string `json:"destinationVirtualMachineName,omitempty"`

	// The full resource ID of the virtual machine to be imported.
	SourceVirtualMachineResourceID *string `json:"sourceVirtualMachineResourceId,omitempty"`
}

// InboundNatRule - A rule for NAT - exposing a VM's port (backendPort) on the public IP address using a load balancer.
type InboundNatRule struct {
	// The port to which the external traffic will be redirected.
	BackendPort *int32 `json:"backendPort,omitempty"`

	// The external endpoint port of the inbound connection. Possible values range between 1 and 65535, inclusive. If unspecified,
	// a value will be allocated automatically.
	FrontendPort *int32 `json:"frontendPort,omitempty"`

	// The transport protocol for the endpoint.
	TransportProtocol *TransportProtocol `json:"transportProtocol,omitempty"`
}

// Lab - A lab.
type Lab struct {
	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The properties of the resource.
	Properties *LabProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LabAnnouncementProperties - Properties of a lab's announcement banner
type LabAnnouncementProperties struct {
	// Is the lab announcement active/enabled at this time?
	Enabled *EnableStatus `json:"enabled,omitempty"`

	// The time at which the announcement expires (null for never)
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`

	// Has this announcement expired?
	Expired *bool `json:"expired,omitempty"`

	// The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
	Markdown *string `json:"markdown,omitempty"`

	// The plain text title for the lab announcement
	Title *string `json:"title,omitempty"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// LabCost - A cost item.
type LabCost struct {
	// REQUIRED; The properties of the resource.
	Properties *LabCostProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LabCostDetailsProperties - The properties of a lab cost item.
type LabCostDetailsProperties struct {
	// The cost component of the cost item.
	Cost *float64 `json:"cost,omitempty"`

	// The type of the cost.
	CostType *CostType `json:"costType,omitempty"`

	// The date of the cost item.
	Date *time.Time `json:"date,omitempty"`
}

// LabCostProperties - Properties of a cost item.
type LabCostProperties struct {
	// The creation date of the cost.
	CreatedDate *time.Time `json:"createdDate,omitempty"`

	// The currency code of the cost.
	CurrencyCode *string `json:"currencyCode,omitempty"`

	// The end time of the cost data.
	EndDateTime *time.Time `json:"endDateTime,omitempty"`

	// The start time of the cost data.
	StartDateTime *time.Time `json:"startDateTime,omitempty"`

	// The target cost properties
	TargetCost *TargetCostProperties `json:"targetCost,omitempty"`

	// READ-ONLY; The lab cost details component of the cost data.
	LabCostDetails []*LabCostDetailsProperties `json:"labCostDetails,omitempty" azure:"ro"`

	// READ-ONLY; The lab cost summary component of the cost data.
	LabCostSummary *LabCostSummaryProperties `json:"labCostSummary,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource cost component of the cost data.
	ResourceCosts []*LabResourceCostProperties `json:"resourceCosts,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// LabCostSummaryProperties - The properties of the cost summary.
type LabCostSummaryProperties struct {
	// The cost component of the cost item.
	EstimatedLabCost *float64 `json:"estimatedLabCost,omitempty"`
}

// LabFragment - A lab.
type LabFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// LabList - The response of a list operation.
type LabList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*Lab `json:"value,omitempty"`
}

// LabProperties - Properties of a lab.
type LabProperties struct {
	// The properties of any lab announcement associated with this lab
	Announcement *LabAnnouncementProperties `json:"announcement,omitempty"`

	// The access rights to be granted to the user when provisioning an environment
	EnvironmentPermission *EnvironmentPermission `json:"environmentPermission,omitempty"`

	// Extended properties of the lab used for experimental features
	ExtendedProperties map[string]*string `json:"extendedProperties,omitempty"`

	// Type of storage used by the lab. It can be either Premium or Standard. Default is Premium.
	LabStorageType *StorageType `json:"labStorageType,omitempty"`

	// The ordered list of artifact resource IDs that should be applied on all Linux VM creations by default, prior to the artifacts
	// specified by the user.
	MandatoryArtifactsResourceIDsLinux []*string `json:"mandatoryArtifactsResourceIdsLinux,omitempty"`

	// The ordered list of artifact resource IDs that should be applied on all Windows VM creations by default, prior to the artifacts
	// specified by the user.
	MandatoryArtifactsResourceIDsWindows []*string `json:"mandatoryArtifactsResourceIdsWindows,omitempty"`

	// The setting to enable usage of premium data disks. When its value is 'Enabled', creation of standard or premium data disks
	// is allowed. When its value is 'Disabled', only creation of standard data
	// disks is allowed.
	PremiumDataDisks *PremiumDataDisk `json:"premiumDataDisks,omitempty"`

	// The properties of any lab support message associated with this lab
	Support *LabSupportProperties `json:"support,omitempty"`

	// READ-ONLY; The lab's artifact storage account.
	ArtifactsStorageAccount *string `json:"artifactsStorageAccount,omitempty" azure:"ro"`

	// READ-ONLY; The creation date of the lab.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The lab's default premium storage account.
	DefaultPremiumStorageAccount *string `json:"defaultPremiumStorageAccount,omitempty" azure:"ro"`

	// READ-ONLY; The lab's default storage account.
	DefaultStorageAccount *string `json:"defaultStorageAccount,omitempty" azure:"ro"`

	// READ-ONLY; The load balancer used to for lab VMs that use shared IP address.
	LoadBalancerID *string `json:"loadBalancerId,omitempty" azure:"ro"`

	// READ-ONLY; The Network Security Group attached to the lab VMs Network interfaces to restrict open ports.
	NetworkSecurityGroupID *string `json:"networkSecurityGroupId,omitempty" azure:"ro"`

	// READ-ONLY; The lab's premium data disk storage account.
	PremiumDataDiskStorageAccount *string `json:"premiumDataDiskStorageAccount,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The public IP address for the lab's load balancer.
	PublicIPID *string `json:"publicIpId,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; The resource group in which all new lab virtual machines will be created. To let DevTest Labs manage resource
	// group creation, set this value to null.
	VMCreationResourceGroup *string `json:"vmCreationResourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; The lab's Key vault.
	VaultName *string `json:"vaultName,omitempty" azure:"ro"`
}

// LabResourceCostProperties - The properties of a resource cost item.
type LabResourceCostProperties struct {
	// The ID of the external resource
	ExternalResourceID *string `json:"externalResourceId,omitempty"`

	// The cost component of the resource cost item.
	ResourceCost *float64 `json:"resourceCost,omitempty"`

	// The ID of the resource
	ResourceID *string `json:"resourceId,omitempty"`

	// The owner of the resource (ex. janedoe@microsoft.com)
	ResourceOwner *string `json:"resourceOwner,omitempty"`

	// The category of the resource (ex. PremiumLRS, StandardDS1)
	ResourcePricingTier *string `json:"resourcePricingTier,omitempty"`

	// The status of the resource (ex. Active)
	ResourceStatus *string `json:"resourceStatus,omitempty"`

	// The logical resource type (ex. virtualmachine, storageaccount)
	ResourceType *string `json:"resourceType,omitempty"`

	// The unique identifier of the resource.
	ResourceUID *string `json:"resourceUId,omitempty"`

	// The name of the resource.
	Resourcename *string `json:"resourcename,omitempty"`
}

// LabSupportProperties - Properties of a lab's support banner
type LabSupportProperties struct {
	// Is the lab support banner active/enabled at this time?
	Enabled *EnableStatus `json:"enabled,omitempty"`

	// The markdown text (if any) that this lab displays in the UI. If left empty/null, nothing will be shown.
	Markdown *string `json:"markdown,omitempty"`
}

// LabVhd - Properties of a VHD in the lab.
type LabVhd struct {
	// The URI to the VHD.
	ID *string `json:"id,omitempty"`
}

// LabVhdList - The response of a list operation.
type LabVhdList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*LabVhd `json:"value,omitempty"`
}

// LabVirtualMachine - A virtual machine.
type LabVirtualMachine struct {
	// REQUIRED; The properties of the resource.
	Properties *LabVirtualMachineProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LabVirtualMachineCreationParameter - Properties for creating a virtual machine.
type LabVirtualMachineCreationParameter struct {
	// The location of the new virtual machine or environment
	Location *string `json:"location,omitempty"`

	// The name of the virtual machine or environment
	Name *string `json:"name,omitempty"`

	// The properties of the resource.
	Properties *LabVirtualMachineCreationParameterProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// LabVirtualMachineCreationParameterProperties - Properties for virtual machine creation.
type LabVirtualMachineCreationParameterProperties struct {
	// Indicates whether another user can take ownership of the virtual machine
	AllowClaim *bool `json:"allowClaim,omitempty"`

	// The artifacts to be installed on the virtual machine.
	Artifacts []*ArtifactInstallProperties `json:"artifacts,omitempty"`

	// The number of virtual machine instances to create.
	BulkCreationParameters *BulkCreationParameters `json:"bulkCreationParameters,omitempty"`

	// The creation date of the virtual machine.
	CreatedDate *time.Time `json:"createdDate,omitempty"`

	// The custom image identifier of the virtual machine.
	CustomImageID *string `json:"customImageId,omitempty"`

	// New or existing data disks to attach to the virtual machine after creation
	DataDiskParameters []*DataDiskProperties `json:"dataDiskParameters,omitempty"`

	// Indicates whether the virtual machine is to be created without a public IP address.
	DisallowPublicIPAddress *bool `json:"disallowPublicIpAddress,omitempty"`

	// The resource ID of the environment that contains this virtual machine, if any.
	EnvironmentID *string `json:"environmentId,omitempty"`

	// The expiration date for VM.
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`

	// The Microsoft Azure Marketplace image reference of the virtual machine.
	GalleryImageReference *GalleryImageReference `json:"galleryImageReference,omitempty"`

	// Indicates whether this virtual machine uses an SSH key for authentication.
	IsAuthenticationWithSSHKey *bool `json:"isAuthenticationWithSshKey,omitempty"`

	// The lab subnet name of the virtual machine.
	LabSubnetName *string `json:"labSubnetName,omitempty"`

	// The lab virtual network identifier of the virtual machine.
	LabVirtualNetworkID *string `json:"labVirtualNetworkId,omitempty"`

	// The network interface properties.
	NetworkInterface *NetworkInterfaceProperties `json:"networkInterface,omitempty"`

	// The notes of the virtual machine.
	Notes *string `json:"notes,omitempty"`

	// The object identifier of the owner of the virtual machine.
	OwnerObjectID *string `json:"ownerObjectId,omitempty"`

	// The user principal name of the virtual machine owner.
	OwnerUserPrincipalName *string `json:"ownerUserPrincipalName,omitempty"`

	// The password of the virtual machine administrator.
	Password *string `json:"password,omitempty"`

	// The id of the plan associated with the virtual machine image
	PlanID *string `json:"planId,omitempty"`

	// The SSH key of the virtual machine administrator.
	SSHKey *string `json:"sshKey,omitempty"`

	// Virtual Machine schedules to be created
	ScheduleParameters []*ScheduleCreationParameter `json:"scheduleParameters,omitempty"`

	// The size of the virtual machine.
	Size *string `json:"size,omitempty"`

	// Storage type to use for virtual machine (i.e. Standard, Premium).
	StorageType *string `json:"storageType,omitempty"`

	// The user name of the virtual machine.
	UserName *string `json:"userName,omitempty"`
}

// LabVirtualMachineFragment - A virtual machine.
type LabVirtualMachineFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// LabVirtualMachineList - The response of a list operation.
type LabVirtualMachineList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*LabVirtualMachine `json:"value,omitempty"`
}

// LabVirtualMachineProperties - Properties of a virtual machine.
type LabVirtualMachineProperties struct {
	// Indicates whether another user can take ownership of the virtual machine
	AllowClaim *bool `json:"allowClaim,omitempty"`

	// The artifacts to be installed on the virtual machine.
	Artifacts []*ArtifactInstallProperties `json:"artifacts,omitempty"`

	// The creation date of the virtual machine.
	CreatedDate *time.Time `json:"createdDate,omitempty"`

	// The custom image identifier of the virtual machine.
	CustomImageID *string `json:"customImageId,omitempty"`

	// New or existing data disks to attach to the virtual machine after creation
	DataDiskParameters []*DataDiskProperties `json:"dataDiskParameters,omitempty"`

	// Indicates whether the virtual machine is to be created without a public IP address.
	DisallowPublicIPAddress *bool `json:"disallowPublicIpAddress,omitempty"`

	// The resource ID of the environment that contains this virtual machine, if any.
	EnvironmentID *string `json:"environmentId,omitempty"`

	// The expiration date for VM.
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`

	// The Microsoft Azure Marketplace image reference of the virtual machine.
	GalleryImageReference *GalleryImageReference `json:"galleryImageReference,omitempty"`

	// Indicates whether this virtual machine uses an SSH key for authentication.
	IsAuthenticationWithSSHKey *bool `json:"isAuthenticationWithSshKey,omitempty"`

	// The lab subnet name of the virtual machine.
	LabSubnetName *string `json:"labSubnetName,omitempty"`

	// The lab virtual network identifier of the virtual machine.
	LabVirtualNetworkID *string `json:"labVirtualNetworkId,omitempty"`

	// The network interface properties.
	NetworkInterface *NetworkInterfaceProperties `json:"networkInterface,omitempty"`

	// The notes of the virtual machine.
	Notes *string `json:"notes,omitempty"`

	// The object identifier of the owner of the virtual machine.
	OwnerObjectID *string `json:"ownerObjectId,omitempty"`

	// The user principal name of the virtual machine owner.
	OwnerUserPrincipalName *string `json:"ownerUserPrincipalName,omitempty"`

	// The password of the virtual machine administrator.
	Password *string `json:"password,omitempty"`

	// The id of the plan associated with the virtual machine image
	PlanID *string `json:"planId,omitempty"`

	// The SSH key of the virtual machine administrator.
	SSHKey *string `json:"sshKey,omitempty"`

	// Virtual Machine schedules to be created
	ScheduleParameters []*ScheduleCreationParameter `json:"scheduleParameters,omitempty"`

	// The size of the virtual machine.
	Size *string `json:"size,omitempty"`

	// Storage type to use for virtual machine (i.e. Standard, Premium).
	StorageType *string `json:"storageType,omitempty"`

	// The user name of the virtual machine.
	UserName *string `json:"userName,omitempty"`

	// READ-ONLY; The applicable schedule for the virtual machine.
	ApplicableSchedule *ApplicableSchedule `json:"applicableSchedule,omitempty" azure:"ro"`

	// READ-ONLY; The artifact deployment status for the virtual machine.
	ArtifactDeploymentStatus *ArtifactDeploymentStatusProperties `json:"artifactDeploymentStatus,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier (Microsoft.Compute) of the virtual machine.
	ComputeID *string `json:"computeId,omitempty" azure:"ro"`

	// READ-ONLY; The compute virtual machine properties.
	ComputeVM *ComputeVMProperties `json:"computeVm,omitempty" azure:"ro"`

	// READ-ONLY; The email address of creator of the virtual machine.
	CreatedByUser *string `json:"createdByUser,omitempty" azure:"ro"`

	// READ-ONLY; The object identifier of the creator of the virtual machine.
	CreatedByUserID *string `json:"createdByUserId,omitempty" azure:"ro"`

	// READ-ONLY; The fully-qualified domain name of the virtual machine.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; Last known compute power state captured in DTL
	LastKnownPowerState *string `json:"lastKnownPowerState,omitempty" azure:"ro"`

	// READ-ONLY; The OS type of the virtual machine.
	OSType *string `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; Tells source of creation of lab virtual machine. Output property only.
	VirtualMachineCreationSource *VirtualMachineCreationSource `json:"virtualMachineCreationSource,omitempty" azure:"ro"`
}

// LabsClientBeginClaimAnyVMOptions contains the optional parameters for the LabsClient.BeginClaimAnyVM method.
type LabsClientBeginClaimAnyVMOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabsClientBeginCreateEnvironmentOptions contains the optional parameters for the LabsClient.BeginCreateEnvironment method.
type LabsClientBeginCreateEnvironmentOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabsClientBeginCreateOrUpdateOptions contains the optional parameters for the LabsClient.BeginCreateOrUpdate method.
type LabsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabsClientBeginDeleteOptions contains the optional parameters for the LabsClient.BeginDelete method.
type LabsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabsClientBeginExportResourceUsageOptions contains the optional parameters for the LabsClient.BeginExportResourceUsage
// method.
type LabsClientBeginExportResourceUsageOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabsClientBeginImportVirtualMachineOptions contains the optional parameters for the LabsClient.BeginImportVirtualMachine
// method.
type LabsClientBeginImportVirtualMachineOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LabsClientGenerateUploadURIOptions contains the optional parameters for the LabsClient.GenerateUploadURI method.
type LabsClientGenerateUploadURIOptions struct {
	// placeholder for future optional parameters
}

// LabsClientGetOptions contains the optional parameters for the LabsClient.Get method.
type LabsClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=defaultStorageAccount)'
	Expand *string
}

// LabsClientListByResourceGroupOptions contains the optional parameters for the LabsClient.ListByResourceGroup method.
type LabsClientListByResourceGroupOptions struct {
	// Specify the $expand query. Example: 'properties($select=defaultStorageAccount)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// LabsClientListBySubscriptionOptions contains the optional parameters for the LabsClient.ListBySubscription method.
type LabsClientListBySubscriptionOptions struct {
	// Specify the $expand query. Example: 'properties($select=defaultStorageAccount)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// LabsClientListVhdsOptions contains the optional parameters for the LabsClient.ListVhds method.
type LabsClientListVhdsOptions struct {
	// placeholder for future optional parameters
}

// LabsClientUpdateOptions contains the optional parameters for the LabsClient.Update method.
type LabsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// LinuxOsInfo - Information about a Linux OS.
type LinuxOsInfo struct {
	// The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested, DeprovisionApplied).
	LinuxOsState *LinuxOsState `json:"linuxOsState,omitempty"`
}

// NetworkInterfaceProperties - Properties of a network interface.
type NetworkInterfaceProperties struct {
	// The DNS name.
	DNSName *string `json:"dnsName,omitempty"`

	// The private IP address.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`

	// The public IP address.
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`

	// The resource ID of the public IP address.
	PublicIPAddressID *string `json:"publicIpAddressId,omitempty"`

	// The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop
	// Protocol).
	RdpAuthority *string `json:"rdpAuthority,omitempty"`

	// The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
	SSHAuthority *string `json:"sshAuthority,omitempty"`

	// The configuration for sharing a public IP address across multiple virtual machines.
	SharedPublicIPAddressConfiguration *SharedPublicIPAddressConfiguration `json:"sharedPublicIpAddressConfiguration,omitempty"`

	// The resource ID of the sub net.
	SubnetID *string `json:"subnetId,omitempty"`

	// The resource ID of the virtual network.
	VirtualNetworkID *string `json:"virtualNetworkId,omitempty"`
}

// NotificationChannel - A notification.
type NotificationChannel struct {
	// REQUIRED; The properties of the resource.
	Properties *NotificationChannelProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NotificationChannelFragment - A notification.
type NotificationChannelFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// NotificationChannelList - The response of a list operation.
type NotificationChannelList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*NotificationChannel `json:"value,omitempty"`
}

// NotificationChannelProperties - Properties of a schedule.
type NotificationChannelProperties struct {
	// Description of notification.
	Description *string `json:"description,omitempty"`

	// The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
	EmailRecipient *string `json:"emailRecipient,omitempty"`

	// The list of event for which this notification is enabled.
	Events []*Event `json:"events,omitempty"`

	// The locale to use when sending a notification (fallback for unsupported languages is EN).
	NotificationLocale *string `json:"notificationLocale,omitempty"`

	// The webhook URL to send notifications to.
	WebHookURL *string `json:"webHookUrl,omitempty"`

	// READ-ONLY; The creation date of the notification channel.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// NotificationChannelsClientCreateOrUpdateOptions contains the optional parameters for the NotificationChannelsClient.CreateOrUpdate
// method.
type NotificationChannelsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// NotificationChannelsClientDeleteOptions contains the optional parameters for the NotificationChannelsClient.Delete method.
type NotificationChannelsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// NotificationChannelsClientGetOptions contains the optional parameters for the NotificationChannelsClient.Get method.
type NotificationChannelsClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=webHookUrl)'
	Expand *string
}

// NotificationChannelsClientListOptions contains the optional parameters for the NotificationChannelsClient.List method.
type NotificationChannelsClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=webHookUrl)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// NotificationChannelsClientNotifyOptions contains the optional parameters for the NotificationChannelsClient.Notify method.
type NotificationChannelsClientNotifyOptions struct {
	// placeholder for future optional parameters
}

// NotificationChannelsClientUpdateOptions contains the optional parameters for the NotificationChannelsClient.Update method.
type NotificationChannelsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// NotificationSettings - Notification settings for a schedule.
type NotificationSettings struct {
	// The email recipient to send notifications to (can be a list of semi-colon separated email addresses).
	EmailRecipient *string `json:"emailRecipient,omitempty"`

	// The locale to use when sending a notification (fallback for unsupported languages is EN).
	NotificationLocale *string `json:"notificationLocale,omitempty"`

	// If notifications are enabled for this schedule (i.e. Enabled, Disabled).
	Status *EnableStatus `json:"status,omitempty"`

	// Time in minutes before event at which notification will be sent.
	TimeInMinutes *int32 `json:"timeInMinutes,omitempty"`

	// The webhook URL to which the notification will be sent.
	WebhookURL *string `json:"webhookUrl,omitempty"`
}

// NotifyParameters - Properties for generating a Notification.
type NotifyParameters struct {
	// The type of event (i.e. AutoShutdown, Cost)
	EventName *NotificationChannelEventType `json:"eventName,omitempty"`

	// Properties for the notification in json format.
	JSONPayload *string `json:"jsonPayload,omitempty"`
}

// OperationError - Error details for the operation in case of a failure.
type OperationError struct {
	// The error code of the operation error.
	Code *string `json:"code,omitempty"`

	// The error message of the operation error.
	Message *string `json:"message,omitempty"`
}

// OperationMetadata - The REST API operation supported by DevTestLab ResourceProvider.
type OperationMetadata struct {
	// The object that describes the operations
	Display *OperationMetadataDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationMetadataDisplay - The object that describes the operations
type OperationMetadataDisplay struct {
	// Friendly name of the operation
	Description *string `json:"description,omitempty"`

	// Operation type: read, write, delete, listKeys/action, etc.
	Operation *string `json:"operation,omitempty"`

	// Friendly name of the resource provider
	Provider *string `json:"provider,omitempty"`

	// Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationResult - An Operation Result
type OperationResult struct {
	// Error details for the operation in case of a failure.
	Error *OperationError `json:"error,omitempty"`

	// The operation status.
	Status *string `json:"status,omitempty"`

	// The status code for the operation.
	StatusCode *HTTPStatusCode `json:"statusCode,omitempty"`
}

// OperationsClientGetOptions contains the optional parameters for the OperationsClient.Get method.
type OperationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ParameterInfo - Information about an artifact's parameter.
type ParameterInfo struct {
	// The name of the artifact parameter.
	Name *string `json:"name,omitempty"`

	// The value of the artifact parameter.
	Value *string `json:"value,omitempty"`
}

// ParametersValueFileInfo - A file containing a set of parameter values for an ARM template.
type ParametersValueFileInfo struct {
	// File name.
	FileName *string `json:"fileName,omitempty"`

	// Contents of the file.
	ParametersValueInfo interface{} `json:"parametersValueInfo,omitempty"`
}

// PercentageCostThresholdProperties - Properties of a percentage cost threshold.
type PercentageCostThresholdProperties struct {
	// The cost threshold value.
	ThresholdValue *float64 `json:"thresholdValue,omitempty"`
}

// PoliciesClientCreateOrUpdateOptions contains the optional parameters for the PoliciesClient.CreateOrUpdate method.
type PoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PoliciesClientDeleteOptions contains the optional parameters for the PoliciesClient.Delete method.
type PoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PoliciesClientGetOptions contains the optional parameters for the PoliciesClient.Get method.
type PoliciesClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=description)'
	Expand *string
}

// PoliciesClientListOptions contains the optional parameters for the PoliciesClient.List method.
type PoliciesClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=description)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// PoliciesClientUpdateOptions contains the optional parameters for the PoliciesClient.Update method.
type PoliciesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// Policy - A Policy.
type Policy struct {
	// REQUIRED; The properties of the resource.
	Properties *PolicyProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PolicyFragment - A Policy.
type PolicyFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// PolicyList - The response of a list operation.
type PolicyList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*Policy `json:"value,omitempty"`
}

// PolicyProperties - Properties of a Policy.
type PolicyProperties struct {
	// The description of the policy.
	Description *string `json:"description,omitempty"`

	// The evaluator type of the policy (i.e. AllowedValuesPolicy, MaxValuePolicy).
	EvaluatorType *PolicyEvaluatorType `json:"evaluatorType,omitempty"`

	// The fact data of the policy.
	FactData *string `json:"factData,omitempty"`

	// The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab, etc.
	FactName *PolicyFactName `json:"factName,omitempty"`

	// The status of the policy.
	Status *PolicyStatus `json:"status,omitempty"`

	// The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON array of values for AllowedValuesPolicy).
	Threshold *string `json:"threshold,omitempty"`

	// READ-ONLY; The creation date of the policy.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// PolicySetResult - Result of a policy set evaluation.
type PolicySetResult struct {
	// A value indicating whether this policy set evaluation has discovered violations.
	HasError *bool `json:"hasError,omitempty"`

	// The list of policy violations.
	PolicyViolations []*PolicyViolation `json:"policyViolations,omitempty"`
}

// PolicySetsClientEvaluatePoliciesOptions contains the optional parameters for the PolicySetsClient.EvaluatePolicies method.
type PolicySetsClientEvaluatePoliciesOptions struct {
	// placeholder for future optional parameters
}

// PolicyViolation - Policy violation.
type PolicyViolation struct {
	// The code of the policy violation.
	Code *string `json:"code,omitempty"`

	// The message of the policy violation.
	Message *string `json:"message,omitempty"`
}

// Port - Properties of a network port.
type Port struct {
	// Backend port of the target virtual machine.
	BackendPort *int32 `json:"backendPort,omitempty"`

	// Protocol type of the port.
	TransportProtocol *TransportProtocol `json:"transportProtocol,omitempty"`
}

// ProviderOperationResult - Result of the request to list REST API operations
type ProviderOperationResult struct {
	// List of operations supported by the resource provider.
	Value []*OperationMetadata `json:"value,omitempty"`

	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ProviderOperationsClientListOptions contains the optional parameters for the ProviderOperationsClient.List method.
type ProviderOperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// RdpConnection - Represents a .rdp file
type RdpConnection struct {
	// The contents of the .rdp file
	Contents *string `json:"contents,omitempty"`
}

// ResizeLabVirtualMachineProperties - Request body for resizing a virtual machine.
type ResizeLabVirtualMachineProperties struct {
	// Specifies the size of the virtual machine.
	Size *string `json:"size,omitempty"`
}

// Resource - An Azure resource.
type Resource struct {
	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RetargetScheduleProperties - Properties for retargeting a virtual machine schedule.
type RetargetScheduleProperties struct {
	// The resource Id of the virtual machine on which the schedule operates
	CurrentResourceID *string `json:"currentResourceId,omitempty"`

	// The resource Id of the virtual machine that the schedule should be retargeted to
	TargetResourceID *string `json:"targetResourceId,omitempty"`
}

// Schedule - A schedule.
type Schedule struct {
	// REQUIRED; The properties of the resource.
	Properties *ScheduleProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ScheduleCreationParameter - Properties for creating a schedule.
type ScheduleCreationParameter struct {
	// The name of the virtual machine or environment
	Name *string `json:"name,omitempty"`

	// The properties of the schedule.
	Properties *ScheduleCreationParameterProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The location of the new virtual machine or environment
	Location *string `json:"location,omitempty" azure:"ro"`
}

// ScheduleCreationParameterProperties - Properties for schedule creation.
type ScheduleCreationParameterProperties struct {
	// If the schedule will occur once each day of the week, specify the daily recurrence.
	DailyRecurrence *DayDetails `json:"dailyRecurrence,omitempty"`

	// If the schedule will occur multiple times a day, specify the hourly recurrence.
	HourlyRecurrence *HourDetails `json:"hourlyRecurrence,omitempty"`

	// Notification settings.
	NotificationSettings *NotificationSettings `json:"notificationSettings,omitempty"`

	// The status of the schedule (i.e. Enabled, Disabled)
	Status *EnableStatus `json:"status,omitempty"`

	// The resource ID to which the schedule belongs
	TargetResourceID *string `json:"targetResourceId,omitempty"`

	// The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
	TaskType *string `json:"taskType,omitempty"`

	// The time zone ID (e.g. Pacific Standard time).
	TimeZoneID *string `json:"timeZoneId,omitempty"`

	// If the schedule will occur only some days of the week, specify the weekly recurrence.
	WeeklyRecurrence *WeekDetails `json:"weeklyRecurrence,omitempty"`
}

// ScheduleFragment - A schedule.
type ScheduleFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ScheduleList - The response of a list operation.
type ScheduleList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*Schedule `json:"value,omitempty"`
}

// ScheduleProperties - Properties of a schedule.
type ScheduleProperties struct {
	// If the schedule will occur once each day of the week, specify the daily recurrence.
	DailyRecurrence *DayDetails `json:"dailyRecurrence,omitempty"`

	// If the schedule will occur multiple times a day, specify the hourly recurrence.
	HourlyRecurrence *HourDetails `json:"hourlyRecurrence,omitempty"`

	// Notification settings.
	NotificationSettings *NotificationSettings `json:"notificationSettings,omitempty"`

	// The status of the schedule (i.e. Enabled, Disabled)
	Status *EnableStatus `json:"status,omitempty"`

	// The resource ID to which the schedule belongs
	TargetResourceID *string `json:"targetResourceId,omitempty"`

	// The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
	TaskType *string `json:"taskType,omitempty"`

	// The time zone ID (e.g. Pacific Standard time).
	TimeZoneID *string `json:"timeZoneId,omitempty"`

	// If the schedule will occur only some days of the week, specify the weekly recurrence.
	WeeklyRecurrence *WeekDetails `json:"weeklyRecurrence,omitempty"`

	// READ-ONLY; The creation date of the schedule.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// SchedulesClientBeginExecuteOptions contains the optional parameters for the SchedulesClient.BeginExecute method.
type SchedulesClientBeginExecuteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SchedulesClientCreateOrUpdateOptions contains the optional parameters for the SchedulesClient.CreateOrUpdate method.
type SchedulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SchedulesClientDeleteOptions contains the optional parameters for the SchedulesClient.Delete method.
type SchedulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SchedulesClientGetOptions contains the optional parameters for the SchedulesClient.Get method.
type SchedulesClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=status)'
	Expand *string
}

// SchedulesClientListApplicableOptions contains the optional parameters for the SchedulesClient.ListApplicable method.
type SchedulesClientListApplicableOptions struct {
	// placeholder for future optional parameters
}

// SchedulesClientListOptions contains the optional parameters for the SchedulesClient.List method.
type SchedulesClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=status)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// SchedulesClientUpdateOptions contains the optional parameters for the SchedulesClient.Update method.
type SchedulesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// Secret - A secret.
type Secret struct {
	// REQUIRED; The properties of the resource.
	Properties *SecretProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecretFragment - A secret.
type SecretFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// SecretList - The response of a list operation.
type SecretList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*Secret `json:"value,omitempty"`
}

// SecretProperties - Properties of a secret.
type SecretProperties struct {
	// The value of the secret for secret creation.
	Value *string `json:"value,omitempty"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// SecretsClientBeginCreateOrUpdateOptions contains the optional parameters for the SecretsClient.BeginCreateOrUpdate method.
type SecretsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecretsClientDeleteOptions contains the optional parameters for the SecretsClient.Delete method.
type SecretsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SecretsClientGetOptions contains the optional parameters for the SecretsClient.Get method.
type SecretsClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=value)'
	Expand *string
}

// SecretsClientListOptions contains the optional parameters for the SecretsClient.List method.
type SecretsClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=value)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// SecretsClientUpdateOptions contains the optional parameters for the SecretsClient.Update method.
type SecretsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServiceFabric - A Service Fabric.
type ServiceFabric struct {
	// REQUIRED; The properties of the resource.
	Properties *ServiceFabricProperties `json:"properties,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceFabricFragment - A Service Fabric.
type ServiceFabricFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ServiceFabricList - The response of a list operation.
type ServiceFabricList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*ServiceFabric `json:"value,omitempty"`
}

// ServiceFabricProperties - Properties of a service fabric.
type ServiceFabricProperties struct {
	// The resource id of the environment under which the service fabric resource is present
	EnvironmentID *string `json:"environmentId,omitempty"`

	// The backing service fabric resource's id
	ExternalServiceFabricID *string `json:"externalServiceFabricId,omitempty"`

	// READ-ONLY; The applicable schedule for the virtual machine.
	ApplicableSchedule *ApplicableSchedule `json:"applicableSchedule,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// ServiceFabricSchedulesClientBeginExecuteOptions contains the optional parameters for the ServiceFabricSchedulesClient.BeginExecute
// method.
type ServiceFabricSchedulesClientBeginExecuteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceFabricSchedulesClientCreateOrUpdateOptions contains the optional parameters for the ServiceFabricSchedulesClient.CreateOrUpdate
// method.
type ServiceFabricSchedulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServiceFabricSchedulesClientDeleteOptions contains the optional parameters for the ServiceFabricSchedulesClient.Delete
// method.
type ServiceFabricSchedulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ServiceFabricSchedulesClientGetOptions contains the optional parameters for the ServiceFabricSchedulesClient.Get method.
type ServiceFabricSchedulesClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=status)'
	Expand *string
}

// ServiceFabricSchedulesClientListOptions contains the optional parameters for the ServiceFabricSchedulesClient.List method.
type ServiceFabricSchedulesClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=status)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// ServiceFabricSchedulesClientUpdateOptions contains the optional parameters for the ServiceFabricSchedulesClient.Update
// method.
type ServiceFabricSchedulesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServiceFabricsClientBeginCreateOrUpdateOptions contains the optional parameters for the ServiceFabricsClient.BeginCreateOrUpdate
// method.
type ServiceFabricsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceFabricsClientBeginDeleteOptions contains the optional parameters for the ServiceFabricsClient.BeginDelete method.
type ServiceFabricsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceFabricsClientBeginStartOptions contains the optional parameters for the ServiceFabricsClient.BeginStart method.
type ServiceFabricsClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceFabricsClientBeginStopOptions contains the optional parameters for the ServiceFabricsClient.BeginStop method.
type ServiceFabricsClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServiceFabricsClientGetOptions contains the optional parameters for the ServiceFabricsClient.Get method.
type ServiceFabricsClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($expand=applicableSchedule)'
	Expand *string
}

// ServiceFabricsClientListApplicableSchedulesOptions contains the optional parameters for the ServiceFabricsClient.ListApplicableSchedules
// method.
type ServiceFabricsClientListApplicableSchedulesOptions struct {
	// placeholder for future optional parameters
}

// ServiceFabricsClientListOptions contains the optional parameters for the ServiceFabricsClient.List method.
type ServiceFabricsClientListOptions struct {
	// Specify the $expand query. Example: 'properties($expand=applicableSchedule)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// ServiceFabricsClientUpdateOptions contains the optional parameters for the ServiceFabricsClient.Update method.
type ServiceFabricsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServiceRunner - A container for a managed identity to execute DevTest lab services.
type ServiceRunner struct {
	// The identity of the resource.
	Identity *IdentityProperties `json:"identity,omitempty"`

	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceRunnerList - The response of a list operation.
type ServiceRunnerList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*ServiceRunner `json:"value,omitempty"`
}

// ServiceRunnersClientCreateOrUpdateOptions contains the optional parameters for the ServiceRunnersClient.CreateOrUpdate
// method.
type ServiceRunnersClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServiceRunnersClientDeleteOptions contains the optional parameters for the ServiceRunnersClient.Delete method.
type ServiceRunnersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ServiceRunnersClientGetOptions contains the optional parameters for the ServiceRunnersClient.Get method.
type ServiceRunnersClientGetOptions struct {
	// placeholder for future optional parameters
}

// SharedPublicIPAddressConfiguration - Properties of a virtual machine that determine how it is connected to a load balancer.
type SharedPublicIPAddressConfiguration struct {
	// The incoming NAT rules
	InboundNatRules []*InboundNatRule `json:"inboundNatRules,omitempty"`
}

// ShutdownNotificationContent - The contents of a shutdown notification. Webhooks can use this type to deserialize the request
// body when they get notified of an imminent shutdown.
type ShutdownNotificationContent struct {
	// The URL to delay shutdown by 2 hours.
	DelayUrl120 *string `json:"delayUrl120,omitempty"`

	// The URL to delay shutdown by 60 minutes.
	DelayUrl60 *string `json:"delayUrl60,omitempty"`

	// The event for which a notification will be sent.
	EventType *string `json:"eventType,omitempty"`

	// The GUID for the virtual machine to be shut down.
	GUID *string `json:"guid,omitempty"`

	// The lab for the schedule.
	LabName *string `json:"labName,omitempty"`

	// Minutes remaining until shutdown
	MinutesUntilShutdown *string `json:"minutesUntilShutdown,omitempty"`

	// The owner of the virtual machine.
	Owner *string `json:"owner,omitempty"`

	// The resource group name for the schedule.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`

	// The URL to skip auto-shutdown.
	SkipURL *string `json:"skipUrl,omitempty"`

	// The subscription ID for the schedule.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// The text for the notification.
	Text *string `json:"text,omitempty"`

	// The virtual machine to be shut down.
	VMName *string `json:"vmName,omitempty"`

	// The URL of the virtual machine.
	VMURL *string `json:"vmUrl,omitempty"`
}

// Subnet information.
type Subnet struct {
	// The permission policy of the subnet for allowing public IP addresses (i.e. Allow, Deny)).
	AllowPublicIP *UsagePermissionType `json:"allowPublicIp,omitempty"`

	// The name of the subnet as seen in the lab.
	LabSubnetName *string `json:"labSubnetName,omitempty"`

	// The resource ID of the subnet.
	ResourceID *string `json:"resourceId,omitempty"`
}

// SubnetOverride - Property overrides on a subnet of a virtual network.
type SubnetOverride struct {
	// The name given to the subnet within the lab.
	LabSubnetName *string `json:"labSubnetName,omitempty"`

	// The resource ID of the subnet.
	ResourceID *string `json:"resourceId,omitempty"`

	// Properties that virtual machines on this subnet will share.
	SharedPublicIPAddressConfiguration *SubnetSharedPublicIPAddressConfiguration `json:"sharedPublicIpAddressConfiguration,omitempty"`

	// Indicates whether this subnet can be used during virtual machine creation (i.e. Allow, Deny).
	UseInVMCreationPermission *UsagePermissionType `json:"useInVmCreationPermission,omitempty"`

	// Indicates whether public IP addresses can be assigned to virtual machines on this subnet (i.e. Allow, Deny).
	UsePublicIPAddressPermission *UsagePermissionType `json:"usePublicIpAddressPermission,omitempty"`

	// The virtual network pool associated with this subnet.
	VirtualNetworkPoolName *string `json:"virtualNetworkPoolName,omitempty"`
}

// SubnetSharedPublicIPAddressConfiguration - Configuration for public IP address sharing.
type SubnetSharedPublicIPAddressConfiguration struct {
	// Backend ports that virtual machines on this subnet are allowed to expose
	AllowedPorts []*Port `json:"allowedPorts,omitempty"`
}

// TargetCostProperties - Properties of a cost target.
type TargetCostProperties struct {
	// Cost thresholds.
	CostThresholds []*CostThresholdProperties `json:"costThresholds,omitempty"`

	// Reporting cycle end date.
	CycleEndDateTime *time.Time `json:"cycleEndDateTime,omitempty"`

	// Reporting cycle start date.
	CycleStartDateTime *time.Time `json:"cycleStartDateTime,omitempty"`

	// Reporting cycle type.
	CycleType *ReportingCycleType `json:"cycleType,omitempty"`

	// Target cost status
	Status *TargetCostStatus `json:"status,omitempty"`

	// Lab target cost
	Target *int32 `json:"target,omitempty"`
}

// UpdateResource - Represents an update resource
type UpdateResource struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// User - Profile of a lab user.
type User struct {
	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The properties of the resource.
	Properties *UserProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserFragment - Profile of a lab user.
type UserFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// UserIdentity - Identity attributes of a lab user.
type UserIdentity struct {
	// Set to the app Id of the client JWT making the request.
	AppID *string `json:"appId,omitempty"`

	// Set to the object Id of the client JWT making the request. Not all users have object Id. For CSP (reseller) scenarios for
	// example, object Id is not available.
	ObjectID *string `json:"objectId,omitempty"`

	// Set to the principal Id of the client JWT making the request. Service principal will not have the principal Id.
	PrincipalID *string `json:"principalId,omitempty"`

	// Set to the principal name / UPN of the client JWT making the request.
	PrincipalName *string `json:"principalName,omitempty"`

	// Set to the tenant ID of the client JWT making the request.
	TenantID *string `json:"tenantId,omitempty"`
}

// UserList - The response of a list operation.
type UserList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*User `json:"value,omitempty"`
}

// UserProperties - Properties of a lab user profile.
type UserProperties struct {
	// The identity of the user.
	Identity *UserIdentity `json:"identity,omitempty"`

	// The secret store of the user.
	SecretStore *UserSecretStore `json:"secretStore,omitempty"`

	// READ-ONLY; The creation date of the user profile.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// UserSecretStore - Properties of a user's secret store.
type UserSecretStore struct {
	// The ID of the user's Key vault.
	KeyVaultID *string `json:"keyVaultId,omitempty"`

	// The URI of the user's Key vault.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
}

// UsersClientBeginCreateOrUpdateOptions contains the optional parameters for the UsersClient.BeginCreateOrUpdate method.
type UsersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// UsersClientBeginDeleteOptions contains the optional parameters for the UsersClient.BeginDelete method.
type UsersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// UsersClientGetOptions contains the optional parameters for the UsersClient.Get method.
type UsersClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=identity)'
	Expand *string
}

// UsersClientListOptions contains the optional parameters for the UsersClient.List method.
type UsersClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=identity)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// UsersClientUpdateOptions contains the optional parameters for the UsersClient.Update method.
type UsersClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineSchedulesClientBeginExecuteOptions contains the optional parameters for the VirtualMachineSchedulesClient.BeginExecute
// method.
type VirtualMachineSchedulesClientBeginExecuteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineSchedulesClientCreateOrUpdateOptions contains the optional parameters for the VirtualMachineSchedulesClient.CreateOrUpdate
// method.
type VirtualMachineSchedulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineSchedulesClientDeleteOptions contains the optional parameters for the VirtualMachineSchedulesClient.Delete
// method.
type VirtualMachineSchedulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineSchedulesClientGetOptions contains the optional parameters for the VirtualMachineSchedulesClient.Get method.
type VirtualMachineSchedulesClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($select=status)'
	Expand *string
}

// VirtualMachineSchedulesClientListOptions contains the optional parameters for the VirtualMachineSchedulesClient.List method.
type VirtualMachineSchedulesClientListOptions struct {
	// Specify the $expand query. Example: 'properties($select=status)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// VirtualMachineSchedulesClientUpdateOptions contains the optional parameters for the VirtualMachineSchedulesClient.Update
// method.
type VirtualMachineSchedulesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientBeginAddDataDiskOptions contains the optional parameters for the VirtualMachinesClient.BeginAddDataDisk
// method.
type VirtualMachinesClientBeginAddDataDiskOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginApplyArtifactsOptions contains the optional parameters for the VirtualMachinesClient.BeginApplyArtifacts
// method.
type VirtualMachinesClientBeginApplyArtifactsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginClaimOptions contains the optional parameters for the VirtualMachinesClient.BeginClaim method.
type VirtualMachinesClientBeginClaimOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualMachinesClient.BeginCreateOrUpdate
// method.
type VirtualMachinesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginDeleteOptions contains the optional parameters for the VirtualMachinesClient.BeginDelete method.
type VirtualMachinesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginDetachDataDiskOptions contains the optional parameters for the VirtualMachinesClient.BeginDetachDataDisk
// method.
type VirtualMachinesClientBeginDetachDataDiskOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginRedeployOptions contains the optional parameters for the VirtualMachinesClient.BeginRedeploy
// method.
type VirtualMachinesClientBeginRedeployOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginResizeOptions contains the optional parameters for the VirtualMachinesClient.BeginResize method.
type VirtualMachinesClientBeginResizeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginRestartOptions contains the optional parameters for the VirtualMachinesClient.BeginRestart method.
type VirtualMachinesClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginStartOptions contains the optional parameters for the VirtualMachinesClient.BeginStart method.
type VirtualMachinesClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginStopOptions contains the optional parameters for the VirtualMachinesClient.BeginStop method.
type VirtualMachinesClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginTransferDisksOptions contains the optional parameters for the VirtualMachinesClient.BeginTransferDisks
// method.
type VirtualMachinesClientBeginTransferDisksOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginUnClaimOptions contains the optional parameters for the VirtualMachinesClient.BeginUnClaim method.
type VirtualMachinesClientBeginUnClaimOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientGetOptions contains the optional parameters for the VirtualMachinesClient.Get method.
type VirtualMachinesClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($expand=artifacts,computeVm,networkInterface,applicableSchedule)'
	Expand *string
}

// VirtualMachinesClientGetRdpFileContentsOptions contains the optional parameters for the VirtualMachinesClient.GetRdpFileContents
// method.
type VirtualMachinesClientGetRdpFileContentsOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientListApplicableSchedulesOptions contains the optional parameters for the VirtualMachinesClient.ListApplicableSchedules
// method.
type VirtualMachinesClientListApplicableSchedulesOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientListOptions contains the optional parameters for the VirtualMachinesClient.List method.
type VirtualMachinesClientListOptions struct {
	// Specify the $expand query. Example: 'properties($expand=artifacts,computeVm,networkInterface,applicableSchedule)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// VirtualMachinesClientUpdateOptions contains the optional parameters for the VirtualMachinesClient.Update method.
type VirtualMachinesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetwork - A virtual network.
type VirtualNetwork struct {
	// The location of the resource.
	Location *string `json:"location,omitempty"`

	// The properties of the resource.
	Properties *VirtualNetworkProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkFragment - A virtual network.
type VirtualNetworkFragment struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// VirtualNetworkList - The response of a list operation.
type VirtualNetworkList struct {
	// Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Results of the list operation.
	Value []*VirtualNetwork `json:"value,omitempty"`
}

// VirtualNetworkProperties - Properties of a virtual network.
type VirtualNetworkProperties struct {
	// The allowed subnets of the virtual network.
	AllowedSubnets []*Subnet `json:"allowedSubnets,omitempty"`

	// The description of the virtual network.
	Description *string `json:"description,omitempty"`

	// The Microsoft.Network resource identifier of the virtual network.
	ExternalProviderResourceID *string `json:"externalProviderResourceId,omitempty"`

	// The subnet overrides of the virtual network.
	SubnetOverrides []*SubnetOverride `json:"subnetOverrides,omitempty"`

	// READ-ONLY; The creation date of the virtual network.
	CreatedDate *time.Time `json:"createdDate,omitempty" azure:"ro"`

	// READ-ONLY; The external subnet properties.
	ExternalSubnets []*ExternalSubnet `json:"externalSubnets,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty" azure:"ro"`
}

// VirtualNetworksClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworksClient.BeginCreateOrUpdate
// method.
type VirtualNetworksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientBeginDeleteOptions contains the optional parameters for the VirtualNetworksClient.BeginDelete method.
type VirtualNetworksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientGetOptions contains the optional parameters for the VirtualNetworksClient.Get method.
type VirtualNetworksClientGetOptions struct {
	// Specify the $expand query. Example: 'properties($expand=externalSubnets)'
	Expand *string
}

// VirtualNetworksClientListOptions contains the optional parameters for the VirtualNetworksClient.List method.
type VirtualNetworksClientListOptions struct {
	// Specify the $expand query. Example: 'properties($expand=externalSubnets)'
	Expand *string
	// The filter to apply to the operation. Example: '$filter=contains(name,'myName')
	Filter *string
	// The ordering expression for the results, using OData notation. Example: '$orderby=name desc'
	Orderby *string
	// The maximum number of resources to return from the operation. Example: '$top=10'
	Top *int32
}

// VirtualNetworksClientUpdateOptions contains the optional parameters for the VirtualNetworksClient.Update method.
type VirtualNetworksClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// WeekDetails - Properties of a weekly schedule.
type WeekDetails struct {
	// The time of the day the schedule will occur.
	Time *string `json:"time,omitempty"`

	// The days of the week for which the schedule is set (e.g. Sunday, Monday, Tuesday, etc.).
	Weekdays []*string `json:"weekdays,omitempty"`
}

// WindowsOsInfo - Information about a Windows OS.
type WindowsOsInfo struct {
	// The state of the Windows OS (i.e. NonSysprepped, SysprepRequested, SysprepApplied).
	WindowsOsState *WindowsOsState `json:"windowsOsState,omitempty"`
}
