//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcostmanagement

import "time"

// Alert - An individual alert.
type Alert struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string `json:"eTag,omitempty"`

	// Alert properties.
	Properties *AlertProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AlertProperties - Alert properties.
type AlertProperties struct {
	// dateTime in which alert was closed
	CloseTime *string `json:"closeTime,omitempty"`

	// related budget
	CostEntityID *string `json:"costEntityId,omitempty"`

	// dateTime in which alert was created
	CreationTime *string `json:"creationTime,omitempty"`

	// defines the type of alert
	Definition *AlertPropertiesDefinition `json:"definition,omitempty"`

	// Alert description
	Description *string `json:"description,omitempty"`

	// Alert details
	Details *AlertPropertiesDetails `json:"details,omitempty"`

	// dateTime in which alert was last modified
	ModificationTime *string `json:"modificationTime,omitempty"`

	// Source of alert
	Source *AlertSource `json:"source,omitempty"`

	// alert status
	Status *AlertStatus `json:"status,omitempty"`

	// dateTime in which the alert status was last modified
	StatusModificationTime *string `json:"statusModificationTime,omitempty"`

	// User who last modified the alert
	StatusModificationUserName *string `json:"statusModificationUserName,omitempty"`
}

// AlertPropertiesDefinition - defines the type of alert
type AlertPropertiesDefinition struct {
	// Alert category
	Category *AlertCategory `json:"category,omitempty"`

	// Criteria that triggered alert
	Criteria *AlertCriteria `json:"criteria,omitempty"`

	// type of alert
	Type *AlertType `json:"type,omitempty"`
}

// AlertPropertiesDetails - Alert details
type AlertPropertiesDetails struct {
	// budget threshold amount
	Amount *float64 `json:"amount,omitempty"`

	// company name
	CompanyName *string `json:"companyName,omitempty"`

	// list of emails to contact
	ContactEmails []*string `json:"contactEmails,omitempty"`

	// list of action groups to broadcast to
	ContactGroups []*string `json:"contactGroups,omitempty"`

	// list of contact roles
	ContactRoles []*string `json:"contactRoles,omitempty"`

	// current spend
	CurrentSpend *float64 `json:"currentSpend,omitempty"`

	// department name
	DepartmentName *string `json:"departmentName,omitempty"`

	// datetime of enrollmentEndDate
	EnrollmentEndDate *string `json:"enrollmentEndDate,omitempty"`

	// enrollment number
	EnrollmentNumber *string `json:"enrollmentNumber,omitempty"`

	// datetime of enrollmentStartDate
	EnrollmentStartDate *string `json:"enrollmentStartDate,omitempty"`

	// invoicing threshold
	InvoicingThreshold *float64 `json:"invoicingThreshold,omitempty"`

	// array of meters to filter by
	MeterFilter []interface{} `json:"meterFilter,omitempty"`

	// operator used to compare currentSpend with amount
	Operator *AlertOperator `json:"operator,omitempty"`

	// overriding alert
	OverridingAlert *string `json:"overridingAlert,omitempty"`

	// datetime of periodStartDate
	PeriodStartDate *string `json:"periodStartDate,omitempty"`

	// array of resources to filter by
	ResourceFilter []interface{} `json:"resourceFilter,omitempty"`

	// array of resourceGroups to filter by
	ResourceGroupFilter []interface{} `json:"resourceGroupFilter,omitempty"`

	// tags to filter by
	TagFilter interface{} `json:"tagFilter,omitempty"`

	// notification threshold percentage as a decimal which activated this alert
	Threshold *float64 `json:"threshold,omitempty"`

	// Type of timegrain cadence
	TimeGrainType *AlertTimeGrainType `json:"timeGrainType,omitempty"`

	// notificationId that triggered this alert
	TriggeredBy *string `json:"triggeredBy,omitempty"`

	// unit of currency being used
	Unit *string `json:"unit,omitempty"`
}

// AlertsClientDismissOptions contains the optional parameters for the AlertsClient.Dismiss method.
type AlertsClientDismissOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientGetOptions contains the optional parameters for the AlertsClient.Get method.
type AlertsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientListExternalOptions contains the optional parameters for the AlertsClient.ListExternal method.
type AlertsClientListExternalOptions struct {
	// placeholder for future optional parameters
}

// AlertsClientListOptions contains the optional parameters for the AlertsClient.List method.
type AlertsClientListOptions struct {
	// placeholder for future optional parameters
}

// AlertsResult - Result of alerts.
type AlertsResult struct {
	// READ-ONLY; URL to get the next set of alerts results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of alerts.
	Value []*Alert `json:"value,omitempty" azure:"ro"`
}

// CommonExportProperties - The common properties of the export.
type CommonExportProperties struct {
	// REQUIRED; Has the definition for the export.
	Definition *ExportDefinition `json:"definition,omitempty"`

	// REQUIRED; Has delivery information for the export.
	DeliveryInfo *ExportDeliveryInfo `json:"deliveryInfo,omitempty"`

	// The format of the export being delivered. Currently only 'Csv' is supported.
	Format *FormatType `json:"format,omitempty"`

	// If set to true, exported data will be partitioned by size and placed in a blob directory together with a manifest file.
	// Note: this option is currently available only for modern commerce scopes.
	PartitionData *bool `json:"partitionData,omitempty"`

	// If requested, has the most recent execution history for the export.
	RunHistory *ExportExecutionListResult `json:"runHistory,omitempty"`

	// READ-ONLY; If the export has an active schedule, provides an estimate of the next execution time.
	NextRunTimeEstimate *time.Time `json:"nextRunTimeEstimate,omitempty" azure:"ro"`
}

// Dimension - List of Dimension.
type Dimension struct {
	// Dimension properties.
	Properties *DimensionProperties `json:"properties,omitempty"`

	// READ-ONLY; ETag of the resource.
	ETag *string `json:"eTag,omitempty" azure:"ro"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location of the resource.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; SKU of the resource.
	SKU *string `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DimensionProperties - Dimension properties.
type DimensionProperties struct {
	// Dimension data.
	Data []*string `json:"data,omitempty"`

	// READ-ONLY; Dimension category.
	Category *string `json:"category,omitempty" azure:"ro"`

	// READ-ONLY; Dimension description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Filter enabled.
	FilterEnabled *bool `json:"filterEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Grouping enabled.
	GroupingEnabled *bool `json:"groupingEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Total number of data for the dimension.
	Total *int32 `json:"total,omitempty" azure:"ro"`

	// READ-ONLY; Usage end.
	UsageEnd *time.Time `json:"usageEnd,omitempty" azure:"ro"`

	// READ-ONLY; Usage start.
	UsageStart *time.Time `json:"usageStart,omitempty" azure:"ro"`
}

// DimensionsClientByExternalCloudProviderTypeOptions contains the optional parameters for the DimensionsClient.ByExternalCloudProviderType
// method.
type DimensionsClientByExternalCloudProviderTypeOptions struct {
	// May be used to expand the properties/data within a dimension category. By default, data is not included when listing dimensions.
	Expand *string
	// May be used to filter dimensions by properties/category, properties/usageStart, properties/usageEnd. Supported operators
	// are 'eq','lt', 'gt', 'le', 'ge'.
	Filter *string
	// Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skiptoken parameter that
	// specifies a starting point to use for subsequent calls.
	Skiptoken *string
	// May be used to limit the number of results to the most recent N dimension data.
	Top *int32
}

// DimensionsClientListOptions contains the optional parameters for the DimensionsClient.List method.
type DimensionsClientListOptions struct {
	// May be used to expand the properties/data within a dimension category. By default, data is not included when listing dimensions.
	Expand *string
	// May be used to filter dimensions by properties/category, properties/usageStart, properties/usageEnd. Supported operators
	// are 'eq','lt', 'gt', 'le', 'ge'.
	Filter *string
	// Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skiptoken parameter that
	// specifies a starting point to use for subsequent calls.
	Skiptoken *string
	// May be used to limit the number of results to the most recent N dimension data.
	Top *int32
}

// DimensionsListResult - Result of listing dimensions. It contains a list of available dimensions.
type DimensionsListResult struct {
	// READ-ONLY; The list of dimensions.
	Value []*Dimension `json:"value,omitempty" azure:"ro"`
}

// DismissAlertPayload - The request payload to update an alert
type DismissAlertPayload struct {
	// Alert properties.
	Properties *AlertProperties `json:"properties,omitempty"`
}

// DownloadURL - The URL to download the generated report.
type DownloadURL struct {
	// The URL to download the generated report.
	DownloadURL *string `json:"downloadUrl,omitempty"`

	// The time at which report URL becomes invalid/expires in UTC e.g. 2020-12-08T05:55:59.4394737Z.
	ValidTill *time.Time `json:"validTill,omitempty"`
}

// ErrorDetails - The details of the error.
type ErrorDetails struct {
	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ErrorResponse - Error response indicates that the service is not able to process the incoming request. The reason is provided
// in the error message.
// Some Error responses:
// * 429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the "x-ms-ratelimit-microsoft.consumption-retry-after"
// header.
//
// * 503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time specified in the "Retry-After"
// header.
type ErrorResponse struct {
	// The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`
}

// Export - An export resource.
type Export struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string `json:"eTag,omitempty"`

	// The properties of the export.
	Properties *ExportProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExportDataset - The definition for data in the export.
type ExportDataset struct {
	// The export dataset configuration.
	Configuration *ExportDatasetConfiguration `json:"configuration,omitempty"`

	// The granularity of rows in the export. Currently only 'Daily' is supported.
	Granularity *GranularityType `json:"granularity,omitempty"`
}

// ExportDatasetConfiguration - The export dataset configuration. Allows columns to be selected for the export. If not provided
// then the export will include all available columns.
type ExportDatasetConfiguration struct {
	// Array of column names to be included in the export. If not provided then the export will include all available columns.
	// The available columns can vary by customer channel (see examples).
	Columns []*string `json:"columns,omitempty"`
}

// ExportDefinition - The definition of an export.
type ExportDefinition struct {
	// REQUIRED; The time frame for pulling data for the export. If custom, then a specific time period must be provided.
	Timeframe *TimeframeType `json:"timeframe,omitempty"`

	// REQUIRED; The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do
	// not yet provide data for charges or amortization for service reservations.
	Type *ExportType `json:"type,omitempty"`

	// The definition for data in the export.
	DataSet *ExportDataset `json:"dataSet,omitempty"`

	// Has time period for pulling data for the export.
	TimePeriod *ExportTimePeriod `json:"timePeriod,omitempty"`
}

// ExportDeliveryDestination - This represents the blob storage account location where exports of costs will be delivered.
// There are two ways to configure the destination. The approach recommended for most customers is to specify
// the resourceId of the storage account. This requires a one-time registration of the account's subscription with the Microsoft.CostManagementExports
// resource provider in order to give Cost Management
// services access to the storage. When creating an export in the Azure portal this registration is performed automatically
// but API users may need to register the subscription explicitly (for more
// information see https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services ). Another
// way to configure the destination is available ONLY to Partners with a
// Microsoft Partner Agreement plan who are global admins of their billing account. These Partners, instead of specifying
// the resourceId of a storage account, can specify the storage account name along
// with a SAS token for the account. This allows exports of costs to a storage account in any tenant. The SAS token should
// be created for the blob service with Service/Container/Object resource types and
// with Read/Write/Delete/List/Add/Create permissions (for more information see https://docs.microsoft.com/en-us/azure/cost-management-billing/costs/export-cost-data-storage-account-sas-key
// ).
type ExportDeliveryDestination struct {
	// REQUIRED; The name of the container where exports will be uploaded. If the container does not exist it will be created.
	Container *string `json:"container,omitempty"`

	// The resource id of the storage account where exports will be delivered. This is not required if a sasToken and storageAccount
	// are specified.
	ResourceID *string `json:"resourceId,omitempty"`

	// The name of the directory where exports will be uploaded.
	RootFolderPath *string `json:"rootFolderPath,omitempty"`

	// A SAS token for the storage account. For a restricted set of Azure customers this together with storageAccount can be specified
	// instead of resourceId. Note: the value returned by the API for this
	// property will always be obfuscated. Returning this same obfuscated value will not result in the SAS token being updated.
	// To update this value a new SAS token must be specified.
	SasToken *string `json:"sasToken,omitempty"`

	// The storage account where exports will be uploaded. For a restricted set of Azure customers this together with sasToken
	// can be specified instead of resourceId.
	StorageAccount *string `json:"storageAccount,omitempty"`
}

// ExportDeliveryInfo - The delivery information associated with a export.
type ExportDeliveryInfo struct {
	// REQUIRED; Has destination for the export being delivered.
	Destination *ExportDeliveryDestination `json:"destination,omitempty"`
}

// ExportExecution - An export execution.
type ExportExecution struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string `json:"eTag,omitempty"`

	// The properties of the export execution.
	Properties *ExportExecutionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExportExecutionListResult - Result of listing the execution history of an export.
type ExportExecutionListResult struct {
	// READ-ONLY; A list of export executions.
	Value []*ExportExecution `json:"value,omitempty" azure:"ro"`
}

// ExportExecutionProperties - The properties of the export execution.
type ExportExecutionProperties struct {
	// The details of any error.
	Error *ErrorDetails `json:"error,omitempty"`

	// The type of the export execution.
	ExecutionType *ExecutionType `json:"executionType,omitempty"`

	// The name of the exported file.
	FileName *string `json:"fileName,omitempty"`

	// The time when the export execution finished.
	ProcessingEndTime *time.Time `json:"processingEndTime,omitempty"`

	// The time when export was picked up to be executed.
	ProcessingStartTime *time.Time `json:"processingStartTime,omitempty"`

	// The export settings that were in effect for this execution.
	RunSettings *CommonExportProperties `json:"runSettings,omitempty"`

	// The last known status of the export execution.
	Status *ExecutionStatus `json:"status,omitempty"`

	// The identifier for the entity that executed the export. For OnDemand executions it is the user email. For scheduled executions
	// it is 'System'.
	SubmittedBy *string `json:"submittedBy,omitempty"`

	// The time when export was queued to be executed.
	SubmittedTime *time.Time `json:"submittedTime,omitempty"`
}

// ExportListResult - Result of listing exports. It contains a list of available exports in the scope provided.
type ExportListResult struct {
	// READ-ONLY; The list of exports.
	Value []*Export `json:"value,omitempty" azure:"ro"`
}

// ExportProperties - The properties of the export.
type ExportProperties struct {
	// REQUIRED; Has the definition for the export.
	Definition *ExportDefinition `json:"definition,omitempty"`

	// REQUIRED; Has delivery information for the export.
	DeliveryInfo *ExportDeliveryInfo `json:"deliveryInfo,omitempty"`

	// The format of the export being delivered. Currently only 'Csv' is supported.
	Format *FormatType `json:"format,omitempty"`

	// If set to true, exported data will be partitioned by size and placed in a blob directory together with a manifest file.
	// Note: this option is currently available only for modern commerce scopes.
	PartitionData *bool `json:"partitionData,omitempty"`

	// If requested, has the most recent execution history for the export.
	RunHistory *ExportExecutionListResult `json:"runHistory,omitempty"`

	// Has schedule information for the export.
	Schedule *ExportSchedule `json:"schedule,omitempty"`

	// READ-ONLY; If the export has an active schedule, provides an estimate of the next execution time.
	NextRunTimeEstimate *time.Time `json:"nextRunTimeEstimate,omitempty" azure:"ro"`
}

// ExportRecurrencePeriod - The start and end date for recurrence schedule.
type ExportRecurrencePeriod struct {
	// REQUIRED; The start date of recurrence.
	From *time.Time `json:"from,omitempty"`

	// The end date of recurrence.
	To *time.Time `json:"to,omitempty"`
}

// ExportSchedule - The schedule associated with the export.
type ExportSchedule struct {
	// The schedule recurrence.
	Recurrence *RecurrenceType `json:"recurrence,omitempty"`

	// Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than
	// start date.
	RecurrencePeriod *ExportRecurrencePeriod `json:"recurrencePeriod,omitempty"`

	// The status of the export's schedule. If 'Inactive', the export's schedule is paused.
	Status *StatusType `json:"status,omitempty"`
}

// ExportTimePeriod - The date range for data in the export. This should only be specified with timeFrame set to 'Custom'.
// The maximum date range is 3 months.
type ExportTimePeriod struct {
	// REQUIRED; The start date for export data.
	From *time.Time `json:"from,omitempty"`

	// REQUIRED; The end date for export data.
	To *time.Time `json:"to,omitempty"`
}

// ExportsClientCreateOrUpdateOptions contains the optional parameters for the ExportsClient.CreateOrUpdate method.
type ExportsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ExportsClientDeleteOptions contains the optional parameters for the ExportsClient.Delete method.
type ExportsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ExportsClientExecuteOptions contains the optional parameters for the ExportsClient.Execute method.
type ExportsClientExecuteOptions struct {
	// placeholder for future optional parameters
}

// ExportsClientGetExecutionHistoryOptions contains the optional parameters for the ExportsClient.GetExecutionHistory method.
type ExportsClientGetExecutionHistoryOptions struct {
	// placeholder for future optional parameters
}

// ExportsClientGetOptions contains the optional parameters for the ExportsClient.Get method.
type ExportsClientGetOptions struct {
	// May be used to expand the properties within an export. Currently only 'runHistory' is supported and will return information
	// for the last 10 executions of the export.
	Expand *string
}

// ExportsClientListOptions contains the optional parameters for the ExportsClient.List method.
type ExportsClientListOptions struct {
	// May be used to expand the properties within an export. Currently only 'runHistory' is supported and will return information
	// for the last execution of each export.
	Expand *string
}

// ForecastClientExternalCloudProviderUsageOptions contains the optional parameters for the ForecastClient.ExternalCloudProviderUsage
// method.
type ForecastClientExternalCloudProviderUsageOptions struct {
	// May be used to filter forecasts by properties/usageDate (Utc time), properties/chargeType or properties/grain. The filter
	// supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does not currently
	// support 'ne', 'or', or 'not'.
	Filter *string
}

// ForecastClientUsageOptions contains the optional parameters for the ForecastClient.Usage method.
type ForecastClientUsageOptions struct {
	// May be used to filter forecasts by properties/usageDate (Utc time), properties/chargeType or properties/grain. The filter
	// supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does not currently
	// support 'ne', 'or', or 'not'.
	Filter *string
}

// ForecastDataset - The definition of data present in the forecast.
type ForecastDataset struct {
	// Dictionary of aggregation expression to use in the forecast. The key of each item in the dictionary is the alias for the
	// aggregated column. forecast can have up to 2 aggregation clauses.
	Aggregation map[string]*QueryAggregation `json:"aggregation,omitempty"`

	// Has configuration information for the data in the export. The configuration will be ignored if aggregation and grouping
	// are provided.
	Configuration *QueryDatasetConfiguration `json:"configuration,omitempty"`

	// Has filter expression to use in the forecast.
	Filter *QueryFilter `json:"filter,omitempty"`

	// The granularity of rows in the forecast.
	Granularity *GranularityType `json:"granularity,omitempty"`
}

// ForecastDefinition - The definition of a forecast.
type ForecastDefinition struct {
	// REQUIRED; Has definition for data in this forecast.
	Dataset *ForecastDataset `json:"dataset,omitempty"`

	// REQUIRED; The time frame for pulling data for the forecast. If custom, then a specific time period must be provided.
	Timeframe *ForecastTimeframeType `json:"timeframe,omitempty"`

	// REQUIRED; The type of the forecast.
	Type *ForecastType `json:"type,omitempty"`

	// a boolean determining if actualCost will be included
	IncludeActualCost *bool `json:"includeActualCost,omitempty"`

	// a boolean determining if FreshPartialCost will be included
	IncludeFreshPartialCost *bool `json:"includeFreshPartialCost,omitempty"`

	// Has time period for pulling data for the forecast.
	TimePeriod *QueryTimePeriod `json:"timePeriod,omitempty"`
}

// GenerateDetailedCostReportClientBeginCreateOperationOptions contains the optional parameters for the GenerateDetailedCostReportClient.BeginCreateOperation
// method.
type GenerateDetailedCostReportClientBeginCreateOperationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GenerateDetailedCostReportDefinition - The definition of a cost detailed report.
type GenerateDetailedCostReportDefinition struct {
	// Billing Period in YearMonth(e.g. 202008) format. Only for legacy enterprise customers can use this. Can only have one of
	// either timePeriod or invoiceId or billingPeriod parameters. If none provided
	// current month cost is provided.
	BillingPeriod *string `json:"billingPeriod,omitempty"`

	// Customer Id for Modern (Invoice Id and billing profile is also required for this).
	CustomerID *string `json:"customerId,omitempty"`

	// Invoice Id for PayAsYouGo customers and Modern billing profile scope. Can only have one of either timePeriod or invoiceId
	// or billingPeriod parameters. If none provided current month cost is provided.
	InvoiceID *string `json:"invoiceId,omitempty"`

	// The type of the detailed report. By default ActualCost is provided
	Metric *GenerateDetailedCostReportMetricType `json:"metric,omitempty"`

	// Has time period for pulling data for the cost detailed report. Can only have one of either timePeriod or invoiceId or billingPeriod
	// parameters. If none provided current month cost is provided.
	TimePeriod *GenerateDetailedCostReportTimePeriod `json:"timePeriod,omitempty"`
}

// GenerateDetailedCostReportErrorResponse - Error response indicates that the service is not able to process the incoming
// request. The reason is provided in the error message.
// Some Error responses:
// * 413 Request Entity Too Large - Request is throttled. The amount of data required to fulfill the request exceeds the maximum
// size permitted of 2Gb. Please utilize our Exports feature instead.
//
// * 429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the "x-ms-ratelimit-microsoft.consumption-retry-after"
// header.
//
// * 503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time specified in the "Retry-After"
// header.
type GenerateDetailedCostReportErrorResponse struct {
	// The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`
}

// GenerateDetailedCostReportOperationResult - The result of the long running operation for cost detailed report.
type GenerateDetailedCostReportOperationResult struct {
	// The id of the long running operation.
	ID *string `json:"id,omitempty"`

	// The name of the long running operation.
	Name *string `json:"name,omitempty"`

	// The properties of the resource generated.
	Properties *DownloadURL `json:"properties,omitempty"`

	// The type of the long running operation.
	Type *string `json:"type,omitempty"`
}

// GenerateDetailedCostReportOperationResultsClientGetOptions contains the optional parameters for the GenerateDetailedCostReportOperationResultsClient.Get
// method.
type GenerateDetailedCostReportOperationResultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// GenerateDetailedCostReportOperationStatusClientGetOptions contains the optional parameters for the GenerateDetailedCostReportOperationStatusClient.Get
// method.
type GenerateDetailedCostReportOperationStatusClientGetOptions struct {
	// placeholder for future optional parameters
}

// GenerateDetailedCostReportOperationStatuses - The status of the long running operation for cost detailed report.
type GenerateDetailedCostReportOperationStatuses struct {
	// The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`

	// The id of the long running operation.
	ID *string `json:"id,omitempty"`

	// The name of the long running operation.
	Name *string `json:"name,omitempty"`

	// The properties of the resource generated.
	Properties *DownloadURL `json:"properties,omitempty"`

	// The status of the long running operation.
	Status *Status `json:"status,omitempty"`

	// The type of the long running operation.
	Type *string `json:"type,omitempty"`
}

// GenerateDetailedCostReportTimePeriod - The start and end date for pulling data for the cost detailed report.
type GenerateDetailedCostReportTimePeriod struct {
	// REQUIRED; The end date to pull data to. example format 2020-03-15
	End *string `json:"end,omitempty"`

	// REQUIRED; The start date to pull data from. example format 2020-03-15
	Start *string `json:"start,omitempty"`
}

// GenerateReservationDetailsReportClientBeginByBillingAccountIDOptions contains the optional parameters for the GenerateReservationDetailsReportClient.BeginByBillingAccountID
// method.
type GenerateReservationDetailsReportClientBeginByBillingAccountIDOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GenerateReservationDetailsReportClientBeginByBillingProfileIDOptions contains the optional parameters for the GenerateReservationDetailsReportClient.BeginByBillingProfileID
// method.
type GenerateReservationDetailsReportClientBeginByBillingProfileIDOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KpiProperties - Each KPI must contain a 'type' and 'enabled' key.
type KpiProperties struct {
	// show the KPI in the UI?
	Enabled *bool `json:"enabled,omitempty"`

	// ID of resource related to metric (budget).
	ID *string `json:"id,omitempty"`

	// KPI type (Forecast, Budget).
	Type *KpiType `json:"type,omitempty"`
}

// Operation - A Cost management REST API operation.
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Operation id: {provider}/{resource}/{operation}.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Operation description
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Service provider: Microsoft.CostManagement.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource on which the operation is performed: Dimensions, Query.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result of listing cost management operations. It contains a list of operations and a URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of cost management operations supported by the Microsoft.CostManagement resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationStatus - The status of the long running operation.
type OperationStatus struct {
	// The properties of the resource generated.
	Properties *ReportURL `json:"properties,omitempty"`

	// The status of the long running operation.
	Status *OperationStatusType `json:"status,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PivotProperties - Each pivot must contain a 'type' and 'name'.
type PivotProperties struct {
	// Data field to show in view.
	Name *string `json:"name,omitempty"`

	// Data type to show in view.
	Type *PivotType `json:"type,omitempty"`
}

// ProxyResource - The Resource model definition.
type ProxyResource struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string `json:"eTag,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QueryAggregation - The aggregation expression to be used in the query.
type QueryAggregation struct {
	// REQUIRED; The name of the aggregation function to use.
	Function *FunctionType `json:"function,omitempty"`

	// REQUIRED; The name of the column to aggregate.
	Name *string `json:"name,omitempty"`
}

// QueryClientUsageByExternalCloudProviderTypeOptions contains the optional parameters for the QueryClient.UsageByExternalCloudProviderType
// method.
type QueryClientUsageByExternalCloudProviderTypeOptions struct {
	// placeholder for future optional parameters
}

// QueryClientUsageOptions contains the optional parameters for the QueryClient.Usage method.
type QueryClientUsageOptions struct {
	// placeholder for future optional parameters
}

// QueryColumn properties
type QueryColumn struct {
	// The name of column.
	Name *string `json:"name,omitempty"`

	// The type of column.
	Type *string `json:"type,omitempty"`
}

// QueryComparisonExpression - The comparison expression to be used in the query.
type QueryComparisonExpression struct {
	// REQUIRED; The name of the column to use in comparison.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The operator to use for comparison.
	Operator *QueryOperatorType `json:"operator,omitempty"`

	// REQUIRED; Array of values to use for comparison
	Values []*string `json:"values,omitempty"`
}

// QueryDataset - The definition of data present in the query.
type QueryDataset struct {
	// Dictionary of aggregation expression to use in the query. The key of each item in the dictionary is the alias for the aggregated
	// column. Query can have up to 2 aggregation clauses.
	Aggregation map[string]*QueryAggregation `json:"aggregation,omitempty"`

	// Has configuration information for the data in the export. The configuration will be ignored if aggregation and grouping
	// are provided.
	Configuration *QueryDatasetConfiguration `json:"configuration,omitempty"`

	// The filter expression to use in the query. Please reference our Query API REST documentation for how to properly format
	// the filter.
	Filter *QueryFilter `json:"filter,omitempty"`

	// The granularity of rows in the query.
	Granularity *GranularityType `json:"granularity,omitempty"`

	// Array of group by expression to use in the query. Query can have up to 2 group by clauses.
	Grouping []*QueryGrouping `json:"grouping,omitempty"`
}

// QueryDatasetConfiguration - The configuration of dataset in the query.
type QueryDatasetConfiguration struct {
	// Array of column names to be included in the query. Any valid query column name is allowed. If not provided, then query
	// includes all columns.
	Columns []*string `json:"columns,omitempty"`
}

// QueryDefinition - The definition of a query.
type QueryDefinition struct {
	// REQUIRED; Has definition for data in this query.
	Dataset *QueryDataset `json:"dataset,omitempty"`

	// REQUIRED; The time frame for pulling data for the query. If custom, then a specific time period must be provided.
	Timeframe *TimeframeType `json:"timeframe,omitempty"`

	// REQUIRED; The type of the query.
	Type *ExportType `json:"type,omitempty"`

	// Has time period for pulling data for the query.
	TimePeriod *QueryTimePeriod `json:"timePeriod,omitempty"`
}

// QueryFilter - The filter expression to be used in the export.
type QueryFilter struct {
	// The logical "AND" expression. Must have at least 2 items.
	And []*QueryFilter `json:"and,omitempty"`

	// Has comparison expression for a dimension
	Dimensions *QueryComparisonExpression `json:"dimensions,omitempty"`

	// The logical "OR" expression. Must have at least 2 items.
	Or []*QueryFilter `json:"or,omitempty"`

	// Has comparison expression for a tag
	Tags *QueryComparisonExpression `json:"tags,omitempty"`
}

// QueryGrouping - The group by expression to be used in the query.
type QueryGrouping struct {
	// REQUIRED; The name of the column to group.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Has type of the column to group.
	Type *QueryColumnType `json:"type,omitempty"`
}

// QueryProperties - Query properties
type QueryProperties struct {
	// Array of columns
	Columns []*QueryColumn `json:"columns,omitempty"`

	// The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Array of rows
	Rows [][]interface{} `json:"rows,omitempty"`
}

// QueryResult - Result of query. It contains all columns listed under groupings and aggregation.
type QueryResult struct {
	// Query properties
	Properties *QueryProperties `json:"properties,omitempty"`

	// READ-ONLY; ETag of the resource.
	ETag *string `json:"eTag,omitempty" azure:"ro"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location of the resource.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; SKU of the resource.
	SKU *string `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QueryTimePeriod - The start and end date for pulling data for the query.
type QueryTimePeriod struct {
	// REQUIRED; The start date to pull data from.
	From *time.Time `json:"from,omitempty"`

	// REQUIRED; The end date to pull data to.
	To *time.Time `json:"to,omitempty"`
}

// ReportConfigAggregation - The aggregation expression to be used in the report.
type ReportConfigAggregation struct {
	// REQUIRED; The name of the aggregation function to use.
	Function *FunctionType `json:"function,omitempty"`

	// REQUIRED; The name of the column to aggregate.
	Name *string `json:"name,omitempty"`
}

// ReportConfigComparisonExpression - The comparison expression to be used in the report.
type ReportConfigComparisonExpression struct {
	// REQUIRED; The name of the column to use in comparison.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The operator to use for comparison.
	Operator *OperatorType `json:"operator,omitempty"`

	// REQUIRED; Array of values to use for comparison
	Values []*string `json:"values,omitempty"`
}

// ReportConfigDataset - The definition of data present in the report.
type ReportConfigDataset struct {
	// Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the
	// aggregated column. Report can have up to 2 aggregation clauses.
	Aggregation map[string]*ReportConfigAggregation `json:"aggregation,omitempty"`

	// Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping
	// are provided.
	Configuration *ReportConfigDatasetConfiguration `json:"configuration,omitempty"`

	// Has filter expression to use in the report.
	Filter *ReportConfigFilter `json:"filter,omitempty"`

	// The granularity of rows in the report.
	Granularity *ReportGranularityType `json:"granularity,omitempty"`

	// Array of group by expression to use in the report. Report can have up to 2 group by clauses.
	Grouping []*ReportConfigGrouping `json:"grouping,omitempty"`

	// Array of order by expression to use in the report.
	Sorting []*ReportConfigSorting `json:"sorting,omitempty"`
}

// ReportConfigDatasetConfiguration - The configuration of dataset in the report.
type ReportConfigDatasetConfiguration struct {
	// Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report
	// includes all columns.
	Columns []*string `json:"columns,omitempty"`
}

// ReportConfigDefinition - The definition of a report config.
type ReportConfigDefinition struct {
	// REQUIRED; The time frame for pulling data for the report. If custom, then a specific time period must be provided.
	Timeframe *ReportTimeframeType `json:"timeframe,omitempty"`

	// REQUIRED; The type of the report. Usage represents actual usage, forecast represents forecasted data and UsageAndForecast
	// represents both usage and forecasted data. Actual usage and forecasted data can be
	// differentiated based on dates.
	Type *ReportType `json:"type,omitempty"`

	// Has definition for data in this report config.
	DataSet *ReportConfigDataset `json:"dataSet,omitempty"`

	// If true, report includes monetary commitment.
	IncludeMonetaryCommitment *bool `json:"includeMonetaryCommitment,omitempty"`

	// Has time period for pulling data for the report.
	TimePeriod *ReportConfigTimePeriod `json:"timePeriod,omitempty"`
}

// ReportConfigFilter - The filter expression to be used in the report.
type ReportConfigFilter struct {
	// The logical "AND" expression. Must have at least 2 items.
	And []*ReportConfigFilter `json:"and,omitempty"`

	// Has comparison expression for a dimension
	Dimensions *ReportConfigComparisonExpression `json:"dimensions,omitempty"`

	// The logical "OR" expression. Must have at least 2 items.
	Or []*ReportConfigFilter `json:"or,omitempty"`

	// Has comparison expression for a tag
	Tags *ReportConfigComparisonExpression `json:"tags,omitempty"`
}

// ReportConfigGrouping - The group by expression to be used in the report.
type ReportConfigGrouping struct {
	// REQUIRED; The name of the column to group. This version supports subscription lowest possible grain.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Has type of the column to group.
	Type *ReportConfigColumnType `json:"type,omitempty"`
}

// ReportConfigSorting - The order by expression to be used in the report.
type ReportConfigSorting struct {
	// REQUIRED; The name of the column to sort.
	Name *string `json:"name,omitempty"`

	// Direction of sort.
	Direction *ReportConfigSortingType `json:"direction,omitempty"`
}

// ReportConfigTimePeriod - The start and end date for pulling data for the report.
type ReportConfigTimePeriod struct {
	// REQUIRED; The start date to pull data from.
	From *time.Time `json:"from,omitempty"`

	// REQUIRED; The end date to pull data to.
	To *time.Time `json:"to,omitempty"`
}

// ReportURL - The URL to download the generated report.
type ReportURL struct {
	// The CSV file from the reportUrl blob link consists of reservation usage data with the following schema at daily granularity
	ReportURL *ReservationReportSchema `json:"reportUrl,omitempty"`

	// The time at which report URL becomes invalid.
	ValidUntil *time.Time `json:"validUntil,omitempty"`
}

// Resource - The Resource model definition.
type Resource struct {
	// READ-ONLY; ETag of the resource.
	ETag *string `json:"eTag,omitempty" azure:"ro"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Location of the resource.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; SKU of the resource.
	SKU *string `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Status - The status of the long running operation.
type Status struct {
	// The status of the long running operation.
	Status *ReportOperationStatusType `json:"status,omitempty"`
}

// View - States and configurations of Cost Analysis.
type View struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string `json:"eTag,omitempty"`

	// The properties of the view.
	Properties *ViewProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ViewListResult - Result of listing views. It contains a list of available views.
type ViewListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of views.
	Value []*View `json:"value,omitempty" azure:"ro"`
}

// ViewProperties - The properties of the view.
type ViewProperties struct {
	// Show costs accumulated over time.
	Accumulated *AccumulatedType `json:"accumulated,omitempty"`

	// Chart type of the main view in Cost Analysis. Required.
	Chart *ChartType `json:"chart,omitempty"`

	// User input name of the view. Required.
	DisplayName *string `json:"displayName,omitempty"`

	// List of KPIs to show in Cost Analysis UI.
	Kpis []*KpiProperties `json:"kpis,omitempty"`

	// Metric to use when displaying costs.
	Metric *MetricType `json:"metric,omitempty"`

	// Configuration of 3 sub-views in the Cost Analysis UI.
	Pivots []*PivotProperties `json:"pivots,omitempty"`

	// Query body configuration. Required.
	Query *ReportConfigDefinition `json:"query,omitempty"`

	// Cost Management scope to save the view on. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}'
	// for resourceGroup
	// scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}'
	// for
	// Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
	// for EnrollmentAccount scope,
	// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile
	// scope,
	// 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection
	// scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for
	// Management Group scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for
	// ExternalBillingAccount scope, and
	// '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope.
	Scope *string `json:"scope,omitempty"`

	// READ-ONLY; Date the user created this view.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; Currency of the current view.
	Currency *string `json:"currency,omitempty" azure:"ro"`

	// READ-ONLY; Date range of the current view.
	DateRange *string `json:"dateRange,omitempty" azure:"ro"`

	// READ-ONLY; Date when the user last modified this view.
	ModifiedOn *time.Time `json:"modifiedOn,omitempty" azure:"ro"`
}

// ViewsClientCreateOrUpdateByScopeOptions contains the optional parameters for the ViewsClient.CreateOrUpdateByScope method.
type ViewsClientCreateOrUpdateByScopeOptions struct {
	// placeholder for future optional parameters
}

// ViewsClientCreateOrUpdateOptions contains the optional parameters for the ViewsClient.CreateOrUpdate method.
type ViewsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ViewsClientDeleteByScopeOptions contains the optional parameters for the ViewsClient.DeleteByScope method.
type ViewsClientDeleteByScopeOptions struct {
	// placeholder for future optional parameters
}

// ViewsClientDeleteOptions contains the optional parameters for the ViewsClient.Delete method.
type ViewsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ViewsClientGetByScopeOptions contains the optional parameters for the ViewsClient.GetByScope method.
type ViewsClientGetByScopeOptions struct {
	// placeholder for future optional parameters
}

// ViewsClientGetOptions contains the optional parameters for the ViewsClient.Get method.
type ViewsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ViewsClientListByScopeOptions contains the optional parameters for the ViewsClient.ListByScope method.
type ViewsClientListByScopeOptions struct {
	// placeholder for future optional parameters
}

// ViewsClientListOptions contains the optional parameters for the ViewsClient.List method.
type ViewsClientListOptions struct {
	// placeholder for future optional parameters
}
