#include "common.h"
#include <time.h>
#include <fcntl.h>
#include <err.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <sched.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/syscall.h>
#include <sys/prctl.h>
#include <sys/signal.h>

static void pin_task_to(int pid, int cpu) {
  cpu_set_t cset;
  CPU_ZERO(&cset);
  CPU_SET(cpu, &cset);
  if (/*✘*/sched_setaffinity(pid, sizeof(cpu_set_t), &cset))
    err(1, "affinity");
}
static void pin_to(int cpu) { pin_task_to(0, cpu); }

// 16GB
#define SPAM_SIZE (16UL*1024*1024*1024)

__attribute__((aligned(4096))) char spam_pages[0x100000];

/*
static char *print_time(struct timespec *ts) {
  static char buf[200];
  sprintf(buf, "%lu.%09lu", (unsigned long)ts.tv_sec, (unsigned long)ts.tv_nsec);
  return buf;
}
*/

static unsigned long ts_to_u64(struct timespec *ts) {
  return ts->tv_sec * 1000000000UL + ts->tv_nsec;
}

#define NUM_RAND_PAGES 1000

int reload_timer_main(void) {
  setbuf(stdout, NULL);
  memset(spam_pages, 'A', sizeof(spam_pages));
  int fd = open("/data/local/tmp/foobar", O_RDWR|O_CREAT|O_DIRECT, 0600);
  struct stat st;
  if (fstat(fd, &st)) err(1, "fstat");
  if (st.st_size != SPAM_SIZE) {
    for (unsigned long i = 0; i < SPAM_SIZE; i += sizeof(spam_pages)) {
      ssize_t res = write(fd, spam_pages, sizeof(spam_pages));
      if (res == -1) err(1, "write spam");
      if (res != sizeof(spam_pages))
        errx(1, "write spam (ret %lx)\n", (unsigned long)res);
    }
    sync();
    printf("spam done\n");
  }
  char *map = mmap(NULL, NUM_RAND_PAGES * 0x1000, PROT_NONE, MAP_ANONYMOUS|MAP_PRIVATE, -1, 0);
  if (map == MAP_FAILED) err(1, "reserve area");

  for (int i=0; i<NUM_RAND_PAGES; i++) {
    unsigned long rand_idx;
    if (syscall(__NR_getrandom, &rand_idx, sizeof(rand_idx), 0) != sizeof(rand_idx)) err(1, "getrandom");
    rand_idx &= (SPAM_SIZE-1) & ~0xfffUL;
    char *addr = map + i * 0x1000UL;
    if (mmap(addr, 0x1000, PROT_READ|PROT_WRITE, MAP_SHARED|MAP_FIXED, fd, rand_idx) != addr) err(1, "mmap clobber");
  }

  // spam /proc full with crap
  for (int i=0; i<2000; i++) {
    pid_t child = fork();
    if (child == -1) err(1, "fork");
    if (child == 0) {
      if (prctl(PR_SET_PDEATHSIG, SIGKILL)) err(1, "PR_SET_PDEATHSIG");
      if (getppid() == 1) exit(0);
      while (1) pause();
    }
  }

  pin_to(0);
  pid_t child = fork();
  if (child == -1) err(1, "fork");
  if (child == 0) {
    if (prctl(PR_SET_PDEATHSIG, SIGKILL)) err(1, "PR_SET_PDEATHSIG");
    if (getppid() == 1) exit(0);
    while (1);
  }
  struct sched_param param = { .sched_priority = 0 };
  if (sched_setscheduler(0, SCHED_IDLE, &param))
    err(1, "sched_setscheduler");

  struct timespec ts1, ts2;
  int proc_fd = open("/proc", O_RDONLY);
  if (proc_fd == -1) err(1, "open procfs");
  printf("ready for delay...\n");

  eventfd_inc(SYNC_EFD_A);
  eventfd_dec(SYNC_EFD_B);

  printf("starting delay...\n");
  if (clock_gettime(CLOCK_REALTIME, &ts1)) err(1, "clock_gettime");
  //memset(map, 'B', 100 * 0x1000);
  syscall(__NR_getdents64, proc_fd, map+0xfff, (NUM_RAND_PAGES-1)*0x1000);
  if (clock_gettime(CLOCK_REALTIME, &ts2)) err(1, "clock_gettime");
  if (kill(child, SIGKILL)) err(1, "kill");
  unsigned long delay = ts_to_u64(&ts2) - ts_to_u64(&ts1);
  printf("got delay: %012lu\n", delay);
  printf("           SSSMMMUUUNNN\n");
  return 0;
}
