// Compile with clang -o tester tester.m -framework Foundation
#include <Foundation/Foundation.h>
#include <Foundation/NSURL.h>
#include <WebKit/WebKit.h>
#include <Foundation/NSKeyedArchiver.h>
#include <time.h>
#include <stdlib.h>

int main(int argc, const char * argv[]) {
    @autoreleasepool {
    NSError* err = 0;

    if (argc < 2) {
        printf("Usage: %s path/to/plist\n", argv[0]);
        return 0;
    }

    NSString* path = [NSString stringWithUTF8String:argv[1]];
    NSData* data = [NSData dataWithContentsOfFile:path];

    NSLog(@"Let's go");

    // See IMCore.framework and/or search for references to IMExtensionPayloadUnarchivingClasses
    NSSet* whitelist = [NSSet setWithArray: @[[NSDictionary class], [NSString class], [NSData class], [NSNumber class], [NSURL class], [NSUUID class], [NSValue class], [NSArray class]]];
    NSKeyedUnarchiver* unarchiver = [[NSKeyedUnarchiver alloc] initForReadingFromData:data error:&err];
    id o = [unarchiver decodeObjectOfClasses:whitelist forKey:NSKeyedArchiveRootObjectKey];
    NSLog(@"Decoded %p", o);
    if (!o) {
        NSLog(@"Error: %@", err);
        return -1;
    }

    }

    NSLog(@"Didn't crash?");

    return 0;
}
