﻿using System;
using System.Runtime.InteropServices;
using System.ServiceProcess;

namespace FakeWMIService
{
    public partial class Service1 : ServiceBase
    {
        RegistrationServices _reg_services = new RegistrationServices();
        int _cookie;

        public Service1()
        {
            System.Diagnostics.Trace.WriteLine("Creating Service");
            InitializeComponent();
        }

        protected override void OnStart(string[] args)
        {
            System.Diagnostics.Trace.WriteLine("Starting Service");
            try
            {
                _cookie = _reg_services.RegisterTypeForComClients(typeof(FakeWmiServer),
                    RegistrationClassContext.LocalServer | RegistrationClassContext.RemoteServer,
                    RegistrationConnectionType.MultipleUse);
            }
            catch (Exception ex)
            {
                System.Diagnostics.Trace.WriteLine(ex.ToString());
            }
            System.Diagnostics.Trace.WriteLine("Started Service");
        }

        protected override void OnStop()
        {
            System.Diagnostics.Trace.WriteLine("Stopping Service");
            try
            {
                _reg_services.UnregisterTypeForComClients(_cookie);
            }
            catch (Exception ex)
            {
                System.Diagnostics.Trace.WriteLine(ex.ToString());
            }
        }
    }
}
