﻿using NtApiDotNet;
using System;
using System.Runtime.InteropServices;

namespace PoC_NtlmAuthSession0_EoP
{
    [StructLayout(LayoutKind.Sequential)]
    sealed class CredentialsHandle : IDisposable
    {
        private SecHandle _cred_handle;

        public CredentialsHandle(string package, SecPkgCredFlag cred_use_flag, string user, string domain, string password)
        {
            _cred_handle = new SecHandle();
            Win32NativeMethods.AcquireCredentialsHandle(null, package, cred_use_flag, 
                IntPtr.Zero, new SEC_WINNT_AUTH_IDENTITY_EX(user, domain, password), 
                IntPtr.Zero, IntPtr.Zero, _cred_handle, null).CheckResult();
        }

        public void Dispose()
        {
            Win32NativeMethods.FreeCredentialsHandle(_cred_handle);
        }
    }
}
