// findhex.cpp : Defines the entry point for the console application.
//
#include "stdafx.h"
#include "findhex.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// The one and only application object

CWinApp theApp;

using namespace std;
int axtoi(char *hexStg) {
  int n = 0;         // position in string
  int m = 0;         // position in digit[] to shift
  int count;         // loop index
  int intValue = 0;  // integer value of hex string
  int digit[5];      // hold values to convert
  while (n < 4) {
     if (hexStg[n]=='\0')
        break;
     if (hexStg[n] > 0x29 && hexStg[n] < 0x40 ) //if 0 to 9
        digit[n] = hexStg[n] & 0x0f;            //convert to int
     else if (hexStg[n] >='a' && hexStg[n] <= 'f') //if a to f
        digit[n] = (hexStg[n] & 0x0f) + 9;      //convert to int
     else if (hexStg[n] >='A' && hexStg[n] <= 'F') //if A to F
        digit[n] = (hexStg[n] & 0x0f) + 9;      //convert to int
     else break;
    n++;
  }
  count = n;
  m = n - 1;
  n = 0;
  while(n < count) {
     // digit[n] is value of hex digit at position n
     // (m << 2) is the number of positions to shift
     // OR the bits into return value
     intValue = intValue | (digit[n] << (m << 2));
     m--;   // adjust the position to set
     n++;   // next digit to process
  }
  return (intValue);
}

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		nRetCode = 1;
	}
	else
	{
		bool we_loaded_it = false;
		HINSTANCE h = NULL;
		h = GetModuleHandle(argv[1]);
		if(h==NULL)
		{
			h = LoadLibrary(argv[1]);
			if(h==NULL)
			{
				cout<<"Error Loading DLL: "<<argv[1]<<endl;
				return 1;
			}
			we_loaded_it = true;
		}
		//find wat?
		BYTE find[8];
		int ar;

		if(argc<2){
			printf("Usage: %s [dll] [hex] [hex] <hex> <hex>", argv[0]);
			exit(1);
		}
		for (ar=0; ar<argc-2; ar++){
			find[ar] = axtoi(argv[ar+2]);
		}
		cout<<endl;
		BYTE* ptr = (BYTE*)h;
		bool done = false;
		for(int y = 0; !done; y++)
		{
			try
			{	
				int found=0;
				for(int pp = 0; pp < ar; pp++){
					if(ptr[y+pp]!=find[pp])break;
					found++;
				}
				if (found==ar)
				{
					int pos = (int)ptr + y;
					cout<<"Opcode found at 0x"<<hex<<pos<<endl;	
				}
			}
			catch(...)
			{
				cout<<"End of "<<argv[1]<<" Memory Reached"<<endl;
				done = true;
			}
		}
		if(we_loaded_it) FreeLibrary(h);		
	}
	return nRetCode;
}
